// THIS FILE AUTOGENERATED FROM asm-nseel-x86-gcc.c by a2i.php

#if EEL_F_SIZE == 8
  #define EEL_ASM_TYPE qword ptr
#else
  #define EEL_ASM_TYPE dword ptr
#endif

/* note: only EEL_F_SIZE=8 is now supported (no float EEL_F's) */

#ifndef AMD64ABI
#define X64_EXTRA_STACK_SPACE 32 // win32 requires allocating space for 4 parameters at 8 bytes each, even though we pass via register
#endif

__declspec(naked) void nseel_asm_1pdd(void)
{
  __asm {

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;

    mov edi, 0xfefefefe;
#ifdef TARGET_X64
    fstp qword ptr [rsi];
    movq xmm0, [rsi];
    #ifdef AMD64ABI
       mov r15, rsi;
       call edi;
       mov rsi, r15;
    #else
       sub rsp, X64_EXTRA_STACK_SPACE;
       call edi;
       add rsp, X64_EXTRA_STACK_SPACE;
    #endif
    movq [rsi], xmm0;
    fld qword ptr [rsi];
#else
    sub esp, 16;
    fstp qword ptr [esp];
    call edi;
    add esp, 16;
#endif

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;

  }
}
__declspec(naked) void nseel_asm_1pdd_end(void){}

__declspec(naked) void nseel_asm_2pdd(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;

    mov edi, 0xfefefefe;
#ifdef TARGET_X64
    fstp qword ptr [rsi+8];
    fstp qword ptr [rsi];
    movq xmm1, [rsi+8];
    movq xmm0, [rsi];
    #ifdef AMD64ABI
      mov r15, rsi;
      call edi;
      mov rsi, r15;
    #else
      sub rsp, X64_EXTRA_STACK_SPACE;
      call edi;
      add rsp, X64_EXTRA_STACK_SPACE;
    #endif
    movq [rsi], xmm0;
    fld qword ptr [rsi];
#else
    sub esp, 16;
    fstp qword ptr [esp+8];
    fstp qword ptr [esp];
    call edi;
    add esp, 16;
#endif

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_2pdd_end(void){}

__declspec(naked) void nseel_asm_2pdds(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;

    mov eax, 0xfefefefe;
#ifdef TARGET_X64
    fstp qword ptr [rsi];
    movq xmm0, [rdi];
    movq xmm1, [rsi];
    #ifdef AMD64ABI
      mov r15, rsi;
      mov r14, rdi;
      call eax;
      mov rsi, r15;
      movq [r14], xmm0;
      mov rax, r14; /* set return value */
    #else
      sub rsp, X64_EXTRA_STACK_SPACE;
      call eax;
      movq [edi], xmm0;
      mov eax, edi; /* set return value */
      add rsp, X64_EXTRA_STACK_SPACE;
    #endif
#else
    sub esp, 8;
    fstp qword ptr [esp];
    push dword ptr [edi+4]; /* push parameter */
    push dword ptr [edi];    /* push the rest of the parameter */
    call eax;
    add esp, 16;
    fstp qword ptr [edi]; /* store result */
    mov eax, edi; /* set return value */
#endif

    // denormal-fix result (this is only currently used for pow_op, so we want this!)
    mov edx, dword ptr [edi+4];
    add edx, 0x00100000;
    and edx, 0x7FF00000;
    cmp edx, 0x00100000;
    jg label_0;
      sub edx, edx;
#ifdef TARGET_X64
      mov qword ptr [rdi], rdx;
#else
      mov dword ptr [edi], edx;
      mov dword ptr [edi+4], edx;
#endif
label_0:
    

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;

  }
}
__declspec(naked) void nseel_asm_2pdds_end(void){}



//---------------------------------------------------------------------------------------------------------------


// do nothing, eh
__declspec(naked) void nseel_asm_exec2(void)
{
   __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
      
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }
}
__declspec(naked) void nseel_asm_exec2_end(void) { }



__declspec(naked) void nseel_asm_invsqrt(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov edx, 0x5f3759df;
    fst dword ptr [esi];
#ifdef TARGET_X64
    mov rax, 0xfefefefe;
    fmul EEL_ASM_TYPE [rax];
    movsx rcx, dword ptr [esi];
#else
#if EEL_F_SIZE == 8
_emit 0xDC; // fmul qword ptr [0xfefefefe]
_emit 0x0D;
_emit 0xFE;
_emit 0xFE;
_emit 0xFE;
_emit 0xFE;
#else
_emit 0xD8; // fmul dword ptr [0xfefefefe]
_emit 0x0D;
_emit 0xFE;
_emit 0xFE;
_emit 0xFE;
_emit 0xFE;
#endif
    mov ecx, dword ptr [esi];
#endif
    sar ecx, 1;
    sub edx, ecx;
    mov dword ptr [esi], edx;
    fmul dword ptr [esi];
    fmul dword ptr [esi];
#ifdef TARGET_X64
    mov rax, 0xfefefefe;
    fadd EEL_ASM_TYPE [rax];
#else
#if EEL_F_SIZE == 8
_emit 0xDC; // fadd qword ptr [0xfefefefe]
_emit 0x05;
_emit 0xFE;
_emit 0xFE;
_emit 0xFE;
_emit 0xFE;
#else
_emit 0xD8; // fadd dword ptr [0xfefefefe]
_emit 0x05;
_emit 0xFE;
_emit 0xFE;
_emit 0xFE;
_emit 0xFE;
#endif
#endif
    fmul dword ptr [esi];

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_invsqrt_end(void) {}


__declspec(naked) void nseel_asm_dbg_getstackptr(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#ifdef __clang__
    ffree st(0);
#else
    fstp st(0);
#endif
    mov dword ptr [esi], esp;
    fild dword ptr [esi];

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_dbg_getstackptr_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_sin(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fsin;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_sin_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_cos(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fcos;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_cos_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_tan(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fptan;
    fstp st(0);
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_tan_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_sqr(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fmul st(0), st(0);
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_sqr_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_sqrt(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fabs;
    fsqrt;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_sqrt_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_log(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fldln2;
    fxch;
    fyl2x;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_log_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_log10(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fldlg2;
    fxch;
    fyl2x;

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_log10_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_abs(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fabs;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_abs_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_assign(void)
{
#ifdef TARGET_X64

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov rdx, qword ptr [rax];
    mov rcx, rdx;
    shr rdx, 32;
    add edx, 0x00100000;
    and edx, 0x7FF00000;
    cmp edx, 0x00100000;
    mov rax, rdi;
    jg label_1;
      sub ecx, ecx;
label_1:
    
    mov qword ptr [edi], rcx;

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }

#else

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov ecx, dword ptr [eax];
    mov edx, dword ptr [eax+4];
    mov eax, edx;
    add eax, 0x00100000; // if exponent is zero, make exponent 0x7ff, if 7ff, make 7fe
    and eax, 0x7ff00000;
    cmp eax, 0x00100000;
    jg label_2;
      sub ecx, ecx;
      sub edx, edx;
label_2:
    
    mov eax, edi;
    mov dword ptr [edi], ecx;
    mov dword ptr [edi+4], edx;

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }

#endif
}
__declspec(naked) void nseel_asm_assign_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_assign_fromfp(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fstp qword ptr [edi];
    mov edx, dword ptr [edi+4];
    add edx, 0x00100000;
    and edx, 0x7FF00000;
    cmp edx, 0x00100000;
    mov eax, edi;
    jg label_3;
      sub edx, edx;
#ifdef TARGET_X64
      mov qword ptr [rdi], rdx;
#else
      mov dword ptr [edi], edx;
      mov dword ptr [edi+4], edx;
#endif
label_3:
    

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }
}
__declspec(naked) void nseel_asm_assign_fromfp_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_assign_fast_fromfp(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov eax, edi;
    fstp qword ptr [edi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
   }
}
__declspec(naked) void nseel_asm_assign_fast_fromfp_end(void) {}



//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_assign_fast(void)
{
#ifdef TARGET_X64

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov rdx, qword ptr [rax];
    mov qword ptr [edi], rdx;
    mov rax, rdi;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }

#else

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov ecx, dword ptr [eax];
    mov dword ptr [edi], ecx;
    mov ecx, dword ptr [eax+4];

    mov eax, edi;
    mov dword ptr [edi+4], ecx;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }

#endif
}
__declspec(naked) void nseel_asm_assign_fast_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_add(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#ifdef __clang__
          faddp st(1);
#else
          fadd;
#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
          }
}
__declspec(naked) void nseel_asm_add_end(void) {}

__declspec(naked) void nseel_asm_add_op(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fadd EEL_ASM_TYPE [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];

    mov edx, dword ptr [edi+4];
    add edx, 0x00100000;
    and edx, 0x7FF00000;
    cmp edx, 0x00100000;
    jg label_4;
      sub edx, edx;
#ifdef TARGET_X64
      mov qword ptr [rdi], rdx;
#else
      mov dword ptr [edi], edx;
      mov dword ptr [edi+4], edx;
#endif
label_4:
    
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_add_op_end(void) {}

__declspec(naked) void nseel_asm_add_op_fast(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fadd EEL_ASM_TYPE [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_add_op_fast_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_sub(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#ifdef __clang__
    fsubrp st(1), st(0);
#else
  #ifdef __GNUC__
    #ifdef __INTEL_COMPILER
      fsub;
    #else
      fsubr; // gnuc has fsub/fsubr backwards, ack
    #endif
  #else
    fsub;
  #endif
#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_sub_end(void) {}

__declspec(naked) void nseel_asm_sub_op(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fsubr EEL_ASM_TYPE [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];

    mov edx, dword ptr [edi+4];
    add edx, 0x00100000;
    and edx, 0x7FF00000;
    cmp edx, 0x00100000;
    jg label_5;
      sub edx, edx;
#ifdef TARGET_X64
      mov qword ptr [rdi], rdx;
#else
      mov dword ptr [edi], edx;
      mov dword ptr [edi+4], edx;
#endif
label_5:
    
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_sub_op_end(void) {}

__declspec(naked) void nseel_asm_sub_op_fast(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fsubr EEL_ASM_TYPE [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_sub_op_fast_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_mul(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#ifdef __clang__
          fmulp st(1), st(0);
#else
          fmul;
#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_mul_end(void) {}

__declspec(naked) void nseel_asm_mul_op(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fmul EEL_ASM_TYPE [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];

    mov edx, dword ptr [edi+4];
    add edx, 0x00100000;
    and edx, 0x7FF00000;
    cmp edx, 0x00100000;
    jg label_6;
      sub edx, edx;
#ifdef TARGET_X64
      mov qword ptr [rdi], rdx;
#else
      mov dword ptr [edi], edx;
      mov dword ptr [edi+4], edx;
#endif
label_6:
    
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_mul_op_end(void) {}

__declspec(naked) void nseel_asm_mul_op_fast(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fmul EEL_ASM_TYPE [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_mul_op_fast_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_div(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#ifdef __clang__
    fdivrp st(1);
#else
  #ifdef __GNUC__
    #ifdef __INTEL_COMPILER
      fdiv;
    #else
      fdivr; // gcc inline asm seems to have fdiv/fdivr backwards
    #endif
  #else
    fdiv;
  #endif
#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_div_end(void) {}

__declspec(naked) void nseel_asm_div_op(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fld EEL_ASM_TYPE [edi];
#ifdef __clang__
    fdivp st(1);
#else
  #ifndef __GNUC__
    fdivr;
  #else
    #ifdef __INTEL_COMPILER
      fdivp st(1);
    #else
      fdiv;
    #endif
  #endif
#endif
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];

    mov edx, dword ptr [edi+4];
    add edx, 0x00100000;
    and edx, 0x7FF00000;
    cmp edx, 0x00100000;
    jg label_7;
      sub edx, edx;
#ifdef TARGET_X64
      mov qword ptr [rdi], rdx;
#else
      mov dword ptr [edi], edx;
      mov dword ptr [edi+4], edx;
#endif
label_7:
    

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_div_op_end(void) {}

__declspec(naked) void nseel_asm_div_op_fast(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fld EEL_ASM_TYPE [edi];
#ifdef __clang__
    fdivp st(1);
#else
  #ifndef __GNUC__
    fdivr;
  #else
    #ifdef __INTEL_COMPILER
      fdivp st(1);
    #else
      fdiv;
    #endif
  #endif
#endif
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_div_op_fast_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_mod(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fabs;
    fistp dword ptr [esi];
    fabs;
    fistp dword ptr [esi+4];
    xor edx, edx;
    cmp dword ptr [esi], 0;
    je label_8; // skip devide, set return to 0
    mov eax, dword ptr [esi+4];
    div dword ptr [esi];
label_8:
    
    mov dword ptr [esi], edx;
    fild dword ptr [esi];

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_mod_end(void) {}

__declspec(naked) void nseel_asm_shl(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fistp dword ptr [esi];
    fistp dword ptr [esi+4];
    mov ecx, dword ptr [esi];
    mov eax, dword ptr [esi+4];
    shl eax, cl;
    mov dword ptr [esi], eax;
    fild dword ptr [esi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_shl_end(void) {}

__declspec(naked) void nseel_asm_shr(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fistp dword ptr [esi];
    fistp dword ptr [esi+4];
    mov ecx, dword ptr [esi];
    mov eax, dword ptr [esi+4];
    sar eax, cl;
    mov dword ptr [esi], eax;
    fild dword ptr [esi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_shr_end(void) {}


__declspec(naked) void nseel_asm_mod_op(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fld EEL_ASM_TYPE [edi];
    fxch;
    fabs;
    fistp dword ptr [edi];
    fabs;
    fistp dword ptr [esi];
    xor edx, edx;
    cmp dword ptr [edi], 0;
    je label_9; // skip devide, set return to 0
    mov eax, dword ptr [esi];
    div dword ptr [edi];
label_9:
    
    mov dword ptr [edi], edx;
    fild dword ptr [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }
}
__declspec(naked) void nseel_asm_mod_op_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_or(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fistp qword ptr [esi];
    fistp qword ptr [esi+8];
#ifdef TARGET_X64
    mov rdi, qword ptr [rsi+8];
    or qword ptr [rsi], rdi;
#else
    mov edi, dword ptr [esi+8];
    mov ecx, dword ptr [esi+12];
    or dword ptr [esi], edi;
    or dword ptr [esi+4], ecx;
#endif
    fild qword ptr [esi];

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_or_end(void) {}

__declspec(naked) void nseel_asm_or0(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fistp qword ptr [esi];
    fild qword ptr [esi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_or0_end(void) {}

__declspec(naked) void nseel_asm_or_op(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fld EEL_ASM_TYPE [edi];
    fxch;
    fistp qword ptr [edi];
    fistp qword ptr [esi];
#ifdef TARGET_X64
    mov rax, qword ptr [rsi];
    or qword ptr [rdi], rax;
#else
    mov eax, dword ptr [esi];
    mov ecx, dword ptr [esi+4];
    or dword ptr [edi], eax;
    or dword ptr [edi+4], ecx;
#endif
    fild qword ptr [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_or_op_end(void) {}


__declspec(naked) void nseel_asm_xor(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fistp qword ptr [esi];
    fistp qword ptr [esi+8];
#ifdef TARGET_X64
    mov rdi, qword ptr [rsi+8];
    xor qword ptr [rsi], rdi;
#else
    mov edi, dword ptr [esi+8];
    mov ecx, dword ptr [esi+12];
    xor dword ptr [esi], edi;
    xor dword ptr [esi+4], ecx;
#endif
    fild qword ptr [esi];

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_xor_end(void) {}

__declspec(naked) void nseel_asm_xor_op(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fld EEL_ASM_TYPE [edi];
    fxch;
    fistp qword ptr [edi];
    fistp qword ptr [esi];
#ifdef TARGET_X64
    mov rax, qword ptr [rsi];
    xor qword ptr [rdi], rax;
#else
    mov eax, dword ptr [esi];
    mov ecx, dword ptr [esi+4];
    xor dword ptr [edi], eax;
    xor dword ptr [edi+4], ecx;
#endif
    fild qword ptr [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_xor_op_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_and(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fistp qword ptr [esi];
    fistp qword ptr [esi+8];
#ifdef TARGET_X64
    mov rdi, qword ptr [rsi+8];
    and qword ptr [rsi], rdi;
#else
    mov edi, dword ptr [esi+8];
    mov ecx, dword ptr [esi+12];
    and dword ptr [esi], edi;
    and dword ptr [esi+4], ecx;
#endif
    fild qword ptr [esi];

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_and_end(void) {}

__declspec(naked) void nseel_asm_and_op(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fld EEL_ASM_TYPE [edi];
    fxch;
    fistp qword ptr [edi];
    fistp qword ptr [esi];
#ifdef TARGET_X64
    mov rax, qword ptr [rsi];
    and qword ptr [rdi], rax;
#else
    mov eax, dword ptr [esi];
    mov ecx, dword ptr [esi+4];
    and dword ptr [edi], eax;
    and dword ptr [edi+4], ecx;
#endif
    fild qword ptr [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_and_op_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_uplus(void) // this is the same as doing nothing, it seems
{
   __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
      
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }
}
__declspec(naked) void nseel_asm_uplus_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_uminus(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fchs;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_uminus_end(void) {}



//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_sign(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;

#ifdef TARGET_X64


    fst EEL_ASM_TYPE [rsi];
    mov rdx, EEL_ASM_TYPE [rsi];
    mov rcx, 0x7FFFFFFFFFFFFFFF;
    test rdx, rcx;
    jz label_10; // zero zero, return the value passed directly
      // calculate sign
      inc rcx; // rcx becomes 0x80000...
      fstp st(0);
      fld1;
      test rdx, rcx;
      jz label_10;
      fchs;
label_10:
  	

#else

    fst dword ptr [esi];
    mov ecx, dword ptr [esi];
    mov edx, 0x7FFFFFFF;
    test ecx, edx;
    jz label_11; // zero zero, return the value passed directly
      // calculate sign
      inc edx; // edx becomes 0x8000...
      fstp st(0);
      fld1;
      test ecx, edx;
      jz label_11;
      fchs;
label_11:
  	

#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
}
}
__declspec(naked) void nseel_asm_sign_end(void) {}



//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_bnot(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    test eax, eax;
    setz al;
    and eax, 0xff;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_bnot_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_fcall(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
     mov edx, 0xfefefefe;
#ifdef TARGET_X64
     sub esp, 8;
     call edx;
     add esp, 8;
#else
     sub esp, 12; /* keep stack 16 byte aligned, 4 bytes for return address */
     call edx;
     add esp, 12;
#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_fcall_end(void) {}

__declspec(naked) void nseel_asm_band(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    test eax, eax;
    jz label_12;

     mov ecx, 0xfefefefe;
#ifdef TARGET_X64
        sub rsp, 8;
#else
        sub esp, 12;
#endif
        call ecx;
#ifdef TARGET_X64
        add rsp, 8;
#else
        add esp, 12;
#endif
label_12:
    
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_band_end(void) {}

__declspec(naked) void nseel_asm_bor(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    test eax, eax;
    jnz label_13;

    mov ecx, 0xfefefefe;
#ifdef TARGET_X64
    sub rsp, 8;
#else
    sub esp, 12;
#endif
    call ecx;
#ifdef TARGET_X64
    add rsp, 8;
#else
    add esp, 12;
#endif
label_13:
    
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_bor_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_equal(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#ifdef __clang__
    fsubp st(1);
#else
    fsub;
#endif

    fabs;
#ifdef TARGET_X64
    fcomp EEL_ASM_TYPE [r12+-8]; //[g_closefact]
#else
    fcomp EEL_ASM_TYPE [ebx+-8]; //[g_closefact]
#endif
    fstsw ax;
    and eax, 256; // old behavior: if 256 set, true (NaN means true)

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_equal_end(void) {}
//
//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_equal_exact(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fcompp;
    fstsw ax; // for equal 256 and 1024 should be clear, 16384 should be set
    and eax, 17664;  // mask C4/C3/C1, bits 8/10/14, 16384|256|1024 -- if equals 16384, then equality
    cmp eax, 16384;
    je label_14;
    sub eax, eax;
label_14:
    
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_equal_exact_end(void) {}

__declspec(naked) void nseel_asm_notequal_exact(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fcompp;
    fstsw ax; // for equal 256 and 1024 should be clear, 16384 should be set
    and eax, 17664;  // mask C4/C3/C1, bits 8/10/14, 16384|256|1024 -- if equals 16384, then equality
    cmp eax, 16384;
    je label_15;
    sub eax, eax;
label_15:
    
    xor eax, 16384; // flip the result
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_notequal_exact_end(void) {}
//
//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_notequal(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#ifdef __clang__
    fsubp st(1);
#else
    fsub;
#endif

    fabs;
#ifdef TARGET_X64
    fcomp EEL_ASM_TYPE [r12+-8]; //[g_closefact]
#else
    fcomp EEL_ASM_TYPE [ebx+-8]; //[g_closefact]
#endif
    fstsw ax;
    and eax, 256;
    xor eax, 256; // old behavior: if 256 set, FALSE (NaN makes for false)
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_notequal_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_above(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fcompp;
    fstsw ax;
    and eax, 1280; //  (1024+256) old behavior: NaN would mean 1, preserve that
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_above_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_beloweq(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fcompp;
    fstsw ax;
    and eax, 256; // old behavior: NaN would be 0 (ugh)
    xor eax, 256;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_beloweq_end(void) {}


__declspec(naked) void nseel_asm_booltofp(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    test eax, eax;
    jz label_16;
    fld1;
    jmp label_17;
label_16:
    
    fldz;
label_17:
    
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_booltofp_end(void) {}

__declspec(naked) void nseel_asm_fptobool(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fabs;
#ifdef TARGET_X64
    fcomp EEL_ASM_TYPE [r12+-8]; //[g_closefact]
#else
    fcomp EEL_ASM_TYPE [ebx+-8]; //[g_closefact]
#endif
    fstsw ax;
    and eax, 256;
    xor eax, 256;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_fptobool_end(void) {}


__declspec(naked) void nseel_asm_min(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fld EEL_ASM_TYPE [edi];
    fcomp EEL_ASM_TYPE [eax];
    mov ecx, eax;
    fstsw ax;
    test eax, 256;
    mov eax, ecx;
    jz label_18;
    mov eax, edi;
label_18:
    
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }

}
__declspec(naked) void nseel_asm_min_end(void) {}

__declspec(naked) void nseel_asm_max(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fld EEL_ASM_TYPE [edi];
    fcomp EEL_ASM_TYPE [eax];
    mov ecx, eax;
    fstsw ax;
    test eax, 256;
    mov eax, ecx;
    jnz label_19;
    mov eax, edi;
label_19:
    
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }
}
__declspec(naked) void nseel_asm_max_end(void) {}



__declspec(naked) void nseel_asm_min_fp(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fcom;
    fstsw ax;
    test eax, 256;
    jz label_20;
    fxch;
label_20:
    
    fstp st(0);
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }

}
__declspec(naked) void nseel_asm_min_fp_end(void) {}

__declspec(naked) void nseel_asm_max_fp(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    fcom;
    fstsw ax;
    test eax, 256;
    jnz label_21;
    fxch;
label_21:
    
    fstp st(0);
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }
}
__declspec(naked) void nseel_asm_max_fp_end(void) {}



// just generic functions left, yay




__declspec(naked) void _asm_generic3parm(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#ifdef TARGET_X64

#ifdef AMD64ABI

    mov r15, rsi;
    mov rdx, rdi; // third parameter = parm
    mov rdi, 0xfefefefe; // first parameter= context

    mov rsi, ecx; // second parameter = parm
    mov rcx, rax; // fourth parameter = parm
    mov rax, 0xfefefefe; // call function
    call rax;

    mov rsi, r15;
#else
    mov edx, ecx; // second parameter = parm
    mov ecx, 0xfefefefe; // first parameter= context
    mov r8, rdi; // third parameter = parm
    mov r9, rax; // fourth parameter = parm
    mov edi, 0xfefefefe; // call function
    sub rsp, X64_EXTRA_STACK_SPACE;
    call edi;
    add rsp, X64_EXTRA_STACK_SPACE;
#endif

#else

    mov edx, 0xfefefefe;
    push eax; // push parameter
    push edi; // push parameter
    mov edi, 0xfefefefe;
    push ecx; // push parameter
    push edx; // push context pointer
    call edi;
    add esp, 16;

#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}
__declspec(naked) void _asm_generic3parm_end(void) {}


__declspec(naked) void _asm_generic3parm_retd(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#ifdef TARGET_X64
#ifdef AMD64ABI
    mov r15, rsi;
    mov rdx, rdi; // third parameter = parm
    mov rdi, 0xfefefefe; // first parameter= context
    mov rsi, ecx; // second parameter = parm
    mov rcx, rax; // fourth parameter = parm
    mov rax, 0xfefefefe; // call function
    call rax;
    mov rsi, r15;
    movq [r15], xmm0;
    fld qword ptr [r15];
#else
    mov edx, ecx; // second parameter = parm
    mov ecx, 0xfefefefe; // first parameter= context
    mov r8, rdi; // third parameter = parm
    mov r9, rax; // fourth parameter = parm
    mov edi, 0xfefefefe; // call function
    sub rsp, X64_EXTRA_STACK_SPACE;
    call edi;
    add rsp, X64_EXTRA_STACK_SPACE;
    movq [rsi], xmm0;
    fld qword ptr [rsi];
#endif
#else

    sub esp, 16;
    mov edx, 0xfefefefe;
    mov dword ptr [esp+8], edi;
    mov edi, 0xfefefefe;
    mov dword ptr [esp+12], eax;
    mov dword ptr [esp+4], ecx;
    mov dword ptr [esp], edx;
    call edi;
    add esp, 16;

#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}
__declspec(naked) void _asm_generic3parm_retd_end(void) {}


__declspec(naked) void _asm_generic2parm(void) // this prob neds to be fixed for ppc
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#ifdef TARGET_X64

#ifdef AMD64ABI
    mov r15, rsi;
    mov esi, edi; // second parameter = parm
    mov edi, 0xfefefefe; // first parameter= context
    mov rdx, rax; // third parameter = parm
    mov rcx, 0xfefefefe; // call function
    call rcx;
    mov rsi, r15;
#else
    mov ecx, 0xfefefefe; // first parameter= context
    mov edx, edi; // second parameter = parm
    mov r8, rax; // third parameter = parm
    mov edi, 0xfefefefe; // call function
    sub rsp, X64_EXTRA_STACK_SPACE;
    call edi;
    add rsp, X64_EXTRA_STACK_SPACE;
#endif
#else

    mov edx, 0xfefefefe;
    mov ecx, 0xfefefefe;
    sub esp, 4; // keep stack aligned
    push eax; // push parameter
    push edi; // push parameter
    push edx; // push context pointer
    call ecx;
    add esp, 16;

#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}
__declspec(naked) void _asm_generic2parm_end(void) {}


__declspec(naked) void _asm_generic2parm_retd(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#ifdef TARGET_X64
#ifdef AMD64ABI
    mov r15, rsi;
    mov rsi, rdi; // second parameter = parm
    mov rdi, 0xfefefefe; // first parameter= context
    mov rcx, 0xfefefefe; // call function
    mov rdx, rax; // third parameter = parm
    call rcx;
    mov rsi, r15;
    movq [r15], xmm0;
    fld qword ptr [r15];
#else
    mov rdx, rdi; // second parameter = parm
    mov rcx, 0xfefefefe; // first parameter= context
    mov rdi, 0xfefefefe; // call function
    mov r8, rax; // third parameter = parm
    sub rsp, X64_EXTRA_STACK_SPACE;
    call edi;
    add rsp, X64_EXTRA_STACK_SPACE;
    movq [rsi], xmm0;
    fld qword ptr [rsi];
#endif
#else

    sub esp, 16;
    mov edx, 0xfefefefe;
    mov ecx, 0xfefefefe;
    mov dword ptr [esp], edx;
    mov dword ptr [esp+4], edi;
    mov dword ptr [esp+8], eax;
    call ecx;
    add esp, 16;

#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}
__declspec(naked) void _asm_generic2parm_retd_end(void) {}





__declspec(naked) void _asm_generic1parm(void)
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#ifdef TARGET_X64
#ifdef AMD64ABI
    mov rdi, 0xfefefefe; // first parameter= context
    mov r15, rsi;
    mov rsi, eax; // second parameter = parm
    mov rcx, 0xfefefefe; // call function
    call rcx;
    mov rsi, r15;
#else
    mov ecx, 0xfefefefe; // first parameter= context
    mov edx, eax; // second parameter = parm
    mov edi, 0xfefefefe; // call function
    sub rsp, X64_EXTRA_STACK_SPACE;
    call edi;
    add rsp, X64_EXTRA_STACK_SPACE;
#endif
#else

    mov edx, 0xfefefefe;
    sub esp, 8; // keep stack aligned
    mov ecx, 0xfefefefe;
    push eax; // push parameter
    push edx; // push context pointer
    call ecx;
    add esp, 16;

#endif

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}
__declspec(naked) void _asm_generic1parm_end(void) {}


__declspec(naked) void _asm_generic1parm_retd(void) // 1 parameter returning double
{
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#ifdef TARGET_X64
#ifdef AMD64ABI
    mov rdi, 0xfefefefe; // first parameter = context pointer
    mov rcx, 0xfefefefe; // function address
    mov r15, rsi; // save rsi
    mov rsi, rax; // second parameter = parameter

    call rcx;

    mov rsi, r15;
    movq [r15], xmm0;
    fld qword ptr [r15];
#else
    mov ecx, 0xfefefefe; // first parameter= context
    mov edi, 0xfefefefe; // call function

    mov rdx, rax; // second parameter = parm

    sub rsp, X64_EXTRA_STACK_SPACE;
    call edi;
    add rsp, X64_EXTRA_STACK_SPACE;
    movq [rsi], xmm0;
    fld qword ptr [rsi];
#endif
#else

    mov edx, 0xfefefefe; // context pointer
    mov ecx, 0xfefefefe; // func-addr
    sub esp, 16;
    mov dword ptr [esp+4], eax; // push parameter
    mov dword ptr [esp], edx; // push context pointer
    call ecx;
    add esp, 16;

#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}
__declspec(naked) void _asm_generic1parm_retd_end(void) {}





// this gets its own stub because it's pretty crucial for performance :/

__declspec(naked) void _asm_megabuf(void)
{
  __asm {

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;

#ifdef TARGET_X64


#ifdef AMD64ABI

    fadd EEL_ASM_TYPE [r12+-8];

    fistp dword ptr [rsi];

    // check if (%rsi) is in range, and buffer available, otherwise call function
    mov edx, dword ptr [rsi];
    cmp rdx, ((NSEEL_RAM_BLOCKS*NSEEL_RAM_ITEMSPERBLOCK));      //REPLACE=((NSEEL_RAM_BLOCKS*NSEEL_RAM_ITEMSPERBLOCK))
    jae label_22;
      mov rax, rdx;
      shr rax, (NSEEL_RAM_ITEMSPERBLOCK_LOG2 - 3/*log2(sizeof(void *))*/   );     //REPLACE=(NSEEL_RAM_ITEMSPERBLOCK_LOG2 - 3/*log2(sizeof(void *))*/   )
      and rax, ((NSEEL_RAM_BLOCKS-1)*8 /*sizeof(void*)*/                   );     //REPLACE=((NSEEL_RAM_BLOCKS-1)*8 /*sizeof(void*)*/                   )
      mov rax, qword ptr [r12+rax];
      test rax, rax;
      jnz label_23;
label_22:
    
      mov rax, 0xfefefefe;
      mov rdi, r12; // set first parm to ctx
      mov r15, rsi; // save rsi
      mov esi, rdx; // esi becomes second parameter (edi is first, context pointer)
      call rax;
      mov rsi, r15; // restore rsi
      jmp label_24;
label_23:
    
      and rdx, (NSEEL_RAM_ITEMSPERBLOCK-1);      //REPLACE=(NSEEL_RAM_ITEMSPERBLOCK-1)
      shl rdx, 3;      // 3 is log2(sizeof(EEL_F))
      add rax, rdx;
label_24:
    

#else

    fadd EEL_ASM_TYPE [r12+-8];

    fistp dword ptr [rsi];

    // check if (%rsi) is in range...
    mov edi, dword ptr [rsi];
    cmp edi, ((NSEEL_RAM_BLOCKS*NSEEL_RAM_ITEMSPERBLOCK));       //REPLACE=((NSEEL_RAM_BLOCKS*NSEEL_RAM_ITEMSPERBLOCK))
    jae label_25;
      mov rax, rdi;
      shr rax, (NSEEL_RAM_ITEMSPERBLOCK_LOG2 - 3/*log2(sizeof(void *))*/   );       //REPLACE=(NSEEL_RAM_ITEMSPERBLOCK_LOG2 - 3/*log2(sizeof(void *))*/   )
      and rax, ((NSEEL_RAM_BLOCKS-1)*8 /*sizeof(void*)*/                   );       //REPLACE=((NSEEL_RAM_BLOCKS-1)*8 /*sizeof(void*)*/                   )
      mov rax, qword ptr [r12+rax];
      test rax, rax;
      jnz label_26;
label_25:
    
      mov rax, 0xfefefefe; // function ptr
      mov rcx, r12; // set first parm to ctx
      mov rdx, rdi; // rdx is second parameter (rcx is first)
      sub rsp, X64_EXTRA_STACK_SPACE;
      call rax;
      add rsp, X64_EXTRA_STACK_SPACE;
      jmp label_27;
label_26:
    
      and rdi, (NSEEL_RAM_ITEMSPERBLOCK-1);       //REPLACE=(NSEEL_RAM_ITEMSPERBLOCK-1)
      shl rdi, 3;       // 3 is log2(sizeof(EEL_F))
      add rax, rdi;
label_27:
    
#endif


_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
#else
    fadd EEL_ASM_TYPE [ebx+-8];
    fistp dword ptr [esi];

    // check if (%esi) is in range, and buffer available, otherwise call function
    mov edi, dword ptr [esi];
    cmp edi, ((NSEEL_RAM_BLOCKS*NSEEL_RAM_ITEMSPERBLOCK));     //REPLACE=((NSEEL_RAM_BLOCKS*NSEEL_RAM_ITEMSPERBLOCK))
    jae label_28;

      mov eax, edi;
      shr eax, (NSEEL_RAM_ITEMSPERBLOCK_LOG2 - 2/*log2(sizeof(void *))*/   );      //REPLACE=(NSEEL_RAM_ITEMSPERBLOCK_LOG2 - 2/*log2(sizeof(void *))*/   )
      and eax, ((NSEEL_RAM_BLOCKS-1)*4 /*sizeof(void*)*/                   );      //REPLACE=((NSEEL_RAM_BLOCKS-1)*4 /*sizeof(void*)*/                   )
      mov eax, dword ptr [ebx+eax];
      test eax, eax;
      jnz label_29;
label_28:
    
      sub esp, 8; // keep stack aligned
      mov ecx, 0xfefefefe;
      push edi; // parameter
      push ebx; // push context pointer
      call ecx;
      add esp, 16;
      jmp label_30;
label_29:
    
      and edi, (NSEEL_RAM_ITEMSPERBLOCK-1);      //REPLACE=(NSEEL_RAM_ITEMSPERBLOCK-1)
      shl edi, 3;      // 3 is log2(sizeof(EEL_F))
      add eax, edi;
label_30:
    
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;

    #ifndef _MSC_VER
        :: i; (((NSEEL_RAM_BLOCKS*NSEEL_RAM_ITEMSPERBLOCK))),
           i; ((NSEEL_RAM_ITEMSPERBLOCK_LOG2 - 2/*log2(sizeof(void *))*/   )),
           i; (((NSEEL_RAM_BLOCKS-1)*4 /*sizeof(void*)*/                   )),
           i; ((NSEEL_RAM_ITEMSPERBLOCK-1                                  ))
    #endif



#endif

  }
}

__declspec(naked) void _asm_megabuf_end(void) {}


__declspec(naked) void _asm_gmegabuf(void)
{
  __asm {

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;

#ifdef TARGET_X64


#ifdef AMD64ABI

    mov r15, rsi;
    fadd EEL_ASM_TYPE [r12+-8];
    mov rdi, 0xfefefefe; // first parameter = context pointer
    fistp dword ptr [rsi];
    mov edx, 0xfefefefe;
    mov esi, dword ptr [rsi];
    call rdx;
    mov rsi, r15;

#else
    fadd EEL_ASM_TYPE [r12+-8];
    mov rcx, 0xfefefefe; // first parameter = context pointer
    fistp dword ptr [rsi];
    mov rdi, 0xfefefefe;
    mov edx, dword ptr [rsi];
    sub rsp, X64_EXTRA_STACK_SPACE;
    call rdi;
    add rsp, X64_EXTRA_STACK_SPACE;
#endif


#else
    sub esp, 16; // keep stack aligned
    mov dword ptr [esp], 0xfefefefe;
    fadd EEL_ASM_TYPE [ebx+-8];
    mov edi, 0xfefefefe;
    fistp dword ptr [esp+4];
    call edi;
    add esp, 16;

#endif



_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}

__declspec(naked) void _asm_gmegabuf_end(void) {}

__declspec(naked) void nseel_asm_stack_push(void)
{
#ifdef TARGET_X64
  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov rdi, 0xfefefefe;
    mov rcx, qword ptr [rax];
    mov rax, qword ptr [rdi];
    add rax, 8;
    mov rdx, 0xFEFEFEFE;
    and rax, rdx;
    mov rdx, 0xFEFEFEFE;
    or rax, rdx;
    mov qword ptr [rax], rcx;
    mov qword ptr [rdi], rax;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }
#else

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov edi, 0xfefefefe;

    mov ecx, dword ptr [eax];
    mov edx, dword ptr [eax+4];

    mov eax, dword ptr [edi];

    add eax, 8;
    and eax, 0xfefefefe;
    or eax, 0xfefefefe;

    mov dword ptr [eax], ecx;
    mov dword ptr [eax+4], edx;

    mov dword ptr [edi], eax;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }

#endif

}
__declspec(naked) void nseel_asm_stack_push_end(void) {}



__declspec(naked) void nseel_asm_stack_pop(void)
{
#ifdef TARGET_X64

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
      mov rdi, 0xfefefefe;
      mov rcx, qword ptr [rdi];
      movq xmm0, [rcx];
      sub rcx, 8;
      mov rdx, 0xFEFEFEFE;
      and rcx, rdx;
      mov rdx, 0xFEFEFEFE;
      or rcx, rdx;
      mov qword ptr [rdi], rcx;
      movq [eax], xmm0;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }

#else

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov edi, 0xfefefefe;
    mov ecx, dword ptr [edi];
    fld EEL_ASM_TYPE [ecx];
    sub ecx, 8;
    and ecx, 0xfefefefe;
    or ecx, 0xfefefefe;
    mov dword ptr [edi], ecx;
    fstp EEL_ASM_TYPE [eax];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }

#endif
}
__declspec(naked) void nseel_asm_stack_pop_end(void) {}


__declspec(naked) void nseel_asm_stack_pop_fast(void)
{
#ifdef TARGET_X64

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
      mov rdi, 0xfefefefe;
      mov rcx, qword ptr [rdi];
      mov rax, rcx;
      sub rcx, 8;
      mov rdx, 0xFEFEFEFE;
      and rcx, rdx;
      mov rdx, 0xFEFEFEFE;
      or rcx, rdx;
      mov qword ptr [rdi], rcx;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }

#else

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov edi, 0xfefefefe;
    mov ecx, dword ptr [edi];
    mov eax, ecx;
    sub ecx, 8;
    and ecx, 0xfefefefe;
    or ecx, 0xfefefefe;
    mov dword ptr [edi], ecx;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }

#endif
}
__declspec(naked) void nseel_asm_stack_pop_fast_end(void) {}

__declspec(naked) void nseel_asm_stack_peek_int(void)
{
#ifdef TARGET_X64

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov rdi, 0xfefefefe;
    mov rax, qword ptr [rdi];
    mov rdx, 0xfefefefe;
    sub rax, rdx;
    mov rdx, 0xFEFEFEFE;
    and rax, rdx;
    mov rdx, 0xFEFEFEFE;
    or rax, rdx;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }

#else

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov edi, 0xfefefefe;
    mov eax, dword ptr [edi];
    mov edx, 0xfefefefe;
    sub eax, edx;
    and eax, 0xfefefefe;
    or eax, 0xfefefefe;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }

#endif

}
__declspec(naked) void nseel_asm_stack_peek_int_end(void) {}



__declspec(naked) void nseel_asm_stack_peek(void)
{
#ifdef TARGET_X64

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov rdi, 0xfefefefe;
    fistp dword ptr [rsi];
    mov rax, qword ptr [rdi];
    mov rdx, qword ptr [rsi];
    shl rdx, 3; // log2(sizeof(EEL_F))
    sub rax, rdx;
    mov rdx, 0xFEFEFEFE;
    and rax, rdx;
    mov rdx, 0xFEFEFEFE;
    or rax, rdx;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }

#else

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov edi, 0xfefefefe;
    fistp dword ptr [esi];
    mov eax, dword ptr [edi];
    mov edx, dword ptr [esi];
    shl edx, 3; // log2(sizeof(EEL_F))
    sub eax, edx;
    and eax, 0xfefefefe;
    or eax, 0xfefefefe;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }

#endif

}
__declspec(naked) void nseel_asm_stack_peek_end(void) {}


__declspec(naked) void nseel_asm_stack_peek_top(void)
{
#ifdef TARGET_X64

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov rdi, 0xfefefefe;
    mov rax, qword ptr [rdi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }

#else

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov edi, 0xfefefefe;
    mov eax, dword ptr [edi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }

#endif

}
__declspec(naked) void nseel_asm_stack_peek_top_end(void) {}

__declspec(naked) void nseel_asm_stack_exch(void)
{
#ifdef TARGET_X64

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov rdi, 0xfefefefe;
    mov rcx, qword ptr [rdi];
    movq xmm0, [rcx];
    movq xmm1, [rax];
    movq [rax], xmm0;
    movq [rcx], xmm1;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }

#else

  __asm {
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    mov edi, 0xfefefefe;
    mov ecx, dword ptr [edi];
    fld EEL_ASM_TYPE [ecx];
    fld EEL_ASM_TYPE [eax];
    fstp EEL_ASM_TYPE [ecx];
    fstp EEL_ASM_TYPE [eax];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }

#endif

}
__declspec(naked) void nseel_asm_stack_exch_end(void) {}

#ifdef TARGET_X64
__declspec(naked) void eel_callcode64()
{
	__asm {
#ifndef EEL_X64_NO_CHANGE_FPFLAGS
		sub rsp, 16;
		fnstcw [rsp];
		mov ax, [rsp];
		or ax, 0xE3F; // 53 or 64 bit precision, trunc, and masking all exceptions
		mov [rsp+4], ax;
		fldcw [rsp+4];
#endif
		push rbx;
		push rbp;
		push r12;
		push r13;
		push r14;
		push r15;

#ifdef AMD64ABI
    		mov r12, rsi; // second parameter is ram-blocks pointer
		call rdi;
#else
		push rdi;
		push rsi;
    		mov r12, rdx; // second parameter is ram-blocks pointer
		call rcx;
		pop rsi;
		pop rdi;
#endif

		fclex;

		pop r15;
		pop r14;
		pop r13;
		pop r12;
		pop rbp;
		pop rbx;

#ifndef EEL_X64_NO_CHANGE_FPFLAGS
		fldcw [rsp];
		add rsp, 16;
#endif

		ret;
	}
}

__declspec(naked) void eel_setfp_round()
{
	__asm {
#ifndef EEL_X64_NO_CHANGE_FPFLAGS
		sub rsp, 16;
		fnstcw [rsp];
		mov ax, [rsp];
		and ax, 0xF3FF; // set round to nearest
		mov [rsp+4], ax;
		fldcw [rsp+4];
		add rsp, 16;
#endif
		ret;
	}
}

__declspec(naked) void eel_setfp_trunc()
{
	__asm {
#ifndef EEL_X64_NO_CHANGE_FPFLAGS
		sub rsp, 16;
		fnstcw [rsp];
		mov ax, [rsp];
		or ax, 0xC00; // set to truncate
		mov [rsp+4], ax;
		fldcw [rsp+4];
		add rsp, 16;
#endif
		ret;
	}
}

#endif
