{-# LANGUAGE PatternSynonyms #-}
--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.GL.Core46
-- Copyright   :  (c) Sven Panne 2018
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
--------------------------------------------------------------------------------

module Graphics.GL.Core46 (
  -- * Types
  GLDEBUGPROC,
  GLDEBUGPROCFunc,
  GLbitfield,
  GLboolean,
  GLbyte,
  GLchar,
  GLclampd,
  GLclampf,
  GLdouble,
  GLenum,
  GLfloat,
  GLhalf,
  GLint,
  GLint64,
  GLintptr,
  GLshort,
  GLsizei,
  GLsizeiptr,
  GLsync,
  GLubyte,
  GLuint,
  GLuint64,
  GLushort,
  GLvoid,
  makeGLDEBUGPROC,
  -- * Enums
  pattern GL_ACTIVE_ATOMIC_COUNTER_BUFFERS,
  pattern GL_ACTIVE_ATTRIBUTES,
  pattern GL_ACTIVE_ATTRIBUTE_MAX_LENGTH,
  pattern GL_ACTIVE_PROGRAM,
  pattern GL_ACTIVE_RESOURCES,
  pattern GL_ACTIVE_SUBROUTINES,
  pattern GL_ACTIVE_SUBROUTINE_MAX_LENGTH,
  pattern GL_ACTIVE_SUBROUTINE_UNIFORMS,
  pattern GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS,
  pattern GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH,
  pattern GL_ACTIVE_TEXTURE,
  pattern GL_ACTIVE_UNIFORMS,
  pattern GL_ACTIVE_UNIFORM_BLOCKS,
  pattern GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH,
  pattern GL_ACTIVE_UNIFORM_MAX_LENGTH,
  pattern GL_ACTIVE_VARIABLES,
  pattern GL_ALIASED_LINE_WIDTH_RANGE,
  pattern GL_ALL_BARRIER_BITS,
  pattern GL_ALL_SHADER_BITS,
  pattern GL_ALPHA,
  pattern GL_ALREADY_SIGNALED,
  pattern GL_ALWAYS,
  pattern GL_AND,
  pattern GL_AND_INVERTED,
  pattern GL_AND_REVERSE,
  pattern GL_ANY_SAMPLES_PASSED,
  pattern GL_ANY_SAMPLES_PASSED_CONSERVATIVE,
  pattern GL_ARRAY_BUFFER,
  pattern GL_ARRAY_BUFFER_BINDING,
  pattern GL_ARRAY_SIZE,
  pattern GL_ARRAY_STRIDE,
  pattern GL_ATOMIC_COUNTER_BARRIER_BIT,
  pattern GL_ATOMIC_COUNTER_BUFFER,
  pattern GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS,
  pattern GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES,
  pattern GL_ATOMIC_COUNTER_BUFFER_BINDING,
  pattern GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE,
  pattern GL_ATOMIC_COUNTER_BUFFER_INDEX,
  pattern GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER,
  pattern GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER,
  pattern GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER,
  pattern GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER,
  pattern GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER,
  pattern GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER,
  pattern GL_ATOMIC_COUNTER_BUFFER_SIZE,
  pattern GL_ATOMIC_COUNTER_BUFFER_START,
  pattern GL_ATTACHED_SHADERS,
  pattern GL_AUTO_GENERATE_MIPMAP,
  pattern GL_BACK,
  pattern GL_BACK_LEFT,
  pattern GL_BACK_RIGHT,
  pattern GL_BGR,
  pattern GL_BGRA,
  pattern GL_BGRA_INTEGER,
  pattern GL_BGR_INTEGER,
  pattern GL_BLEND,
  pattern GL_BLEND_COLOR,
  pattern GL_BLEND_DST,
  pattern GL_BLEND_DST_ALPHA,
  pattern GL_BLEND_DST_RGB,
  pattern GL_BLEND_EQUATION,
  pattern GL_BLEND_EQUATION_ALPHA,
  pattern GL_BLEND_EQUATION_RGB,
  pattern GL_BLEND_SRC,
  pattern GL_BLEND_SRC_ALPHA,
  pattern GL_BLEND_SRC_RGB,
  pattern GL_BLOCK_INDEX,
  pattern GL_BLUE,
  pattern GL_BLUE_INTEGER,
  pattern GL_BOOL,
  pattern GL_BOOL_VEC2,
  pattern GL_BOOL_VEC3,
  pattern GL_BOOL_VEC4,
  pattern GL_BUFFER,
  pattern GL_BUFFER_ACCESS,
  pattern GL_BUFFER_ACCESS_FLAGS,
  pattern GL_BUFFER_BINDING,
  pattern GL_BUFFER_DATA_SIZE,
  pattern GL_BUFFER_IMMUTABLE_STORAGE,
  pattern GL_BUFFER_MAPPED,
  pattern GL_BUFFER_MAP_LENGTH,
  pattern GL_BUFFER_MAP_OFFSET,
  pattern GL_BUFFER_MAP_POINTER,
  pattern GL_BUFFER_SIZE,
  pattern GL_BUFFER_STORAGE_FLAGS,
  pattern GL_BUFFER_UPDATE_BARRIER_BIT,
  pattern GL_BUFFER_USAGE,
  pattern GL_BUFFER_VARIABLE,
  pattern GL_BYTE,
  pattern GL_CAVEAT_SUPPORT,
  pattern GL_CCW,
  pattern GL_CLAMP_READ_COLOR,
  pattern GL_CLAMP_TO_BORDER,
  pattern GL_CLAMP_TO_EDGE,
  pattern GL_CLEAR,
  pattern GL_CLEAR_BUFFER,
  pattern GL_CLEAR_TEXTURE,
  pattern GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT,
  pattern GL_CLIENT_STORAGE_BIT,
  pattern GL_CLIPPING_INPUT_PRIMITIVES,
  pattern GL_CLIPPING_OUTPUT_PRIMITIVES,
  pattern GL_CLIP_DEPTH_MODE,
  pattern GL_CLIP_DISTANCE0,
  pattern GL_CLIP_DISTANCE1,
  pattern GL_CLIP_DISTANCE2,
  pattern GL_CLIP_DISTANCE3,
  pattern GL_CLIP_DISTANCE4,
  pattern GL_CLIP_DISTANCE5,
  pattern GL_CLIP_DISTANCE6,
  pattern GL_CLIP_DISTANCE7,
  pattern GL_CLIP_ORIGIN,
  pattern GL_COLOR,
  pattern GL_COLOR_ATTACHMENT0,
  pattern GL_COLOR_ATTACHMENT1,
  pattern GL_COLOR_ATTACHMENT10,
  pattern GL_COLOR_ATTACHMENT11,
  pattern GL_COLOR_ATTACHMENT12,
  pattern GL_COLOR_ATTACHMENT13,
  pattern GL_COLOR_ATTACHMENT14,
  pattern GL_COLOR_ATTACHMENT15,
  pattern GL_COLOR_ATTACHMENT16,
  pattern GL_COLOR_ATTACHMENT17,
  pattern GL_COLOR_ATTACHMENT18,
  pattern GL_COLOR_ATTACHMENT19,
  pattern GL_COLOR_ATTACHMENT2,
  pattern GL_COLOR_ATTACHMENT20,
  pattern GL_COLOR_ATTACHMENT21,
  pattern GL_COLOR_ATTACHMENT22,
  pattern GL_COLOR_ATTACHMENT23,
  pattern GL_COLOR_ATTACHMENT24,
  pattern GL_COLOR_ATTACHMENT25,
  pattern GL_COLOR_ATTACHMENT26,
  pattern GL_COLOR_ATTACHMENT27,
  pattern GL_COLOR_ATTACHMENT28,
  pattern GL_COLOR_ATTACHMENT29,
  pattern GL_COLOR_ATTACHMENT3,
  pattern GL_COLOR_ATTACHMENT30,
  pattern GL_COLOR_ATTACHMENT31,
  pattern GL_COLOR_ATTACHMENT4,
  pattern GL_COLOR_ATTACHMENT5,
  pattern GL_COLOR_ATTACHMENT6,
  pattern GL_COLOR_ATTACHMENT7,
  pattern GL_COLOR_ATTACHMENT8,
  pattern GL_COLOR_ATTACHMENT9,
  pattern GL_COLOR_BUFFER_BIT,
  pattern GL_COLOR_CLEAR_VALUE,
  pattern GL_COLOR_COMPONENTS,
  pattern GL_COLOR_ENCODING,
  pattern GL_COLOR_LOGIC_OP,
  pattern GL_COLOR_RENDERABLE,
  pattern GL_COLOR_WRITEMASK,
  pattern GL_COMMAND_BARRIER_BIT,
  pattern GL_COMPARE_REF_TO_TEXTURE,
  pattern GL_COMPATIBLE_SUBROUTINES,
  pattern GL_COMPILE_STATUS,
  pattern GL_COMPRESSED_R11_EAC,
  pattern GL_COMPRESSED_RED,
  pattern GL_COMPRESSED_RED_RGTC1,
  pattern GL_COMPRESSED_RG,
  pattern GL_COMPRESSED_RG11_EAC,
  pattern GL_COMPRESSED_RGB,
  pattern GL_COMPRESSED_RGB8_ETC2,
  pattern GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2,
  pattern GL_COMPRESSED_RGBA,
  pattern GL_COMPRESSED_RGBA8_ETC2_EAC,
  pattern GL_COMPRESSED_RGBA_BPTC_UNORM,
  pattern GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT,
  pattern GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT,
  pattern GL_COMPRESSED_RG_RGTC2,
  pattern GL_COMPRESSED_SIGNED_R11_EAC,
  pattern GL_COMPRESSED_SIGNED_RED_RGTC1,
  pattern GL_COMPRESSED_SIGNED_RG11_EAC,
  pattern GL_COMPRESSED_SIGNED_RG_RGTC2,
  pattern GL_COMPRESSED_SRGB,
  pattern GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC,
  pattern GL_COMPRESSED_SRGB8_ETC2,
  pattern GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2,
  pattern GL_COMPRESSED_SRGB_ALPHA,
  pattern GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM,
  pattern GL_COMPRESSED_TEXTURE_FORMATS,
  pattern GL_COMPUTE_SHADER,
  pattern GL_COMPUTE_SHADER_BIT,
  pattern GL_COMPUTE_SHADER_INVOCATIONS,
  pattern GL_COMPUTE_SUBROUTINE,
  pattern GL_COMPUTE_SUBROUTINE_UNIFORM,
  pattern GL_COMPUTE_TEXTURE,
  pattern GL_COMPUTE_WORK_GROUP_SIZE,
  pattern GL_CONDITION_SATISFIED,
  pattern GL_CONSTANT_ALPHA,
  pattern GL_CONSTANT_COLOR,
  pattern GL_CONTEXT_COMPATIBILITY_PROFILE_BIT,
  pattern GL_CONTEXT_CORE_PROFILE_BIT,
  pattern GL_CONTEXT_FLAGS,
  pattern GL_CONTEXT_FLAG_DEBUG_BIT,
  pattern GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT,
  pattern GL_CONTEXT_FLAG_NO_ERROR_BIT,
  pattern GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT,
  pattern GL_CONTEXT_LOST,
  pattern GL_CONTEXT_PROFILE_MASK,
  pattern GL_CONTEXT_RELEASE_BEHAVIOR,
  pattern GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH,
  pattern GL_COPY,
  pattern GL_COPY_INVERTED,
  pattern GL_COPY_READ_BUFFER,
  pattern GL_COPY_READ_BUFFER_BINDING,
  pattern GL_COPY_WRITE_BUFFER,
  pattern GL_COPY_WRITE_BUFFER_BINDING,
  pattern GL_CULL_FACE,
  pattern GL_CULL_FACE_MODE,
  pattern GL_CURRENT_PROGRAM,
  pattern GL_CURRENT_QUERY,
  pattern GL_CURRENT_VERTEX_ATTRIB,
  pattern GL_CW,
  pattern GL_DEBUG_CALLBACK_FUNCTION,
  pattern GL_DEBUG_CALLBACK_USER_PARAM,
  pattern GL_DEBUG_GROUP_STACK_DEPTH,
  pattern GL_DEBUG_LOGGED_MESSAGES,
  pattern GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH,
  pattern GL_DEBUG_OUTPUT,
  pattern GL_DEBUG_OUTPUT_SYNCHRONOUS,
  pattern GL_DEBUG_SEVERITY_HIGH,
  pattern GL_DEBUG_SEVERITY_LOW,
  pattern GL_DEBUG_SEVERITY_MEDIUM,
  pattern GL_DEBUG_SEVERITY_NOTIFICATION,
  pattern GL_DEBUG_SOURCE_API,
  pattern GL_DEBUG_SOURCE_APPLICATION,
  pattern GL_DEBUG_SOURCE_OTHER,
  pattern GL_DEBUG_SOURCE_SHADER_COMPILER,
  pattern GL_DEBUG_SOURCE_THIRD_PARTY,
  pattern GL_DEBUG_SOURCE_WINDOW_SYSTEM,
  pattern GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR,
  pattern GL_DEBUG_TYPE_ERROR,
  pattern GL_DEBUG_TYPE_MARKER,
  pattern GL_DEBUG_TYPE_OTHER,
  pattern GL_DEBUG_TYPE_PERFORMANCE,
  pattern GL_DEBUG_TYPE_POP_GROUP,
  pattern GL_DEBUG_TYPE_PORTABILITY,
  pattern GL_DEBUG_TYPE_PUSH_GROUP,
  pattern GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR,
  pattern GL_DECR,
  pattern GL_DECR_WRAP,
  pattern GL_DELETE_STATUS,
  pattern GL_DEPTH,
  pattern GL_DEPTH24_STENCIL8,
  pattern GL_DEPTH32F_STENCIL8,
  pattern GL_DEPTH_ATTACHMENT,
  pattern GL_DEPTH_BUFFER_BIT,
  pattern GL_DEPTH_CLAMP,
  pattern GL_DEPTH_CLEAR_VALUE,
  pattern GL_DEPTH_COMPONENT,
  pattern GL_DEPTH_COMPONENT16,
  pattern GL_DEPTH_COMPONENT24,
  pattern GL_DEPTH_COMPONENT32,
  pattern GL_DEPTH_COMPONENT32F,
  pattern GL_DEPTH_COMPONENTS,
  pattern GL_DEPTH_FUNC,
  pattern GL_DEPTH_RANGE,
  pattern GL_DEPTH_RENDERABLE,
  pattern GL_DEPTH_STENCIL,
  pattern GL_DEPTH_STENCIL_ATTACHMENT,
  pattern GL_DEPTH_STENCIL_TEXTURE_MODE,
  pattern GL_DEPTH_TEST,
  pattern GL_DEPTH_WRITEMASK,
  pattern GL_DISPATCH_INDIRECT_BUFFER,
  pattern GL_DISPATCH_INDIRECT_BUFFER_BINDING,
  pattern GL_DITHER,
  pattern GL_DONT_CARE,
  pattern GL_DOUBLE,
  pattern GL_DOUBLEBUFFER,
  pattern GL_DOUBLE_MAT2,
  pattern GL_DOUBLE_MAT2x3,
  pattern GL_DOUBLE_MAT2x4,
  pattern GL_DOUBLE_MAT3,
  pattern GL_DOUBLE_MAT3x2,
  pattern GL_DOUBLE_MAT3x4,
  pattern GL_DOUBLE_MAT4,
  pattern GL_DOUBLE_MAT4x2,
  pattern GL_DOUBLE_MAT4x3,
  pattern GL_DOUBLE_VEC2,
  pattern GL_DOUBLE_VEC3,
  pattern GL_DOUBLE_VEC4,
  pattern GL_DRAW_BUFFER,
  pattern GL_DRAW_BUFFER0,
  pattern GL_DRAW_BUFFER1,
  pattern GL_DRAW_BUFFER10,
  pattern GL_DRAW_BUFFER11,
  pattern GL_DRAW_BUFFER12,
  pattern GL_DRAW_BUFFER13,
  pattern GL_DRAW_BUFFER14,
  pattern GL_DRAW_BUFFER15,
  pattern GL_DRAW_BUFFER2,
  pattern GL_DRAW_BUFFER3,
  pattern GL_DRAW_BUFFER4,
  pattern GL_DRAW_BUFFER5,
  pattern GL_DRAW_BUFFER6,
  pattern GL_DRAW_BUFFER7,
  pattern GL_DRAW_BUFFER8,
  pattern GL_DRAW_BUFFER9,
  pattern GL_DRAW_FRAMEBUFFER,
  pattern GL_DRAW_FRAMEBUFFER_BINDING,
  pattern GL_DRAW_INDIRECT_BUFFER,
  pattern GL_DRAW_INDIRECT_BUFFER_BINDING,
  pattern GL_DST_ALPHA,
  pattern GL_DST_COLOR,
  pattern GL_DYNAMIC_COPY,
  pattern GL_DYNAMIC_DRAW,
  pattern GL_DYNAMIC_READ,
  pattern GL_DYNAMIC_STORAGE_BIT,
  pattern GL_ELEMENT_ARRAY_BARRIER_BIT,
  pattern GL_ELEMENT_ARRAY_BUFFER,
  pattern GL_ELEMENT_ARRAY_BUFFER_BINDING,
  pattern GL_EQUAL,
  pattern GL_EQUIV,
  pattern GL_EXTENSIONS,
  pattern GL_FALSE,
  pattern GL_FASTEST,
  pattern GL_FILL,
  pattern GL_FILTER,
  pattern GL_FIRST_VERTEX_CONVENTION,
  pattern GL_FIXED,
  pattern GL_FIXED_ONLY,
  pattern GL_FLOAT,
  pattern GL_FLOAT_32_UNSIGNED_INT_24_8_REV,
  pattern GL_FLOAT_MAT2,
  pattern GL_FLOAT_MAT2x3,
  pattern GL_FLOAT_MAT2x4,
  pattern GL_FLOAT_MAT3,
  pattern GL_FLOAT_MAT3x2,
  pattern GL_FLOAT_MAT3x4,
  pattern GL_FLOAT_MAT4,
  pattern GL_FLOAT_MAT4x2,
  pattern GL_FLOAT_MAT4x3,
  pattern GL_FLOAT_VEC2,
  pattern GL_FLOAT_VEC3,
  pattern GL_FLOAT_VEC4,
  pattern GL_FRACTIONAL_EVEN,
  pattern GL_FRACTIONAL_ODD,
  pattern GL_FRAGMENT_INTERPOLATION_OFFSET_BITS,
  pattern GL_FRAGMENT_SHADER,
  pattern GL_FRAGMENT_SHADER_BIT,
  pattern GL_FRAGMENT_SHADER_DERIVATIVE_HINT,
  pattern GL_FRAGMENT_SHADER_INVOCATIONS,
  pattern GL_FRAGMENT_SUBROUTINE,
  pattern GL_FRAGMENT_SUBROUTINE_UNIFORM,
  pattern GL_FRAGMENT_TEXTURE,
  pattern GL_FRAMEBUFFER,
  pattern GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE,
  pattern GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE,
  pattern GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING,
  pattern GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE,
  pattern GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE,
  pattern GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE,
  pattern GL_FRAMEBUFFER_ATTACHMENT_LAYERED,
  pattern GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME,
  pattern GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE,
  pattern GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE,
  pattern GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE,
  pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE,
  pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER,
  pattern GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL,
  pattern GL_FRAMEBUFFER_BARRIER_BIT,
  pattern GL_FRAMEBUFFER_BINDING,
  pattern GL_FRAMEBUFFER_BLEND,
  pattern GL_FRAMEBUFFER_COMPLETE,
  pattern GL_FRAMEBUFFER_DEFAULT,
  pattern GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS,
  pattern GL_FRAMEBUFFER_DEFAULT_HEIGHT,
  pattern GL_FRAMEBUFFER_DEFAULT_LAYERS,
  pattern GL_FRAMEBUFFER_DEFAULT_SAMPLES,
  pattern GL_FRAMEBUFFER_DEFAULT_WIDTH,
  pattern GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT,
  pattern GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER,
  pattern GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS,
  pattern GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT,
  pattern GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE,
  pattern GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER,
  pattern GL_FRAMEBUFFER_RENDERABLE,
  pattern GL_FRAMEBUFFER_RENDERABLE_LAYERED,
  pattern GL_FRAMEBUFFER_SRGB,
  pattern GL_FRAMEBUFFER_UNDEFINED,
  pattern GL_FRAMEBUFFER_UNSUPPORTED,
  pattern GL_FRONT,
  pattern GL_FRONT_AND_BACK,
  pattern GL_FRONT_FACE,
  pattern GL_FRONT_LEFT,
  pattern GL_FRONT_RIGHT,
  pattern GL_FULL_SUPPORT,
  pattern GL_FUNC_ADD,
  pattern GL_FUNC_REVERSE_SUBTRACT,
  pattern GL_FUNC_SUBTRACT,
  pattern GL_GEOMETRY_INPUT_TYPE,
  pattern GL_GEOMETRY_OUTPUT_TYPE,
  pattern GL_GEOMETRY_SHADER,
  pattern GL_GEOMETRY_SHADER_BIT,
  pattern GL_GEOMETRY_SHADER_INVOCATIONS,
  pattern GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED,
  pattern GL_GEOMETRY_SUBROUTINE,
  pattern GL_GEOMETRY_SUBROUTINE_UNIFORM,
  pattern GL_GEOMETRY_TEXTURE,
  pattern GL_GEOMETRY_VERTICES_OUT,
  pattern GL_GEQUAL,
  pattern GL_GET_TEXTURE_IMAGE_FORMAT,
  pattern GL_GET_TEXTURE_IMAGE_TYPE,
  pattern GL_GREATER,
  pattern GL_GREEN,
  pattern GL_GREEN_INTEGER,
  pattern GL_GUILTY_CONTEXT_RESET,
  pattern GL_HALF_FLOAT,
  pattern GL_HIGH_FLOAT,
  pattern GL_HIGH_INT,
  pattern GL_IMAGE_1D,
  pattern GL_IMAGE_1D_ARRAY,
  pattern GL_IMAGE_2D,
  pattern GL_IMAGE_2D_ARRAY,
  pattern GL_IMAGE_2D_MULTISAMPLE,
  pattern GL_IMAGE_2D_MULTISAMPLE_ARRAY,
  pattern GL_IMAGE_2D_RECT,
  pattern GL_IMAGE_3D,
  pattern GL_IMAGE_BINDING_ACCESS,
  pattern GL_IMAGE_BINDING_FORMAT,
  pattern GL_IMAGE_BINDING_LAYER,
  pattern GL_IMAGE_BINDING_LAYERED,
  pattern GL_IMAGE_BINDING_LEVEL,
  pattern GL_IMAGE_BINDING_NAME,
  pattern GL_IMAGE_BUFFER,
  pattern GL_IMAGE_CLASS_10_10_10_2,
  pattern GL_IMAGE_CLASS_11_11_10,
  pattern GL_IMAGE_CLASS_1_X_16,
  pattern GL_IMAGE_CLASS_1_X_32,
  pattern GL_IMAGE_CLASS_1_X_8,
  pattern GL_IMAGE_CLASS_2_X_16,
  pattern GL_IMAGE_CLASS_2_X_32,
  pattern GL_IMAGE_CLASS_2_X_8,
  pattern GL_IMAGE_CLASS_4_X_16,
  pattern GL_IMAGE_CLASS_4_X_32,
  pattern GL_IMAGE_CLASS_4_X_8,
  pattern GL_IMAGE_COMPATIBILITY_CLASS,
  pattern GL_IMAGE_CUBE,
  pattern GL_IMAGE_CUBE_MAP_ARRAY,
  pattern GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS,
  pattern GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE,
  pattern GL_IMAGE_FORMAT_COMPATIBILITY_TYPE,
  pattern GL_IMAGE_PIXEL_FORMAT,
  pattern GL_IMAGE_PIXEL_TYPE,
  pattern GL_IMAGE_TEXEL_SIZE,
  pattern GL_IMPLEMENTATION_COLOR_READ_FORMAT,
  pattern GL_IMPLEMENTATION_COLOR_READ_TYPE,
  pattern GL_INCR,
  pattern GL_INCR_WRAP,
  pattern GL_INFO_LOG_LENGTH,
  pattern GL_INNOCENT_CONTEXT_RESET,
  pattern GL_INT,
  pattern GL_INTERLEAVED_ATTRIBS,
  pattern GL_INTERNALFORMAT_ALPHA_SIZE,
  pattern GL_INTERNALFORMAT_ALPHA_TYPE,
  pattern GL_INTERNALFORMAT_BLUE_SIZE,
  pattern GL_INTERNALFORMAT_BLUE_TYPE,
  pattern GL_INTERNALFORMAT_DEPTH_SIZE,
  pattern GL_INTERNALFORMAT_DEPTH_TYPE,
  pattern GL_INTERNALFORMAT_GREEN_SIZE,
  pattern GL_INTERNALFORMAT_GREEN_TYPE,
  pattern GL_INTERNALFORMAT_PREFERRED,
  pattern GL_INTERNALFORMAT_RED_SIZE,
  pattern GL_INTERNALFORMAT_RED_TYPE,
  pattern GL_INTERNALFORMAT_SHARED_SIZE,
  pattern GL_INTERNALFORMAT_STENCIL_SIZE,
  pattern GL_INTERNALFORMAT_STENCIL_TYPE,
  pattern GL_INTERNALFORMAT_SUPPORTED,
  pattern GL_INT_2_10_10_10_REV,
  pattern GL_INT_IMAGE_1D,
  pattern GL_INT_IMAGE_1D_ARRAY,
  pattern GL_INT_IMAGE_2D,
  pattern GL_INT_IMAGE_2D_ARRAY,
  pattern GL_INT_IMAGE_2D_MULTISAMPLE,
  pattern GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY,
  pattern GL_INT_IMAGE_2D_RECT,
  pattern GL_INT_IMAGE_3D,
  pattern GL_INT_IMAGE_BUFFER,
  pattern GL_INT_IMAGE_CUBE,
  pattern GL_INT_IMAGE_CUBE_MAP_ARRAY,
  pattern GL_INT_SAMPLER_1D,
  pattern GL_INT_SAMPLER_1D_ARRAY,
  pattern GL_INT_SAMPLER_2D,
  pattern GL_INT_SAMPLER_2D_ARRAY,
  pattern GL_INT_SAMPLER_2D_MULTISAMPLE,
  pattern GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY,
  pattern GL_INT_SAMPLER_2D_RECT,
  pattern GL_INT_SAMPLER_3D,
  pattern GL_INT_SAMPLER_BUFFER,
  pattern GL_INT_SAMPLER_CUBE,
  pattern GL_INT_SAMPLER_CUBE_MAP_ARRAY,
  pattern GL_INT_VEC2,
  pattern GL_INT_VEC3,
  pattern GL_INT_VEC4,
  pattern GL_INVALID_ENUM,
  pattern GL_INVALID_FRAMEBUFFER_OPERATION,
  pattern GL_INVALID_INDEX,
  pattern GL_INVALID_OPERATION,
  pattern GL_INVALID_VALUE,
  pattern GL_INVERT,
  pattern GL_ISOLINES,
  pattern GL_IS_PER_PATCH,
  pattern GL_IS_ROW_MAJOR,
  pattern GL_KEEP,
  pattern GL_LAST_VERTEX_CONVENTION,
  pattern GL_LAYER_PROVOKING_VERTEX,
  pattern GL_LEFT,
  pattern GL_LEQUAL,
  pattern GL_LESS,
  pattern GL_LINE,
  pattern GL_LINEAR,
  pattern GL_LINEAR_MIPMAP_LINEAR,
  pattern GL_LINEAR_MIPMAP_NEAREST,
  pattern GL_LINES,
  pattern GL_LINES_ADJACENCY,
  pattern GL_LINE_LOOP,
  pattern GL_LINE_SMOOTH,
  pattern GL_LINE_SMOOTH_HINT,
  pattern GL_LINE_STRIP,
  pattern GL_LINE_STRIP_ADJACENCY,
  pattern GL_LINE_WIDTH,
  pattern GL_LINE_WIDTH_GRANULARITY,
  pattern GL_LINE_WIDTH_RANGE,
  pattern GL_LINK_STATUS,
  pattern GL_LOCATION,
  pattern GL_LOCATION_COMPONENT,
  pattern GL_LOCATION_INDEX,
  pattern GL_LOGIC_OP_MODE,
  pattern GL_LOSE_CONTEXT_ON_RESET,
  pattern GL_LOWER_LEFT,
  pattern GL_LOW_FLOAT,
  pattern GL_LOW_INT,
  pattern GL_MAJOR_VERSION,
  pattern GL_MANUAL_GENERATE_MIPMAP,
  pattern GL_MAP_COHERENT_BIT,
  pattern GL_MAP_FLUSH_EXPLICIT_BIT,
  pattern GL_MAP_INVALIDATE_BUFFER_BIT,
  pattern GL_MAP_INVALIDATE_RANGE_BIT,
  pattern GL_MAP_PERSISTENT_BIT,
  pattern GL_MAP_READ_BIT,
  pattern GL_MAP_UNSYNCHRONIZED_BIT,
  pattern GL_MAP_WRITE_BIT,
  pattern GL_MATRIX_STRIDE,
  pattern GL_MAX,
  pattern GL_MAX_3D_TEXTURE_SIZE,
  pattern GL_MAX_ARRAY_TEXTURE_LAYERS,
  pattern GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS,
  pattern GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE,
  pattern GL_MAX_CLIP_DISTANCES,
  pattern GL_MAX_COLOR_ATTACHMENTS,
  pattern GL_MAX_COLOR_TEXTURE_SAMPLES,
  pattern GL_MAX_COMBINED_ATOMIC_COUNTERS,
  pattern GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS,
  pattern GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES,
  pattern GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS,
  pattern GL_MAX_COMBINED_DIMENSIONS,
  pattern GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS,
  pattern GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS,
  pattern GL_MAX_COMBINED_IMAGE_UNIFORMS,
  pattern GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS,
  pattern GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES,
  pattern GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS,
  pattern GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS,
  pattern GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS,
  pattern GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS,
  pattern GL_MAX_COMBINED_UNIFORM_BLOCKS,
  pattern GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS,
  pattern GL_MAX_COMPUTE_ATOMIC_COUNTERS,
  pattern GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS,
  pattern GL_MAX_COMPUTE_IMAGE_UNIFORMS,
  pattern GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS,
  pattern GL_MAX_COMPUTE_SHARED_MEMORY_SIZE,
  pattern GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS,
  pattern GL_MAX_COMPUTE_UNIFORM_BLOCKS,
  pattern GL_MAX_COMPUTE_UNIFORM_COMPONENTS,
  pattern GL_MAX_COMPUTE_WORK_GROUP_COUNT,
  pattern GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS,
  pattern GL_MAX_COMPUTE_WORK_GROUP_SIZE,
  pattern GL_MAX_CUBE_MAP_TEXTURE_SIZE,
  pattern GL_MAX_CULL_DISTANCES,
  pattern GL_MAX_DEBUG_GROUP_STACK_DEPTH,
  pattern GL_MAX_DEBUG_LOGGED_MESSAGES,
  pattern GL_MAX_DEBUG_MESSAGE_LENGTH,
  pattern GL_MAX_DEPTH,
  pattern GL_MAX_DEPTH_TEXTURE_SAMPLES,
  pattern GL_MAX_DRAW_BUFFERS,
  pattern GL_MAX_DUAL_SOURCE_DRAW_BUFFERS,
  pattern GL_MAX_ELEMENTS_INDICES,
  pattern GL_MAX_ELEMENTS_VERTICES,
  pattern GL_MAX_ELEMENT_INDEX,
  pattern GL_MAX_FRAGMENT_ATOMIC_COUNTERS,
  pattern GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS,
  pattern GL_MAX_FRAGMENT_IMAGE_UNIFORMS,
  pattern GL_MAX_FRAGMENT_INPUT_COMPONENTS,
  pattern GL_MAX_FRAGMENT_INTERPOLATION_OFFSET,
  pattern GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS,
  pattern GL_MAX_FRAGMENT_UNIFORM_BLOCKS,
  pattern GL_MAX_FRAGMENT_UNIFORM_COMPONENTS,
  pattern GL_MAX_FRAGMENT_UNIFORM_VECTORS,
  pattern GL_MAX_FRAMEBUFFER_HEIGHT,
  pattern GL_MAX_FRAMEBUFFER_LAYERS,
  pattern GL_MAX_FRAMEBUFFER_SAMPLES,
  pattern GL_MAX_FRAMEBUFFER_WIDTH,
  pattern GL_MAX_GEOMETRY_ATOMIC_COUNTERS,
  pattern GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS,
  pattern GL_MAX_GEOMETRY_IMAGE_UNIFORMS,
  pattern GL_MAX_GEOMETRY_INPUT_COMPONENTS,
  pattern GL_MAX_GEOMETRY_OUTPUT_COMPONENTS,
  pattern GL_MAX_GEOMETRY_OUTPUT_VERTICES,
  pattern GL_MAX_GEOMETRY_SHADER_INVOCATIONS,
  pattern GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS,
  pattern GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS,
  pattern GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS,
  pattern GL_MAX_GEOMETRY_UNIFORM_BLOCKS,
  pattern GL_MAX_GEOMETRY_UNIFORM_COMPONENTS,
  pattern GL_MAX_HEIGHT,
  pattern GL_MAX_IMAGE_SAMPLES,
  pattern GL_MAX_IMAGE_UNITS,
  pattern GL_MAX_INTEGER_SAMPLES,
  pattern GL_MAX_LABEL_LENGTH,
  pattern GL_MAX_LAYERS,
  pattern GL_MAX_NAME_LENGTH,
  pattern GL_MAX_NUM_ACTIVE_VARIABLES,
  pattern GL_MAX_NUM_COMPATIBLE_SUBROUTINES,
  pattern GL_MAX_PATCH_VERTICES,
  pattern GL_MAX_PROGRAM_TEXEL_OFFSET,
  pattern GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET,
  pattern GL_MAX_RECTANGLE_TEXTURE_SIZE,
  pattern GL_MAX_RENDERBUFFER_SIZE,
  pattern GL_MAX_SAMPLES,
  pattern GL_MAX_SAMPLE_MASK_WORDS,
  pattern GL_MAX_SERVER_WAIT_TIMEOUT,
  pattern GL_MAX_SHADER_STORAGE_BLOCK_SIZE,
  pattern GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS,
  pattern GL_MAX_SUBROUTINES,
  pattern GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS,
  pattern GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS,
  pattern GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS,
  pattern GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS,
  pattern GL_MAX_TESS_CONTROL_INPUT_COMPONENTS,
  pattern GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS,
  pattern GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS,
  pattern GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS,
  pattern GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS,
  pattern GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS,
  pattern GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS,
  pattern GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS,
  pattern GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS,
  pattern GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS,
  pattern GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS,
  pattern GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS,
  pattern GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS,
  pattern GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS,
  pattern GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS,
  pattern GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS,
  pattern GL_MAX_TESS_GEN_LEVEL,
  pattern GL_MAX_TESS_PATCH_COMPONENTS,
  pattern GL_MAX_TEXTURE_BUFFER_SIZE,
  pattern GL_MAX_TEXTURE_IMAGE_UNITS,
  pattern GL_MAX_TEXTURE_LOD_BIAS,
  pattern GL_MAX_TEXTURE_MAX_ANISOTROPY,
  pattern GL_MAX_TEXTURE_SIZE,
  pattern GL_MAX_TRANSFORM_FEEDBACK_BUFFERS,
  pattern GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS,
  pattern GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS,
  pattern GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS,
  pattern GL_MAX_UNIFORM_BLOCK_SIZE,
  pattern GL_MAX_UNIFORM_BUFFER_BINDINGS,
  pattern GL_MAX_UNIFORM_LOCATIONS,
  pattern GL_MAX_VARYING_COMPONENTS,
  pattern GL_MAX_VARYING_FLOATS,
  pattern GL_MAX_VARYING_VECTORS,
  pattern GL_MAX_VERTEX_ATOMIC_COUNTERS,
  pattern GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS,
  pattern GL_MAX_VERTEX_ATTRIBS,
  pattern GL_MAX_VERTEX_ATTRIB_BINDINGS,
  pattern GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET,
  pattern GL_MAX_VERTEX_ATTRIB_STRIDE,
  pattern GL_MAX_VERTEX_IMAGE_UNIFORMS,
  pattern GL_MAX_VERTEX_OUTPUT_COMPONENTS,
  pattern GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS,
  pattern GL_MAX_VERTEX_STREAMS,
  pattern GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS,
  pattern GL_MAX_VERTEX_UNIFORM_BLOCKS,
  pattern GL_MAX_VERTEX_UNIFORM_COMPONENTS,
  pattern GL_MAX_VERTEX_UNIFORM_VECTORS,
  pattern GL_MAX_VIEWPORTS,
  pattern GL_MAX_VIEWPORT_DIMS,
  pattern GL_MAX_WIDTH,
  pattern GL_MEDIUM_FLOAT,
  pattern GL_MEDIUM_INT,
  pattern GL_MIN,
  pattern GL_MINOR_VERSION,
  pattern GL_MIN_FRAGMENT_INTERPOLATION_OFFSET,
  pattern GL_MIN_MAP_BUFFER_ALIGNMENT,
  pattern GL_MIN_PROGRAM_TEXEL_OFFSET,
  pattern GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET,
  pattern GL_MIN_SAMPLE_SHADING_VALUE,
  pattern GL_MIPMAP,
  pattern GL_MIRRORED_REPEAT,
  pattern GL_MIRROR_CLAMP_TO_EDGE,
  pattern GL_MULTISAMPLE,
  pattern GL_NAME_LENGTH,
  pattern GL_NAND,
  pattern GL_NEAREST,
  pattern GL_NEAREST_MIPMAP_LINEAR,
  pattern GL_NEAREST_MIPMAP_NEAREST,
  pattern GL_NEGATIVE_ONE_TO_ONE,
  pattern GL_NEVER,
  pattern GL_NICEST,
  pattern GL_NONE,
  pattern GL_NOOP,
  pattern GL_NOR,
  pattern GL_NOTEQUAL,
  pattern GL_NO_ERROR,
  pattern GL_NO_RESET_NOTIFICATION,
  pattern GL_NUM_ACTIVE_VARIABLES,
  pattern GL_NUM_COMPATIBLE_SUBROUTINES,
  pattern GL_NUM_COMPRESSED_TEXTURE_FORMATS,
  pattern GL_NUM_EXTENSIONS,
  pattern GL_NUM_PROGRAM_BINARY_FORMATS,
  pattern GL_NUM_SAMPLE_COUNTS,
  pattern GL_NUM_SHADER_BINARY_FORMATS,
  pattern GL_NUM_SHADING_LANGUAGE_VERSIONS,
  pattern GL_NUM_SPIR_V_EXTENSIONS,
  pattern GL_OBJECT_TYPE,
  pattern GL_OFFSET,
  pattern GL_ONE,
  pattern GL_ONE_MINUS_CONSTANT_ALPHA,
  pattern GL_ONE_MINUS_CONSTANT_COLOR,
  pattern GL_ONE_MINUS_DST_ALPHA,
  pattern GL_ONE_MINUS_DST_COLOR,
  pattern GL_ONE_MINUS_SRC1_ALPHA,
  pattern GL_ONE_MINUS_SRC1_COLOR,
  pattern GL_ONE_MINUS_SRC_ALPHA,
  pattern GL_ONE_MINUS_SRC_COLOR,
  pattern GL_OR,
  pattern GL_OR_INVERTED,
  pattern GL_OR_REVERSE,
  pattern GL_OUT_OF_MEMORY,
  pattern GL_PACK_ALIGNMENT,
  pattern GL_PACK_COMPRESSED_BLOCK_DEPTH,
  pattern GL_PACK_COMPRESSED_BLOCK_HEIGHT,
  pattern GL_PACK_COMPRESSED_BLOCK_SIZE,
  pattern GL_PACK_COMPRESSED_BLOCK_WIDTH,
  pattern GL_PACK_IMAGE_HEIGHT,
  pattern GL_PACK_LSB_FIRST,
  pattern GL_PACK_ROW_LENGTH,
  pattern GL_PACK_SKIP_IMAGES,
  pattern GL_PACK_SKIP_PIXELS,
  pattern GL_PACK_SKIP_ROWS,
  pattern GL_PACK_SWAP_BYTES,
  pattern GL_PARAMETER_BUFFER,
  pattern GL_PARAMETER_BUFFER_BINDING,
  pattern GL_PATCHES,
  pattern GL_PATCH_DEFAULT_INNER_LEVEL,
  pattern GL_PATCH_DEFAULT_OUTER_LEVEL,
  pattern GL_PATCH_VERTICES,
  pattern GL_PIXEL_BUFFER_BARRIER_BIT,
  pattern GL_PIXEL_PACK_BUFFER,
  pattern GL_PIXEL_PACK_BUFFER_BINDING,
  pattern GL_PIXEL_UNPACK_BUFFER,
  pattern GL_PIXEL_UNPACK_BUFFER_BINDING,
  pattern GL_POINT,
  pattern GL_POINTS,
  pattern GL_POINT_FADE_THRESHOLD_SIZE,
  pattern GL_POINT_SIZE,
  pattern GL_POINT_SIZE_GRANULARITY,
  pattern GL_POINT_SIZE_RANGE,
  pattern GL_POINT_SPRITE_COORD_ORIGIN,
  pattern GL_POLYGON_MODE,
  pattern GL_POLYGON_OFFSET_CLAMP,
  pattern GL_POLYGON_OFFSET_FACTOR,
  pattern GL_POLYGON_OFFSET_FILL,
  pattern GL_POLYGON_OFFSET_LINE,
  pattern GL_POLYGON_OFFSET_POINT,
  pattern GL_POLYGON_OFFSET_UNITS,
  pattern GL_POLYGON_SMOOTH,
  pattern GL_POLYGON_SMOOTH_HINT,
  pattern GL_PRIMITIVES_GENERATED,
  pattern GL_PRIMITIVES_SUBMITTED,
  pattern GL_PRIMITIVE_RESTART,
  pattern GL_PRIMITIVE_RESTART_FIXED_INDEX,
  pattern GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED,
  pattern GL_PRIMITIVE_RESTART_INDEX,
  pattern GL_PROGRAM,
  pattern GL_PROGRAM_BINARY_FORMATS,
  pattern GL_PROGRAM_BINARY_LENGTH,
  pattern GL_PROGRAM_BINARY_RETRIEVABLE_HINT,
  pattern GL_PROGRAM_INPUT,
  pattern GL_PROGRAM_OUTPUT,
  pattern GL_PROGRAM_PIPELINE,
  pattern GL_PROGRAM_PIPELINE_BINDING,
  pattern GL_PROGRAM_POINT_SIZE,
  pattern GL_PROGRAM_SEPARABLE,
  pattern GL_PROVOKING_VERTEX,
  pattern GL_PROXY_TEXTURE_1D,
  pattern GL_PROXY_TEXTURE_1D_ARRAY,
  pattern GL_PROXY_TEXTURE_2D,
  pattern GL_PROXY_TEXTURE_2D_ARRAY,
  pattern GL_PROXY_TEXTURE_2D_MULTISAMPLE,
  pattern GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY,
  pattern GL_PROXY_TEXTURE_3D,
  pattern GL_PROXY_TEXTURE_CUBE_MAP,
  pattern GL_PROXY_TEXTURE_CUBE_MAP_ARRAY,
  pattern GL_PROXY_TEXTURE_RECTANGLE,
  pattern GL_QUADS,
  pattern GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION,
  pattern GL_QUERY,
  pattern GL_QUERY_BUFFER,
  pattern GL_QUERY_BUFFER_BARRIER_BIT,
  pattern GL_QUERY_BUFFER_BINDING,
  pattern GL_QUERY_BY_REGION_NO_WAIT,
  pattern GL_QUERY_BY_REGION_NO_WAIT_INVERTED,
  pattern GL_QUERY_BY_REGION_WAIT,
  pattern GL_QUERY_BY_REGION_WAIT_INVERTED,
  pattern GL_QUERY_COUNTER_BITS,
  pattern GL_QUERY_NO_WAIT,
  pattern GL_QUERY_NO_WAIT_INVERTED,
  pattern GL_QUERY_RESULT,
  pattern GL_QUERY_RESULT_AVAILABLE,
  pattern GL_QUERY_RESULT_NO_WAIT,
  pattern GL_QUERY_TARGET,
  pattern GL_QUERY_WAIT,
  pattern GL_QUERY_WAIT_INVERTED,
  pattern GL_R11F_G11F_B10F,
  pattern GL_R16,
  pattern GL_R16F,
  pattern GL_R16I,
  pattern GL_R16UI,
  pattern GL_R16_SNORM,
  pattern GL_R32F,
  pattern GL_R32I,
  pattern GL_R32UI,
  pattern GL_R3_G3_B2,
  pattern GL_R8,
  pattern GL_R8I,
  pattern GL_R8UI,
  pattern GL_R8_SNORM,
  pattern GL_RASTERIZER_DISCARD,
  pattern GL_READ_BUFFER,
  pattern GL_READ_FRAMEBUFFER,
  pattern GL_READ_FRAMEBUFFER_BINDING,
  pattern GL_READ_ONLY,
  pattern GL_READ_PIXELS,
  pattern GL_READ_PIXELS_FORMAT,
  pattern GL_READ_PIXELS_TYPE,
  pattern GL_READ_WRITE,
  pattern GL_RED,
  pattern GL_RED_INTEGER,
  pattern GL_REFERENCED_BY_COMPUTE_SHADER,
  pattern GL_REFERENCED_BY_FRAGMENT_SHADER,
  pattern GL_REFERENCED_BY_GEOMETRY_SHADER,
  pattern GL_REFERENCED_BY_TESS_CONTROL_SHADER,
  pattern GL_REFERENCED_BY_TESS_EVALUATION_SHADER,
  pattern GL_REFERENCED_BY_VERTEX_SHADER,
  pattern GL_RENDERBUFFER,
  pattern GL_RENDERBUFFER_ALPHA_SIZE,
  pattern GL_RENDERBUFFER_BINDING,
  pattern GL_RENDERBUFFER_BLUE_SIZE,
  pattern GL_RENDERBUFFER_DEPTH_SIZE,
  pattern GL_RENDERBUFFER_GREEN_SIZE,
  pattern GL_RENDERBUFFER_HEIGHT,
  pattern GL_RENDERBUFFER_INTERNAL_FORMAT,
  pattern GL_RENDERBUFFER_RED_SIZE,
  pattern GL_RENDERBUFFER_SAMPLES,
  pattern GL_RENDERBUFFER_STENCIL_SIZE,
  pattern GL_RENDERBUFFER_WIDTH,
  pattern GL_RENDERER,
  pattern GL_REPEAT,
  pattern GL_REPLACE,
  pattern GL_RESET_NOTIFICATION_STRATEGY,
  pattern GL_RG,
  pattern GL_RG16,
  pattern GL_RG16F,
  pattern GL_RG16I,
  pattern GL_RG16UI,
  pattern GL_RG16_SNORM,
  pattern GL_RG32F,
  pattern GL_RG32I,
  pattern GL_RG32UI,
  pattern GL_RG8,
  pattern GL_RG8I,
  pattern GL_RG8UI,
  pattern GL_RG8_SNORM,
  pattern GL_RGB,
  pattern GL_RGB10,
  pattern GL_RGB10_A2,
  pattern GL_RGB10_A2UI,
  pattern GL_RGB12,
  pattern GL_RGB16,
  pattern GL_RGB16F,
  pattern GL_RGB16I,
  pattern GL_RGB16UI,
  pattern GL_RGB16_SNORM,
  pattern GL_RGB32F,
  pattern GL_RGB32I,
  pattern GL_RGB32UI,
  pattern GL_RGB4,
  pattern GL_RGB5,
  pattern GL_RGB565,
  pattern GL_RGB5_A1,
  pattern GL_RGB8,
  pattern GL_RGB8I,
  pattern GL_RGB8UI,
  pattern GL_RGB8_SNORM,
  pattern GL_RGB9_E5,
  pattern GL_RGBA,
  pattern GL_RGBA12,
  pattern GL_RGBA16,
  pattern GL_RGBA16F,
  pattern GL_RGBA16I,
  pattern GL_RGBA16UI,
  pattern GL_RGBA16_SNORM,
  pattern GL_RGBA2,
  pattern GL_RGBA32F,
  pattern GL_RGBA32I,
  pattern GL_RGBA32UI,
  pattern GL_RGBA4,
  pattern GL_RGBA8,
  pattern GL_RGBA8I,
  pattern GL_RGBA8UI,
  pattern GL_RGBA8_SNORM,
  pattern GL_RGBA_INTEGER,
  pattern GL_RGB_INTEGER,
  pattern GL_RG_INTEGER,
  pattern GL_RIGHT,
  pattern GL_SAMPLER,
  pattern GL_SAMPLER_1D,
  pattern GL_SAMPLER_1D_ARRAY,
  pattern GL_SAMPLER_1D_ARRAY_SHADOW,
  pattern GL_SAMPLER_1D_SHADOW,
  pattern GL_SAMPLER_2D,
  pattern GL_SAMPLER_2D_ARRAY,
  pattern GL_SAMPLER_2D_ARRAY_SHADOW,
  pattern GL_SAMPLER_2D_MULTISAMPLE,
  pattern GL_SAMPLER_2D_MULTISAMPLE_ARRAY,
  pattern GL_SAMPLER_2D_RECT,
  pattern GL_SAMPLER_2D_RECT_SHADOW,
  pattern GL_SAMPLER_2D_SHADOW,
  pattern GL_SAMPLER_3D,
  pattern GL_SAMPLER_BINDING,
  pattern GL_SAMPLER_BUFFER,
  pattern GL_SAMPLER_CUBE,
  pattern GL_SAMPLER_CUBE_MAP_ARRAY,
  pattern GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW,
  pattern GL_SAMPLER_CUBE_SHADOW,
  pattern GL_SAMPLES,
  pattern GL_SAMPLES_PASSED,
  pattern GL_SAMPLE_ALPHA_TO_COVERAGE,
  pattern GL_SAMPLE_ALPHA_TO_ONE,
  pattern GL_SAMPLE_BUFFERS,
  pattern GL_SAMPLE_COVERAGE,
  pattern GL_SAMPLE_COVERAGE_INVERT,
  pattern GL_SAMPLE_COVERAGE_VALUE,
  pattern GL_SAMPLE_MASK,
  pattern GL_SAMPLE_MASK_VALUE,
  pattern GL_SAMPLE_POSITION,
  pattern GL_SAMPLE_SHADING,
  pattern GL_SCISSOR_BOX,
  pattern GL_SCISSOR_TEST,
  pattern GL_SEPARATE_ATTRIBS,
  pattern GL_SET,
  pattern GL_SHADER,
  pattern GL_SHADER_BINARY_FORMATS,
  pattern GL_SHADER_BINARY_FORMAT_SPIR_V,
  pattern GL_SHADER_COMPILER,
  pattern GL_SHADER_IMAGE_ACCESS_BARRIER_BIT,
  pattern GL_SHADER_IMAGE_ATOMIC,
  pattern GL_SHADER_IMAGE_LOAD,
  pattern GL_SHADER_IMAGE_STORE,
  pattern GL_SHADER_SOURCE_LENGTH,
  pattern GL_SHADER_STORAGE_BARRIER_BIT,
  pattern GL_SHADER_STORAGE_BLOCK,
  pattern GL_SHADER_STORAGE_BUFFER,
  pattern GL_SHADER_STORAGE_BUFFER_BINDING,
  pattern GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT,
  pattern GL_SHADER_STORAGE_BUFFER_SIZE,
  pattern GL_SHADER_STORAGE_BUFFER_START,
  pattern GL_SHADER_TYPE,
  pattern GL_SHADING_LANGUAGE_VERSION,
  pattern GL_SHORT,
  pattern GL_SIGNALED,
  pattern GL_SIGNED_NORMALIZED,
  pattern GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST,
  pattern GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE,
  pattern GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST,
  pattern GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE,
  pattern GL_SMOOTH_LINE_WIDTH_GRANULARITY,
  pattern GL_SMOOTH_LINE_WIDTH_RANGE,
  pattern GL_SMOOTH_POINT_SIZE_GRANULARITY,
  pattern GL_SMOOTH_POINT_SIZE_RANGE,
  pattern GL_SPIR_V_BINARY,
  pattern GL_SPIR_V_EXTENSIONS,
  pattern GL_SRC1_ALPHA,
  pattern GL_SRC1_COLOR,
  pattern GL_SRC_ALPHA,
  pattern GL_SRC_ALPHA_SATURATE,
  pattern GL_SRC_COLOR,
  pattern GL_SRGB,
  pattern GL_SRGB8,
  pattern GL_SRGB8_ALPHA8,
  pattern GL_SRGB_ALPHA,
  pattern GL_SRGB_READ,
  pattern GL_SRGB_WRITE,
  pattern GL_STACK_OVERFLOW,
  pattern GL_STACK_UNDERFLOW,
  pattern GL_STATIC_COPY,
  pattern GL_STATIC_DRAW,
  pattern GL_STATIC_READ,
  pattern GL_STENCIL,
  pattern GL_STENCIL_ATTACHMENT,
  pattern GL_STENCIL_BACK_FAIL,
  pattern GL_STENCIL_BACK_FUNC,
  pattern GL_STENCIL_BACK_PASS_DEPTH_FAIL,
  pattern GL_STENCIL_BACK_PASS_DEPTH_PASS,
  pattern GL_STENCIL_BACK_REF,
  pattern GL_STENCIL_BACK_VALUE_MASK,
  pattern GL_STENCIL_BACK_WRITEMASK,
  pattern GL_STENCIL_BUFFER_BIT,
  pattern GL_STENCIL_CLEAR_VALUE,
  pattern GL_STENCIL_COMPONENTS,
  pattern GL_STENCIL_FAIL,
  pattern GL_STENCIL_FUNC,
  pattern GL_STENCIL_INDEX,
  pattern GL_STENCIL_INDEX1,
  pattern GL_STENCIL_INDEX16,
  pattern GL_STENCIL_INDEX4,
  pattern GL_STENCIL_INDEX8,
  pattern GL_STENCIL_PASS_DEPTH_FAIL,
  pattern GL_STENCIL_PASS_DEPTH_PASS,
  pattern GL_STENCIL_REF,
  pattern GL_STENCIL_RENDERABLE,
  pattern GL_STENCIL_TEST,
  pattern GL_STENCIL_VALUE_MASK,
  pattern GL_STENCIL_WRITEMASK,
  pattern GL_STEREO,
  pattern GL_STREAM_COPY,
  pattern GL_STREAM_DRAW,
  pattern GL_STREAM_READ,
  pattern GL_SUBPIXEL_BITS,
  pattern GL_SYNC_CONDITION,
  pattern GL_SYNC_FENCE,
  pattern GL_SYNC_FLAGS,
  pattern GL_SYNC_FLUSH_COMMANDS_BIT,
  pattern GL_SYNC_GPU_COMMANDS_COMPLETE,
  pattern GL_SYNC_STATUS,
  pattern GL_TESS_CONTROL_OUTPUT_VERTICES,
  pattern GL_TESS_CONTROL_SHADER,
  pattern GL_TESS_CONTROL_SHADER_BIT,
  pattern GL_TESS_CONTROL_SHADER_PATCHES,
  pattern GL_TESS_CONTROL_SUBROUTINE,
  pattern GL_TESS_CONTROL_SUBROUTINE_UNIFORM,
  pattern GL_TESS_CONTROL_TEXTURE,
  pattern GL_TESS_EVALUATION_SHADER,
  pattern GL_TESS_EVALUATION_SHADER_BIT,
  pattern GL_TESS_EVALUATION_SHADER_INVOCATIONS,
  pattern GL_TESS_EVALUATION_SUBROUTINE,
  pattern GL_TESS_EVALUATION_SUBROUTINE_UNIFORM,
  pattern GL_TESS_EVALUATION_TEXTURE,
  pattern GL_TESS_GEN_MODE,
  pattern GL_TESS_GEN_POINT_MODE,
  pattern GL_TESS_GEN_SPACING,
  pattern GL_TESS_GEN_VERTEX_ORDER,
  pattern GL_TEXTURE,
  pattern GL_TEXTURE0,
  pattern GL_TEXTURE1,
  pattern GL_TEXTURE10,
  pattern GL_TEXTURE11,
  pattern GL_TEXTURE12,
  pattern GL_TEXTURE13,
  pattern GL_TEXTURE14,
  pattern GL_TEXTURE15,
  pattern GL_TEXTURE16,
  pattern GL_TEXTURE17,
  pattern GL_TEXTURE18,
  pattern GL_TEXTURE19,
  pattern GL_TEXTURE2,
  pattern GL_TEXTURE20,
  pattern GL_TEXTURE21,
  pattern GL_TEXTURE22,
  pattern GL_TEXTURE23,
  pattern GL_TEXTURE24,
  pattern GL_TEXTURE25,
  pattern GL_TEXTURE26,
  pattern GL_TEXTURE27,
  pattern GL_TEXTURE28,
  pattern GL_TEXTURE29,
  pattern GL_TEXTURE3,
  pattern GL_TEXTURE30,
  pattern GL_TEXTURE31,
  pattern GL_TEXTURE4,
  pattern GL_TEXTURE5,
  pattern GL_TEXTURE6,
  pattern GL_TEXTURE7,
  pattern GL_TEXTURE8,
  pattern GL_TEXTURE9,
  pattern GL_TEXTURE_1D,
  pattern GL_TEXTURE_1D_ARRAY,
  pattern GL_TEXTURE_2D,
  pattern GL_TEXTURE_2D_ARRAY,
  pattern GL_TEXTURE_2D_MULTISAMPLE,
  pattern GL_TEXTURE_2D_MULTISAMPLE_ARRAY,
  pattern GL_TEXTURE_3D,
  pattern GL_TEXTURE_ALPHA_SIZE,
  pattern GL_TEXTURE_ALPHA_TYPE,
  pattern GL_TEXTURE_BASE_LEVEL,
  pattern GL_TEXTURE_BINDING_1D,
  pattern GL_TEXTURE_BINDING_1D_ARRAY,
  pattern GL_TEXTURE_BINDING_2D,
  pattern GL_TEXTURE_BINDING_2D_ARRAY,
  pattern GL_TEXTURE_BINDING_2D_MULTISAMPLE,
  pattern GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY,
  pattern GL_TEXTURE_BINDING_3D,
  pattern GL_TEXTURE_BINDING_BUFFER,
  pattern GL_TEXTURE_BINDING_CUBE_MAP,
  pattern GL_TEXTURE_BINDING_CUBE_MAP_ARRAY,
  pattern GL_TEXTURE_BINDING_RECTANGLE,
  pattern GL_TEXTURE_BLUE_SIZE,
  pattern GL_TEXTURE_BLUE_TYPE,
  pattern GL_TEXTURE_BORDER_COLOR,
  pattern GL_TEXTURE_BUFFER,
  pattern GL_TEXTURE_BUFFER_BINDING,
  pattern GL_TEXTURE_BUFFER_DATA_STORE_BINDING,
  pattern GL_TEXTURE_BUFFER_OFFSET,
  pattern GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT,
  pattern GL_TEXTURE_BUFFER_SIZE,
  pattern GL_TEXTURE_COMPARE_FUNC,
  pattern GL_TEXTURE_COMPARE_MODE,
  pattern GL_TEXTURE_COMPRESSED,
  pattern GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT,
  pattern GL_TEXTURE_COMPRESSED_BLOCK_SIZE,
  pattern GL_TEXTURE_COMPRESSED_BLOCK_WIDTH,
  pattern GL_TEXTURE_COMPRESSED_IMAGE_SIZE,
  pattern GL_TEXTURE_COMPRESSION_HINT,
  pattern GL_TEXTURE_CUBE_MAP,
  pattern GL_TEXTURE_CUBE_MAP_ARRAY,
  pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
  pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
  pattern GL_TEXTURE_CUBE_MAP_NEGATIVE_Z,
  pattern GL_TEXTURE_CUBE_MAP_POSITIVE_X,
  pattern GL_TEXTURE_CUBE_MAP_POSITIVE_Y,
  pattern GL_TEXTURE_CUBE_MAP_POSITIVE_Z,
  pattern GL_TEXTURE_CUBE_MAP_SEAMLESS,
  pattern GL_TEXTURE_DEPTH,
  pattern GL_TEXTURE_DEPTH_SIZE,
  pattern GL_TEXTURE_DEPTH_TYPE,
  pattern GL_TEXTURE_FETCH_BARRIER_BIT,
  pattern GL_TEXTURE_FIXED_SAMPLE_LOCATIONS,
  pattern GL_TEXTURE_GATHER,
  pattern GL_TEXTURE_GATHER_SHADOW,
  pattern GL_TEXTURE_GREEN_SIZE,
  pattern GL_TEXTURE_GREEN_TYPE,
  pattern GL_TEXTURE_HEIGHT,
  pattern GL_TEXTURE_IMAGE_FORMAT,
  pattern GL_TEXTURE_IMAGE_TYPE,
  pattern GL_TEXTURE_IMMUTABLE_FORMAT,
  pattern GL_TEXTURE_IMMUTABLE_LEVELS,
  pattern GL_TEXTURE_INTERNAL_FORMAT,
  pattern GL_TEXTURE_LOD_BIAS,
  pattern GL_TEXTURE_MAG_FILTER,
  pattern GL_TEXTURE_MAX_ANISOTROPY,
  pattern GL_TEXTURE_MAX_LEVEL,
  pattern GL_TEXTURE_MAX_LOD,
  pattern GL_TEXTURE_MIN_FILTER,
  pattern GL_TEXTURE_MIN_LOD,
  pattern GL_TEXTURE_RECTANGLE,
  pattern GL_TEXTURE_RED_SIZE,
  pattern GL_TEXTURE_RED_TYPE,
  pattern GL_TEXTURE_SAMPLES,
  pattern GL_TEXTURE_SHADOW,
  pattern GL_TEXTURE_SHARED_SIZE,
  pattern GL_TEXTURE_STENCIL_SIZE,
  pattern GL_TEXTURE_SWIZZLE_A,
  pattern GL_TEXTURE_SWIZZLE_B,
  pattern GL_TEXTURE_SWIZZLE_G,
  pattern GL_TEXTURE_SWIZZLE_R,
  pattern GL_TEXTURE_SWIZZLE_RGBA,
  pattern GL_TEXTURE_TARGET,
  pattern GL_TEXTURE_UPDATE_BARRIER_BIT,
  pattern GL_TEXTURE_VIEW,
  pattern GL_TEXTURE_VIEW_MIN_LAYER,
  pattern GL_TEXTURE_VIEW_MIN_LEVEL,
  pattern GL_TEXTURE_VIEW_NUM_LAYERS,
  pattern GL_TEXTURE_VIEW_NUM_LEVELS,
  pattern GL_TEXTURE_WIDTH,
  pattern GL_TEXTURE_WRAP_R,
  pattern GL_TEXTURE_WRAP_S,
  pattern GL_TEXTURE_WRAP_T,
  pattern GL_TIMEOUT_EXPIRED,
  pattern GL_TIMEOUT_IGNORED,
  pattern GL_TIMESTAMP,
  pattern GL_TIME_ELAPSED,
  pattern GL_TOP_LEVEL_ARRAY_SIZE,
  pattern GL_TOP_LEVEL_ARRAY_STRIDE,
  pattern GL_TRANSFORM_FEEDBACK,
  pattern GL_TRANSFORM_FEEDBACK_ACTIVE,
  pattern GL_TRANSFORM_FEEDBACK_BARRIER_BIT,
  pattern GL_TRANSFORM_FEEDBACK_BINDING,
  pattern GL_TRANSFORM_FEEDBACK_BUFFER,
  pattern GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE,
  pattern GL_TRANSFORM_FEEDBACK_BUFFER_BINDING,
  pattern GL_TRANSFORM_FEEDBACK_BUFFER_INDEX,
  pattern GL_TRANSFORM_FEEDBACK_BUFFER_MODE,
  pattern GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED,
  pattern GL_TRANSFORM_FEEDBACK_BUFFER_SIZE,
  pattern GL_TRANSFORM_FEEDBACK_BUFFER_START,
  pattern GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE,
  pattern GL_TRANSFORM_FEEDBACK_OVERFLOW,
  pattern GL_TRANSFORM_FEEDBACK_PAUSED,
  pattern GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN,
  pattern GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW,
  pattern GL_TRANSFORM_FEEDBACK_VARYING,
  pattern GL_TRANSFORM_FEEDBACK_VARYINGS,
  pattern GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH,
  pattern GL_TRIANGLES,
  pattern GL_TRIANGLES_ADJACENCY,
  pattern GL_TRIANGLE_FAN,
  pattern GL_TRIANGLE_STRIP,
  pattern GL_TRIANGLE_STRIP_ADJACENCY,
  pattern GL_TRUE,
  pattern GL_TYPE,
  pattern GL_UNDEFINED_VERTEX,
  pattern GL_UNIFORM,
  pattern GL_UNIFORM_ARRAY_STRIDE,
  pattern GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX,
  pattern GL_UNIFORM_BARRIER_BIT,
  pattern GL_UNIFORM_BLOCK,
  pattern GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS,
  pattern GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES,
  pattern GL_UNIFORM_BLOCK_BINDING,
  pattern GL_UNIFORM_BLOCK_DATA_SIZE,
  pattern GL_UNIFORM_BLOCK_INDEX,
  pattern GL_UNIFORM_BLOCK_NAME_LENGTH,
  pattern GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER,
  pattern GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER,
  pattern GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER,
  pattern GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER,
  pattern GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER,
  pattern GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER,
  pattern GL_UNIFORM_BUFFER,
  pattern GL_UNIFORM_BUFFER_BINDING,
  pattern GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT,
  pattern GL_UNIFORM_BUFFER_SIZE,
  pattern GL_UNIFORM_BUFFER_START,
  pattern GL_UNIFORM_IS_ROW_MAJOR,
  pattern GL_UNIFORM_MATRIX_STRIDE,
  pattern GL_UNIFORM_NAME_LENGTH,
  pattern GL_UNIFORM_OFFSET,
  pattern GL_UNIFORM_SIZE,
  pattern GL_UNIFORM_TYPE,
  pattern GL_UNKNOWN_CONTEXT_RESET,
  pattern GL_UNPACK_ALIGNMENT,
  pattern GL_UNPACK_COMPRESSED_BLOCK_DEPTH,
  pattern GL_UNPACK_COMPRESSED_BLOCK_HEIGHT,
  pattern GL_UNPACK_COMPRESSED_BLOCK_SIZE,
  pattern GL_UNPACK_COMPRESSED_BLOCK_WIDTH,
  pattern GL_UNPACK_IMAGE_HEIGHT,
  pattern GL_UNPACK_LSB_FIRST,
  pattern GL_UNPACK_ROW_LENGTH,
  pattern GL_UNPACK_SKIP_IMAGES,
  pattern GL_UNPACK_SKIP_PIXELS,
  pattern GL_UNPACK_SKIP_ROWS,
  pattern GL_UNPACK_SWAP_BYTES,
  pattern GL_UNSIGNALED,
  pattern GL_UNSIGNED_BYTE,
  pattern GL_UNSIGNED_BYTE_2_3_3_REV,
  pattern GL_UNSIGNED_BYTE_3_3_2,
  pattern GL_UNSIGNED_INT,
  pattern GL_UNSIGNED_INT_10F_11F_11F_REV,
  pattern GL_UNSIGNED_INT_10_10_10_2,
  pattern GL_UNSIGNED_INT_24_8,
  pattern GL_UNSIGNED_INT_2_10_10_10_REV,
  pattern GL_UNSIGNED_INT_5_9_9_9_REV,
  pattern GL_UNSIGNED_INT_8_8_8_8,
  pattern GL_UNSIGNED_INT_8_8_8_8_REV,
  pattern GL_UNSIGNED_INT_ATOMIC_COUNTER,
  pattern GL_UNSIGNED_INT_IMAGE_1D,
  pattern GL_UNSIGNED_INT_IMAGE_1D_ARRAY,
  pattern GL_UNSIGNED_INT_IMAGE_2D,
  pattern GL_UNSIGNED_INT_IMAGE_2D_ARRAY,
  pattern GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE,
  pattern GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY,
  pattern GL_UNSIGNED_INT_IMAGE_2D_RECT,
  pattern GL_UNSIGNED_INT_IMAGE_3D,
  pattern GL_UNSIGNED_INT_IMAGE_BUFFER,
  pattern GL_UNSIGNED_INT_IMAGE_CUBE,
  pattern GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY,
  pattern GL_UNSIGNED_INT_SAMPLER_1D,
  pattern GL_UNSIGNED_INT_SAMPLER_1D_ARRAY,
  pattern GL_UNSIGNED_INT_SAMPLER_2D,
  pattern GL_UNSIGNED_INT_SAMPLER_2D_ARRAY,
  pattern GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE,
  pattern GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY,
  pattern GL_UNSIGNED_INT_SAMPLER_2D_RECT,
  pattern GL_UNSIGNED_INT_SAMPLER_3D,
  pattern GL_UNSIGNED_INT_SAMPLER_BUFFER,
  pattern GL_UNSIGNED_INT_SAMPLER_CUBE,
  pattern GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY,
  pattern GL_UNSIGNED_INT_VEC2,
  pattern GL_UNSIGNED_INT_VEC3,
  pattern GL_UNSIGNED_INT_VEC4,
  pattern GL_UNSIGNED_NORMALIZED,
  pattern GL_UNSIGNED_SHORT,
  pattern GL_UNSIGNED_SHORT_1_5_5_5_REV,
  pattern GL_UNSIGNED_SHORT_4_4_4_4,
  pattern GL_UNSIGNED_SHORT_4_4_4_4_REV,
  pattern GL_UNSIGNED_SHORT_5_5_5_1,
  pattern GL_UNSIGNED_SHORT_5_6_5,
  pattern GL_UNSIGNED_SHORT_5_6_5_REV,
  pattern GL_UPPER_LEFT,
  pattern GL_VALIDATE_STATUS,
  pattern GL_VENDOR,
  pattern GL_VERSION,
  pattern GL_VERTEX_ARRAY,
  pattern GL_VERTEX_ARRAY_BINDING,
  pattern GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT,
  pattern GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING,
  pattern GL_VERTEX_ATTRIB_ARRAY_DIVISOR,
  pattern GL_VERTEX_ATTRIB_ARRAY_ENABLED,
  pattern GL_VERTEX_ATTRIB_ARRAY_INTEGER,
  pattern GL_VERTEX_ATTRIB_ARRAY_LONG,
  pattern GL_VERTEX_ATTRIB_ARRAY_NORMALIZED,
  pattern GL_VERTEX_ATTRIB_ARRAY_POINTER,
  pattern GL_VERTEX_ATTRIB_ARRAY_SIZE,
  pattern GL_VERTEX_ATTRIB_ARRAY_STRIDE,
  pattern GL_VERTEX_ATTRIB_ARRAY_TYPE,
  pattern GL_VERTEX_ATTRIB_BINDING,
  pattern GL_VERTEX_ATTRIB_RELATIVE_OFFSET,
  pattern GL_VERTEX_BINDING_BUFFER,
  pattern GL_VERTEX_BINDING_DIVISOR,
  pattern GL_VERTEX_BINDING_OFFSET,
  pattern GL_VERTEX_BINDING_STRIDE,
  pattern GL_VERTEX_PROGRAM_POINT_SIZE,
  pattern GL_VERTEX_SHADER,
  pattern GL_VERTEX_SHADER_BIT,
  pattern GL_VERTEX_SHADER_INVOCATIONS,
  pattern GL_VERTEX_SUBROUTINE,
  pattern GL_VERTEX_SUBROUTINE_UNIFORM,
  pattern GL_VERTEX_TEXTURE,
  pattern GL_VERTICES_SUBMITTED,
  pattern GL_VIEWPORT,
  pattern GL_VIEWPORT_BOUNDS_RANGE,
  pattern GL_VIEWPORT_INDEX_PROVOKING_VERTEX,
  pattern GL_VIEWPORT_SUBPIXEL_BITS,
  pattern GL_VIEW_CLASS_128_BITS,
  pattern GL_VIEW_CLASS_16_BITS,
  pattern GL_VIEW_CLASS_24_BITS,
  pattern GL_VIEW_CLASS_32_BITS,
  pattern GL_VIEW_CLASS_48_BITS,
  pattern GL_VIEW_CLASS_64_BITS,
  pattern GL_VIEW_CLASS_8_BITS,
  pattern GL_VIEW_CLASS_96_BITS,
  pattern GL_VIEW_CLASS_BPTC_FLOAT,
  pattern GL_VIEW_CLASS_BPTC_UNORM,
  pattern GL_VIEW_CLASS_RGTC1_RED,
  pattern GL_VIEW_CLASS_RGTC2_RG,
  pattern GL_VIEW_CLASS_S3TC_DXT1_RGB,
  pattern GL_VIEW_CLASS_S3TC_DXT1_RGBA,
  pattern GL_VIEW_CLASS_S3TC_DXT3_RGBA,
  pattern GL_VIEW_CLASS_S3TC_DXT5_RGBA,
  pattern GL_VIEW_COMPATIBILITY_CLASS,
  pattern GL_WAIT_FAILED,
  pattern GL_WRITE_ONLY,
  pattern GL_XOR,
  pattern GL_ZERO,
  pattern GL_ZERO_TO_ONE,
  -- * Functions
  glActiveShaderProgram,
  glActiveTexture,
  glAttachShader,
  glBeginConditionalRender,
  glBeginQuery,
  glBeginQueryIndexed,
  glBeginTransformFeedback,
  glBindAttribLocation,
  glBindBuffer,
  glBindBufferBase,
  glBindBufferRange,
  glBindBuffersBase,
  glBindBuffersRange,
  glBindFragDataLocation,
  glBindFragDataLocationIndexed,
  glBindFramebuffer,
  glBindImageTexture,
  glBindImageTextures,
  glBindProgramPipeline,
  glBindRenderbuffer,
  glBindSampler,
  glBindSamplers,
  glBindTexture,
  glBindTextureUnit,
  glBindTextures,
  glBindTransformFeedback,
  glBindVertexArray,
  glBindVertexBuffer,
  glBindVertexBuffers,
  glBlendColor,
  glBlendEquation,
  glBlendEquationSeparate,
  glBlendEquationSeparatei,
  glBlendEquationi,
  glBlendFunc,
  glBlendFuncSeparate,
  glBlendFuncSeparatei,
  glBlendFunci,
  glBlitFramebuffer,
  glBlitNamedFramebuffer,
  glBufferData,
  glBufferStorage,
  glBufferSubData,
  glCheckFramebufferStatus,
  glCheckNamedFramebufferStatus,
  glClampColor,
  glClear,
  glClearBufferData,
  glClearBufferSubData,
  glClearBufferfi,
  glClearBufferfv,
  glClearBufferiv,
  glClearBufferuiv,
  glClearColor,
  glClearDepth,
  glClearDepthf,
  glClearNamedBufferData,
  glClearNamedBufferSubData,
  glClearNamedFramebufferfi,
  glClearNamedFramebufferfv,
  glClearNamedFramebufferiv,
  glClearNamedFramebufferuiv,
  glClearStencil,
  glClearTexImage,
  glClearTexSubImage,
  glClientWaitSync,
  glClipControl,
  glColorMask,
  glColorMaski,
  glCompileShader,
  glCompressedTexImage1D,
  glCompressedTexImage2D,
  glCompressedTexImage3D,
  glCompressedTexSubImage1D,
  glCompressedTexSubImage2D,
  glCompressedTexSubImage3D,
  glCompressedTextureSubImage1D,
  glCompressedTextureSubImage2D,
  glCompressedTextureSubImage3D,
  glCopyBufferSubData,
  glCopyImageSubData,
  glCopyNamedBufferSubData,
  glCopyTexImage1D,
  glCopyTexImage2D,
  glCopyTexSubImage1D,
  glCopyTexSubImage2D,
  glCopyTexSubImage3D,
  glCopyTextureSubImage1D,
  glCopyTextureSubImage2D,
  glCopyTextureSubImage3D,
  glCreateBuffers,
  glCreateFramebuffers,
  glCreateProgram,
  glCreateProgramPipelines,
  glCreateQueries,
  glCreateRenderbuffers,
  glCreateSamplers,
  glCreateShader,
  glCreateShaderProgramv,
  glCreateTextures,
  glCreateTransformFeedbacks,
  glCreateVertexArrays,
  glCullFace,
  glDebugMessageCallback,
  glDebugMessageControl,
  glDebugMessageInsert,
  glDeleteBuffers,
  glDeleteFramebuffers,
  glDeleteProgram,
  glDeleteProgramPipelines,
  glDeleteQueries,
  glDeleteRenderbuffers,
  glDeleteSamplers,
  glDeleteShader,
  glDeleteSync,
  glDeleteTextures,
  glDeleteTransformFeedbacks,
  glDeleteVertexArrays,
  glDepthFunc,
  glDepthMask,
  glDepthRange,
  glDepthRangeArrayv,
  glDepthRangeIndexed,
  glDepthRangef,
  glDetachShader,
  glDisable,
  glDisableVertexArrayAttrib,
  glDisableVertexAttribArray,
  glDisablei,
  glDispatchCompute,
  glDispatchComputeIndirect,
  glDrawArrays,
  glDrawArraysIndirect,
  glDrawArraysInstanced,
  glDrawArraysInstancedBaseInstance,
  glDrawBuffer,
  glDrawBuffers,
  glDrawElements,
  glDrawElementsBaseVertex,
  glDrawElementsIndirect,
  glDrawElementsInstanced,
  glDrawElementsInstancedBaseInstance,
  glDrawElementsInstancedBaseVertex,
  glDrawElementsInstancedBaseVertexBaseInstance,
  glDrawRangeElements,
  glDrawRangeElementsBaseVertex,
  glDrawTransformFeedback,
  glDrawTransformFeedbackInstanced,
  glDrawTransformFeedbackStream,
  glDrawTransformFeedbackStreamInstanced,
  glEnable,
  glEnableVertexArrayAttrib,
  glEnableVertexAttribArray,
  glEnablei,
  glEndConditionalRender,
  glEndQuery,
  glEndQueryIndexed,
  glEndTransformFeedback,
  glFenceSync,
  glFinish,
  glFlush,
  glFlushMappedBufferRange,
  glFlushMappedNamedBufferRange,
  glFramebufferParameteri,
  glFramebufferRenderbuffer,
  glFramebufferTexture,
  glFramebufferTexture1D,
  glFramebufferTexture2D,
  glFramebufferTexture3D,
  glFramebufferTextureLayer,
  glFrontFace,
  glGenBuffers,
  glGenFramebuffers,
  glGenProgramPipelines,
  glGenQueries,
  glGenRenderbuffers,
  glGenSamplers,
  glGenTextures,
  glGenTransformFeedbacks,
  glGenVertexArrays,
  glGenerateMipmap,
  glGenerateTextureMipmap,
  glGetActiveAtomicCounterBufferiv,
  glGetActiveAttrib,
  glGetActiveSubroutineName,
  glGetActiveSubroutineUniformName,
  glGetActiveSubroutineUniformiv,
  glGetActiveUniform,
  glGetActiveUniformBlockName,
  glGetActiveUniformBlockiv,
  glGetActiveUniformName,
  glGetActiveUniformsiv,
  glGetAttachedShaders,
  glGetAttribLocation,
  glGetBooleani_v,
  glGetBooleanv,
  glGetBufferParameteri64v,
  glGetBufferParameteriv,
  glGetBufferPointerv,
  glGetBufferSubData,
  glGetCompressedTexImage,
  glGetCompressedTextureImage,
  glGetCompressedTextureSubImage,
  glGetDebugMessageLog,
  glGetDoublei_v,
  glGetDoublev,
  glGetError,
  glGetFloati_v,
  glGetFloatv,
  glGetFragDataIndex,
  glGetFragDataLocation,
  glGetFramebufferAttachmentParameteriv,
  glGetFramebufferParameteriv,
  glGetGraphicsResetStatus,
  glGetInteger64i_v,
  glGetInteger64v,
  glGetIntegeri_v,
  glGetIntegerv,
  glGetInternalformati64v,
  glGetInternalformativ,
  glGetMultisamplefv,
  glGetNamedBufferParameteri64v,
  glGetNamedBufferParameteriv,
  glGetNamedBufferPointerv,
  glGetNamedBufferSubData,
  glGetNamedFramebufferAttachmentParameteriv,
  glGetNamedFramebufferParameteriv,
  glGetNamedRenderbufferParameteriv,
  glGetObjectLabel,
  glGetObjectPtrLabel,
  glGetPointerv,
  glGetProgramBinary,
  glGetProgramInfoLog,
  glGetProgramInterfaceiv,
  glGetProgramPipelineInfoLog,
  glGetProgramPipelineiv,
  glGetProgramResourceIndex,
  glGetProgramResourceLocation,
  glGetProgramResourceLocationIndex,
  glGetProgramResourceName,
  glGetProgramResourceiv,
  glGetProgramStageiv,
  glGetProgramiv,
  glGetQueryBufferObjecti64v,
  glGetQueryBufferObjectiv,
  glGetQueryBufferObjectui64v,
  glGetQueryBufferObjectuiv,
  glGetQueryIndexediv,
  glGetQueryObjecti64v,
  glGetQueryObjectiv,
  glGetQueryObjectui64v,
  glGetQueryObjectuiv,
  glGetQueryiv,
  glGetRenderbufferParameteriv,
  glGetSamplerParameterIiv,
  glGetSamplerParameterIuiv,
  glGetSamplerParameterfv,
  glGetSamplerParameteriv,
  glGetShaderInfoLog,
  glGetShaderPrecisionFormat,
  glGetShaderSource,
  glGetShaderiv,
  glGetString,
  glGetStringi,
  glGetSubroutineIndex,
  glGetSubroutineUniformLocation,
  glGetSynciv,
  glGetTexImage,
  glGetTexLevelParameterfv,
  glGetTexLevelParameteriv,
  glGetTexParameterIiv,
  glGetTexParameterIuiv,
  glGetTexParameterfv,
  glGetTexParameteriv,
  glGetTextureImage,
  glGetTextureLevelParameterfv,
  glGetTextureLevelParameteriv,
  glGetTextureParameterIiv,
  glGetTextureParameterIuiv,
  glGetTextureParameterfv,
  glGetTextureParameteriv,
  glGetTextureSubImage,
  glGetTransformFeedbackVarying,
  glGetTransformFeedbacki64_v,
  glGetTransformFeedbacki_v,
  glGetTransformFeedbackiv,
  glGetUniformBlockIndex,
  glGetUniformIndices,
  glGetUniformLocation,
  glGetUniformSubroutineuiv,
  glGetUniformdv,
  glGetUniformfv,
  glGetUniformiv,
  glGetUniformuiv,
  glGetVertexArrayIndexed64iv,
  glGetVertexArrayIndexediv,
  glGetVertexArrayiv,
  glGetVertexAttribIiv,
  glGetVertexAttribIuiv,
  glGetVertexAttribLdv,
  glGetVertexAttribPointerv,
  glGetVertexAttribdv,
  glGetVertexAttribfv,
  glGetVertexAttribiv,
  glGetnCompressedTexImage,
  glGetnTexImage,
  glGetnUniformdv,
  glGetnUniformfv,
  glGetnUniformiv,
  glGetnUniformuiv,
  glHint,
  glInvalidateBufferData,
  glInvalidateBufferSubData,
  glInvalidateFramebuffer,
  glInvalidateNamedFramebufferData,
  glInvalidateNamedFramebufferSubData,
  glInvalidateSubFramebuffer,
  glInvalidateTexImage,
  glInvalidateTexSubImage,
  glIsBuffer,
  glIsEnabled,
  glIsEnabledi,
  glIsFramebuffer,
  glIsProgram,
  glIsProgramPipeline,
  glIsQuery,
  glIsRenderbuffer,
  glIsSampler,
  glIsShader,
  glIsSync,
  glIsTexture,
  glIsTransformFeedback,
  glIsVertexArray,
  glLineWidth,
  glLinkProgram,
  glLogicOp,
  glMapBuffer,
  glMapBufferRange,
  glMapNamedBuffer,
  glMapNamedBufferRange,
  glMemoryBarrier,
  glMemoryBarrierByRegion,
  glMinSampleShading,
  glMultiDrawArrays,
  glMultiDrawArraysIndirect,
  glMultiDrawArraysIndirectCount,
  glMultiDrawElements,
  glMultiDrawElementsBaseVertex,
  glMultiDrawElementsIndirect,
  glMultiDrawElementsIndirectCount,
  glNamedBufferData,
  glNamedBufferStorage,
  glNamedBufferSubData,
  glNamedFramebufferDrawBuffer,
  glNamedFramebufferDrawBuffers,
  glNamedFramebufferParameteri,
  glNamedFramebufferReadBuffer,
  glNamedFramebufferRenderbuffer,
  glNamedFramebufferTexture,
  glNamedFramebufferTextureLayer,
  glNamedRenderbufferStorage,
  glNamedRenderbufferStorageMultisample,
  glObjectLabel,
  glObjectPtrLabel,
  glPatchParameterfv,
  glPatchParameteri,
  glPauseTransformFeedback,
  glPixelStoref,
  glPixelStorei,
  glPointParameterf,
  glPointParameterfv,
  glPointParameteri,
  glPointParameteriv,
  glPointSize,
  glPolygonMode,
  glPolygonOffset,
  glPolygonOffsetClamp,
  glPopDebugGroup,
  glPrimitiveRestartIndex,
  glProgramBinary,
  glProgramParameteri,
  glProgramUniform1d,
  glProgramUniform1dv,
  glProgramUniform1f,
  glProgramUniform1fv,
  glProgramUniform1i,
  glProgramUniform1iv,
  glProgramUniform1ui,
  glProgramUniform1uiv,
  glProgramUniform2d,
  glProgramUniform2dv,
  glProgramUniform2f,
  glProgramUniform2fv,
  glProgramUniform2i,
  glProgramUniform2iv,
  glProgramUniform2ui,
  glProgramUniform2uiv,
  glProgramUniform3d,
  glProgramUniform3dv,
  glProgramUniform3f,
  glProgramUniform3fv,
  glProgramUniform3i,
  glProgramUniform3iv,
  glProgramUniform3ui,
  glProgramUniform3uiv,
  glProgramUniform4d,
  glProgramUniform4dv,
  glProgramUniform4f,
  glProgramUniform4fv,
  glProgramUniform4i,
  glProgramUniform4iv,
  glProgramUniform4ui,
  glProgramUniform4uiv,
  glProgramUniformMatrix2dv,
  glProgramUniformMatrix2fv,
  glProgramUniformMatrix2x3dv,
  glProgramUniformMatrix2x3fv,
  glProgramUniformMatrix2x4dv,
  glProgramUniformMatrix2x4fv,
  glProgramUniformMatrix3dv,
  glProgramUniformMatrix3fv,
  glProgramUniformMatrix3x2dv,
  glProgramUniformMatrix3x2fv,
  glProgramUniformMatrix3x4dv,
  glProgramUniformMatrix3x4fv,
  glProgramUniformMatrix4dv,
  glProgramUniformMatrix4fv,
  glProgramUniformMatrix4x2dv,
  glProgramUniformMatrix4x2fv,
  glProgramUniformMatrix4x3dv,
  glProgramUniformMatrix4x3fv,
  glProvokingVertex,
  glPushDebugGroup,
  glQueryCounter,
  glReadBuffer,
  glReadPixels,
  glReadnPixels,
  glReleaseShaderCompiler,
  glRenderbufferStorage,
  glRenderbufferStorageMultisample,
  glResumeTransformFeedback,
  glSampleCoverage,
  glSampleMaski,
  glSamplerParameterIiv,
  glSamplerParameterIuiv,
  glSamplerParameterf,
  glSamplerParameterfv,
  glSamplerParameteri,
  glSamplerParameteriv,
  glScissor,
  glScissorArrayv,
  glScissorIndexed,
  glScissorIndexedv,
  glShaderBinary,
  glShaderSource,
  glShaderStorageBlockBinding,
  glSpecializeShader,
  glStencilFunc,
  glStencilFuncSeparate,
  glStencilMask,
  glStencilMaskSeparate,
  glStencilOp,
  glStencilOpSeparate,
  glTexBuffer,
  glTexBufferRange,
  glTexImage1D,
  glTexImage2D,
  glTexImage2DMultisample,
  glTexImage3D,
  glTexImage3DMultisample,
  glTexParameterIiv,
  glTexParameterIuiv,
  glTexParameterf,
  glTexParameterfv,
  glTexParameteri,
  glTexParameteriv,
  glTexStorage1D,
  glTexStorage2D,
  glTexStorage2DMultisample,
  glTexStorage3D,
  glTexStorage3DMultisample,
  glTexSubImage1D,
  glTexSubImage2D,
  glTexSubImage3D,
  glTextureBarrier,
  glTextureBuffer,
  glTextureBufferRange,
  glTextureParameterIiv,
  glTextureParameterIuiv,
  glTextureParameterf,
  glTextureParameterfv,
  glTextureParameteri,
  glTextureParameteriv,
  glTextureStorage1D,
  glTextureStorage2D,
  glTextureStorage2DMultisample,
  glTextureStorage3D,
  glTextureStorage3DMultisample,
  glTextureSubImage1D,
  glTextureSubImage2D,
  glTextureSubImage3D,
  glTextureView,
  glTransformFeedbackBufferBase,
  glTransformFeedbackBufferRange,
  glTransformFeedbackVaryings,
  glUniform1d,
  glUniform1dv,
  glUniform1f,
  glUniform1fv,
  glUniform1i,
  glUniform1iv,
  glUniform1ui,
  glUniform1uiv,
  glUniform2d,
  glUniform2dv,
  glUniform2f,
  glUniform2fv,
  glUniform2i,
  glUniform2iv,
  glUniform2ui,
  glUniform2uiv,
  glUniform3d,
  glUniform3dv,
  glUniform3f,
  glUniform3fv,
  glUniform3i,
  glUniform3iv,
  glUniform3ui,
  glUniform3uiv,
  glUniform4d,
  glUniform4dv,
  glUniform4f,
  glUniform4fv,
  glUniform4i,
  glUniform4iv,
  glUniform4ui,
  glUniform4uiv,
  glUniformBlockBinding,
  glUniformMatrix2dv,
  glUniformMatrix2fv,
  glUniformMatrix2x3dv,
  glUniformMatrix2x3fv,
  glUniformMatrix2x4dv,
  glUniformMatrix2x4fv,
  glUniformMatrix3dv,
  glUniformMatrix3fv,
  glUniformMatrix3x2dv,
  glUniformMatrix3x2fv,
  glUniformMatrix3x4dv,
  glUniformMatrix3x4fv,
  glUniformMatrix4dv,
  glUniformMatrix4fv,
  glUniformMatrix4x2dv,
  glUniformMatrix4x2fv,
  glUniformMatrix4x3dv,
  glUniformMatrix4x3fv,
  glUniformSubroutinesuiv,
  glUnmapBuffer,
  glUnmapNamedBuffer,
  glUseProgram,
  glUseProgramStages,
  glValidateProgram,
  glValidateProgramPipeline,
  glVertexArrayAttribBinding,
  glVertexArrayAttribFormat,
  glVertexArrayAttribIFormat,
  glVertexArrayAttribLFormat,
  glVertexArrayBindingDivisor,
  glVertexArrayElementBuffer,
  glVertexArrayVertexBuffer,
  glVertexArrayVertexBuffers,
  glVertexAttrib1d,
  glVertexAttrib1dv,
  glVertexAttrib1f,
  glVertexAttrib1fv,
  glVertexAttrib1s,
  glVertexAttrib1sv,
  glVertexAttrib2d,
  glVertexAttrib2dv,
  glVertexAttrib2f,
  glVertexAttrib2fv,
  glVertexAttrib2s,
  glVertexAttrib2sv,
  glVertexAttrib3d,
  glVertexAttrib3dv,
  glVertexAttrib3f,
  glVertexAttrib3fv,
  glVertexAttrib3s,
  glVertexAttrib3sv,
  glVertexAttrib4Nbv,
  glVertexAttrib4Niv,
  glVertexAttrib4Nsv,
  glVertexAttrib4Nub,
  glVertexAttrib4Nubv,
  glVertexAttrib4Nuiv,
  glVertexAttrib4Nusv,
  glVertexAttrib4bv,
  glVertexAttrib4d,
  glVertexAttrib4dv,
  glVertexAttrib4f,
  glVertexAttrib4fv,
  glVertexAttrib4iv,
  glVertexAttrib4s,
  glVertexAttrib4sv,
  glVertexAttrib4ubv,
  glVertexAttrib4uiv,
  glVertexAttrib4usv,
  glVertexAttribBinding,
  glVertexAttribDivisor,
  glVertexAttribFormat,
  glVertexAttribI1i,
  glVertexAttribI1iv,
  glVertexAttribI1ui,
  glVertexAttribI1uiv,
  glVertexAttribI2i,
  glVertexAttribI2iv,
  glVertexAttribI2ui,
  glVertexAttribI2uiv,
  glVertexAttribI3i,
  glVertexAttribI3iv,
  glVertexAttribI3ui,
  glVertexAttribI3uiv,
  glVertexAttribI4bv,
  glVertexAttribI4i,
  glVertexAttribI4iv,
  glVertexAttribI4sv,
  glVertexAttribI4ubv,
  glVertexAttribI4ui,
  glVertexAttribI4uiv,
  glVertexAttribI4usv,
  glVertexAttribIFormat,
  glVertexAttribIPointer,
  glVertexAttribL1d,
  glVertexAttribL1dv,
  glVertexAttribL2d,
  glVertexAttribL2dv,
  glVertexAttribL3d,
  glVertexAttribL3dv,
  glVertexAttribL4d,
  glVertexAttribL4dv,
  glVertexAttribLFormat,
  glVertexAttribLPointer,
  glVertexAttribP1ui,
  glVertexAttribP1uiv,
  glVertexAttribP2ui,
  glVertexAttribP2uiv,
  glVertexAttribP3ui,
  glVertexAttribP3uiv,
  glVertexAttribP4ui,
  glVertexAttribP4uiv,
  glVertexAttribPointer,
  glVertexBindingDivisor,
  glViewport,
  glViewportArrayv,
  glViewportIndexedf,
  glViewportIndexedfv,
  glWaitSync
) where

import Graphics.GL.Types
import Graphics.GL.Tokens
import Graphics.GL.Functions
