/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.CRC;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class Decode {
    private static final long DECODE_DATA_RECORDS_ONLY = Long.MAX_VALUE;
    private STATE state;
    private byte fileHdrOffset;
    private byte fileHdrSize;
    private long fileDataSize;
    private long fileBytesLeft;
    private int crc;
    private Mesg mesg;
    private int localMesgIndex;
    private MesgDefinition[] localMesgDefs = new MesgDefinition[16];
    private int numFields;
    private int fieldIndex;
    private int fieldDataIndex;
    private int fieldBytesLeft;
    private byte[] fieldData = new byte[255];
    private int lastTimeOffset;
    private long timestamp;
    private long systemTimeOffset = 0L;
    private Accumulator accumulator = new Accumulator();
    private boolean pause;
    private InputStream in;
    private boolean instreamIsComplete;
    private ArrayList<MesgListener> mesgListeners = new ArrayList();
    private ArrayList<MesgDefinitionListener> mesgDefListeners = new ArrayList();

    public Decode() {
        this.nextFile();
        if (Fit.debug) {
            System.out.printf("Fit.Decode: Starting decode...\n", new Object[0]);
        }
    }

    public void nextFile() {
        this.fileBytesLeft = 3L;
        this.fileHdrOffset = 0;
        this.crc = 0;
        this.state = STATE.FILE_HDR;
        this.lastTimeOffset = 0;
        this.pause = false;
        this.instreamIsComplete = true;
    }

    public void addListener(MesgListener mesgListener) {
        if (mesgListener != null && !this.mesgListeners.contains(mesgListener)) {
            this.mesgListeners.add(mesgListener);
        }
    }

    public void addListener(MesgDefinitionListener mesgDefinitionListener) {
        if (mesgDefinitionListener != null && !this.mesgDefListeners.contains(mesgDefinitionListener)) {
            this.mesgDefListeners.add(mesgDefinitionListener);
        }
    }

    public void setSystemTimeOffset(long l) {
        this.systemTimeOffset = l;
    }

    public void skipHeader() {
        if (this.in != null) {
            throw new FitRuntimeException("Can't set skipHeader option after Decode started!");
        }
        this.state = STATE.RECORD;
        this.fileBytesLeft = Long.MAX_VALUE;
    }

    public void incompleteStream() {
        if (this.in != null) {
            throw new FitRuntimeException("Can't set incompleteStream option after Decode started!");
        }
        this.instreamIsComplete = false;
    }

    public boolean read(InputStream inputStream, MesgListener mesgListener) {
        this.addListener(mesgListener);
        return this.read(inputStream);
    }

    public boolean read(InputStream inputStream) {
        this.in = inputStream;
        return this.resume();
    }

    public void pause() {
        this.pause = true;
    }

    public boolean resume() {
        this.pause = false;
        RETURN rETURN = RETURN.CONTINUE;
        try {
            int n;
            block8: while ((n = this.in.read()) >= 0) {
                if (this.pause) {
                    return false;
                }
                rETURN = this.read((byte)n);
                switch (rETURN) {
                    case CONTINUE: {
                        continue block8;
                    }
                    case MESG: {
                        for (MesgListener mesgListener : this.mesgListeners) {
                            mesgListener.onMesg(this.mesg);
                        }
                        continue block8;
                    }
                    case MESG_DEF: {
                        for (MesgDefinitionListener mesgDefinitionListener : this.mesgDefListeners) {
                            mesgDefinitionListener.onMesgDefinition(this.localMesgDefs[this.localMesgIndex]);
                        }
                        continue block8;
                    }
                    case END_OF_FILE: {
                        return true;
                    }
                }
                throw new FitRuntimeException("FIT decode error: " + (Object)((Object)rETURN));
            }
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
        if (this.instreamIsComplete && this.fileBytesLeft != Long.MAX_VALUE) {
            throw new FitRuntimeException("FIT decode error: Unexpected end of input stream.");
        }
        if (!this.instreamIsComplete) {
            return rETURN == RETURN.MESG || rETURN == RETURN.MESG_DEF;
        }
        if (rETURN == RETURN.MESG || rETURN == RETURN.MESG_DEF) {
            return true;
        }
        throw new FitRuntimeException("FIT decode error: Unexpected end of input stream.");
    }

    public static boolean isFit(InputStream inputStream) {
        Decode decode = new Decode();
        try {
            int n;
            while ((n = inputStream.read()) >= 0) {
                switch (decode.read((byte)n)) {
                    case CONTINUE: 
                    case MESG: 
                    case MESG_DEF: {
                        break;
                    }
                    case END_OF_FILE: {
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
                if (decode.state == STATE.FILE_HDR) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
        catch (FitRuntimeException fitRuntimeException) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkIntegrity(InputStream inputStream) {
        Decode decode = new Decode();
        try {
            int n;
            block7: while ((n = inputStream.read()) >= 0) {
                switch (decode.read((byte)n)) {
                    case CONTINUE: 
                    case MESG: 
                    case MESG_DEF: {
                        continue block7;
                    }
                    case END_OF_FILE: {
                        return true;
                    }
                }
                return false;
            }
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
        catch (FitRuntimeException fitRuntimeException) {
            // empty catch block
        }
        return false;
    }

    public RETURN read(byte by) {
        if (Fit.debug) {
            if (this.fileBytesLeft == 2L) {
                System.out.printf("Fit.Decode: Expecting next 2 bytes to be end of file CRC = 0x%04X\n", this.crc);
            }
            System.out.printf("Fit.Decode: 0x%02X - %s\n", by & 0xFF, this.state.toString());
        }
        if (this.fileBytesLeft > 0L && this.fileBytesLeft != Long.MAX_VALUE) {
            this.crc = CRC.get16(this.crc, by);
            --this.fileBytesLeft;
            if (this.fileBytesLeft == 1L) {
                if (this.state != STATE.RECORD) {
                    throw new FitRuntimeException("FIT decode error: Decoder not in correct state after last data byte in file.  Check message definitions.");
                }
                return RETURN.CONTINUE;
            }
            if (this.fileBytesLeft == 0L) {
                if (this.crc != 0) {
                    throw new FitRuntimeException("FIT decode error: File CRC failed.");
                }
                return RETURN.END_OF_FILE;
            }
        }
        switch (this.state) {
            case FILE_HDR: {
                byte by2 = this.fileHdrOffset;
                this.fileHdrOffset = (byte)(by2 + 1);
                switch (by2) {
                    case 0: {
                        this.fileHdrSize = by;
                        this.fileBytesLeft = this.fileHdrSize + 2;
                        break;
                    }
                    case 1: {
                        if ((by & 0xF0) <= 16) break;
                        throw new FitRuntimeException("FIT decode error: Protocol version " + ((by & 0xF0) >> 4) + "." + (by & 0xF) + " not supported.  Must be " + 1 + ".15 or earlier.");
                    }
                    case 4: {
                        this.fileDataSize = by & 0xFF;
                        break;
                    }
                    case 5: {
                        this.fileDataSize |= (long)(by & 0xFF) << 8;
                        break;
                    }
                    case 6: {
                        this.fileDataSize |= (long)(by & 0xFF) << 16;
                        break;
                    }
                    case 7: {
                        this.fileDataSize |= (long)(by & 0xFF) << 24;
                        break;
                    }
                    case 8: {
                        if (by == 46) break;
                        throw new FitRuntimeException("FIT decode error: File is not FIT format.  Check file header data type.");
                    }
                    case 9: {
                        if (by == 70) break;
                        throw new FitRuntimeException("FIT decode error: File is not FIT format.  Check file header data type.");
                    }
                    case 10: {
                        if (by == 73) break;
                        throw new FitRuntimeException("FIT decode error: File is not FIT format.  Check file header data type.");
                    }
                    case 11: {
                        if (by == 84) break;
                        throw new FitRuntimeException("FIT decode error: File is not FIT format.  Check file header data type.");
                    }
                }
                if (this.fileHdrOffset != this.fileHdrSize) break;
                this.fileBytesLeft = this.fileDataSize + 2L;
                this.state = STATE.RECORD;
                break;
            }
            case RECORD: {
                this.fieldIndex = 0;
                this.fieldBytesLeft = 0;
                if (this.fileBytesLeft > 1L) {
                    if ((by & 0x80) != 0) {
                        int n = by & 0x1F;
                        this.localMesgIndex = (by & 0x60) >> 5;
                        if (this.localMesgDefs[this.localMesgIndex] == null) {
                            throw new FitRuntimeException("FIT decode error: Missing message definition for local message number " + this.localMesgIndex + ".");
                        }
                        Field field = Factory.createField(this.localMesgDefs[this.localMesgIndex].num, 253);
                        this.timestamp += (long)(n - this.lastTimeOffset & 0x1F);
                        this.lastTimeOffset = n;
                        field.setValue(this.timestamp);
                        this.mesg = Factory.createMesg(this.localMesgDefs[this.localMesgIndex].num);
                        this.mesg.localNum = this.localMesgIndex;
                        this.mesg.systemTimeOffset = this.systemTimeOffset;
                        this.mesg.addField(field);
                        if (this.localMesgDefs[this.localMesgIndex].fields.size() == 0) {
                            return RETURN.MESG;
                        }
                        this.state = STATE.FIELD_DATA;
                        break;
                    }
                    this.localMesgIndex = by & 0xF;
                    if ((by & 0x40) != 0) {
                        this.localMesgDefs[this.localMesgIndex] = new MesgDefinition();
                        this.localMesgDefs[this.localMesgIndex].localNum = this.localMesgIndex;
                        this.state = STATE.RESERVED1;
                        break;
                    }
                    if (this.localMesgDefs[this.localMesgIndex] == null) {
                        throw new FitRuntimeException("FIT decode error: Missing message definition for local message number " + this.localMesgIndex + ".");
                    }
                    this.mesg = Factory.createMesg(this.localMesgDefs[this.localMesgIndex].num);
                    this.mesg.localNum = this.localMesgIndex;
                    this.mesg.systemTimeOffset = this.systemTimeOffset;
                    if (this.localMesgDefs[this.localMesgIndex].fields.size() == 0) {
                        return RETURN.MESG;
                    }
                    this.state = STATE.FIELD_DATA;
                    break;
                }
                this.state = STATE.FILE_CRC_HIGH;
                break;
            }
            case RESERVED1: {
                this.state = STATE.ARCH;
                break;
            }
            case ARCH: {
                this.localMesgDefs[this.localMesgIndex].arch = by & 0xFF;
                this.state = STATE.MESG_NUM_0;
                break;
            }
            case MESG_NUM_0: {
                this.localMesgDefs[this.localMesgIndex].num = by & 0xFF;
                this.state = STATE.MESG_NUM_1;
                break;
            }
            case MESG_NUM_1: {
                this.localMesgDefs[this.localMesgIndex].num |= (by & 0xFF) << 8;
                if (this.localMesgDefs[this.localMesgIndex].arch == 1) {
                    this.localMesgDefs[this.localMesgIndex].num = this.localMesgDefs[this.localMesgIndex].num >> 8 | (this.localMesgDefs[this.localMesgIndex].num & 0xFF) << 8;
                } else if (this.localMesgDefs[this.localMesgIndex].arch != 0) {
                    throw new FitRuntimeException("FIT decode error: Endian " + this.localMesgDefs[this.localMesgIndex].arch + " not supported.");
                }
                this.state = STATE.NUM_FIELDS;
                break;
            }
            case NUM_FIELDS: {
                this.numFields = by & 0xFF;
                if (this.numFields == 0) {
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.FIELD_NUM;
                break;
            }
            case FIELD_NUM: {
                this.localMesgDefs[this.localMesgIndex].fields.add(new FieldDefinition());
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).num = by & 0xFF;
                this.state = STATE.FIELD_SIZE;
                break;
            }
            case FIELD_SIZE: {
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).size = by & 0xFF;
                this.state = STATE.FIELD_TYPE;
                break;
            }
            case FIELD_TYPE: {
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).type = by & 0xFF;
                if (++this.fieldIndex >= this.numFields) {
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.FIELD_NUM;
                break;
            }
            case FIELD_DATA: {
                int n;
                FieldDefinition fieldDefinition = this.localMesgDefs[this.localMesgIndex].fields.get(this.fieldIndex);
                if (this.fieldBytesLeft == 0) {
                    this.fieldDataIndex = 0;
                    this.fieldBytesLeft = fieldDefinition.size;
                }
                this.fieldData[this.fieldDataIndex++] = by;
                --this.fieldBytesLeft;
                if (this.fieldBytesLeft != 0) break;
                if ((fieldDefinition.type & 0x1F) < 14) {
                    Field field;
                    int n2 = Fit.baseTypeSizes[fieldDefinition.type & 0x1F];
                    int n3 = fieldDefinition.size / n2;
                    if ((fieldDefinition.type & 0x80) != 0 && (this.localMesgDefs[this.localMesgIndex].arch & 1) != 1) {
                        for (n = 0; n < n3; ++n) {
                            for (int i = 0; i < n2 / 2; ++i) {
                                byte by3 = this.fieldData[n * n2 + i];
                                this.fieldData[n * n2 + i] = this.fieldData[n * n2 + n2 - i - 1];
                                this.fieldData[n * n2 + n2 - i - 1] = by3;
                            }
                        }
                    }
                    if ((field = Factory.createField(this.mesg.num, fieldDefinition.num)) != null) {
                        Long l;
                        if (field.getName().equals("unknown")) {
                            field = new Field("unknown", fieldDefinition.num, fieldDefinition.type, 1.0, 0.0, "", false);
                        }
                        field.read(new ByteArrayInputStream(this.fieldData), fieldDefinition.size);
                        if (fieldDefinition.num == 253 && (l = field.getLongValue()) != null) {
                            this.timestamp = l;
                            this.lastTimeOffset = (int)(this.timestamp & 0x1FL);
                        }
                        if (field.getIsAccumulated()) {
                            for (n = 0; n < field.getNumValues(); ++n) {
                                long l2 = ((Number)field.getRawValue(n)).longValue();
                                this.accumulator.set(this.mesg.num, field.getNum(), l2);
                            }
                        }
                        if (field.getNumValues() > 0) {
                            this.mesg.addField(field);
                        }
                    }
                }
                ++this.fieldIndex;
                if (this.fieldIndex < this.localMesgDefs[this.localMesgIndex].fields.size()) break;
                for (n = 0; n < this.mesg.fields.size(); ++n) {
                    int n4 = this.mesg.GetActiveSubFieldIndex(this.mesg.fields.get(n).getNum());
                    if (n4 == 65535) {
                        if (this.mesg.fields.get((int)n).components.size() <= 0) continue;
                        this.expandComponents(this.mesg.fields.get(n), this.mesg.fields.get((int)n).components);
                        continue;
                    }
                    if (this.mesg.fields.get((int)n).subFields.get((int)n4).components.size() <= 0) continue;
                    this.expandComponents(this.mesg.fields.get(n), this.mesg.fields.get((int)n).subFields.get((int)n4).components);
                }
                this.state = STATE.RECORD;
                return RETURN.MESG;
            }
        }
        return RETURN.CONTINUE;
    }

    protected void expandComponents(Field field, ArrayList<FieldComponent> arrayList) {
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            FieldComponent fieldComponent = arrayList.get(i);
            if (fieldComponent.fieldNum != 255) {
                Field field2 = Factory.createField(this.mesg.num, fieldComponent.fieldNum);
                Long l = field.getBitsValue(n, fieldComponent.bits, field2.isSignedInteger());
                if (l == null) break;
                if (fieldComponent.accumulate) {
                    l = this.accumulator.accumulate(this.mesg.num, fieldComponent.fieldNum, l, fieldComponent.bits);
                }
                Double d = ((double)l.longValue() / fieldComponent.scale - fieldComponent.offset + field2.offset) * field2.scale;
                if (this.mesg.hasField(field2.num)) {
                    this.mesg.getField(field2.num).addValue(d);
                } else {
                    field2.addValue(d);
                    this.mesg.addField(field2);
                }
            }
            n += fieldComponent.bits;
        }
    }

    public Mesg getMesg() {
        return this.mesg;
    }

    private class Accumulator {
        ArrayList<AccumulatedField> accumulatedFields = new ArrayList();

        Accumulator() {
        }

        public void set(int n, int n2, long l) {
            int n3;
            AccumulatedField accumulatedField = null;
            for (n3 = 0; n3 < this.accumulatedFields.size(); ++n3) {
                accumulatedField = this.accumulatedFields.get(n3);
                if (accumulatedField.mesgNum == n && accumulatedField.destFieldNum == n2) break;
            }
            if (n3 == this.accumulatedFields.size()) {
                accumulatedField = new AccumulatedField(n, n2);
                this.accumulatedFields.add(accumulatedField);
            }
            accumulatedField.set(l);
        }

        public long accumulate(int n, int n2, long l, int n3) {
            int n4;
            AccumulatedField accumulatedField = null;
            for (n4 = 0; n4 < this.accumulatedFields.size(); ++n4) {
                accumulatedField = this.accumulatedFields.get(n4);
                if (accumulatedField.mesgNum == n && accumulatedField.destFieldNum == n2) break;
            }
            if (n4 == this.accumulatedFields.size()) {
                accumulatedField = new AccumulatedField(n, n2);
                this.accumulatedFields.add(accumulatedField);
            }
            return accumulatedField.accumulate(l, n3);
        }
    }

    private class AccumulatedField {
        int mesgNum;
        int destFieldNum;
        long lastValue;
        long accumulatedValue;

        AccumulatedField(int n, int n2) {
            this.mesgNum = n;
            this.destFieldNum = n2;
            this.lastValue = 0L;
            this.accumulatedValue = 0L;
        }

        public long accumulate(long l, int n) {
            long l2 = (1L << n) - 1L;
            this.accumulatedValue += l - this.lastValue & l2;
            this.lastValue = l;
            return this.accumulatedValue;
        }

        public long set(long l) {
            this.accumulatedValue = l;
            this.lastValue = l;
            return this.accumulatedValue;
        }
    }

    private static enum STATE {
        FILE_HDR,
        RECORD,
        RESERVED1,
        ARCH,
        MESG_NUM_0,
        MESG_NUM_1,
        NUM_FIELDS,
        FIELD_NUM,
        FIELD_SIZE,
        FIELD_TYPE,
        FIELD_DATA,
        FILE_CRC_HIGH;

    }

    public static enum RETURN {
        CONTINUE,
        MESG,
        MESG_DEF,
        END_OF_FILE;

    }
}

