/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* Use includes - FIXME */

#define ticks_low	0x6c
#define ticks_high	0x6e
#define time_24h	0x70

#define RTC_CLCK_32KHZ	0x20
#define RTC_24H		0x02

	.code16

/* ==================== RUNTIME_RM ==================== */
#ifdef RUNTIME_RM

/*
 * Increment timer ticks counter in BDA.
 * If one day is over increment day counter in BDA.
 */
rtc_tick: .globl rtc_tick
	pushw %ds
	pushw $0x40
	popw %ds

	movl ticks_low, %eax
	incl %eax
	movl %eax, ticks_low
	/* 1573064 = 60 * 60 * 24 * 1193180 / 65535 */
	cmpl $1573064, %eax
	jne 1f

	/* One day is over... */
	movl $0, ticks_low
	incb time_24h
1:
	popw %ds
	lretw


/*
 * Check whether CMOS clock is currently updating its registers.
 * If it is updating wait for some time.
 * If it stays updating for a long time return error code (1).
 * Otherwise return (0).
 */
rtc_updating:
	pushw %cx

	movw $0xffff, %cx

rtc_updating_loop:
	movb $0x0a, %al /* Read UIP bit. */
	outb %al, $0x70
	inb $0x71, %al

	testb $(1 << 7), %al
	je rtc_updating_success /* No update in progress. */

	loop rtc_updating_loop
	
	movb $1, %al /* Fail */
	jmp rtc_updating_end
rtc_updating_success:
	movb $0, %al /* Success */
rtc_updating_end:
	popw %cx
	retw


/*
 * Handle BIOS calls for interrupt 0x1a:
 *
 * 0x00: Read timer ticks.
 * 0x01: Write timer ticks.
 *
 * 0x02: Read CMOS time.
 * 0x03: Write CMOS time.
 *
 * 0x04: Read CMOS date.
 * 0x05: Write CMOS date.
 *
 * 0x06: Set alarm.
 * 0x07: Reset alarm.
 *
 * 0xb1 is redirected to PCI module.
 */
	.section .text.org_ffe6e
bios_1a: .globl bios_1a
	ex_ljmp bios_1a_real

	.section .text
bios_1a_real:
	pushw %ds
	pushw $0x40
	popw %ds

	cmpb $0, %ah
	jne bios_1a_check_01

	/*
	 * Read timer ticks.
	 *
	 * In:	%ah	= 0x1a
	 *	%al	= 0x00
	 *
	 * Out:	%cx:%dx	= timer ticks since midnight
	 *	%ax	= number of midnight passes since last call
	 */
	/* Allow some timer ticks. */
	sti
	nop
	cli

	/* Read timer ticks. */
	movw ticks_low, %dx
	movw ticks_high, %cx
	movb $0, %al
	xchgb %al, time_24h
	movb $0, %ah

	jmp bios_1a_success

bios_1a_check_01:
	cmp $1, %ah
	jne bios_1a_check_02

	/*
	 * Write timer ticks.
	 *
	 * In:	%ah	= 0x1a
	 *	%al	= 0x01
	 *	%cx:%dx	= timer ticks since midnight
	 *
	 * Out:	-
	 */
	movw %dx, ticks_low
	movw %cx, ticks_high
	movb $0, time_24h

	jmp bios_1a_success

bios_1a_check_02:
	cmp $2, %ah
	jne bios_1a_check_03

	/*
	 * Read CMOS time.
	 *
	 * In:	%ah	= 0x1a
	 *	%al	= 0x02
	 *
	 * Out:	%cl	= hours (BCD)
	 *	%ch	= minutes (BCD)
	 *	%dh	= seconds (BCD)
	 *	%dl	= daylight savings enabled
	 *	%al	= %ch (Correct - FIXME)
	 */
	/* Check if updating. */
	callw rtc_updating
	andb %al, %al
	jne bios_1a_fail

	movb $0x04, %al /* Read hours. */
	outb %al, $0x70
	inb $0x71, %al
	movb %al, %cl

	movb $0x02, %al /* Read minutes. */
	outb %al, $0x70
	inb $0x71, %al
	movb %al, %ch

	movb $0x00, %al /* Read seconds. */
	outb %al, $0x70
	inb $0x71, %al
	movb %al, %dh

	movb $0x0b, %al /* Read register B. */
	outb %al, $0x70
	inb $0x71, %al
	andb $(1 << 0), %al
	movb %al, %dl

	movb %ch, %al /* Correct - FIXME */

	jmp bios_1a_success

bios_1a_check_03:
	cmp $3, %ah
	jne bios_1a_check_04

	/*
	 * Write CMOS time.
	 *
	 * In:	%ah	= 0x1a
	 *	%al	= 0x03
	 *
	 * Out:	%ch	= hours (BCD)
	 *	%cl	= minutes (BCD)
	 *	%dh	= seconds (BCD)
	 *	%dl	= daylight savings enabled
	 */
	/* Check if updating. */
	callw rtc_updating
	andb %al, %al
	jne bios_1a_fail

	andb $1, %dl

	movb $0x04, %al /* Write hours. */
	outb %al, $0x70
	movb %ch, %al
	outb %al, $0x71

	movb $0x02, %al /* Write minutes. */
	outb %al, $0x70
	movb %cl, %al
	outb %al, $0x71

	movb $0x00, %al /* Write seconds. */
	outb %al, $0x70
	movb %dh, %al
	outb %al, $0x71

	movb $0x0b, %al /* Read register B. */
	outb %al, $0x70
	inb $0x71, %al
	andb $~(1 << 0), %al
	orb %dl, %al /* Set daylight savings enable bit. */
	outb %al, $0x71

	jmp bios_1a_success

bios_1a_check_04:
	cmp $4, %ah
	jne bios_1a_check_05

	/*
	 * Read CMOS date.
	 *
	 * In:	%ah	= 0x1a
	 *	%al	= 0x04
	 *
	 * Out:	%ch	= century (BCD)
	 *	%cl	= year (BCD)
	 *	%dh	= month (BCD)
	 *	%dl	= day of month (BCD)
	 */
	/* Check if updating. */
	callw rtc_updating
	andb %al, %al
	jne bios_1a_fail

	movb $0x32, %al /* Read century. */
	outb %al, $0x70
	inb $0x71, %al
	movb %al, %ch

	movb $9, %al /* Read year. */
	outb %al, $0x70
	inb $0x71, %al
	movb %al, %cl

	movb $8, %al /* Read month. */
	outb %al, $0x70
	inb $0x71, %al
	movb %al, %dh

	movb $7, %al /* Read day of month. */
	outb %al, $0x70
	inb $0x71, %al
	movb %al, %dl

	jmp bios_1a_success

bios_1a_check_05:
	cmp $5, %ah
	jne bios_1a_check_06

	/*
	 * Write CMOS date.
	 *
	 * In:	%ah	= 0x1a
	 *	%al	= 0x05
	 *	%ch	= century (BCD)
	 *	%cl	= year (BCD)
	 *	%dh	= month (BCD)
	 *	%dl	= day of month (BCD)
	 *
	 * Out:	-
	 */
	/* Check if updating. */
	callw rtc_updating
	andb %al, %al
	jne bios_1a_fail

	movb $0x32, %al /* Write century. */
	outb %al, $0x70
	movb %ch, %al
	outb %al, $0x71

	movb $9, %al /* Write year. */
	outb %al, $0x70
	movb %cl, %al
	outb %al, $0x71

	movb $8, %al /* Write month. */
	outb %al, $0x70
	movb %dh, %al
	outb %al, $0x71

	movb $9, %al /* Write day of month. */
	outb %al, $0x70
	movb %dl, %al
	outb %al, $0x71

	movb $0x0b, %al /* Clear SET bit. */
	outb %al, $0x70
	inb $0x71, %al
	andb $~(1 << 7), %al
	outb %al, $0x71

	jmp bios_1a_success

bios_1a_check_06:
	cmp $6, %ah
	jne bios_1a_check_07

	/*
	 * Set alarm.
	 *
	 * In:	%ah	= 0x1a
	 *	%al	= 0x06
	 *	%ch	= hours (BCD)
	 *	%cl	= minutes (BCD)
	 *	%dh	= seconds (BCD)
	 *
	 * Out:	%carry	= 0: success
	 *		= 1: alarm already set
	 */
	/* Check AIE bit. */
	movb $0x0b, %al
	outb %al, $0x70
	inb $0x71, %al
	andb $(1 << 5), %al
	jne bios_1a_fail /* Alarm already set. */

	/* Enable RTC interrupt. */
	inb $0xa1, %al
	andb $~(1 << (8-8)), %al
	outb %al, $0xa1

	/* Set alarm time. */
	movb $5, %al /* Write hours. */
	outb %al, $0x70
	movb %ch, %al
	outb %al, $0x71

	movb $3, %al /* Write minutes. */
	outb %al, $0x70
	movb %cl, %al
	outb %al, $0x71

	movb $1, %al /* Write seconds. */
	outb %al, $0x70
	movb %dh, %al
	outb %al, $0x71

	/* Clear SET bit, clear AIE bit. */
	movb $0x0b, %al
	outb %al, $0x70
	inb $0x71, %al
	andb $~(1 << 7), %al
	orb $(1 << 5), %al
	outb %al, $0x71

	jmp bios_1a_success

bios_1a_check_07:
	cmp $7, %ah
	jne bios_1a_check_b1

	/*
	 * Reset alarm.
	 *
	 * In:	%ah	= 0x1a
	 *	%al	= 0x07
	 *
	 * Out:	%carry	= 0: success
	 */
	/* Disable AIE bit. */
	movb $0x0b, %al
	outb %al, $0x70
	inb $0x71, %al
	andb $~(1 << 5), %al
	outb %al, $0x71

	jmp bios_1a_success

bios_1a_check_b1:
#ifdef CONFIG_PCI_SUPPORT

	cmp $0xb1, %ah
	jne bios_1a_fail

	popw %ds
	ex_ljmp irq1a_b1xx

#endif /* CONFIG_PCI_SUPPORT */

bios_1a_fail:
	stc
	jmp 1f
bios_1a_success:
	clc
1:
	popw %ds
	iretw

#endif /* RUNTIME_RM
/* ==================== REAL-MODE INIT ==================== */
#ifdef INIT_RM

rtc_init: .globl rtc_init
	pushw %ds
	movw $0x40, %ax
	movw %ax, %ds

	/*
	 * Initialize 18Hz clock.
	 */
	movw $0, ticks_low
	movw $0, ticks_high
	movw $0, time_24h
	
	/*
	 * Set clock control to 32kHz.
	 * Windows XP needs this!
	 */
	movb $0x0a, %al
	outb %al, $0x70
	movb $RTC_CLCK_32KHZ, %al
	outb %al, $0x71

	/*
	 * Set mode to BCD, 24h.
	 */
	movb $0x0b, %al
	outb %al, $0x70
	movb $RTC_24H, %al
	outb %al, $0x71

	/*
	 * Clear pending interrupts.
	 */
	movb $0x0c, %al
	outb %al, $0x70
	inb $0x71, %al

	/*
	 * Fix RTC century if not set properly.
	 */
	/* Read year. */
	movb $0x09, %al
	outb %al, $0x70
	inb $0x71, %al

	/* Compare with 0x80. */
	cmpb $0x80, %al
	jb 1f

	/* We assume 1980...1999. */
	/* Write 0x19 to century byte. */
	movb $0x32, %al
	outb %al, $0x70
	movb $0x19, %al
	outb %al, $0x71
	jmp 2f
1:
	/* We assume 2000...2079. */
	/* Write 0x20 to century byte. */
	movb $0x32, %al
	outb %al, $0x70
	movb $0x20, %al
	outb %al, $0x71
2:

	popw %ds
	lretw

#endif /* INIT_RM */
