/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SCXML_H_INCLUDED
#define __SCXML_H_INCLUDED

#include "xml.h"

#define MAX_NAME    64
#define MAX_DATA    96
#define MAX_STATES  64
#define MAX_ELEM    32
#define MAX_SUPER   128
#define MAX_BOOL    512
#define MAX_FLAG    128
#define MAX_PATH_LEN    32
#define MAX_ACTIVE	32
#define MAX_PATH	32
#define MAX_FUNCS	8
#define MAX_VAR		16

struct counter {
	int nif;
	int nelif;
	int ntrans;
};

struct scxml {
	struct scxml_datamodel *model_first;
	struct scxml_datamodel *model_last;
	struct scxml_state *state_first;
	struct scxml_state *state_last;
	struct scxml_function *func_first;
	struct scxml_function *func_last;

	const char* name;
	const char* initial;
	const char* type;
};

struct scxml_datamodel {
	struct scxml_datamodel *prev;
	struct scxml_datamodel *next;
	struct scxml_data *data_first;
	struct scxml_data *data_last;

	const char* name;
};

struct scxml_data {
	struct scxml_data *prev;
	struct scxml_data *next;

	const char *id;
	int expr;
	const char *flags;
	const char *bytes;
};

struct scxml_function {
	struct scxml_function *prev;
	struct scxml_function *next;

	struct scxml_datamodel *model_first;
	struct scxml_datamodel *model_last;

	const char* name;
};

struct scxml_extern {
	struct scxml_extern *prev;
	struct scxml_extern *next;
	const char* input;
	const char* output;
};

struct scxml_assign {
	struct scxml_assign *prev;
	struct scxml_assign *next;

	const char* location;
	const char* expr;
};

struct scxml_state {
	struct scxml_state *prev;
	struct scxml_state *next;

	struct scxml_trans *trans_first;
	struct scxml_trans *trans_last;
	struct scxml_assign *assign_first;
	struct scxml_assign *assign_last;
	struct scxml_if *if_first;
	struct scxml_if *if_last;
	struct scxml_extern *ex_first;
	struct scxml_extern *ex_last;
	struct scxml_onentry *onentry_first;
	struct scxml_onentry *onentry_last;
	struct scxml_onexit *onexit_first;
	struct scxml_onexit *onexit_last;

	const char *id;
};

struct scxml_onexit {
	struct scxml_onexit *prev;
	struct scxml_onexit *next;

	struct scxml_if *if_first;
	struct scxml_if *if_last;
	struct scxml_assign *assign_first;
	struct scxml_assign *assign_last;
	struct scxml_extern *ex_first;
	struct scxml_extern *ex_last;
};

struct scxml_onentry {
	struct scxml_onentry *prev;
	struct scxml_onentry *next;

	struct scxml_if *if_first;
	struct scxml_if *if_last;
	struct scxml_assign *assign_first;
	struct scxml_assign *assign_last;
	struct scxml_extern *ex_first;
	struct scxml_extern *ex_last;
};

struct scxml_trans {
	struct scxml_trans *prev;
	struct scxml_trans *next;

	const char* event;
	const char* cond;
	int count;
	const char* target;
};

struct scxml_if {
	struct scxml_if *prev;
	struct scxml_if *next;

	struct scxml_assign *assign_first;
	struct scxml_assign *assign_last;
	struct scxml_extern *ex_first;
	struct scxml_extern *ex_last;
	struct scxml_if *if_first;
	struct scxml_if *if_last;
	struct scxml_elif *elif_first;
	struct scxml_elif *elif_last;
	struct scxml_else *else_first;
	struct scxml_else *else_last;

	const char* cond;
	int count;
};

struct scxml_elif {
	struct scxml_elif *prev;
	struct scxml_elif *next;

	struct scxml_if *if_first;
	struct scxml_if *if_last;
	struct scxml_assign *assign_first;
	struct scxml_assign *assign_last;
	struct scxml_extern *ex_first;
	struct scxml_extern *ex_last;

	const char* cond;
	int count;
};

struct scxml_else {
	struct scxml_else *prev;
	struct scxml_else *next;

	struct scxml_assign *assign_first;
	struct scxml_assign *assign_last;
	struct scxml_if *if_first;
	struct scxml_if *if_last;
	struct scxml_extern *ex_first;
	struct scxml_extern *ex_last;
};

struct scxml* scxml_read(struct xml *);

void scxml_free(struct scxml *);

#endif /* __SCXML_H_INCLUDED */
