/*
 * Copyright (C) 2007-2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "zuse_trommel.h"

#define COMP_(x)	zuse_trommel_ ## x

#define DEBUG	0

struct cpssp {
	unsigned long long time;
	unsigned long takt;

	struct sig_std_logic *port_Uhr1;
	struct sig_std_logic *port_Uhr2;
	struct sig_std_logic *port_Imp1;
	struct sig_std_logic *port_Imp2;
};

static void
COMP_(step)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

#if DEBUG
	fprintf(stderr, "%s %d...\n", __FUNCTION__, cpssp->takt);
#endif
	/* FIXME */
	if (cpssp->takt == 0) {
		fprintf(stderr, "Trommel: %llu\n", time_real() - cpssp->time);
		cpssp->time = time_real();
	}

	if (cpssp->takt % 2 == 0) {
		/*
		 * Set Uhr1
		 */
		sig_std_logic_set(cpssp->port_Uhr1, cpssp, SIG_STD_LOGIC_1);
		sig_std_logic_set(cpssp->port_Uhr2, cpssp, SIG_STD_LOGIC_0);
	} else {
		/*
		 * Reset Uhr1
		 */
		sig_std_logic_set(cpssp->port_Uhr1, cpssp, SIG_STD_LOGIC_0);
		sig_std_logic_set(cpssp->port_Uhr2, cpssp, SIG_STD_LOGIC_1);
	}

	if (cpssp->takt == 2) {
		/*
		 * Set Einzelimpuls
		 */
		sig_std_logic_set(cpssp->port_Imp1, cpssp, SIG_STD_LOGIC_1);
		sig_std_logic_set(cpssp->port_Imp2, cpssp, SIG_STD_LOGIC_0);
	} else {
		/*
		 * Reset Einzelimpuls
		 */
		sig_std_logic_set(cpssp->port_Imp1, cpssp, SIG_STD_LOGIC_0);
		sig_std_logic_set(cpssp->port_Imp2, cpssp, SIG_STD_LOGIC_1);
	}

	cpssp->takt = (cpssp->takt + 1) % (32 * 2 * 46);
	// cpssp->takt = (cpssp->takt + 1) % (1 * 2 * 8);

	time_call_after(TIME_HZ / (100 * 32 * 2 * 46), COMP_(step), cpssp);
	// time_call_after(TIME_HZ / (100 * 32), COMP_(step), cpssp);
}

void *
COMP_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_Uhr1,
	struct sig_std_logic *port_Uhr2,
	struct sig_std_logic *port_Imp1,
	struct sig_std_logic *port_Imp2
)
{
	struct cpssp *cpssp;

	/* cpssp */
	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->takt = 0;

	/* outs */
	cpssp->port_Uhr1 = port_Uhr1;
	sig_std_logic_connect_out(port_Uhr1, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_Uhr2 = port_Uhr2;
	sig_std_logic_connect_out(port_Uhr2, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_Imp1 = port_Imp1;
	sig_std_logic_connect_out(port_Imp1, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_Imp2 = port_Imp2;
	sig_std_logic_connect_out(port_Imp2, cpssp, SIG_STD_LOGIC_Z);

	/* ins */

	time_call_after(1 * TIME_HZ, COMP_(step), cpssp);

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
COMP_(resume)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fp);
}
