@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
#
# ecaccess-file-copy: Copy an ECaccess File
#
# Laurent.Gougeon@ecmwf.int - 2010-10-15

use ECMWF::ECaccess;
use Getopt::Long;
use Pod::Usage;

my %opt = ( version => 0, erase => 0, help => 0, manual => 0, retry => 0, debug => 0 );

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if !GetOptions(
	\%opt,
	qw(
	  erase
	  version
	  help|?
	  manual
	  retry=i
	  debug
	  )
);

# Display version if requested
die ECMWF::ECaccess->VERSION . "\n" if ( $opt{version} );

my $sourceECaccessFile = $ARGV[0];
my $targetECaccessFile = $ARGV[1];

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if ( $opt{help} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 2 ) if ( $opt{manual} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "No source-ecaccess-file specified!\n" ) if not($sourceECaccessFile);
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "No target-ecaccess-file specified!\n" ) if not($targetECaccessFile);

# Create the ECaccess Controler
my $ecaccess = ECMWF::ECaccess->new( $opt{retry}, $opt{debug});

# Get the Token (using the Certificate in $HOME)
my $token = $ecaccess->getToken();

# Get the Control Channel
my $controlChannel = $ecaccess->getControlChannel();

# Copy the file
$controlChannel->copyFile( $token, $sourceECaccessFile, $targetECaccessFile, SOAP::Data->type( boolean => $opt{erase} ) );

# Logout
$ecaccess->releaseToken($token);

__END__

=head1 NAME

ecaccess-file-copy - Copy an ECaccess File

=head1 SYNOPSIS

B<ecaccess-file-copy -version|-help|-manual>

B<ecaccess-file-copy [-debug] [-erase]> I<source-ecaccess-file> I<target-ecaccess-file>

=head1 DESCRIPTION

Copy the I<source-ecaccess-file> to the I<target-ecaccess-file>.

The I<source-ecaccess-file> and I<target-ecaccess-file> are in the form [domain:][/user-id/]path. Please
read the "Shell commands -> File Management" section of the "ecaccess" guide for more information on the
ECaccess File System.

=head1 ARGUMENTS

=over 8

=item I<source-ecaccess-file>

The source ECaccess File name for the copy.

=item I<target-ecaccess-file>

the target ECaccess File name for the copy.

=back

=head1 OPTIONS

=over 8

=item B<-erase>

Delete the source file once the copy has completed successfully. By default the source file is not deleted.

=item B<-version>

Display version number and exits.

=item B<-help>

Print a brief help message and exits.

=item B<-manual>

Prints the manual page and exits.

=item B<-retry> I<count>

Number of SSL connection retries per 5s to ECMWF. This parameter only apply to the
initial SSL connection initiated by the command to the ECMWF server. It does not
apply to all the subsequent requests made afteward as it is mainly targeting errors
that can happen from time to time during the SSL handshake. Default is no retry.

=item B<-debug>

Display the SOAP and SSL messages exchanged.

=back

=head1 EXAMPLES

B<ecaccess-file-copy> I<ec:bin/a.out> I<c1a:/c1a/tmp/systems/xyz/a.out>

Copy the I<a.out> File in the ECFS bin directory of the authenticated user to the "/c1a/tmp/systems/xyz" directory on c1a.

=head1 SEE ALSO

B<ecaccess-file-delete>, B<ecaccess-file-get>, B<ecaccess-file-mget>, B<ecaccess-file-modtime>, B<ecaccess-file-mput>,
B<ecaccess-file-rmdir>, B<ecaccess-file-chmod>, B<ecaccess-file-dir>, B<ecaccess-file-mdelete>, B<ecaccess-file-mkdir>,
B<ecaccess-file-move>, B<ecaccess-file-put>, B<ecaccess-file-size> and B<ecaccess>.

=cut

__END__
:endofperl
