/*
 *   DIS/x : An implementation of the IEEE 1278.1 protocol
 *
 *   Copyright (C) 1996, Riley Rainey (rainey@netcom.com)
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of either:
 *
 *   a) the GNU Library General Public License as published by the Free
 *   Software Foundation; either version 2 of the License, or (at your
 *   option) any later version.  A description of the terms and conditions
 *   of the GLPL may be found in the "COPYING.LIB" file.
 *
 *   b) the "Artistic License" which comes with this Kit.  Information
 *   about this license may be found in the "Artistic" file.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License or the Artistic License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Information describing how to contact the author can be found in the
 *   README file.
 */
#include <dis/dis.h>
#include <dis/simx.h>
#include <stdio.h>

main ()
{
	dis_simulation_addr	my_addr;
	dis_entity_type		type;
	int	code;
	char	site[64];
	char	name[256];
	char	*names[7];
	int	i;

	code = SIMxRegisterApplication ((char *) NULL,
		SIMxGetSiteName(site, sizeof(site)),
		0, &my_addr);
	if (code != 0) {
		fprintf (stderr, "Error: %d\n", code);
		exit (1);
	}
	printf ("address: %04x.%04x\n", my_addr.site_id,
		my_addr.application_id);

	type.kind = 1;
	type.domain = 2;
	type.country = 225;
	type.category = 2;
	type.subcategory = 6;
	type.specific = 2;
	type.extra = 0;

	code = SIMxLookupEntityName (&type, name, sizeof(name));
	printf ("\nShould be an EA6-B : \"%s\" code = %d\n", name, code);

	for (i=0; i<7; ++i) {
		names[i] = malloc(256);
	}
	code = SIMxLookupEntityNames (&type, names, 256);
	printf ("\nShould be an EA6-B : code = %d\n", code);
	for (i=0; i<7; ++i) {
		printf ("\"%s\"\n", names[i]);
	}
	exit (0);

}
