#ifndef UOS_RECOVERY_CHECK_TASK_H
#define UOS_RECOVERY_CHECK_TASK_H

#include "AsyncTask.h"
#include "global.h"

class CheckTask : public AsyncTask {
    Q_OBJECT
public:
    CheckTask();
    explicit CheckTask(OperateType opType, RecoveryType recoveryType);
    virtual ~CheckTask();

    virtual bool buildArgumentsForBackup() override;
    virtual bool buildArgumentsForRestore(const QString &) override;
    virtual void doResult() override;

    void setRootUUID(const QString &rootUUID);
    void setDestUUID(const QString &destUUID);
    void setDestPath(const QString &destPath);

Q_SIGNALS:
    void spaceCheckFinished(const QJsonObject &space);

private:
    void checkFullSystemBackupSpace();
    void checkIncSystemBackupSpace();
    void checkGhostBackupSpace();
    void checkDimFileUseSpace();

    bool getSystemBackupDirSizeBytes(const QString &rootUUID, const QString &backupDeviceUUID,
                                     const QString &dirPath, const QStringList &excludeDir,
                                     quint64 &totalBytes, QString &errMsg);
    void reportSpace(ErrorCode errCode, quint64 backupSizeBytes, int liveFlag, const QString &errMsg);
    qint64 getUsedSpace(const QStringList &bindPaths);
    quint64 getTotalFileSize(const QStringList &list);
    quint64 getDimFileTotalSize(const QString &dimFilePath);

private:
    OperateType m_opType = OperateType::Invalid;
    RecoveryType m_recoveryType = RecoveryType::InvalidRecoveryType;
    QString m_rootUUID = "";
    QString m_destUUID = "";
    QString m_destPath = "";
};

#endif
