#pragma once
#include "UImgRecovery.h"

class QTimer;
class RsyncTask;
class SquashfsTask;
class CheckTask;

class GhostUImg : public UImgRecovery
{
    Q_OBJECT

public:
    GhostUImg();
    ~GhostUImg();

    // Ghost备份空间校验
    ErrorCode CheckGhostBackupDiskSpace(const QString &selectDir) override;

    //制作uimg
    ErrorCode createUImg(const QString &backupDir, const qint64 totalSize) override;

#ifdef QT_DEBUG
    // 这里都是单元测试函数
    QStringList getRsyncSystemBackupFiltersTest();
#endif

private:
    void makeImgFile();
    int updateTimeRemain(int progress);
    bool doSystemUpgradeConfig();
    void unDoSystemUpgradeConfig();
    bool writeGhostDeviceInfo(const QString &filePath);
    qint64 getUsedDeviceSize(const QString &fstabPath);
    QJsonArray getFstabInfos(const QString &fstabPath);
    bool getRootDev(QString &rootDev);
    QJsonObject getSystemUpgradeInfo();
    void backUpConfFiles();
    void replaceRootUuidContent(const QString &srcFilePath, const QString &destFilePath, const QJsonArray &devInfos);
    QStringList getRsyncSystemBackupFilters();
    void clearUuidInRecoveryConf(const QString &recoveryConf);

private slots:
    void subTimeSlot();

private:
    RsyncTask *m_rsyncTask = nullptr;
    SquashfsTask *m_squashfsTask = nullptr;
    CheckTask *m_checkTask = nullptr;
    QTimer *m_subTimer = nullptr;
    QString m_destDir = "";
    QString m_startTime = "";
    int m_totalTimeNeed = 0;
    int m_timeUsed = 0;
    int m_timeIndex = 0;
    bool m_doSystemUpgradeConfig = false;
};
