//
// Created by uos on 2022/3/16.
//

#ifndef UOS_RECOVERY_BACKUPWIDGET_H
#define UOS_RECOVERY_BACKUPWIDGET_H

#include "common/ProgressWidget.h"
#include "common/ItemFrame.h"
#include "common/SelectPartitionDialog.h"
#include "common/HelpDialog.h"
#include <DGuiApplicationHelper>
#include <DWidget>
#include <QStandardItemModel>
#include <DListView>


DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE


class BackupWidget : public DWidget
{
    Q_OBJECT
public:
    explicit BackupWidget(DWidget *parent = nullptr);
    void initUI();
Q_SIGNALS:
    void notifySystemBackup();
    void notifyDataBackup();
    void enter();
    void leave();

protected:
    bool eventFilter(QObject* watched, QEvent* event);

private Q_SLOTS:
    void onThemeChange(Dtk::Gui::DGuiApplicationHelper::ColorType themeType);
    void onItemChanged(bool checked);

private:
    int getBackupUiLayoutType();
    void uiHorizontalLayout();
    void uiVerticalLayout();
    void initHelpLayout();

private:
    QStringList m_iconList;
    DListView *m_backupView = nullptr;
    QStandardItemModel *m_model = nullptr;
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
    ProgressWidget *m_progressWidget = nullptr;
    DLabel *m_title = nullptr;
    DPushButton *m_nextBtn = nullptr;
    QLabel *m_helpLabel = nullptr;
    HelpDialog* m_helpDialog = nullptr;
    bool m_bDirectionRTL = false;
};


#endif //UOS_RECOVERY_BACKUPWIDGET_H
