#ifndef WORDWIZARD_H
#define WORDWIZARD_H
#include "uosai_global.h"
#include "private/disableappwidget.h"

#include <QVariant>
#include <QPoint>
#include <QRect>
#include <QTimer>
#include <QStringList>

namespace uos_ai {

class BaseClipboard;
class BaseMonitor;
class WizardWrapper;
class AiWriterDialog;
class WordWizard : public QObject
{
    Q_OBJECT
public:
    explicit WordWizard(QObject *parent = nullptr);
    void initWordWizard();
    void initConnect();
    bool queryHiddenStatus();
    ~WordWizard();

    static bool launchUosBrowser(QString url);
    static bool launchDefaultBrowser(QString url);
    static bool onSearchBtnClicked(const QString &text);
    static void onInsertBtnClicked(QString text) {}
    static void onReplaceBtnClicked(QString text) {}
    static bool fcitxWritable() { return kIsFcitxWritable; }

public:
    enum WizardType {
        WIZARD_TYPE_SEARCH = 0, // 搜索
        WIZARD_TYPE_EXPLAIN, // 解释
        WIZARD_TYPE_SUMMARIZE, // 总结
        WIZARD_TYPE_TRANSLATE, // 翻译
        WIZARD_TYPE_RENEW, // 续写
        WIZARD_TYPE_EXTEND, // 扩写
        WIZARD_TYPE_CORRECT, // 纠错
        WIZARD_TYPE_HIDDEN, //隐藏
        WIZARD_TYPE_POLISH0 = 10, // 润色-正式专业
        WIZARD_TYPE_POLISH1, // 润色-亲切友善
        WIZARD_TYPE_POLISH2, // 润色-幽默风趣
        WIZARD_TYPE_POLISH3 // 润色-激昂鼓舞
    };

signals:
    /**
     * @brief 显示快捷面板
     * @param type 处理类别
     * @param query 文本
     * @param pos 显示位置
     */
    void sigToLaunchAiQuick(int type, QString query, QPoint pos);
    void signalHiddenwidget(bool isHidden);
    void signalAddDisabledApp(const QString &appName);

public slots:
    void onGlobalMousePress(int x, int y);
    void onGlobalMouseRelease(int x, int y);
    void onKeyEscapePress();
    void onShowScribeWord();
    void onShortcutPressed();
    void onShortcutTranslate();
    void onMoreMenuTriggered(int wizardtype, const QPoint &cursorPos);
    void onWizardBtnClicked(int wizardtype, const QPoint &cursorPos);
    void onSaveClipText();
    void onCloseBtnClicked();
    void onChangeXEventMonitorStatus(bool isopen);
    void onHiddenwidget(bool ishide) { m_isHidden = ishide; }
    void onChangeHiddenStatus(bool isHidden);
    void onFocusIn() { kIsFcitxWritable = true; }
    void onFocusOut() { kIsFcitxWritable = false; }
    void onDisableInApp();
    void updateDisabledApps(const QStringList &appList);

    static void onIconBtnClicked(QString text = "");

private:
    void onHiddenActionTriggered();
    void getScreenRect();
    void adjustMulScreenPos(QPoint &pos);
    bool isAppDisabled(const QString &appName);

    static volatile bool kIsFcitxWritable;

    double m_scaleFactor; // 屏幕缩放比
    int m_mouseClickX;
    int m_mouseClickY;
    int m_mouseReleaseX;
    int m_mouseReleaseY;
    bool m_isMousePress = false;
    bool m_isMouseRelease = false;

    bool m_stopShow = false;//close x11 event monitor
    bool m_isClose = false;//close btn, one time
    bool m_isHidden = false;//hidden action
    bool m_isShortcut = false;

    QPoint m_Point;
    QString m_clipText = "";

    BaseClipboard *m_selectclip = nullptr;
    WizardWrapper *m_selectwid = nullptr;
    AiWriterDialog *m_writerwid = nullptr;
    QThread *m_eventMonitor = nullptr;

    QPoint m_cursorPos;
    QRect m_screenRect;

    QTimer *m_timer = nullptr;

    QString m_curApp;
    QStringList m_disabledApps; // 存储禁用的应用列表
};
}
#endif // WORDWIZARD_H
