#include "wordwizardwidget.h"
#include "themedlable.h"
#include "wordwizarditem.h"
#include "disableappwidget.h"
#include "util.h"

#include <QVBoxLayout>
#include <QHBoxLayout>

#include <DLabel>
#include <DFontSizeManager>
#include <DBackgroundGroup>
#include <DGuiApplicationHelper>

DWIDGET_USE_NAMESPACE
using namespace uos_ai;

WordWizardWidget::WordWizardWidget(DWidget *parent)
    : DWidget(parent)
{
    initUI();
    onThemeTypeChanged();
    connect(DGuiApplicationHelper::instance(), &DGuiApplicationHelper::themeTypeChanged, this, &WordWizardWidget::onThemeTypeChanged);
}

void WordWizardWidget::initUI()
{
    QVBoxLayout *layout = new QVBoxLayout(this);
    layout->setContentsMargins(20, 0, 0, 0);
    layout->setSpacing(10);

    m_pWidgetLabel = new ThemedLable(tr("UOS AI FollowAlong"));
    m_pWidgetLabel->setPaletteColor(QPalette::Text, DPalette::TextTitle);
    DFontSizeManager::instance()->bind(m_pWidgetLabel, DFontSizeManager::T5, QFont::Bold);

    layout->addWidget(m_pWidgetLabel, 0, Qt::AlignLeft);
    layout->addWidget(wordWizardWidget(), 0, Qt::AlignLeft);
    layout->addWidget(disableAppWidget());
    layout->addStretch();

    if (m_pDisableWidget && m_pDisableWidget->isEmpty()) {
        m_pDisableAppWidget->setVisible(false);
    }

    setLayout(layout);
}

void WordWizardWidget::onThemeTypeChanged()
{
    DPalette pl = m_pWordWizardWidget->palette();
    pl.setBrush(DPalette::Base, DGuiApplicationHelper::instance()->applicationPalette().color(DPalette::ItemBackground));
    m_pWordWizardWidget->setPalette(pl);

    changeDisplayImage();
}

DBackgroundGroup *WordWizardWidget::wordWizardWidget()
{
    m_imageLabel = new DLabel;
    changeDisplayImage();
    m_imageLabel->setContentsMargins(0, 0, 0, 0);
    m_imageLabel->setAlignment(Qt::AlignCenter);
    m_imageLabel->setFixedSize(560, 116);

    m_WordWizardItem = new WordWizardItem(this);
    m_WordWizardItem->setText(tr("Automatically display the UOS AI FollowAlong toolbar when text is selected."), tr("After closing, the selected text can still be woken up by the shortcut Super+Space bar."));
    m_WordWizardItem->setMinimumHeight(60);
    m_WordWizardItem->setMaximumHeight(75);
    m_WordWizardItem->setSwitchChecked(true);
    connect(m_WordWizardItem, &WordWizardItem::signalSwitchChanged, this, &WordWizardWidget::signalChangeHiddenStatus);

    DWidget *widget = new DWidget(this);
    auto *bgLayout = new QVBoxLayout(widget);
    bgLayout->setContentsMargins(0, 0, 0, 0);
    bgLayout->addWidget(m_imageLabel, 0, Qt::AlignCenter);
    bgLayout->addWidget(m_WordWizardItem);

    m_pWordWizardWidget = new DBackgroundGroup(bgLayout, this);
    m_pWordWizardWidget->setItemSpacing(1);
    m_pWordWizardWidget->setContentsMargins(0, 0, 0, 0);
    m_pWordWizardWidget->setFixedWidth(560);

    return m_pWordWizardWidget;
}

DBackgroundGroup *WordWizardWidget::disableAppWidget()
{
    DWidget *widget = new DWidget(this);
    auto *bgLayout = new QVBoxLayout(widget);
    bgLayout->setContentsMargins(0, 0, 0, 0);

    m_pDisableWidget = new DisableAppWidget(widget);
    m_pDisableWidget->setFixedWidth(568);
    bgLayout->addWidget(m_pDisableWidget);

    connect(m_pDisableWidget, &DisableAppWidget::becameEmpty, this, &WordWizardWidget::onDisableWidgetEmpty);
    connect(m_pDisableWidget, &DisableAppWidget::appAdded, this, &WordWizardWidget::onDisableAppAdded);
    connect(m_pDisableWidget, &DisableAppWidget::requestDisabledAppsUpdate,
            this, &WordWizardWidget::disabledAppsUpdateRequested);

    m_pDisableAppWidget = new DBackgroundGroup(bgLayout, this);
    m_pDisableAppWidget->setContentsMargins(0, 0, 0, 0);
    m_pDisableAppWidget->setFixedWidth(576);

    return m_pDisableAppWidget;
}

QString WordWizardWidget::getTitleName()
{
    return m_pWidgetLabel->text();
}

void WordWizardWidget::updateHiddenStatus(bool isHidden)
{
    m_WordWizardItem->setSwitchChecked(isHidden);
}

void WordWizardWidget::onDisableWidgetEmpty()
{
    if (m_pDisableAppWidget) {
        if (m_WordWizardItem) {
            m_WordWizardItem->setFocus();
        } else {
            this->setFocus();
        }

        m_pDisableAppWidget->setVisible(false);
    }
}

void WordWizardWidget::onDisableAppAdded(const QString &appName)
{
    if (m_pDisableAppWidget && !m_pDisableAppWidget->isVisible()) {
        m_pDisableAppWidget->setVisible(true);
    }
    emit disabledAppAdded(appName);
}

void WordWizardWidget::changeDisplayImage()
{
    QString iconName = QString(":/icons/deepin/builtin/%1/icons/");
    if (Util::checkLanguage())
        iconName += "display.png";
    else
        iconName += "display_en.png";

    if (DGuiApplicationHelper::instance()->themeType() == DGuiApplicationHelper::LightType)
        iconName = iconName.arg("light");
    else
        iconName = iconName.arg("dark");
    m_imageLabel->setPixmap(QIcon(iconName).pixmap(450, 88));
}
