/*
 * Conditionally compiled error and logging routines for ALPS
 *
 * Copyright (c) 2009-2011 Centro Svizzero di Calcolo Scientifico (CSCS)
 * Licensed under the GPLv2.
 */
#ifndef __BASIL_LOG_H
#define __BASIL_LOG_H
#include <stdarg.h>
#include <err.h>

static int  error(const char *fmt, ...)
		__attribute__((format(printf, 1, 2)));
static void fatal(const char *fmt, ...)
		__attribute__((format(printf, 1, 2)));

/* Warn about non-serious error */
static inline int error(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vwarnx(fmt, ap);
	va_end(ap);
	return -1;
}

/* Abort on fatal error */
static inline void fatal(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	verrx(1, fmt, ap);
	va_end(ap);
}
#endif /* __BASIL_LOG_H */
