# 元文档

> 用于描述如何读写文档。

## operator描述

### 类型

系统所有数据类型都是 `Tensor`，表示任意大小和类型的数据。
类型描述可以分为三个部分 `[Type][Shape]` 在 `Shape` 为 `1` 时可以省略。

`Type` 可以描述为 `类型+宽度` 的形式，如 `Char8` 表示8个bit宽度的 `Char`。

其中类型有默认宽度大小，默认宽度可以省略书写，已经明确的数据默认宽度为：

| 类型 | 默认宽度 |
| ---- | ------ |
| `Char`  |  8 |
| `Int`   | 32 |
| `Float` | 32 |

`Shape` 可以描述为以中括号括起来的 `[x1, x2, ...]` 的形式。
方括号中元素个数表示了张量的阶数。每个数字表示对应的维度。对于不确定的维度大小。
采用非数字 `_` ，或者其他命名变量。

例如：`Int[_, _, _]`表示三阶张量；
`Int[height, widht, 3]`也表示三阶张量，并对前两个维度大小进行了命名。

对于既需要命名，又需要声明大小的情况，采用在命名后使用小括号写出即可。
例如：`Int8[height(300), width(300), 3]`。

**更新**，为了统一命名方式，该声明可以写成`Int8[height:300, width:300, 3]`

对于阶数也不确定大小的 `Shape` 采用 `[...]` 表示。

对于特定阶数的张量可以采用命名表示，如下：

| 命名 | 表示 |
| ---- | ------ |
| `Tensor`  |  `[...]` |
| `Tensor4D`  |  `[_, _, _, _]` |
| `Tensor3D`  |  `[_, _, _]` |
| `Tensor2D`  |  `[_, _]` |
| `Tensor1D`  |  `[_]` |
| `Matrix`   | `[_, _]` |
| `Array` | `[_]` |
| `Scalar` | `[]` |

对于类型不确定的情况，当Shape采用命名表示时，类型声明可以省略。
否则只能采用 `Tensor` + 对应的`Shape`声明。
例如：`Tensor[4, 2]`表示，不确定类型的，大小为`4x2`的矩阵。

对于 `Scalar` 类型，可以直接使用类型声明表示：
例如：`Int` 等价于 `IntScalar`。

对于不确定类型，也不确定大小的情况，可以采用命名表示：
例如：`Matrix` 等价于 `Tensor[_, _]`；
`Matirx[rows, cols]` 等价于 `Tensor[rows, cols]`

特殊地，`String` 等价于 `CharArray`。

### 字面数值

对于特殊场合采用花括号括起来表示字面值：形如：
`{1， 2， 3， 4}`，其含义就是一个`IntArray`并声明了每个变量的值。
例如：  
`{{0, 0}, {0, 0}, {$h, $h}, {$w, $w}}` 是一个 `Int[4, 2]`类型的矩阵。

在不引起歧义的情况下，单独出现的花括号`{}`可以采用`[]`代替。

### 定义与反射

定义一个参数变量可以在单行内用冒号`:`隔开表示。形如:  
`padding`: `Int[4, 2]`，就是声明了具有固定类型和大小的变量。
之后的上下文中可以用`$padding`表示这个变量。
`$padding(0, 0)` 表示第`(0, 0)`的元素。
`$padding.shape` 表示张量的阶数和维度。是`IntArray`类型。
对于声明：
`padding`: `Int[height, weight]`，
可以采用`$padding.height`等价于`$padding.shape(0)`。
其中`.shape(0)`可以简写为`.size`。

特殊地，除了`Tensor`在声明的时候定义的命名，会包含隐式命名如下：
> 1. type: 表示张量元素的类型
> 1. shape: 表示形状的数组
> 2. size: 如果`Tensor`的维度是`1`的话，表示数组的长度，否则为张量的第一个维度大小；等价于`shape(0)`
> 3. dims: 表示张量的维度；等价于`shape.size`


### 存储

存储设备分为 `device` 和 `host` 两种。
`device` 是指计算时的存储设备，`host` 指的是 `CPU` 的内存存储。

在变量声明在不引起歧义的前提下，可以再变量后采用`..` 区分的方式声明。
形如`stride..device`表示对应的数据存储在设备上。

存储声明是建议，并不是绝对的结果。

### 默认值

采用`Default` 或者 `default` 关键字声明。

例如：
`stride..host`: `Int[4]` `default` `[1, 1, 1, 1]` 表示，`stride`存储在`host`，
是一个四维的整数数组，默认值为`{1, 1, 1, 1}`。

### 枚举

枚举类型是特殊的`IntScalar`，声明形如：
`e`: `Enum[a=0, b=1]`，表示枚举类型可以取值0或者1。
对应的枚举值可以通过反射`$e.a`代替。对应的阈值也可以直接书写枚举名。
例如声明可以改写为：
`e`: `Enum[a=0, b=1]` `default` `a` 表示`e`的默认值为`a`