; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -mattr=+2e3 | FileCheck %s

;EQ
define i32 @brRR_eq(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bt32 .LBB0_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB0_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_eq(i32 %x) {
; CHECK-LABEL: brRI_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    bt32 .LBB1_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB1_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_eq(i32 %x) {
; CHECK-LABEL: brR0_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bez32 a0, .LBB2_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB2_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;NE
define i32 @brRR_ne(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bf32 .LBB3_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB3_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ne(i32 %x) {
; CHECK-LABEL: brRI_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    bf32 .LBB4_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB4_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ne(i32 %x) {
; CHECK-LABEL: brR0_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bez32 a0, .LBB5_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB5_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;UGT
define i32 @brRR_ugt(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bt32 .LBB6_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB6_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ugt(i32 %x) {
; CHECK-LABEL: brRI_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    bf32 .LBB7_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB7_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ugt(i32 %x) {
; CHECK-LABEL: brR0_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bez32 a0, .LBB8_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB8_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;UGE
define i32 @brRR_uge(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB9_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB9_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_uge(i32 %x) {
; CHECK-LABEL: brRI_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    bf32 .LBB10_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB10_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;ULT
define i32 @brRR_ult(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bt32 .LBB11_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB11_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ult(i32 %x) {
; CHECK-LABEL: brRI_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB12_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB12_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}


;ULE
define i32 @brRR_ule(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bf32 .LBB13_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB13_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ule(i32 %x) {
; CHECK-LABEL: brRI_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB14_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB14_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ule(i32 %x) {
; CHECK-LABEL: brR0_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bnez32 a0, .LBB15_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB15_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SGT
define i32 @brRR_sgt(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bf32 .LBB16_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB16_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_sgt(i32 %x) {
; CHECK-LABEL: brRI_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplti16 a0, 11
; CHECK-NEXT:    bt32 .LBB17_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB17_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_sgt(i32 %x) {
; CHECK-LABEL: brR0_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplti16 a0, 1
; CHECK-NEXT:    bt32 .LBB18_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB18_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SGE
define i32 @brRR_sge(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB19_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB19_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_sge(i32 %x) {
; CHECK-LABEL: brRI_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplti16 a0, 10
; CHECK-NEXT:    bt32 .LBB20_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB20_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_sge(i32 %x) {
; CHECK-LABEL: brR0_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    blz32 a0, .LBB21_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB21_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SLT
define i32 @brRR_slt(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB22_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB22_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_slt(i32 %x) {
; CHECK-LABEL: brRI_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB23_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB23_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_slt(i32 %x) {
; CHECK-LABEL: brR0_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 65535
; CHECK-NEXT:    ori32 a1, a1, 65535
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB24_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB24_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SLE
define i32 @brRR_sle(i32 %x, i32 %y) {
; CHECK-LABEL: brRR_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bt32 .LBB25_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB25_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i32 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_sle(i32 %x) {
; CHECK-LABEL: brRI_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB26_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB26_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i32 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_sle(i32 %x) {
; CHECK-LABEL: brR0_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bhz32 a0, .LBB27_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB27_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i32 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}


define i32 @brCBit(i1 %c) {
; CHECK-LABEL: brCBit:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB28_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB28_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  br i1 %c, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}


;EQ
define i64 @brRR_i64_eq(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a1, a3
; CHECK-NEXT:    xor16 a0, a2
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bnez32 a0, .LBB29_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB29_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_eq(i64 %x) {
; CHECK-LABEL: brR0_i64_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 10
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bnez32 a0, .LBB30_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB30_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_eq(i64 %x) {
; CHECK-LABEL: brRI_i64_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bez32 a0, .LBB31_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB31_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;NE
define i64 @brRR_i64_ne(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a1, a3
; CHECK-NEXT:    xor16 a0, a2
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bez32 a0, .LBB32_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB32_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_ne(i64 %x) {
; CHECK-LABEL: brRI_i64_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 10
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bez32 a0, .LBB33_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB33_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_ne(i64 %x) {
; CHECK-LABEL: brR0_i64_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bez32 a0, .LBB34_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB34_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;UGT
define i64 @brRR_i64_ugt(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    cmphs16 a1, a3
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 12)
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a1, (sp, 12)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB35_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB35_3
; CHECK-NEXT:  .LBB35_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB35_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 16
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_ugt(i64 %x) {
; CHECK-LABEL: brRI_i64_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB36_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB36_3
; CHECK-NEXT:  .LBB36_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB36_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_ugt(i64 %x) {
; CHECK-LABEL: brR0_i64_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bez32 a0, .LBB37_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB37_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;UGE
define i64 @brRR_i64_uge(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmphs16 a3, a1
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB38_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB38_3
; CHECK-NEXT:  .LBB38_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB38_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_uge(i64 %x) {
; CHECK-LABEL: brRI_i64_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB39_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB39_3
; CHECK-NEXT:  .LBB39_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB39_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;ULT
define i64 @brRR_i64_ult(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    cmphs16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 12)
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a1, (sp, 12)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB40_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB40_3
; CHECK-NEXT:  .LBB40_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB40_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 16
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_ult(i64 %x) {
; CHECK-LABEL: brRI_i64_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a2, 9
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB41_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB41_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}


;ULE
define i64 @brRR_i64_ule(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmphs16 a1, a3
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB42_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB42_3
; CHECK-NEXT:  .LBB42_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB42_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_ule(i64 %x) {
; CHECK-LABEL: brRI_i64_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a2, 10
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB43_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB43_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_ule(i64 %x) {
; CHECK-LABEL: brR0_i64_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    bnez32 a0, .LBB44_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB44_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;SGT
define i64 @brRR_i64_sgt(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    cmplt16 a1, a3
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB45_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB45_3
; CHECK-NEXT:  .LBB45_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB45_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_sgt(i64 %x) {
; CHECK-LABEL: brRI_i64_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a1, a2
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB46_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB46_3
; CHECK-NEXT:  .LBB46_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB46_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_sgt(i64 %x) {
; CHECK-LABEL: brR0_i64_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a1, a2
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB47_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB47_3
; CHECK-NEXT:  .LBB47_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB47_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;SGE
define i64 @brRR_i64_sge(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmplt16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB48_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB48_3
; CHECK-NEXT:  .LBB48_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB48_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_sge(i64 %x) {
; CHECK-LABEL: brRI_i64_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a1, a2
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB49_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB49_3
; CHECK-NEXT:  .LBB49_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB49_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_sge(i64 %x) {
; CHECK-LABEL: brR0_i64_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    blz32 a1, .LBB50_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB50_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;SLT
define i64 @brRR_i64_slt(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    cmplt16 a3, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB51_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB51_3
; CHECK-NEXT:  .LBB51_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB51_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_slt(i64 %x) {
; CHECK-LABEL: brRI_i64_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a2, a1
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 8)
; CHECK-NEXT:    movi16 a2, 9
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB52_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB52_3
; CHECK-NEXT:  .LBB52_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB52_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_slt(i64 %x) {
; CHECK-LABEL: brR0_i64_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a0, 65535
; CHECK-NEXT:    ori32 a0, a0, 65535
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bf32 .LBB53_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB53_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

;SLE
define i64 @brRR_i64_sle(i64 %x, i64 %y) {
; CHECK-LABEL: brRR_i64_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmplt16 a1, a3
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB54_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB54_3
; CHECK-NEXT:  .LBB54_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB54_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i64 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brRI_i64_sle(i64 %x) {
; CHECK-LABEL: brRI_i64_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a2, a1
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 8)
; CHECK-NEXT:    movi16 a2, 10
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    ld16.w a1, (sp, 8)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB55_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB55_3
; CHECK-NEXT:  .LBB55_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB55_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i64 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}

define i64 @brR0_i64_sle(i64 %x) {
; CHECK-LABEL: brR0_i64_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a2, a1
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 12)
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a1, (sp, 12)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    bt32 .LBB56_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    br32 .LBB56_3
; CHECK-NEXT:  .LBB56_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:  .LBB56_3: # %label1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    addi16 sp, sp, 16
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i64 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}


define i64 @brCBit_i64(i1 %c) {
; CHECK-LABEL: brCBit_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB57_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB57_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
entry:
  br i1 %c, label %label1, label %label2
label1:
  ret i64 1
label2:
  ret i64 0
}


;EQ
define i16 @brRR_i16_eq(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bt32 .LBB58_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB58_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_eq(i16 %x) {
; CHECK-LABEL: brRI_i16_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    bt32 .LBB59_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB59_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_eq(i16 %x) {
; CHECK-LABEL: brR0_i16_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    bez32 a0, .LBB60_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB60_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;NE
define i16 @brRR_i16_ne(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bf32 .LBB61_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB61_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_ne(i16 %x) {
; CHECK-LABEL: brRI_i16_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    bf32 .LBB62_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB62_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_ne(i16 %x) {
; CHECK-LABEL: brR0_i16_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    bez32 a0, .LBB63_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB63_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;UGT
define i16 @brRR_i16_ugt(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bt32 .LBB64_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB64_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_ugt(i16 %x) {
; CHECK-LABEL: brRI_i16_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    bf32 .LBB65_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB65_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_ugt(i16 %x) {
; CHECK-LABEL: brR0_i16_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    bez32 a0, .LBB66_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB66_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;UGE
define i16 @brRR_i16_uge(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB67_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB67_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_uge(i16 %x) {
; CHECK-LABEL: brRI_i16_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    bf32 .LBB68_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB68_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;ULT
define i16 @brRR_i16_ult(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bt32 .LBB69_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB69_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_ult(i16 %x) {
; CHECK-LABEL: brRI_i16_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB70_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB70_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}


;ULE
define i16 @brRR_i16_ule(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bf32 .LBB71_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB71_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_ule(i16 %x) {
; CHECK-LABEL: brRI_i16_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB72_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB72_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_ule(i16 %x) {
; CHECK-LABEL: brR0_i16_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    bnez32 a0, .LBB73_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB73_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;SGT
define i16 @brRR_i16_sgt(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bf32 .LBB74_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB74_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_sgt(i16 %x) {
; CHECK-LABEL: brRI_i16_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 11
; CHECK-NEXT:    bt32 .LBB75_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB75_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_sgt(i16 %x) {
; CHECK-LABEL: brR0_i16_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 1
; CHECK-NEXT:    bt32 .LBB76_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB76_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;SGE
define i16 @brRR_i16_sge(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB77_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB77_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_sge(i16 %x) {
; CHECK-LABEL: brRI_i16_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 10
; CHECK-NEXT:    bt32 .LBB78_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB78_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_sge(i16 %x) {
; CHECK-LABEL: brR0_i16_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    blz32 a0, .LBB79_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB79_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;SLT
define i16 @brRR_i16_slt(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB80_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB80_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_slt(i16 %x) {
; CHECK-LABEL: brRI_i16_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB81_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB81_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_slt(i16 %x) {
; CHECK-LABEL: brR0_i16_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movih32 a1, 65535
; CHECK-NEXT:    ori32 a1, a1, 65535
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB82_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB82_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

;SLE
define i16 @brRR_i16_sle(i16 %x, i16 %y) {
; CHECK-LABEL: brRR_i16_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bt32 .LBB83_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB83_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i16 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brRI_i16_sle(i16 %x) {
; CHECK-LABEL: brRI_i16_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB84_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB84_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i16 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}

define i16 @brR0_i16_sle(i16 %x) {
; CHECK-LABEL: brR0_i16_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    bhz32 a0, .LBB85_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB85_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i16 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}


define i16 @brCBit_i16(i1 %c) {
; CHECK-LABEL: brCBit_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB86_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB86_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  br i1 %c, label %label1, label %label2
label1:
  ret i16 1
label2:
  ret i16 0
}


;EQ
define i8 @brRR_i8_eq(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bt32 .LBB87_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB87_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_eq(i8 %x) {
; CHECK-LABEL: brRI_i8_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    bt32 .LBB88_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB88_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_eq(i8 %x) {
; CHECK-LABEL: brR0_i8_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    bez32 a0, .LBB89_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB89_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;NE
define i8 @brRR_i8_ne(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bf32 .LBB90_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB90_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_ne(i8 %x) {
; CHECK-LABEL: brRI_i8_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    bf32 .LBB91_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB91_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_ne(i8 %x) {
; CHECK-LABEL: brR0_i8_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    bez32 a0, .LBB92_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB92_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;UGT
define i8 @brRR_i8_ugt(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bt32 .LBB93_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB93_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_ugt(i8 %x) {
; CHECK-LABEL: brRI_i8_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    bf32 .LBB94_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB94_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_ugt(i8 %x) {
; CHECK-LABEL: brR0_i8_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    bez32 a0, .LBB95_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB95_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;UGE
define i8 @brRR_i8_uge(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB96_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB96_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_uge(i8 %x) {
; CHECK-LABEL: brRI_i8_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    bf32 .LBB97_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB97_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;ULT
define i8 @brRR_i8_ult(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bt32 .LBB98_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB98_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_ult(i8 %x) {
; CHECK-LABEL: brRI_i8_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB99_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB99_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}


;ULE
define i8 @brRR_i8_ule(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bf32 .LBB100_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB100_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_ule(i8 %x) {
; CHECK-LABEL: brRI_i8_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB101_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB101_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_ule(i8 %x) {
; CHECK-LABEL: brR0_i8_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    bnez32 a0, .LBB102_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB102_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;SGT
define i8 @brRR_i8_sgt(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bf32 .LBB103_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB103_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_sgt(i8 %x) {
; CHECK-LABEL: brRI_i8_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 11
; CHECK-NEXT:    bt32 .LBB104_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB104_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_sgt(i8 %x) {
; CHECK-LABEL: brR0_i8_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 1
; CHECK-NEXT:    bt32 .LBB105_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB105_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;SGE
define i8 @brRR_i8_sge(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB106_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB106_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_sge(i8 %x) {
; CHECK-LABEL: brRI_i8_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 10
; CHECK-NEXT:    bt32 .LBB107_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB107_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_sge(i8 %x) {
; CHECK-LABEL: brR0_i8_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    blz32 a0, .LBB108_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB108_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;SLT
define i8 @brRR_i8_slt(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB109_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB109_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_slt(i8 %x) {
; CHECK-LABEL: brRI_i8_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB110_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB110_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_slt(i8 %x) {
; CHECK-LABEL: brR0_i8_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movih32 a1, 65535
; CHECK-NEXT:    ori32 a1, a1, 65535
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB111_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB111_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

;SLE
define i8 @brRR_i8_sle(i8 %x, i8 %y) {
; CHECK-LABEL: brRR_i8_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bt32 .LBB112_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB112_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i8 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brRI_i8_sle(i8 %x) {
; CHECK-LABEL: brRI_i8_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB113_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB113_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i8 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}

define i8 @brR0_i8_sle(i8 %x) {
; CHECK-LABEL: brR0_i8_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    bhz32 a0, .LBB114_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB114_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i8 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}


define i8 @brCBit_i8(i1 %c) {
; CHECK-LABEL: brCBit_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB115_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB115_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  br i1 %c, label %label1, label %label2
label1:
  ret i8 1
label2:
  ret i8 0
}


;EQ
define i1 @brRR_i1_eq(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    andi32 a1, a1, 1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bt32 .LBB116_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB116_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_eq(i1 %x) {
; CHECK-LABEL: brRI_i1_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bf32 .LBB117_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB117_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_eq(i1 %x) {
; CHECK-LABEL: brR0_i1_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bf32 .LBB118_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB118_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;NE
define i1 @brRR_i1_ne(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    andi32 a1, a1, 1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    bf32 .LBB119_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB119_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_ne(i1 %x) {
; CHECK-LABEL: brRI_i1_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB120_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB120_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_ne(i1 %x) {
; CHECK-LABEL: brR0_i1_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB121_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB121_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;UGT
define i1 @brRR_i1_ugt(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a1, a1, 1
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bt32 .LBB122_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB122_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_ugt(i1 %x) {
; CHECK-LABEL: brRI_i1_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB123_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB123_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_ugt(i1 %x) {
; CHECK-LABEL: brR0_i1_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB124_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB124_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ugt i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;UGE
define i1 @brRR_i1_uge(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    andi32 a1, a1, 1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bf32 .LBB125_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB125_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_uge(i1 %x) {
; CHECK-LABEL: brRI_i1_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB126_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB126_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp uge i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;ULT
define i1 @brRR_i1_ult(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    andi32 a1, a1, 1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    bt32 .LBB127_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB127_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_ult(i1 %x) {
; CHECK-LABEL: brRI_i1_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB128_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB128_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ult i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}


;ULE
define i1 @brRR_i1_ule(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a1, a1, 1
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    bf32 .LBB129_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB129_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_ule(i1 %x) {
; CHECK-LABEL: brRI_i1_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB130_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB130_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_ule(i1 %x) {
; CHECK-LABEL: brR0_i1_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB131_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB131_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp ule i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;SGT
define i1 @brRR_i1_sgt(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sext32 a1, a1, 0, 0
; CHECK-NEXT:    sext32 a0, a0, 0, 0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bf32 .LBB132_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB132_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_sgt(i1 %x) {
; CHECK-LABEL: brRI_i1_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB133_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB133_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_sgt(i1 %x) {
; CHECK-LABEL: brR0_i1_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB134_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB134_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sgt i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;SGE
define i1 @brRR_i1_sge(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sext32 a0, a0, 0, 0
; CHECK-NEXT:    sext32 a1, a1, 0, 0
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bt32 .LBB135_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB135_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_sge(i1 %x) {
; CHECK-LABEL: brRI_i1_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB136_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB136_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_sge(i1 %x) {
; CHECK-LABEL: brR0_i1_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB137_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB137_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sge i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;SLT
define i1 @brRR_i1_slt(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sext32 a0, a0, 0, 0
; CHECK-NEXT:    sext32 a1, a1, 0, 0
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    bf32 .LBB138_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB138_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_slt(i1 %x) {
; CHECK-LABEL: brRI_i1_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bnez32 a0, .LBB139_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB139_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_slt(i1 %x) {
; CHECK-LABEL: brR0_i1_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bnez32 a0, .LBB140_2
; CHECK-NEXT:  # %bb.1: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB140_2: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp slt i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

;SLE
define i1 @brRR_i1_sle(i1 %x, i1 %y) {
; CHECK-LABEL: brRR_i1_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sext32 a1, a1, 0, 0
; CHECK-NEXT:    sext32 a0, a0, 0, 0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    bt32 .LBB141_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB141_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i1 %y, %x
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brRI_i1_sle(i1 %x) {
; CHECK-LABEL: brRI_i1_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB142_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB142_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i1 %x, 10
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}

define i1 @brR0_i1_sle(i1 %x) {
; CHECK-LABEL: brR0_i1_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    bt32 .LBB143_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB143_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
; CHECK-UGTXT:    icmpu32 a0, a1, a0
; CHECK-UGTXT:    rts16
entry:
  %icmp = icmp sle i1 %x, 0
  br i1 %icmp, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}


define i1 @brCBit_i1(i1 %c) {
; CHECK-LABEL: brCBit_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    bez32 a0, .LBB144_2
; CHECK-NEXT:  # %bb.1: # %label1
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
; CHECK-NEXT:  .LBB144_2: # %label2
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  br i1 %c, label %label1, label %label2
label1:
  ret i1 1
label2:
  ret i1 0
}
