## Getting started
Here is some information that's good to know when contributing to JavaParser:

- There is some interesting information on the [wiki](https://github.com/javaparser/javaparser/wiki).
- We work on JavaParser because we like to, not because it earns us money. Please remember that we try to run a professional project in our spare time, on a budget of zero.
- Be sure to check [the coding guidelines](https://github.com/javaparser/javaparser/wiki/Coding-Guidelines) which are easily used by installing the formatting rules as described there.
- If you're new and like to casually contribute something, check out the [easy issues](https://github.com/javaparser/javaparser/labels/Easy).
- If you're new and would like to become a member, start your own project that uses JavaParser.
We noticed we get the best feedback from those. 
Here are [some fun project ideas](https://github.com/javaparser/javaparser/labels/fun%20project%20idea).
- If you start working on an issue, please say so with a comment in the issue.
- If you know how to fix a problem, please fix it and open a pull request instead of opening an issue.

Thanks for helping!

## Contribution Workflow

Our development workflow is based on Pull Request. If you are not familiar with the Pull Requests, we suggest you to checkout the [Github Documentation](https://help.github.com/articles/creating-a-pull-request/) for more information.

1. **Fork** the JavaParser project. If you already have a fork, ensure to fetch the latest commits.
2. In your forked project, **create a branch** related to the issue you are working on. This is important to ensure that your pull request will not contain unrelated work.
3. When your work in your branch is done, **push your branch to your forked repository**.
4. Go back to the [javaparser project site](https://github.com/javaparser/javaparser) and it should have a message offering to **create a pull request**. If it doesn't you can [create one manually](https://github.com/javaparser/javaparser/compare).

### Remember:
- A pull request should include tests. You can either use BDD or JUnit.
- Every pull request will automatically be checked by a few tools. Make sure AppVeyor and Travis are green.
- Pull requests often stay open for at least a few days to give people a chance to review it.
- A pull request is merged when all comments on it have been resolved.
- If you create a pull request for an issue, mention the issue in the format #123 to make github link it automatically.
