// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef BACKENDLOADER_H
#define BACKENDLOADER_H

#include "global_header.h"
#include "backendmetaobject.h"

#include <QObject>

GLOBAL_BEGIN_NAMESPACE
class ModelInfo;
class BackendLoaderPrivate;
class BackendLoader : public QObject
{
    Q_OBJECT
    friend class BackendLoaderPrivate;
public:
    explicit BackendLoader(QObject *parent = nullptr);
    void setPaths(const QStringList &paths);
    void readBackends();
    QList<BackendMetaObjectPointer> backends() const;
    QSharedPointer<InferencePlugin> load(BackendMetaObjectPointer) const;
    BackendMetaObjectPointer perfect(const QSharedPointer<ModelInfo> &model, QString *matchedFormat = nullptr, QString *matchedArch = nullptr) const;
    bool isRuntimeSupported(BackendMetaObjectPointer) const;
signals:

public slots:
private:
    BackendLoaderPrivate *d;
};

GLOBAL_END_NAMESPACE

#endif // BACKENDLOADER_H
