# 测试内核模块

步骤：

1. 切换到root，并进入`kernelmod`目录
2. 执行`insmod vfs_monitor.ko`命令加载内核模块
3. 执行`cat /proc/vfs_changes`查看整个文件系统的文件变更
4. 执行`rmmod vfs_monitor`卸载内核模块

# 无文件系统更新的测试

为了避免干扰，我们先不加载内核模块来单独测试用户态程序。

测试用户态程序的步骤：

1. 切换到root，并进入`cli`目录 (使用root是为了遍历所有目录与文件)
2. 执行`LD_LIBRARY_PATH=../library/bin/release/ ./bin/release/anything_cli scan`命令，对全盘文件系统进行扫描，视文件系统中文件数量的多少、硬盘规格以及处理器架构等多方面因素影响，这一步可能会花费数分钟到数十分钟不等
3. 扫描结束之后会保存扫描数据，并将显示统计数据，包括总文件数、不同长度文件名的文件数、内存占用等，然后进入命令提示符($)
4. 在命令提示符处，你可以输入任何字符串进行搜索，例如输入hellfire在所有文件里搜索文件/目录名包含hellfire的，最多显示100个搜索结果，但是搜索总结果数与搜索时间统计都会显示在搜索结果的最后。在x86上，在百万个文件中搜索的延迟一般不超过20毫秒，在申威1621上，在百万个文件中搜索的延迟一般不超过300毫秒
5. 在运行过程中使用`cat /proc/#anything_pid/status | grep Vm`观察程序的占用内存，对于百万个文件来说应该不会超过25M，其中`#anything_pid`是anything程序的pid，可以通过`pidof anything_cli`来获得
6. 可以输入Ctrl+D退出程序

生成了文件系统数据后可以反复使用此数据进行搜索(即离线搜索，不再依赖于原始文件系统了)，测试步骤如下：

1. 执行`LD_LIBRARY_PATH=../library/bin/release/ ./bin/release/anything_cli load`命令载入扫描数据，载入速度会非常快(毫秒量级)，而且也会显示相应的统计数据
2. 在命令提示符中输入任何字符串进行搜索，延迟不变
3. 在运行过程中观察程序内存占用情况，应该仍然较小
4. 可以输入Ctrl+D退出程序

除此之外，程序还支持倒排索引，生成索引步骤如下：

1. 切换到root，并进入`cli`目录 (使用root是为了遍历所有目录与文件)
2. 执行`LD_LIBRARY_PATH=../library/bin/release/ ./bin/release/anything_cli scan -i`命令，对全盘文件系统进行扫描并生成倒排索引，这一步会比不带`-i`参数的时候多花约一倍的时间(申威龙芯更慢一些)
3. 扫描结束之后会保存索引数据，并将显示统计数据，包括总文件数、不同长度文件名的文件数、内存占用、索引数等，然后进入命令提示符($)
4. 在命令提示符处，除了之前的搜索方式，还可以使用s/hellfire针对倒排索引搜索，一般会比不带s/的搜索(原搜索)快十倍以上，它也是最多显示100个搜索结果，搜索总结果数与搜索时间统计都会显示在搜索结果的最后
5. 在运行过程中观察程序的占用内存，对于百万个文件来说内存占用大约会在1.2G左右，内存占用大幅提高
6. 可以输入Ctrl+D退出程序

生成了倒排索引数据后也可以反复使用此数据进行搜索，测试步骤同上，内存消耗与不带倒排索引的载入搜索类似，但若搜索结果较多，则可能搜索较原来的搜索方式反而会较慢。

# 详细参数与测试命令

# 集成测试