# This file is part of Yaggo.

# Yaggo is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# Yaggo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Yaggo.  If not, see <http://www.gnu.org/licenses/>.


def display_stub_yaggo_file file
  stub = <<EOS
# Stub file generated by yaggo. Modify to your liking
purpose = "Foo software to do bar and baz, one line description"
description = "A longer multiline description of how Foo does bar and baz

Really, it works great, you should try all the options below
"

option("b", "bar") {
  description "Insist on bar"
  flag }
option("z", "baz") {
  description "Baz parameter"
  int64; default "5" }
option("l", "long") {
  description "Long switch can be used multiple time"
  int32; multiple }
arg("OneArg") {
  description "first arg"
  string }
EOS

  out = file ? open(file, "W") : STDOUT
  out.write(stub)
end
