// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_FDIV_8H_TRACE_AARCH64_H_
#define VIXL_SIM_FDIV_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_fdiv_8H[] = {
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x3c00, 0x3c00, 0x3c00, 0x7e00,
  0x7f23, 0x7f23, 0x7f23, 0x7e01, 0x2481, 0x63fe, 0x7c00, 0x0000,
  0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x4c80, 0x7c00, 0x1400, 0x0000,
  0x7e01, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x3bfe, 0x0002, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x2480, 0x07ff, 0x0002, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024, 0x07fe, 0x0002, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024, 0x07fc, 0x0001, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024, 0x03ff, 0x0001, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03fe, 0x0001, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x02aa, 0x0000, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x000c, 0x0066, 0x0000, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0002, 0x0000, 0x0000, 0x7f23,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0000, 0x0000, 0x7f23, 0x7e00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e00, 0x7f23, 0x7e01, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x2b1c, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e01, 0x531b, 0x1401, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x3c00, 0x3c00, 0x3c00, 0x7e00,
  0x7f23, 0x7f23, 0x7f23, 0x7e01, 0x2481, 0x63fe, 0xfc00, 0x8000,
  0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x4c80, 0xfc00, 0x9400, 0x8000,
  0x7e01, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xbbfe, 0x8002, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xa480, 0x87ff, 0x8002, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024, 0x87fe, 0x8002, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024, 0x87fc, 0x8001, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024, 0x83ff, 0x8001, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012, 0x83ff, 0x8001, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012, 0x83fe, 0x8001, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012, 0x82aa, 0x8000, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x800c, 0x8066, 0x8000, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8002, 0x8000, 0x8000, 0xff23,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8000, 0x8000, 0xff23, 0xfe00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8000, 0xff23, 0xfe00, 0xff23,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe00, 0xff23, 0xfe01, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0xab1c, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe01, 0xd31b, 0x9401, 0x8000,
  0x7e00, 0x7f23, 0x7e01, 0xfe01, 0xd31b, 0x9401, 0x8000, 0x7c00,
  0x7e00, 0x7f23, 0x7e01, 0xbc00, 0xbc00, 0xbc00, 0x7e00, 0x3c00,
  0xff23, 0x7f23, 0x7e01, 0xa481, 0xe3fe, 0x7c00, 0x0000, 0x0801,
  0xfe01, 0x7f23, 0x7e01, 0xcc80, 0x7c00, 0x1400, 0x0000, 0x0800,
  0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x3bfe, 0x0002, 0x0000, 0x07fe,
  0x7e00, 0x7f23, 0x7e01, 0x2480, 0x07ff, 0x0002, 0x0000, 0x0401,
  0x7e00, 0x7f23, 0x7e01, 0x0024, 0x07fe, 0x0002, 0x0000, 0x0400,
  0x7e00, 0x7f23, 0x7e01, 0x0024, 0x07fc, 0x0001, 0x0000, 0x03ff,
  0x7e00, 0x7f23, 0x7e01, 0x0024, 0x03ff, 0x0001, 0x0000, 0x02ab,
  0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0066,
  0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03fe, 0x0001, 0x0000, 0x0000,
  0x7e00, 0x7f23, 0x7e01, 0x0012, 0x02aa, 0x0000, 0x0000, 0x0000,
  0x7e00, 0x7f23, 0x7e01, 0x000c, 0x0066, 0x0000, 0x0000, 0x7f23,
  0x7e00, 0x7f23, 0x7e01, 0x0002, 0x0000, 0x0000, 0x7f23, 0x7e00,
  0x7e00, 0x7f23, 0x7e01, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x7e00, 0x7f23, 0x7e01, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x531c,
  0x7e00, 0x7f23, 0x7e01, 0x7e00, 0x7f23, 0x7e01, 0x0000, 0x3c01,
  0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x2b1c, 0x0000, 0x6400,
  0x7e00, 0x7f23, 0x7e01, 0x7e01, 0x531b, 0x1401, 0x0000, 0xfc00,
  0x7e00, 0x7f23, 0x7e01, 0x3c00, 0x3c00, 0x3c00, 0x7e00, 0xbc00,
  0x7f23, 0x7f23, 0x7e01, 0x2481, 0x63fe, 0xfc00, 0x8000, 0x8801,
  0x7e01, 0x7f23, 0x7e01, 0x4c80, 0xfc00, 0x9400, 0x8000, 0x8800,
  0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xbbfe, 0x8002, 0x8000, 0x87fe,
  0x7e00, 0x7f23, 0x7e01, 0xa480, 0x87ff, 0x8002, 0x8000, 0x8401,
  0x7e00, 0x7f23, 0x7e01, 0x8024, 0x87fe, 0x8002, 0x8000, 0x8400,
  0x7e00, 0x7f23, 0x7e01, 0x8024, 0x87fc, 0x8001, 0x8000, 0x83ff,
  0x7e00, 0x7f23, 0x7e01, 0x8024, 0x83ff, 0x8001, 0x8000, 0x82ab,
  0x7e00, 0x7f23, 0x7e01, 0x8012, 0x83ff, 0x8001, 0x8000, 0x8066,
  0x7e00, 0x7f23, 0x7e01, 0x8012, 0x83fe, 0x8001, 0x8000, 0x8000,
  0x7e00, 0x7f23, 0x7e01, 0x8012, 0x82aa, 0x8000, 0x8000, 0x8000,
  0x7e00, 0x7f23, 0x7e01, 0x800c, 0x8066, 0x8000, 0x8000, 0xff23,
  0x7e00, 0x7f23, 0x7e01, 0x8002, 0x8000, 0x8000, 0xff23, 0xfe00,
  0x7e00, 0x7f23, 0x7e01, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23,
  0x7e00, 0x7f23, 0x7e01, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xd31c,
  0x7e00, 0x7f23, 0x7e01, 0xfe00, 0xff23, 0xfe01, 0x8000, 0xbc01,
  0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0xab1c, 0x8000, 0xe400,
  0x7f23, 0x7e01, 0xff23, 0xfe01, 0xab1c, 0x8000, 0xe400, 0x7c00,
  0x7f23, 0x7e01, 0xfe01, 0xd31b, 0x9401, 0x8000, 0x7c00, 0x6fff,
  0x7f23, 0x7e01, 0xbc00, 0xbc00, 0xbc00, 0x7e00, 0x3c00, 0x3c00,
  0x7f23, 0x7e01, 0xa481, 0xe3fe, 0x7c00, 0x0000, 0x0801, 0x3bff,
  0x7f23, 0x7e01, 0xcc80, 0x7c00, 0x1400, 0x0000, 0x0800, 0x3bfd,
  0x7f23, 0x7e01, 0x7c00, 0x3bfe, 0x0002, 0x0000, 0x07fe, 0x3800,
  0x7f23, 0x7e01, 0x2480, 0x07ff, 0x0002, 0x0000, 0x0401, 0x37ff,
  0x7f23, 0x7e01, 0x0024, 0x07fe, 0x0002, 0x0000, 0x0400, 0x37fd,
  0x7f23, 0x7e01, 0x0024, 0x07fc, 0x0001, 0x0000, 0x03ff, 0x3555,
  0x7f23, 0x7e01, 0x0024, 0x03ff, 0x0001, 0x0000, 0x02ab, 0x2a66,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0066, 0x0080,
  0x7f23, 0x7e01, 0x0012, 0x03fe, 0x0001, 0x0000, 0x0000, 0x0000,
  0x7f23, 0x7e01, 0x0012, 0x02aa, 0x0000, 0x0000, 0x0000, 0x7f23,
  0x7f23, 0x7e01, 0x000c, 0x0066, 0x0000, 0x0000, 0x7f23, 0x7e00,
  0x7f23, 0x7e01, 0x0002, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x7f23, 0x7e01, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7f23, 0x7e01, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00,
  0x7f23, 0x7e01, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x531c, 0x7001,
  0x7f23, 0x7e01, 0x7e00, 0x7f23, 0x7e01, 0x0000, 0x3c01, 0x7c00,
  0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x2b1c, 0x0000, 0x6400, 0xfc00,
  0x7f23, 0x7e01, 0x7e01, 0x531b, 0x1401, 0x0000, 0xfc00, 0xefff,
  0x7f23, 0x7e01, 0x3c00, 0x3c00, 0x3c00, 0x7e00, 0xbc00, 0xbc00,
  0x7f23, 0x7e01, 0x2481, 0x63fe, 0xfc00, 0x8000, 0x8801, 0xbbff,
  0x7f23, 0x7e01, 0x4c80, 0xfc00, 0x9400, 0x8000, 0x8800, 0xbbfd,
  0x7f23, 0x7e01, 0xfc00, 0xbbfe, 0x8002, 0x8000, 0x87fe, 0xb800,
  0x7f23, 0x7e01, 0xa480, 0x87ff, 0x8002, 0x8000, 0x8401, 0xb7ff,
  0x7f23, 0x7e01, 0x8024, 0x87fe, 0x8002, 0x8000, 0x8400, 0xb7fd,
  0x7f23, 0x7e01, 0x8024, 0x87fc, 0x8001, 0x8000, 0x83ff, 0xb555,
  0x7f23, 0x7e01, 0x8024, 0x83ff, 0x8001, 0x8000, 0x82ab, 0xaa66,
  0x7f23, 0x7e01, 0x8012, 0x83ff, 0x8001, 0x8000, 0x8066, 0x8080,
  0x7f23, 0x7e01, 0x8012, 0x83fe, 0x8001, 0x8000, 0x8000, 0x8000,
  0x7f23, 0x7e01, 0x8012, 0x82aa, 0x8000, 0x8000, 0x8000, 0xff23,
  0x7f23, 0x7e01, 0x800c, 0x8066, 0x8000, 0x8000, 0xff23, 0xfe00,
  0x7f23, 0x7e01, 0x8002, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23,
  0x7f23, 0x7e01, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7f23, 0x7e01, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00,
  0x7f23, 0x7e01, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xd31c, 0xf001,
  0x7f23, 0x7e01, 0xfe00, 0xff23, 0xfe01, 0x8000, 0xbc01, 0xfc00,
  0x7e01, 0xfe00, 0xff23, 0xfe01, 0x8000, 0xbc01, 0xfc00, 0x7c00,
  0x7e01, 0xff23, 0xfe01, 0xab1c, 0x8000, 0xe400, 0x7c00, 0x7000,
  0x7e01, 0xfe01, 0xd31b, 0x9401, 0x8000, 0x7c00, 0x6fff, 0x3c01,
  0x7e01, 0xbc00, 0xbc00, 0xbc00, 0x7e00, 0x3c00, 0x3c00, 0x3c00,
  0x7e01, 0xa481, 0xe3fe, 0x7c00, 0x0000, 0x0801, 0x3bff, 0x3bfe,
  0x7e01, 0xcc80, 0x7c00, 0x1400, 0x0000, 0x0800, 0x3bfd, 0x3801,
  0x7e01, 0x7c00, 0x3bfe, 0x0002, 0x0000, 0x07fe, 0x3800, 0x3800,
  0x7e01, 0x2480, 0x07ff, 0x0002, 0x0000, 0x0401, 0x37ff, 0x37fe,
  0x7e01, 0x0024, 0x07fe, 0x0002, 0x0000, 0x0400, 0x37fd, 0x3555,
  0x7e01, 0x0024, 0x07fc, 0x0001, 0x0000, 0x03ff, 0x3555, 0x2a66,
  0x7e01, 0x0024, 0x03ff, 0x0001, 0x0000, 0x02ab, 0x2a66, 0x0080,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0066, 0x0080, 0x0000,
  0x7e01, 0x0012, 0x03fe, 0x0001, 0x0000, 0x0000, 0x0000, 0x7f23,
  0x7e01, 0x0012, 0x02aa, 0x0000, 0x0000, 0x0000, 0x7f23, 0x7e00,
  0x7e01, 0x000c, 0x0066, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x7e01, 0x0002, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7e01, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00,
  0x7e01, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7001,
  0x7e01, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x531c, 0x7001, 0x7c00,
  0x7e01, 0x7e00, 0x7f23, 0x7e01, 0x0000, 0x3c01, 0x7c00, 0xfc00,
  0x7e01, 0x7f23, 0x7e01, 0x2b1c, 0x0000, 0x6400, 0xfc00, 0xf000,
  0x7e01, 0x7e01, 0x531b, 0x1401, 0x0000, 0xfc00, 0xefff, 0xbc01,
  0x7e01, 0x3c00, 0x3c00, 0x3c00, 0x7e00, 0xbc00, 0xbc00, 0xbc00,
  0x7e01, 0x2481, 0x63fe, 0xfc00, 0x8000, 0x8801, 0xbbff, 0xbbfe,
  0x7e01, 0x4c80, 0xfc00, 0x9400, 0x8000, 0x8800, 0xbbfd, 0xb801,
  0x7e01, 0xfc00, 0xbbfe, 0x8002, 0x8000, 0x87fe, 0xb800, 0xb800,
  0x7e01, 0xa480, 0x87ff, 0x8002, 0x8000, 0x8401, 0xb7ff, 0xb7fe,
  0x7e01, 0x8024, 0x87fe, 0x8002, 0x8000, 0x8400, 0xb7fd, 0xb555,
  0x7e01, 0x8024, 0x87fc, 0x8001, 0x8000, 0x83ff, 0xb555, 0xaa66,
  0x7e01, 0x8024, 0x83ff, 0x8001, 0x8000, 0x82ab, 0xaa66, 0x8080,
  0x7e01, 0x8012, 0x83ff, 0x8001, 0x8000, 0x8066, 0x8080, 0x8000,
  0x7e01, 0x8012, 0x83fe, 0x8001, 0x8000, 0x8000, 0x8000, 0xff23,
  0x7e01, 0x8012, 0x82aa, 0x8000, 0x8000, 0x8000, 0xff23, 0xfe00,
  0x7e01, 0x800c, 0x8066, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23,
  0x7e01, 0x8002, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7e01, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00,
  0x7e01, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf001,
  0x7e01, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xd31c, 0xf001, 0xfc00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xd31c, 0xf001, 0xfc00, 0x7c00,
  0xfe00, 0xff23, 0xfe01, 0x8000, 0xbc01, 0xfc00, 0x7c00, 0x7001,
  0xff23, 0xfe01, 0xab1c, 0x8000, 0xe400, 0x7c00, 0x7000, 0x3c02,
  0xfe01, 0xd31b, 0x9401, 0x8000, 0x7c00, 0x6fff, 0x3c01, 0x3c01,
  0xbc00, 0xbc00, 0xbc00, 0x7e00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0xa481, 0xe3fe, 0x7c00, 0x0000, 0x0801, 0x3bff, 0x3bfe, 0x3802,
  0xcc80, 0x7c00, 0x1400, 0x0000, 0x0800, 0x3bfd, 0x3801, 0x3801,
  0x7c00, 0x3bfe, 0x0002, 0x0000, 0x07fe, 0x3800, 0x3800, 0x3800,
  0x2480, 0x07ff, 0x0002, 0x0000, 0x0401, 0x37ff, 0x37fe, 0x3557,
  0x0024, 0x07fe, 0x0002, 0x0000, 0x0400, 0x37fd, 0x3555, 0x2a68,
  0x0024, 0x07fc, 0x0001, 0x0000, 0x03ff, 0x3555, 0x2a66, 0x0080,
  0x0024, 0x03ff, 0x0001, 0x0000, 0x02ab, 0x2a66, 0x0080, 0x0000,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0066, 0x0080, 0x0000, 0x7f23,
  0x0012, 0x03fe, 0x0001, 0x0000, 0x0000, 0x0000, 0x7f23, 0x7e00,
  0x0012, 0x02aa, 0x0000, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x000c, 0x0066, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x0002, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00,
  0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7002,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7001, 0x7c00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x531c, 0x7001, 0x7c00, 0xfc00,
  0x7e00, 0x7f23, 0x7e01, 0x0000, 0x3c01, 0x7c00, 0xfc00, 0xf001,
  0x7f23, 0x7e01, 0x2b1c, 0x0000, 0x6400, 0xfc00, 0xf000, 0xbc02,
  0x7e01, 0x531b, 0x1401, 0x0000, 0xfc00, 0xefff, 0xbc01, 0xbc01,
  0x3c00, 0x3c00, 0x3c00, 0x7e00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0x2481, 0x63fe, 0xfc00, 0x8000, 0x8801, 0xbbff, 0xbbfe, 0xb802,
  0x4c80, 0xfc00, 0x9400, 0x8000, 0x8800, 0xbbfd, 0xb801, 0xb801,
  0xfc00, 0xbbfe, 0x8002, 0x8000, 0x87fe, 0xb800, 0xb800, 0xb800,
  0xa480, 0x87ff, 0x8002, 0x8000, 0x8401, 0xb7ff, 0xb7fe, 0xb557,
  0x8024, 0x87fe, 0x8002, 0x8000, 0x8400, 0xb7fd, 0xb555, 0xaa68,
  0x8024, 0x87fc, 0x8001, 0x8000, 0x83ff, 0xb555, 0xaa66, 0x8080,
  0x8024, 0x83ff, 0x8001, 0x8000, 0x82ab, 0xaa66, 0x8080, 0x8000,
  0x8012, 0x83ff, 0x8001, 0x8000, 0x8066, 0x8080, 0x8000, 0xff23,
  0x8012, 0x83fe, 0x8001, 0x8000, 0x8000, 0x8000, 0xff23, 0xfe00,
  0x8012, 0x82aa, 0x8000, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23,
  0x800c, 0x8066, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x8002, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00,
  0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf002,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf001, 0xfc00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf001, 0xfc00, 0x7c00,
  0xfe00, 0xff23, 0xfe01, 0xd31c, 0xf001, 0xfc00, 0x7c00, 0x73ff,
  0xff23, 0xfe01, 0x8000, 0xbc01, 0xfc00, 0x7c00, 0x7001, 0x4000,
  0xfe01, 0xab1c, 0x8000, 0xe400, 0x7c00, 0x7000, 0x3c02, 0x3fff,
  0xd31b, 0x9401, 0x8000, 0x7c00, 0x6fff, 0x3c01, 0x3c01, 0x3ffd,
  0xbc00, 0xbc00, 0x7e00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0xe3fe, 0x7c00, 0x0000, 0x0801, 0x3bff, 0x3bfe, 0x3802, 0x3bff,
  0x7c00, 0x1400, 0x0000, 0x0800, 0x3bfd, 0x3801, 0x3801, 0x3bfd,
  0x3bfe, 0x0002, 0x0000, 0x07fe, 0x3800, 0x3800, 0x3800, 0x3955,
  0x07ff, 0x0002, 0x0000, 0x0401, 0x37ff, 0x37fe, 0x3557, 0x2e66,
  0x07fe, 0x0002, 0x0000, 0x0400, 0x37fd, 0x3555, 0x2a68, 0x0100,
  0x07fc, 0x0001, 0x0000, 0x03ff, 0x3555, 0x2a66, 0x0080, 0x0000,
  0x03ff, 0x0001, 0x0000, 0x02ab, 0x2a66, 0x0080, 0x0000, 0x7f23,
  0x03ff, 0x0001, 0x0000, 0x0066, 0x0080, 0x0000, 0x7f23, 0x7e00,
  0x03fe, 0x0001, 0x0000, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x02aa, 0x0000, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x0066, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00,
  0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7401,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7002, 0x7c00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7001, 0x7c00, 0xfc00,
  0x7e00, 0x7f23, 0x7e01, 0x531c, 0x7001, 0x7c00, 0xfc00, 0xf3ff,
  0x7f23, 0x7e01, 0x0000, 0x3c01, 0x7c00, 0xfc00, 0xf001, 0xc000,
  0x7e01, 0x2b1c, 0x0000, 0x6400, 0xfc00, 0xf000, 0xbc02, 0xbfff,
  0x531b, 0x1401, 0x0000, 0xfc00, 0xefff, 0xbc01, 0xbc01, 0xbffd,
  0x3c00, 0x3c00, 0x7e00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0x63fe, 0xfc00, 0x8000, 0x8801, 0xbbff, 0xbbfe, 0xb802, 0xbbff,
  0xfc00, 0x9400, 0x8000, 0x8800, 0xbbfd, 0xb801, 0xb801, 0xbbfd,
  0xbbfe, 0x8002, 0x8000, 0x87fe, 0xb800, 0xb800, 0xb800, 0xb955,
  0x87ff, 0x8002, 0x8000, 0x8401, 0xb7ff, 0xb7fe, 0xb557, 0xae66,
  0x87fe, 0x8002, 0x8000, 0x8400, 0xb7fd, 0xb555, 0xaa68, 0x8100,
  0x87fc, 0x8001, 0x8000, 0x83ff, 0xb555, 0xaa66, 0x8080, 0x8000,
  0x83ff, 0x8001, 0x8000, 0x82ab, 0xaa66, 0x8080, 0x8000, 0xff23,
  0x83ff, 0x8001, 0x8000, 0x8066, 0x8080, 0x8000, 0xff23, 0xfe00,
  0x83fe, 0x8001, 0x8000, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23,
  0x82aa, 0x8000, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x8066, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00,
  0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf401,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf002, 0xfc00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf002, 0xfc00, 0x7c00,
  0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf001, 0xfc00, 0x7c00, 0x7400,
  0xff23, 0xfe01, 0xd31c, 0xf001, 0xfc00, 0x7c00, 0x73ff, 0x4001,
  0xfe01, 0x8000, 0xbc01, 0xfc00, 0x7c00, 0x7001, 0x4000, 0x4000,
  0xab1c, 0x8000, 0xe400, 0x7c00, 0x7000, 0x3c02, 0x3fff, 0x3ffe,
  0x9401, 0x8000, 0x7c00, 0x6fff, 0x3c01, 0x3c01, 0x3ffd, 0x3c01,
  0xbc00, 0x7e00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x7c00, 0x0000, 0x0801, 0x3bff, 0x3bfe, 0x3802, 0x3bff, 0x3bfe,
  0x1400, 0x0000, 0x0800, 0x3bfd, 0x3801, 0x3801, 0x3bfd, 0x3955,
  0x0002, 0x0000, 0x07fe, 0x3800, 0x3800, 0x3800, 0x3955, 0x2e66,
  0x0002, 0x0000, 0x0401, 0x37ff, 0x37fe, 0x3557, 0x2e66, 0x0100,
  0x0002, 0x0000, 0x0400, 0x37fd, 0x3555, 0x2a68, 0x0100, 0x0000,
  0x0001, 0x0000, 0x03ff, 0x3555, 0x2a66, 0x0080, 0x0000, 0x7f23,
  0x0001, 0x0000, 0x02ab, 0x2a66, 0x0080, 0x0000, 0x7f23, 0x7e00,
  0x0001, 0x0000, 0x0066, 0x0080, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x0001, 0x0000, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x0000, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00,
  0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7401,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7401, 0x7c00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7002, 0x7c00, 0xfc00,
  0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7001, 0x7c00, 0xfc00, 0xf400,
  0x7f23, 0x7e01, 0x531c, 0x7001, 0x7c00, 0xfc00, 0xf3ff, 0xc001,
  0x7e01, 0x0000, 0x3c01, 0x7c00, 0xfc00, 0xf001, 0xc000, 0xc000,
  0x2b1c, 0x0000, 0x6400, 0xfc00, 0xf000, 0xbc02, 0xbfff, 0xbffe,
  0x1401, 0x0000, 0xfc00, 0xefff, 0xbc01, 0xbc01, 0xbffd, 0xbc01,
  0x3c00, 0x7e00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0xfc00, 0x8000, 0x8801, 0xbbff, 0xbbfe, 0xb802, 0xbbff, 0xbbfe,
  0x9400, 0x8000, 0x8800, 0xbbfd, 0xb801, 0xb801, 0xbbfd, 0xb955,
  0x8002, 0x8000, 0x87fe, 0xb800, 0xb800, 0xb800, 0xb955, 0xae66,
  0x8002, 0x8000, 0x8401, 0xb7ff, 0xb7fe, 0xb557, 0xae66, 0x8100,
  0x8002, 0x8000, 0x8400, 0xb7fd, 0xb555, 0xaa68, 0x8100, 0x8000,
  0x8001, 0x8000, 0x83ff, 0xb555, 0xaa66, 0x8080, 0x8000, 0xff23,
  0x8001, 0x8000, 0x82ab, 0xaa66, 0x8080, 0x8000, 0xff23, 0xfe00,
  0x8001, 0x8000, 0x8066, 0x8080, 0x8000, 0xff23, 0xfe00, 0xff23,
  0x8001, 0x8000, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x8000, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00,
  0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf401,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf401, 0xfc00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf401, 0xfc00, 0x7c00,
  0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf002, 0xfc00, 0x7c00, 0x7401,
  0xff23, 0xfe01, 0xfc00, 0xf001, 0xfc00, 0x7c00, 0x7400, 0x4002,
  0xfe01, 0xd31c, 0xf001, 0xfc00, 0x7c00, 0x73ff, 0x4001, 0x4001,
  0x8000, 0xbc01, 0xfc00, 0x7c00, 0x7001, 0x4000, 0x4000, 0x4000,
  0x8000, 0xe400, 0x7c00, 0x7000, 0x3c02, 0x3fff, 0x3ffe, 0x3c02,
  0x8000, 0x7c00, 0x6fff, 0x3c01, 0x3c01, 0x3ffd, 0x3c01, 0x3c01,
  0x7e00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x0000, 0x0801, 0x3bff, 0x3bfe, 0x3802, 0x3bff, 0x3bfe, 0x3957,
  0x0000, 0x0800, 0x3bfd, 0x3801, 0x3801, 0x3bfd, 0x3955, 0x2e68,
  0x0000, 0x07fe, 0x3800, 0x3800, 0x3800, 0x3955, 0x2e66, 0x0100,
  0x0000, 0x0401, 0x37ff, 0x37fe, 0x3557, 0x2e66, 0x0100, 0x0000,
  0x0000, 0x0400, 0x37fd, 0x3555, 0x2a68, 0x0100, 0x0000, 0x7f23,
  0x0000, 0x03ff, 0x3555, 0x2a66, 0x0080, 0x0000, 0x7f23, 0x7e00,
  0x0000, 0x02ab, 0x2a66, 0x0080, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x0000, 0x0066, 0x0080, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x0000, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00,
  0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7402,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7401, 0x7c00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7401, 0x7c00, 0xfc00,
  0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7002, 0x7c00, 0xfc00, 0xf401,
  0x7f23, 0x7e01, 0x7c00, 0x7001, 0x7c00, 0xfc00, 0xf400, 0xc002,
  0x7e01, 0x531c, 0x7001, 0x7c00, 0xfc00, 0xf3ff, 0xc001, 0xc001,
  0x0000, 0x3c01, 0x7c00, 0xfc00, 0xf001, 0xc000, 0xc000, 0xc000,
  0x0000, 0x6400, 0xfc00, 0xf000, 0xbc02, 0xbfff, 0xbffe, 0xbc02,
  0x0000, 0xfc00, 0xefff, 0xbc01, 0xbc01, 0xbffd, 0xbc01, 0xbc01,
  0x7e00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0x8000, 0x8801, 0xbbff, 0xbbfe, 0xb802, 0xbbff, 0xbbfe, 0xb957,
  0x8000, 0x8800, 0xbbfd, 0xb801, 0xb801, 0xbbfd, 0xb955, 0xae68,
  0x8000, 0x87fe, 0xb800, 0xb800, 0xb800, 0xb955, 0xae66, 0x8100,
  0x8000, 0x8401, 0xb7ff, 0xb7fe, 0xb557, 0xae66, 0x8100, 0x8000,
  0x8000, 0x8400, 0xb7fd, 0xb555, 0xaa68, 0x8100, 0x8000, 0xff23,
  0x8000, 0x83ff, 0xb555, 0xaa66, 0x8080, 0x8000, 0xff23, 0xfe00,
  0x8000, 0x82ab, 0xaa66, 0x8080, 0x8000, 0xff23, 0xfe00, 0xff23,
  0x8000, 0x8066, 0x8080, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x8000, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00,
  0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf402,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf401, 0xfc00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf401, 0xfc00, 0x7c00,
  0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7600,
  0xff23, 0xfe01, 0xfc00, 0xf002, 0xfc00, 0x7c00, 0x7401, 0x4201,
  0xfe01, 0xfc00, 0xf001, 0xfc00, 0x7c00, 0x7400, 0x4002, 0x4200,
  0xd31c, 0xf001, 0xfc00, 0x7c00, 0x73ff, 0x4001, 0x4001, 0x41ff,
  0xbc01, 0xfc00, 0x7c00, 0x7001, 0x4000, 0x4000, 0x4000, 0x3e01,
  0xe400, 0x7c00, 0x7000, 0x3c02, 0x3fff, 0x3ffe, 0x3c02, 0x3e00,
  0x7c00, 0x6fff, 0x3c01, 0x3c01, 0x3ffd, 0x3c01, 0x3c01, 0x3dff,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x0801, 0x3bff, 0x3bfe, 0x3802, 0x3bff, 0x3bfe, 0x3957, 0x30cd,
  0x0800, 0x3bfd, 0x3801, 0x3801, 0x3bfd, 0x3955, 0x2e68, 0x0180,
  0x07fe, 0x3800, 0x3800, 0x3800, 0x3955, 0x2e66, 0x0100, 0x0000,
  0x0401, 0x37ff, 0x37fe, 0x3557, 0x2e66, 0x0100, 0x0000, 0x7f23,
  0x0400, 0x37fd, 0x3555, 0x2a68, 0x0100, 0x0000, 0x7f23, 0x7e00,
  0x03ff, 0x3555, 0x2a66, 0x0080, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x02ab, 0x2a66, 0x0080, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x0066, 0x0080, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00,
  0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7602,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7402, 0x7c00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7401, 0x7c00, 0xfc00,
  0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7401, 0x7c00, 0xfc00, 0xf600,
  0x7f23, 0x7e01, 0x7c00, 0x7002, 0x7c00, 0xfc00, 0xf401, 0xc201,
  0x7e01, 0x7c00, 0x7001, 0x7c00, 0xfc00, 0xf400, 0xc002, 0xc200,
  0x531c, 0x7001, 0x7c00, 0xfc00, 0xf3ff, 0xc001, 0xc001, 0xc1ff,
  0x3c01, 0x7c00, 0xfc00, 0xf001, 0xc000, 0xc000, 0xc000, 0xbe01,
  0x6400, 0xfc00, 0xf000, 0xbc02, 0xbfff, 0xbffe, 0xbc02, 0xbe00,
  0xfc00, 0xefff, 0xbc01, 0xbc01, 0xbffd, 0xbc01, 0xbc01, 0xbdff,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0x8801, 0xbbff, 0xbbfe, 0xb802, 0xbbff, 0xbbfe, 0xb957, 0xb0cd,
  0x8800, 0xbbfd, 0xb801, 0xb801, 0xbbfd, 0xb955, 0xae68, 0x8180,
  0x87fe, 0xb800, 0xb800, 0xb800, 0xb955, 0xae66, 0x8100, 0x8000,
  0x8401, 0xb7ff, 0xb7fe, 0xb557, 0xae66, 0x8100, 0x8000, 0xff23,
  0x8400, 0xb7fd, 0xb555, 0xaa68, 0x8100, 0x8000, 0xff23, 0xfe00,
  0x83ff, 0xb555, 0xaa66, 0x8080, 0x8000, 0xff23, 0xfe00, 0xff23,
  0x82ab, 0xaa66, 0x8080, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x8066, 0x8080, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00,
  0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf602,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf402, 0xfc00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf402, 0xfc00, 0x7c00,
  0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7c00,
  0xff23, 0xfe01, 0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7600, 0x4d01,
  0xfe01, 0xfc00, 0xf002, 0xfc00, 0x7c00, 0x7401, 0x4201, 0x4d00,
  0xfc00, 0xf001, 0xfc00, 0x7c00, 0x7400, 0x4002, 0x4200, 0x4cff,
  0xf001, 0xfc00, 0x7c00, 0x73ff, 0x4001, 0x4001, 0x41ff, 0x4901,
  0xfc00, 0x7c00, 0x7001, 0x4000, 0x4000, 0x4000, 0x3e01, 0x4900,
  0x7c00, 0x7000, 0x3c02, 0x3fff, 0x3ffe, 0x3c02, 0x3e00, 0x48ff,
  0x6fff, 0x3c01, 0x3c01, 0x3ffd, 0x3c01, 0x3c01, 0x3dff, 0x46ab,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x3bff, 0x3bfe, 0x3802, 0x3bff, 0x3bfe, 0x3957, 0x30cd, 0x0901,
  0x3bfd, 0x3801, 0x3801, 0x3bfd, 0x3955, 0x2e68, 0x0180, 0x0000,
  0x3800, 0x3800, 0x3800, 0x3955, 0x2e66, 0x0100, 0x0000, 0x7f23,
  0x37ff, 0x37fe, 0x3557, 0x2e66, 0x0100, 0x0000, 0x7f23, 0x7e00,
  0x37fd, 0x3555, 0x2a68, 0x0100, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x3555, 0x2a66, 0x0080, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x2a66, 0x0080, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00,
  0x0080, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7c00,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7602, 0x7c00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7402, 0x7c00, 0xfc00,
  0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7401, 0x7c00, 0xfc00, 0xfc00,
  0x7f23, 0x7e01, 0x7c00, 0x7401, 0x7c00, 0xfc00, 0xf600, 0xcd01,
  0x7e01, 0x7c00, 0x7002, 0x7c00, 0xfc00, 0xf401, 0xc201, 0xcd00,
  0x7c00, 0x7001, 0x7c00, 0xfc00, 0xf400, 0xc002, 0xc200, 0xccff,
  0x7001, 0x7c00, 0xfc00, 0xf3ff, 0xc001, 0xc001, 0xc1ff, 0xc901,
  0x7c00, 0xfc00, 0xf001, 0xc000, 0xc000, 0xc000, 0xbe01, 0xc900,
  0xfc00, 0xf000, 0xbc02, 0xbfff, 0xbffe, 0xbc02, 0xbe00, 0xc8ff,
  0xefff, 0xbc01, 0xbc01, 0xbffd, 0xbc01, 0xbc01, 0xbdff, 0xc6ab,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0xbbff, 0xbbfe, 0xb802, 0xbbff, 0xbbfe, 0xb957, 0xb0cd, 0x8901,
  0xbbfd, 0xb801, 0xb801, 0xbbfd, 0xb955, 0xae68, 0x8180, 0x8000,
  0xb800, 0xb800, 0xb800, 0xb955, 0xae66, 0x8100, 0x8000, 0xff23,
  0xb7ff, 0xb7fe, 0xb557, 0xae66, 0x8100, 0x8000, 0xff23, 0xfe00,
  0xb7fd, 0xb555, 0xaa68, 0x8100, 0x8000, 0xff23, 0xfe00, 0xff23,
  0xb555, 0xaa66, 0x8080, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xaa66, 0x8080, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00,
  0x8080, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xfc00,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf602, 0xfc00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf602, 0xfc00, 0x7c00,
  0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf402, 0xfc00, 0x7c00, 0x7c00,
  0xff23, 0xfe01, 0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7c00, 0x7c00,
  0xfe01, 0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7600, 0x4d01, 0x7c00,
  0xfc00, 0xf002, 0xfc00, 0x7c00, 0x7401, 0x4201, 0x4d00, 0x7c00,
  0xf001, 0xfc00, 0x7c00, 0x7400, 0x4002, 0x4200, 0x4cff, 0x7c00,
  0xfc00, 0x7c00, 0x73ff, 0x4001, 0x4001, 0x41ff, 0x4901, 0x7bff,
  0x7c00, 0x7001, 0x4000, 0x4000, 0x4000, 0x3e01, 0x4900, 0x7bfd,
  0x7000, 0x3c02, 0x3fff, 0x3ffe, 0x3c02, 0x3e00, 0x48ff, 0x7955,
  0x3c01, 0x3c01, 0x3ffd, 0x3c01, 0x3c01, 0x3dff, 0x46ab, 0x6e66,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x3bfe, 0x3802, 0x3bff, 0x3bfe, 0x3957, 0x30cd, 0x0901, 0x0000,
  0x3801, 0x3801, 0x3bfd, 0x3955, 0x2e68, 0x0180, 0x0000, 0x7f23,
  0x3800, 0x3800, 0x3955, 0x2e66, 0x0100, 0x0000, 0x7f23, 0x7e00,
  0x37fe, 0x3557, 0x2e66, 0x0100, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x3555, 0x2a68, 0x0100, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x2a66, 0x0080, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00,
  0x0080, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7c00,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7c00, 0x7c00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7602, 0x7c00, 0xfc00,
  0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7402, 0x7c00, 0xfc00, 0xfc00,
  0x7f23, 0x7e01, 0x7c00, 0x7401, 0x7c00, 0xfc00, 0xfc00, 0xfc00,
  0x7e01, 0x7c00, 0x7401, 0x7c00, 0xfc00, 0xf600, 0xcd01, 0xfc00,
  0x7c00, 0x7002, 0x7c00, 0xfc00, 0xf401, 0xc201, 0xcd00, 0xfc00,
  0x7001, 0x7c00, 0xfc00, 0xf400, 0xc002, 0xc200, 0xccff, 0xfc00,
  0x7c00, 0xfc00, 0xf3ff, 0xc001, 0xc001, 0xc1ff, 0xc901, 0xfbff,
  0xfc00, 0xf001, 0xc000, 0xc000, 0xc000, 0xbe01, 0xc900, 0xfbfd,
  0xf000, 0xbc02, 0xbfff, 0xbffe, 0xbc02, 0xbe00, 0xc8ff, 0xf955,
  0xbc01, 0xbc01, 0xbffd, 0xbc01, 0xbc01, 0xbdff, 0xc6ab, 0xee66,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0xbbfe, 0xb802, 0xbbff, 0xbbfe, 0xb957, 0xb0cd, 0x8901, 0x8000,
  0xb801, 0xb801, 0xbbfd, 0xb955, 0xae68, 0x8180, 0x8000, 0xff23,
  0xb800, 0xb800, 0xb955, 0xae66, 0x8100, 0x8000, 0xff23, 0xfe00,
  0xb7fe, 0xb557, 0xae66, 0x8100, 0x8000, 0xff23, 0xfe00, 0xff23,
  0xb555, 0xaa68, 0x8100, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xaa66, 0x8080, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00,
  0x8080, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xfc00,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xfc00, 0xfc00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xfc00, 0xfc00, 0x7c00,
  0xfe00, 0xff23, 0xfe01, 0xfc00, 0xf602, 0xfc00, 0x7c00, 0x7c00,
  0xff23, 0xfe01, 0xfc00, 0xf402, 0xfc00, 0x7c00, 0x7c00, 0x7c00,
  0xfe01, 0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7c00, 0x7c00, 0x7c00,
  0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7600, 0x4d01, 0x7c00, 0x7c00,
  0xf002, 0xfc00, 0x7c00, 0x7401, 0x4201, 0x4d00, 0x7c00, 0x7c00,
  0xfc00, 0x7c00, 0x7400, 0x4002, 0x4200, 0x4cff, 0x7c00, 0x7c00,
  0x7c00, 0x73ff, 0x4001, 0x4001, 0x41ff, 0x4901, 0x7bff, 0x7c00,
  0x7001, 0x4000, 0x4000, 0x4000, 0x3e01, 0x4900, 0x7bfd, 0x7c00,
  0x3c02, 0x3fff, 0x3ffe, 0x3c02, 0x3e00, 0x48ff, 0x7955, 0x7c00,
  0x3c01, 0x3ffd, 0x3c01, 0x3c01, 0x3dff, 0x46ab, 0x6e66, 0x7c00,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x7e00,
  0x3802, 0x3bff, 0x3bfe, 0x3957, 0x30cd, 0x0901, 0x0000, 0x7f23,
  0x3801, 0x3bfd, 0x3955, 0x2e68, 0x0180, 0x0000, 0x7f23, 0x7e00,
  0x3800, 0x3955, 0x2e66, 0x0100, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x3557, 0x2e66, 0x0100, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x2a68, 0x0100, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00,
  0x0080, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7c00,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7c00, 0x7c00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7c00, 0x7c00, 0xfc00,
  0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7602, 0x7c00, 0xfc00, 0xfc00,
  0x7f23, 0x7e01, 0x7c00, 0x7402, 0x7c00, 0xfc00, 0xfc00, 0xfc00,
  0x7e01, 0x7c00, 0x7401, 0x7c00, 0xfc00, 0xfc00, 0xfc00, 0xfc00,
  0x7c00, 0x7401, 0x7c00, 0xfc00, 0xf600, 0xcd01, 0xfc00, 0xfc00,
  0x7002, 0x7c00, 0xfc00, 0xf401, 0xc201, 0xcd00, 0xfc00, 0xfc00,
  0x7c00, 0xfc00, 0xf400, 0xc002, 0xc200, 0xccff, 0xfc00, 0xfc00,
  0xfc00, 0xf3ff, 0xc001, 0xc001, 0xc1ff, 0xc901, 0xfbff, 0xfc00,
  0xf001, 0xc000, 0xc000, 0xc000, 0xbe01, 0xc900, 0xfbfd, 0xfc00,
  0xbc02, 0xbfff, 0xbffe, 0xbc02, 0xbe00, 0xc8ff, 0xf955, 0xfc00,
  0xbc01, 0xbffd, 0xbc01, 0xbc01, 0xbdff, 0xc6ab, 0xee66, 0xfc00,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0x7e00,
  0xb802, 0xbbff, 0xbbfe, 0xb957, 0xb0cd, 0x8901, 0x8000, 0xff23,
  0xb801, 0xbbfd, 0xb955, 0xae68, 0x8180, 0x8000, 0xff23, 0xfe00,
  0xb800, 0xb955, 0xae66, 0x8100, 0x8000, 0xff23, 0xfe00, 0xff23,
  0xb557, 0xae66, 0x8100, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xaa68, 0x8100, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00,
  0x8080, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xfc00,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xfc00, 0xfc00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xfc00, 0xfc00, 0x7f23,
  0xfe00, 0xff23, 0xfe01, 0xfc00, 0xfc00, 0xfc00, 0x7c00, 0x7f23,
  0xff23, 0xfe01, 0xfc00, 0xf602, 0xfc00, 0x7c00, 0x7c00, 0x7f23,
  0xfe01, 0xfc00, 0xf402, 0xfc00, 0x7c00, 0x7c00, 0x7c00, 0x7f23,
  0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7c00, 0x7c00, 0x7c00, 0x7f23,
  0xf401, 0xfc00, 0x7c00, 0x7600, 0x4d01, 0x7c00, 0x7c00, 0x7f23,
  0xfc00, 0x7c00, 0x7401, 0x4201, 0x4d00, 0x7c00, 0x7c00, 0x7f23,
  0x7c00, 0x7400, 0x4002, 0x4200, 0x4cff, 0x7c00, 0x7c00, 0x7f23,
  0x73ff, 0x4001, 0x4001, 0x41ff, 0x4901, 0x7bff, 0x7c00, 0x7f23,
  0x4000, 0x4000, 0x4000, 0x3e01, 0x4900, 0x7bfd, 0x7c00, 0x7f23,
  0x3fff, 0x3ffe, 0x3c02, 0x3e00, 0x48ff, 0x7955, 0x7c00, 0x7f23,
  0x3ffd, 0x3c01, 0x3c01, 0x3dff, 0x46ab, 0x6e66, 0x7c00, 0x7f23,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x7e00, 0x7f23,
  0x3bff, 0x3bfe, 0x3957, 0x30cd, 0x0901, 0x0000, 0x7f23, 0x7f23,
  0x3bfd, 0x3955, 0x2e68, 0x0180, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x3955, 0x2e66, 0x0100, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x2e66, 0x0100, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23,
  0x0100, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7f23,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7c00, 0x7f23,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7c00, 0x7c00, 0x7f23,
  0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7c00, 0x7c00, 0xfc00, 0x7f23,
  0x7f23, 0x7e01, 0x7c00, 0x7602, 0x7c00, 0xfc00, 0xfc00, 0x7f23,
  0x7e01, 0x7c00, 0x7402, 0x7c00, 0xfc00, 0xfc00, 0xfc00, 0x7f23,
  0x7c00, 0x7401, 0x7c00, 0xfc00, 0xfc00, 0xfc00, 0xfc00, 0x7f23,
  0x7401, 0x7c00, 0xfc00, 0xf600, 0xcd01, 0xfc00, 0xfc00, 0x7f23,
  0x7c00, 0xfc00, 0xf401, 0xc201, 0xcd00, 0xfc00, 0xfc00, 0x7f23,
  0xfc00, 0xf400, 0xc002, 0xc200, 0xccff, 0xfc00, 0xfc00, 0x7f23,
  0xf3ff, 0xc001, 0xc001, 0xc1ff, 0xc901, 0xfbff, 0xfc00, 0x7f23,
  0xc000, 0xc000, 0xc000, 0xbe01, 0xc900, 0xfbfd, 0xfc00, 0x7f23,
  0xbfff, 0xbffe, 0xbc02, 0xbe00, 0xc8ff, 0xf955, 0xfc00, 0x7f23,
  0xbffd, 0xbc01, 0xbc01, 0xbdff, 0xc6ab, 0xee66, 0xfc00, 0x7f23,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0x7e00, 0x7f23,
  0xbbff, 0xbbfe, 0xb957, 0xb0cd, 0x8901, 0x8000, 0xff23, 0x7f23,
  0xbbfd, 0xb955, 0xae68, 0x8180, 0x8000, 0xff23, 0xfe00, 0xff23,
  0xb955, 0xae66, 0x8100, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xae66, 0x8100, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23,
  0x8100, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0x7f23,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xfc00, 0x7f23,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xfc00, 0x7f23, 0x7e00,
  0xfe00, 0xff23, 0xfe01, 0xfc00, 0xfc00, 0xfc00, 0x7f23, 0x7e00,
  0xff23, 0xfe01, 0xfc00, 0xfc00, 0xfc00, 0x7c00, 0x7f23, 0x7e00,
  0xfe01, 0xfc00, 0xf602, 0xfc00, 0x7c00, 0x7c00, 0x7f23, 0x7e00,
  0xfc00, 0xf402, 0xfc00, 0x7c00, 0x7c00, 0x7c00, 0x7f23, 0x7e00,
  0xf401, 0xfc00, 0x7c00, 0x7c00, 0x7c00, 0x7c00, 0x7f23, 0x7e00,
  0xfc00, 0x7c00, 0x7600, 0x4d01, 0x7c00, 0x7c00, 0x7f23, 0x7e00,
  0x7c00, 0x7401, 0x4201, 0x4d00, 0x7c00, 0x7c00, 0x7f23, 0x7e00,
  0x7400, 0x4002, 0x4200, 0x4cff, 0x7c00, 0x7c00, 0x7f23, 0x7e00,
  0x4001, 0x4001, 0x41ff, 0x4901, 0x7bff, 0x7c00, 0x7f23, 0x7e00,
  0x4000, 0x4000, 0x3e01, 0x4900, 0x7bfd, 0x7c00, 0x7f23, 0x7e00,
  0x3ffe, 0x3c02, 0x3e00, 0x48ff, 0x7955, 0x7c00, 0x7f23, 0x7e00,
  0x3c01, 0x3c01, 0x3dff, 0x46ab, 0x6e66, 0x7c00, 0x7f23, 0x7e00,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x7e00, 0x7f23, 0x7e00,
  0x3bfe, 0x3957, 0x30cd, 0x0901, 0x0000, 0x7f23, 0x7f23, 0x7f23,
  0x3955, 0x2e68, 0x0180, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x2e66, 0x0100, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e00,
  0x0100, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e00,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7f23, 0x7e00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7c00, 0x7f23, 0x7e00,
  0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7c00, 0x7c00, 0x7f23, 0x7e00,
  0x7f23, 0x7e01, 0x7c00, 0x7c00, 0x7c00, 0xfc00, 0x7f23, 0x7e00,
  0x7e01, 0x7c00, 0x7602, 0x7c00, 0xfc00, 0xfc00, 0x7f23, 0x7e00,
  0x7c00, 0x7402, 0x7c00, 0xfc00, 0xfc00, 0xfc00, 0x7f23, 0x7e00,
  0x7401, 0x7c00, 0xfc00, 0xfc00, 0xfc00, 0xfc00, 0x7f23, 0x7e00,
  0x7c00, 0xfc00, 0xf600, 0xcd01, 0xfc00, 0xfc00, 0x7f23, 0x7e00,
  0xfc00, 0xf401, 0xc201, 0xcd00, 0xfc00, 0xfc00, 0x7f23, 0x7e00,
  0xf400, 0xc002, 0xc200, 0xccff, 0xfc00, 0xfc00, 0x7f23, 0x7e00,
  0xc001, 0xc001, 0xc1ff, 0xc901, 0xfbff, 0xfc00, 0x7f23, 0x7e00,
  0xc000, 0xc000, 0xbe01, 0xc900, 0xfbfd, 0xfc00, 0x7f23, 0x7e00,
  0xbffe, 0xbc02, 0xbe00, 0xc8ff, 0xf955, 0xfc00, 0x7f23, 0x7e00,
  0xbc01, 0xbc01, 0xbdff, 0xc6ab, 0xee66, 0xfc00, 0x7f23, 0x7e00,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0x7e00, 0x7f23, 0x7e00,
  0xbbfe, 0xb957, 0xb0cd, 0x8901, 0x8000, 0xff23, 0x7f23, 0xff23,
  0xb955, 0xae68, 0x8180, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xae66, 0x8100, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7e00,
  0x8100, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23, 0x7e00,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0x7f23, 0x7e00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0xfe00, 0xff23, 0xfe01, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0xff23, 0xfe01, 0xfc00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0xfe01, 0xfc00, 0xfc00, 0xfc00, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0xfc00, 0xf602, 0xfc00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0xf402, 0xfc00, 0x7c00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0xfc00, 0x7c00, 0x7c00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0x7c00, 0x7600, 0x4d01, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0x7401, 0x4201, 0x4d00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0x4002, 0x4200, 0x4cff, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0x4001, 0x41ff, 0x4901, 0x7bff, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0x4000, 0x3e01, 0x4900, 0x7bfd, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0x3c02, 0x3e00, 0x48ff, 0x7955, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0x3c01, 0x3dff, 0x46ab, 0x6e66, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x7e00, 0x7f23, 0x7e00, 0x7f23,
  0x3957, 0x30cd, 0x0901, 0x0000, 0x7f23, 0x7f23, 0x7f23, 0x7f23,
  0x2e68, 0x0180, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23,
  0x0100, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e00, 0x7f23,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e00, 0x7f23,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0x7f23, 0x7e01, 0x7c00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0x7e01, 0x7c00, 0x7c00, 0x7c00, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0x7c00, 0x7602, 0x7c00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0x7402, 0x7c00, 0xfc00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0x7c00, 0xfc00, 0xfc00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0xfc00, 0xf600, 0xcd01, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0xf401, 0xc201, 0xcd00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0xc002, 0xc200, 0xccff, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0xc001, 0xc1ff, 0xc901, 0xfbff, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0xc000, 0xbe01, 0xc900, 0xfbfd, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0xbc02, 0xbe00, 0xc8ff, 0xf955, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0xbc01, 0xbdff, 0xc6ab, 0xee66, 0xfc00, 0x7f23, 0x7e00, 0x7f23,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0x7e00, 0x7f23, 0x7e00, 0x7f23,
  0xb957, 0xb0cd, 0x8901, 0x8000, 0xff23, 0x7f23, 0xff23, 0x7f23,
  0xae68, 0x8180, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23,
  0x8100, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7e00, 0x7f23,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23, 0x7e00, 0x7f23,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xfe00, 0xff23, 0xfe01, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xff23, 0xfe01, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xfe01, 0xfc00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xfc00, 0xfc00, 0xfc00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xf602, 0xfc00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xfc00, 0x7c00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7c00, 0x7c00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7600, 0x4d01, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x4201, 0x4d00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x4200, 0x4cff, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x41ff, 0x4901, 0x7bff, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x3e01, 0x4900, 0x7bfd, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x3e00, 0x48ff, 0x7955, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x3dff, 0x46ab, 0x6e66, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x3c00, 0x3c00, 0x3c00, 0x7e00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x30cd, 0x0901, 0x0000, 0x7f23, 0x7f23, 0x7f23, 0x7f23, 0x7e01,
  0x0180, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e01,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e00, 0x7f23, 0x7e01,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7f23, 0x7e01, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7e01, 0x7c00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7c00, 0x7c00, 0x7c00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7602, 0x7c00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7c00, 0xfc00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xfc00, 0xfc00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xf600, 0xcd01, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xc201, 0xcd00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xc200, 0xccff, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xc1ff, 0xc901, 0xfbff, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xbe01, 0xc900, 0xfbfd, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xbe00, 0xc8ff, 0xf955, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xbdff, 0xc6ab, 0xee66, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xbc00, 0xbc00, 0xbc00, 0x7e00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xb0cd, 0x8901, 0x8000, 0xff23, 0x7f23, 0xff23, 0x7f23, 0x7e01,
  0x8180, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23, 0x7e01,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7e00, 0x7f23, 0x7e01,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x7e00, 0x7f23, 0x7e01, 0x7c00,
  0xfe00, 0xff23, 0xfe01, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x2480,
  0xff23, 0xfe01, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024,
  0xfe01, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024,
  0xfc00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024,
  0xfc00, 0xfc00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012,
  0xfc00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012,
  0x7c00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012,
  0x7c00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x000c,
  0x4d01, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0002,
  0x4d00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0000,
  0x4cff, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0000,
  0x4901, 0x7bff, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23,
  0x4900, 0x7bfd, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e00,
  0x48ff, 0x7955, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23,
  0x46ab, 0x6e66, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e01,
  0x3c00, 0x3c00, 0x7e00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x3c00,
  0x0901, 0x0000, 0x7f23, 0x7f23, 0x7f23, 0x7f23, 0x7e01, 0x2481,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x4c80,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e00, 0x7f23, 0x7e01, 0xfc00,
  0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xa480,
  0x7f23, 0x7e01, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024,
  0x7e01, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024,
  0x7c00, 0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024,
  0x7c00, 0x7c00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012,
  0x7c00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012,
  0xfc00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012,
  0xfc00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x800c,
  0xcd01, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8002,
  0xcd00, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8000,
  0xccff, 0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8000,
  0xc901, 0xfbff, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23,
  0xc900, 0xfbfd, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe00,
  0xc8ff, 0xf955, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23,
  0xc6ab, 0xee66, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe01,
  0xbc00, 0xbc00, 0x7e00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xbc00,
  0x8901, 0x8000, 0xff23, 0x7f23, 0xff23, 0x7f23, 0x7e01, 0xa481,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23, 0x7e01, 0xcc80,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23, 0x7e01, 0xcc80, 0x7c00,
  0xfe00, 0xff23, 0xfe01, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x3bfe,
  0xff23, 0xfe01, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x2480, 0x07ff,
  0xfe01, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024, 0x07fe,
  0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024, 0x07fc,
  0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024, 0x03ff,
  0xfc00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03fe,
  0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x02aa,
  0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x000c, 0x0066,
  0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0002, 0x0000,
  0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0000, 0x0000,
  0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0000, 0x7f23,
  0x7bff, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e00,
  0x7bfd, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e00, 0x7f23,
  0x7955, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e01,
  0x6e66, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e01, 0x531b,
  0x3c00, 0x7e00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x3c00, 0x3c00,
  0x0000, 0x7f23, 0x7f23, 0x7f23, 0x7f23, 0x7e01, 0x2481, 0x63fe,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x4c80, 0xfc00,
  0x7e00, 0x7f23, 0x7e01, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xbbfe,
  0x7f23, 0x7e01, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xa480, 0x87ff,
  0x7e01, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024, 0x87fe,
  0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024, 0x87fc,
  0x7c00, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024, 0x83ff,
  0x7c00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012, 0x83ff,
  0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012, 0x83fe,
  0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012, 0x82aa,
  0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x800c, 0x8066,
  0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8002, 0x8000,
  0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8000, 0x8000,
  0xfc00, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8000, 0xff23,
  0xfbff, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe00,
  0xfbfd, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe00, 0xff23,
  0xf955, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe01,
  0xee66, 0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe01, 0xd31b,
  0xbc00, 0x7e00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xbc00, 0xbc00,
  0x8000, 0xff23, 0x7f23, 0xff23, 0x7f23, 0x7e01, 0xa481, 0xe3fe,
  0xff23, 0x7f23, 0xff23, 0x7f23, 0x7e01, 0xa481, 0xe3fe, 0x7c00,
  0xfe00, 0xff23, 0xfe01, 0x7f23, 0x7e01, 0xcc80, 0x7c00, 0x1400,
  0xff23, 0xfe01, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x3bfe, 0x0002,
  0xfe01, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x2480, 0x07ff, 0x0002,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024, 0x07fe, 0x0002,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024, 0x07fc, 0x0001,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024, 0x03ff, 0x0001,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03fe, 0x0001,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x02aa, 0x0000,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x000c, 0x0066, 0x0000,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0002, 0x0000, 0x0000,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0000, 0x0000, 0x7f23,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0000, 0x7f23, 0x7e00,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e00, 0x7f23,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e00, 0x7f23, 0x7e01,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x2b1c,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e01, 0x531b, 0x1401,
  0x7e00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x3c00, 0x3c00, 0x3c00,
  0x7f23, 0x7f23, 0x7f23, 0x7f23, 0x7e01, 0x2481, 0x63fe, 0xfc00,
  0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x4c80, 0xfc00, 0x9400,
  0x7f23, 0x7e01, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xbbfe, 0x8002,
  0x7e01, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xa480, 0x87ff, 0x8002,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024, 0x87fe, 0x8002,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024, 0x87fc, 0x8001,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024, 0x83ff, 0x8001,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012, 0x83ff, 0x8001,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012, 0x83fe, 0x8001,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012, 0x82aa, 0x8000,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x800c, 0x8066, 0x8000,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8002, 0x8000, 0x8000,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8000, 0x8000, 0xff23,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8000, 0xff23, 0xfe00,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe00, 0xff23,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe00, 0xff23, 0xfe01,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0xab1c,
  0xfc00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe01, 0xd31b, 0x9401,
  0x7e00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xbc00, 0xbc00, 0xbc00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xbc00, 0xbc00, 0xbc00, 0x7e00,
  0x7f23, 0xff23, 0x7f23, 0x7e01, 0xa481, 0xe3fe, 0x7c00, 0x8000,
  0xff23, 0xfe01, 0x7f23, 0x7e01, 0xcc80, 0x7c00, 0x1400, 0x8000,
  0xfe01, 0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x3bfe, 0x0002, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x2480, 0x07ff, 0x0002, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024, 0x07fe, 0x0002, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024, 0x07fc, 0x0001, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0024, 0x03ff, 0x0001, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03fe, 0x0001, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x02aa, 0x0000, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x000c, 0x0066, 0x0000, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0002, 0x0000, 0x0000, 0x7f23,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0000, 0x0000, 0x7f23, 0x7e00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e00, 0x7f23, 0x7e01, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x2b1c, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x7e01, 0x531b, 0x1401, 0x8000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x3c00, 0x3c00, 0x3c00, 0x7e00,
  0x7f23, 0x7f23, 0x7f23, 0x7e01, 0x2481, 0x63fe, 0xfc00, 0x0000,
  0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x4c80, 0xfc00, 0x9400, 0x0000,
  0x7e01, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xbbfe, 0x8002, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xa480, 0x87ff, 0x8002, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024, 0x87fe, 0x8002, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024, 0x87fc, 0x8001, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8024, 0x83ff, 0x8001, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012, 0x83ff, 0x8001, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012, 0x83fe, 0x8001, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8012, 0x82aa, 0x8000, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x800c, 0x8066, 0x8000, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8002, 0x8000, 0x8000, 0xff23,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8000, 0x8000, 0xff23, 0xfe00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x8000, 0xff23, 0xfe00, 0xff23,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe00, 0xff23, 0xfe01, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0xab1c, 0x0000,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe01, 0xd31b, 0x9401, 0x0000,
  0x7e00, 0x7f23, 0x7e01, 0xfe01, 0xd31b, 0x9401, 0x0000, 0xfc00,
  0x7e00, 0x7f23, 0x7e01, 0xbc00, 0xbc00, 0xbc00, 0x7e00, 0xbc00,
  0xff23, 0x7f23, 0x7e01, 0xa481, 0xe3fe, 0x7c00, 0x8000, 0x8801,
  0xfe01, 0x7f23, 0x7e01, 0xcc80, 0x7c00, 0x1400, 0x8000, 0x8800,
  0x7e00, 0x7f23, 0x7e01, 0x7c00, 0x3bfe, 0x0002, 0x8000, 0x87fe,
  0x7e00, 0x7f23, 0x7e01, 0x2480, 0x07ff, 0x0002, 0x8000, 0x8401,
  0x7e00, 0x7f23, 0x7e01, 0x0024, 0x07fe, 0x0002, 0x8000, 0x8400,
  0x7e00, 0x7f23, 0x7e01, 0x0024, 0x07fc, 0x0001, 0x8000, 0x83ff,
  0x7e00, 0x7f23, 0x7e01, 0x0024, 0x03ff, 0x0001, 0x8000, 0x82ab,
  0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8066,
  0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03fe, 0x0001, 0x8000, 0x8000,
  0x7e00, 0x7f23, 0x7e01, 0x0012, 0x02aa, 0x0000, 0x8000, 0x8000,
  0x7e00, 0x7f23, 0x7e01, 0x000c, 0x0066, 0x0000, 0x8000, 0x7f23,
  0x7e00, 0x7f23, 0x7e01, 0x0002, 0x0000, 0x0000, 0x7f23, 0x7e00,
  0x7e00, 0x7f23, 0x7e01, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x7e00, 0x7f23, 0x7e01, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xd31c,
  0x7e00, 0x7f23, 0x7e01, 0x7e00, 0x7f23, 0x7e01, 0x8000, 0xbc01,
  0x7e00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x2b1c, 0x8000, 0xe400,
  0x7e00, 0x7f23, 0x7e01, 0x7e01, 0x531b, 0x1401, 0x8000, 0x7c00,
  0x7e00, 0x7f23, 0x7e01, 0x3c00, 0x3c00, 0x3c00, 0x7e00, 0x3c00,
  0x7f23, 0x7f23, 0x7e01, 0x2481, 0x63fe, 0xfc00, 0x0000, 0x0801,
  0x7e01, 0x7f23, 0x7e01, 0x4c80, 0xfc00, 0x9400, 0x0000, 0x0800,
  0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xbbfe, 0x8002, 0x0000, 0x07fe,
  0x7e00, 0x7f23, 0x7e01, 0xa480, 0x87ff, 0x8002, 0x0000, 0x0401,
  0x7e00, 0x7f23, 0x7e01, 0x8024, 0x87fe, 0x8002, 0x0000, 0x0400,
  0x7e00, 0x7f23, 0x7e01, 0x8024, 0x87fc, 0x8001, 0x0000, 0x03ff,
  0x7e00, 0x7f23, 0x7e01, 0x8024, 0x83ff, 0x8001, 0x0000, 0x02ab,
  0x7e00, 0x7f23, 0x7e01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0066,
  0x7e00, 0x7f23, 0x7e01, 0x8012, 0x83fe, 0x8001, 0x0000, 0x0000,
  0x7e00, 0x7f23, 0x7e01, 0x8012, 0x82aa, 0x8000, 0x0000, 0x0000,
  0x7e00, 0x7f23, 0x7e01, 0x800c, 0x8066, 0x8000, 0x0000, 0xff23,
  0x7e00, 0x7f23, 0x7e01, 0x8002, 0x8000, 0x8000, 0xff23, 0xfe00,
  0x7e00, 0x7f23, 0x7e01, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23,
  0x7e00, 0x7f23, 0x7e01, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x531c,
  0x7e00, 0x7f23, 0x7e01, 0xfe00, 0xff23, 0xfe01, 0x0000, 0x3c01,
  0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0xab1c, 0x0000, 0x6400,
  0x7f23, 0x7e01, 0xff23, 0xfe01, 0xab1c, 0x0000, 0x6400, 0xfc00,
  0x7f23, 0x7e01, 0xfe01, 0xd31b, 0x9401, 0x0000, 0xfc00, 0xefff,
  0x7f23, 0x7e01, 0xbc00, 0xbc00, 0xbc00, 0x7e00, 0xbc00, 0xbc00,
  0x7f23, 0x7e01, 0xa481, 0xe3fe, 0x7c00, 0x8000, 0x8801, 0xbbff,
  0x7f23, 0x7e01, 0xcc80, 0x7c00, 0x1400, 0x8000, 0x8800, 0xbbfd,
  0x7f23, 0x7e01, 0x7c00, 0x3bfe, 0x0002, 0x8000, 0x87fe, 0xb800,
  0x7f23, 0x7e01, 0x2480, 0x07ff, 0x0002, 0x8000, 0x8401, 0xb7ff,
  0x7f23, 0x7e01, 0x0024, 0x07fe, 0x0002, 0x8000, 0x8400, 0xb7fd,
  0x7f23, 0x7e01, 0x0024, 0x07fc, 0x0001, 0x8000, 0x83ff, 0xb555,
  0x7f23, 0x7e01, 0x0024, 0x03ff, 0x0001, 0x8000, 0x82ab, 0xaa66,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8066, 0x8080,
  0x7f23, 0x7e01, 0x0012, 0x03fe, 0x0001, 0x8000, 0x8000, 0x8000,
  0x7f23, 0x7e01, 0x0012, 0x02aa, 0x0000, 0x8000, 0x8000, 0x7f23,
  0x7f23, 0x7e01, 0x000c, 0x0066, 0x0000, 0x8000, 0x7f23, 0x7e00,
  0x7f23, 0x7e01, 0x0002, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23,
  0x7f23, 0x7e01, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7f23, 0x7e01, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00,
  0x7f23, 0x7e01, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xd31c, 0xf001,
  0x7f23, 0x7e01, 0x7e00, 0x7f23, 0x7e01, 0x8000, 0xbc01, 0xfc00,
  0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x2b1c, 0x8000, 0xe400, 0x7c00,
  0x7f23, 0x7e01, 0x7e01, 0x531b, 0x1401, 0x8000, 0x7c00, 0x6fff,
  0x7f23, 0x7e01, 0x3c00, 0x3c00, 0x3c00, 0x7e00, 0x3c00, 0x3c00,
  0x7f23, 0x7e01, 0x2481, 0x63fe, 0xfc00, 0x0000, 0x0801, 0x3bff,
  0x7f23, 0x7e01, 0x4c80, 0xfc00, 0x9400, 0x0000, 0x0800, 0x3bfd,
  0x7f23, 0x7e01, 0xfc00, 0xbbfe, 0x8002, 0x0000, 0x07fe, 0x3800,
  0x7f23, 0x7e01, 0xa480, 0x87ff, 0x8002, 0x0000, 0x0401, 0x37ff,
  0x7f23, 0x7e01, 0x8024, 0x87fe, 0x8002, 0x0000, 0x0400, 0x37fd,
  0x7f23, 0x7e01, 0x8024, 0x87fc, 0x8001, 0x0000, 0x03ff, 0x3555,
  0x7f23, 0x7e01, 0x8024, 0x83ff, 0x8001, 0x0000, 0x02ab, 0x2a66,
  0x7f23, 0x7e01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0066, 0x0080,
  0x7f23, 0x7e01, 0x8012, 0x83fe, 0x8001, 0x0000, 0x0000, 0x0000,
  0x7f23, 0x7e01, 0x8012, 0x82aa, 0x8000, 0x0000, 0x0000, 0xff23,
  0x7f23, 0x7e01, 0x800c, 0x8066, 0x8000, 0x0000, 0xff23, 0xfe00,
  0x7f23, 0x7e01, 0x8002, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23,
  0x7f23, 0x7e01, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7f23, 0x7e01, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00,
  0x7f23, 0x7e01, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x531c, 0x7001,
  0x7f23, 0x7e01, 0xfe00, 0xff23, 0xfe01, 0x0000, 0x3c01, 0x7c00,
  0x7e01, 0xfe00, 0xff23, 0xfe01, 0x0000, 0x3c01, 0x7c00, 0xfc00,
  0x7e01, 0xff23, 0xfe01, 0xab1c, 0x0000, 0x6400, 0xfc00, 0xf000,
  0x7e01, 0xfe01, 0xd31b, 0x9401, 0x0000, 0xfc00, 0xefff, 0xbc01,
  0x7e01, 0xbc00, 0xbc00, 0xbc00, 0x7e00, 0xbc00, 0xbc00, 0xbc00,
  0x7e01, 0xa481, 0xe3fe, 0x7c00, 0x8000, 0x8801, 0xbbff, 0xbbfe,
  0x7e01, 0xcc80, 0x7c00, 0x1400, 0x8000, 0x8800, 0xbbfd, 0xb801,
  0x7e01, 0x7c00, 0x3bfe, 0x0002, 0x8000, 0x87fe, 0xb800, 0xb800,
  0x7e01, 0x2480, 0x07ff, 0x0002, 0x8000, 0x8401, 0xb7ff, 0xb7fe,
  0x7e01, 0x0024, 0x07fe, 0x0002, 0x8000, 0x8400, 0xb7fd, 0xb555,
  0x7e01, 0x0024, 0x07fc, 0x0001, 0x8000, 0x83ff, 0xb555, 0xaa66,
  0x7e01, 0x0024, 0x03ff, 0x0001, 0x8000, 0x82ab, 0xaa66, 0x8080,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8066, 0x8080, 0x8000,
  0x7e01, 0x0012, 0x03fe, 0x0001, 0x8000, 0x8000, 0x8000, 0x7f23,
  0x7e01, 0x0012, 0x02aa, 0x0000, 0x8000, 0x8000, 0x7f23, 0x7e00,
  0x7e01, 0x000c, 0x0066, 0x0000, 0x8000, 0x7f23, 0x7e00, 0x7f23,
  0x7e01, 0x0002, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x7e01, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00,
  0x7e01, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf001,
  0x7e01, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xd31c, 0xf001, 0xfc00,
  0x7e01, 0x7e00, 0x7f23, 0x7e01, 0x8000, 0xbc01, 0xfc00, 0x7c00,
  0x7e01, 0x7f23, 0x7e01, 0x2b1c, 0x8000, 0xe400, 0x7c00, 0x7000,
  0x7e01, 0x7e01, 0x531b, 0x1401, 0x8000, 0x7c00, 0x6fff, 0x3c01,
  0x7e01, 0x3c00, 0x3c00, 0x3c00, 0x7e00, 0x3c00, 0x3c00, 0x3c00,
  0x7e01, 0x2481, 0x63fe, 0xfc00, 0x0000, 0x0801, 0x3bff, 0x3bfe,
  0x7e01, 0x4c80, 0xfc00, 0x9400, 0x0000, 0x0800, 0x3bfd, 0x3801,
  0x7e01, 0xfc00, 0xbbfe, 0x8002, 0x0000, 0x07fe, 0x3800, 0x3800,
  0x7e01, 0xa480, 0x87ff, 0x8002, 0x0000, 0x0401, 0x37ff, 0x37fe,
  0x7e01, 0x8024, 0x87fe, 0x8002, 0x0000, 0x0400, 0x37fd, 0x3555,
  0x7e01, 0x8024, 0x87fc, 0x8001, 0x0000, 0x03ff, 0x3555, 0x2a66,
  0x7e01, 0x8024, 0x83ff, 0x8001, 0x0000, 0x02ab, 0x2a66, 0x0080,
  0x7e01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0066, 0x0080, 0x0000,
  0x7e01, 0x8012, 0x83fe, 0x8001, 0x0000, 0x0000, 0x0000, 0xff23,
  0x7e01, 0x8012, 0x82aa, 0x8000, 0x0000, 0x0000, 0xff23, 0xfe00,
  0x7e01, 0x800c, 0x8066, 0x8000, 0x0000, 0xff23, 0xfe00, 0xff23,
  0x7e01, 0x8002, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7e01, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00,
  0x7e01, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7001,
  0x7e01, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x531c, 0x7001, 0x7c00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x531c, 0x7001, 0x7c00, 0xfc00,
  0xfe00, 0xff23, 0xfe01, 0x0000, 0x3c01, 0x7c00, 0xfc00, 0xf001,
  0xff23, 0xfe01, 0xab1c, 0x0000, 0x6400, 0xfc00, 0xf000, 0xbc02,
  0xfe01, 0xd31b, 0x9401, 0x0000, 0xfc00, 0xefff, 0xbc01, 0xbc01,
  0xbc00, 0xbc00, 0xbc00, 0x7e00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0xa481, 0xe3fe, 0x7c00, 0x8000, 0x8801, 0xbbff, 0xbbfe, 0xb802,
  0xcc80, 0x7c00, 0x1400, 0x8000, 0x8800, 0xbbfd, 0xb801, 0xb801,
  0x7c00, 0x3bfe, 0x0002, 0x8000, 0x87fe, 0xb800, 0xb800, 0xb800,
  0x2480, 0x07ff, 0x0002, 0x8000, 0x8401, 0xb7ff, 0xb7fe, 0xb557,
  0x0024, 0x07fe, 0x0002, 0x8000, 0x8400, 0xb7fd, 0xb555, 0xaa68,
  0x0024, 0x07fc, 0x0001, 0x8000, 0x83ff, 0xb555, 0xaa66, 0x8080,
  0x0024, 0x03ff, 0x0001, 0x8000, 0x82ab, 0xaa66, 0x8080, 0x8000,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8066, 0x8080, 0x8000, 0x7f23,
  0x0012, 0x03fe, 0x0001, 0x8000, 0x8000, 0x8000, 0x7f23, 0x7e00,
  0x0012, 0x02aa, 0x0000, 0x8000, 0x8000, 0x7f23, 0x7e00, 0x7f23,
  0x000c, 0x0066, 0x0000, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x0002, 0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00,
  0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf002,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf001, 0xfc00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xd31c, 0xf001, 0xfc00, 0x7c00,
  0x7e00, 0x7f23, 0x7e01, 0x8000, 0xbc01, 0xfc00, 0x7c00, 0x7001,
  0x7f23, 0x7e01, 0x2b1c, 0x8000, 0xe400, 0x7c00, 0x7000, 0x3c02,
  0x7e01, 0x531b, 0x1401, 0x8000, 0x7c00, 0x6fff, 0x3c01, 0x3c01,
  0x3c00, 0x3c00, 0x3c00, 0x7e00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x2481, 0x63fe, 0xfc00, 0x0000, 0x0801, 0x3bff, 0x3bfe, 0x3802,
  0x4c80, 0xfc00, 0x9400, 0x0000, 0x0800, 0x3bfd, 0x3801, 0x3801,
  0xfc00, 0xbbfe, 0x8002, 0x0000, 0x07fe, 0x3800, 0x3800, 0x3800,
  0xa480, 0x87ff, 0x8002, 0x0000, 0x0401, 0x37ff, 0x37fe, 0x3557,
  0x8024, 0x87fe, 0x8002, 0x0000, 0x0400, 0x37fd, 0x3555, 0x2a68,
  0x8024, 0x87fc, 0x8001, 0x0000, 0x03ff, 0x3555, 0x2a66, 0x0080,
  0x8024, 0x83ff, 0x8001, 0x0000, 0x02ab, 0x2a66, 0x0080, 0x0000,
  0x8012, 0x83ff, 0x8001, 0x0000, 0x0066, 0x0080, 0x0000, 0xff23,
  0x8012, 0x83fe, 0x8001, 0x0000, 0x0000, 0x0000, 0xff23, 0xfe00,
  0x8012, 0x82aa, 0x8000, 0x0000, 0x0000, 0xff23, 0xfe00, 0xff23,
  0x800c, 0x8066, 0x8000, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x8002, 0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00,
  0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7002,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7001, 0x7c00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7001, 0x7c00, 0xfc00,
  0xfe00, 0xff23, 0xfe01, 0x531c, 0x7001, 0x7c00, 0xfc00, 0xf3ff,
  0xff23, 0xfe01, 0x0000, 0x3c01, 0x7c00, 0xfc00, 0xf001, 0xc000,
  0xfe01, 0xab1c, 0x0000, 0x6400, 0xfc00, 0xf000, 0xbc02, 0xbfff,
  0xd31b, 0x9401, 0x0000, 0xfc00, 0xefff, 0xbc01, 0xbc01, 0xbffd,
  0xbc00, 0xbc00, 0x7e00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0xe3fe, 0x7c00, 0x8000, 0x8801, 0xbbff, 0xbbfe, 0xb802, 0xbbff,
  0x7c00, 0x1400, 0x8000, 0x8800, 0xbbfd, 0xb801, 0xb801, 0xbbfd,
  0x3bfe, 0x0002, 0x8000, 0x87fe, 0xb800, 0xb800, 0xb800, 0xb955,
  0x07ff, 0x0002, 0x8000, 0x8401, 0xb7ff, 0xb7fe, 0xb557, 0xae66,
  0x07fe, 0x0002, 0x8000, 0x8400, 0xb7fd, 0xb555, 0xaa68, 0x8100,
  0x07fc, 0x0001, 0x8000, 0x83ff, 0xb555, 0xaa66, 0x8080, 0x8000,
  0x03ff, 0x0001, 0x8000, 0x82ab, 0xaa66, 0x8080, 0x8000, 0x7f23,
  0x03ff, 0x0001, 0x8000, 0x8066, 0x8080, 0x8000, 0x7f23, 0x7e00,
  0x03fe, 0x0001, 0x8000, 0x8000, 0x8000, 0x7f23, 0x7e00, 0x7f23,
  0x02aa, 0x0000, 0x8000, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x0066, 0x0000, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00,
  0x0000, 0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf401,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf002, 0xfc00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf001, 0xfc00, 0x7c00,
  0x7e00, 0x7f23, 0x7e01, 0xd31c, 0xf001, 0xfc00, 0x7c00, 0x73ff,
  0x7f23, 0x7e01, 0x8000, 0xbc01, 0xfc00, 0x7c00, 0x7001, 0x4000,
  0x7e01, 0x2b1c, 0x8000, 0xe400, 0x7c00, 0x7000, 0x3c02, 0x3fff,
  0x531b, 0x1401, 0x8000, 0x7c00, 0x6fff, 0x3c01, 0x3c01, 0x3ffd,
  0x3c00, 0x3c00, 0x7e00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x63fe, 0xfc00, 0x0000, 0x0801, 0x3bff, 0x3bfe, 0x3802, 0x3bff,
  0xfc00, 0x9400, 0x0000, 0x0800, 0x3bfd, 0x3801, 0x3801, 0x3bfd,
  0xbbfe, 0x8002, 0x0000, 0x07fe, 0x3800, 0x3800, 0x3800, 0x3955,
  0x87ff, 0x8002, 0x0000, 0x0401, 0x37ff, 0x37fe, 0x3557, 0x2e66,
  0x87fe, 0x8002, 0x0000, 0x0400, 0x37fd, 0x3555, 0x2a68, 0x0100,
  0x87fc, 0x8001, 0x0000, 0x03ff, 0x3555, 0x2a66, 0x0080, 0x0000,
  0x83ff, 0x8001, 0x0000, 0x02ab, 0x2a66, 0x0080, 0x0000, 0xff23,
  0x83ff, 0x8001, 0x0000, 0x0066, 0x0080, 0x0000, 0xff23, 0xfe00,
  0x83fe, 0x8001, 0x0000, 0x0000, 0x0000, 0xff23, 0xfe00, 0xff23,
  0x82aa, 0x8000, 0x0000, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x8066, 0x8000, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00,
  0x8000, 0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7401,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7002, 0x7c00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7002, 0x7c00, 0xfc00,
  0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7001, 0x7c00, 0xfc00, 0xf400,
  0xff23, 0xfe01, 0x531c, 0x7001, 0x7c00, 0xfc00, 0xf3ff, 0xc001,
  0xfe01, 0x0000, 0x3c01, 0x7c00, 0xfc00, 0xf001, 0xc000, 0xc000,
  0xab1c, 0x0000, 0x6400, 0xfc00, 0xf000, 0xbc02, 0xbfff, 0xbffe,
  0x9401, 0x0000, 0xfc00, 0xefff, 0xbc01, 0xbc01, 0xbffd, 0xbc01,
  0xbc00, 0x7e00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0x7c00, 0x8000, 0x8801, 0xbbff, 0xbbfe, 0xb802, 0xbbff, 0xbbfe,
  0x1400, 0x8000, 0x8800, 0xbbfd, 0xb801, 0xb801, 0xbbfd, 0xb955,
  0x0002, 0x8000, 0x87fe, 0xb800, 0xb800, 0xb800, 0xb955, 0xae66,
  0x0002, 0x8000, 0x8401, 0xb7ff, 0xb7fe, 0xb557, 0xae66, 0x8100,
  0x0002, 0x8000, 0x8400, 0xb7fd, 0xb555, 0xaa68, 0x8100, 0x8000,
  0x0001, 0x8000, 0x83ff, 0xb555, 0xaa66, 0x8080, 0x8000, 0x7f23,
  0x0001, 0x8000, 0x82ab, 0xaa66, 0x8080, 0x8000, 0x7f23, 0x7e00,
  0x0001, 0x8000, 0x8066, 0x8080, 0x8000, 0x7f23, 0x7e00, 0x7f23,
  0x0001, 0x8000, 0x8000, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x0000, 0x8000, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00,
  0x0000, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf401,
  0x0000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf401, 0xfc00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf002, 0xfc00, 0x7c00,
  0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf001, 0xfc00, 0x7c00, 0x7400,
  0x7f23, 0x7e01, 0xd31c, 0xf001, 0xfc00, 0x7c00, 0x73ff, 0x4001,
  0x7e01, 0x8000, 0xbc01, 0xfc00, 0x7c00, 0x7001, 0x4000, 0x4000,
  0x2b1c, 0x8000, 0xe400, 0x7c00, 0x7000, 0x3c02, 0x3fff, 0x3ffe,
  0x1401, 0x8000, 0x7c00, 0x6fff, 0x3c01, 0x3c01, 0x3ffd, 0x3c01,
  0x3c00, 0x7e00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0xfc00, 0x0000, 0x0801, 0x3bff, 0x3bfe, 0x3802, 0x3bff, 0x3bfe,
  0x9400, 0x0000, 0x0800, 0x3bfd, 0x3801, 0x3801, 0x3bfd, 0x3955,
  0x8002, 0x0000, 0x07fe, 0x3800, 0x3800, 0x3800, 0x3955, 0x2e66,
  0x8002, 0x0000, 0x0401, 0x37ff, 0x37fe, 0x3557, 0x2e66, 0x0100,
  0x8002, 0x0000, 0x0400, 0x37fd, 0x3555, 0x2a68, 0x0100, 0x0000,
  0x8001, 0x0000, 0x03ff, 0x3555, 0x2a66, 0x0080, 0x0000, 0xff23,
  0x8001, 0x0000, 0x02ab, 0x2a66, 0x0080, 0x0000, 0xff23, 0xfe00,
  0x8001, 0x0000, 0x0066, 0x0080, 0x0000, 0xff23, 0xfe00, 0xff23,
  0x8001, 0x0000, 0x0000, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x8000, 0x0000, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00,
  0x8000, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7401,
  0x8000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7401, 0x7c00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7401, 0x7c00, 0xfc00,
  0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7002, 0x7c00, 0xfc00, 0xf401,
  0xff23, 0xfe01, 0x7c00, 0x7001, 0x7c00, 0xfc00, 0xf400, 0xc002,
  0xfe01, 0x531c, 0x7001, 0x7c00, 0xfc00, 0xf3ff, 0xc001, 0xc001,
  0x0000, 0x3c01, 0x7c00, 0xfc00, 0xf001, 0xc000, 0xc000, 0xc000,
  0x0000, 0x6400, 0xfc00, 0xf000, 0xbc02, 0xbfff, 0xbffe, 0xbc02,
  0x0000, 0xfc00, 0xefff, 0xbc01, 0xbc01, 0xbffd, 0xbc01, 0xbc01,
  0x7e00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0x8000, 0x8801, 0xbbff, 0xbbfe, 0xb802, 0xbbff, 0xbbfe, 0xb957,
  0x8000, 0x8800, 0xbbfd, 0xb801, 0xb801, 0xbbfd, 0xb955, 0xae68,
  0x8000, 0x87fe, 0xb800, 0xb800, 0xb800, 0xb955, 0xae66, 0x8100,
  0x8000, 0x8401, 0xb7ff, 0xb7fe, 0xb557, 0xae66, 0x8100, 0x8000,
  0x8000, 0x8400, 0xb7fd, 0xb555, 0xaa68, 0x8100, 0x8000, 0x7f23,
  0x8000, 0x83ff, 0xb555, 0xaa66, 0x8080, 0x8000, 0x7f23, 0x7e00,
  0x8000, 0x82ab, 0xaa66, 0x8080, 0x8000, 0x7f23, 0x7e00, 0x7f23,
  0x8000, 0x8066, 0x8080, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x8000, 0x8000, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00,
  0x8000, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf402,
  0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf401, 0xfc00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf401, 0xfc00, 0x7c00,
  0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf002, 0xfc00, 0x7c00, 0x7401,
  0x7f23, 0x7e01, 0xfc00, 0xf001, 0xfc00, 0x7c00, 0x7400, 0x4002,
  0x7e01, 0xd31c, 0xf001, 0xfc00, 0x7c00, 0x73ff, 0x4001, 0x4001,
  0x8000, 0xbc01, 0xfc00, 0x7c00, 0x7001, 0x4000, 0x4000, 0x4000,
  0x8000, 0xe400, 0x7c00, 0x7000, 0x3c02, 0x3fff, 0x3ffe, 0x3c02,
  0x8000, 0x7c00, 0x6fff, 0x3c01, 0x3c01, 0x3ffd, 0x3c01, 0x3c01,
  0x7e00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x0000, 0x0801, 0x3bff, 0x3bfe, 0x3802, 0x3bff, 0x3bfe, 0x3957,
  0x0000, 0x0800, 0x3bfd, 0x3801, 0x3801, 0x3bfd, 0x3955, 0x2e68,
  0x0000, 0x07fe, 0x3800, 0x3800, 0x3800, 0x3955, 0x2e66, 0x0100,
  0x0000, 0x0401, 0x37ff, 0x37fe, 0x3557, 0x2e66, 0x0100, 0x0000,
  0x0000, 0x0400, 0x37fd, 0x3555, 0x2a68, 0x0100, 0x0000, 0xff23,
  0x0000, 0x03ff, 0x3555, 0x2a66, 0x0080, 0x0000, 0xff23, 0xfe00,
  0x0000, 0x02ab, 0x2a66, 0x0080, 0x0000, 0xff23, 0xfe00, 0xff23,
  0x0000, 0x0066, 0x0080, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x0000, 0x0000, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00,
  0x0000, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7402,
  0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7401, 0x7c00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7401, 0x7c00, 0xfc00,
  0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7401, 0x7c00, 0xfc00, 0xf600,
  0xff23, 0xfe01, 0x7c00, 0x7002, 0x7c00, 0xfc00, 0xf401, 0xc201,
  0xfe01, 0x7c00, 0x7001, 0x7c00, 0xfc00, 0xf400, 0xc002, 0xc200,
  0x531c, 0x7001, 0x7c00, 0xfc00, 0xf3ff, 0xc001, 0xc001, 0xc1ff,
  0x3c01, 0x7c00, 0xfc00, 0xf001, 0xc000, 0xc000, 0xc000, 0xbe01,
  0x6400, 0xfc00, 0xf000, 0xbc02, 0xbfff, 0xbffe, 0xbc02, 0xbe00,
  0xfc00, 0xefff, 0xbc01, 0xbc01, 0xbffd, 0xbc01, 0xbc01, 0xbdff,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0x8801, 0xbbff, 0xbbfe, 0xb802, 0xbbff, 0xbbfe, 0xb957, 0xb0cd,
  0x8800, 0xbbfd, 0xb801, 0xb801, 0xbbfd, 0xb955, 0xae68, 0x8180,
  0x87fe, 0xb800, 0xb800, 0xb800, 0xb955, 0xae66, 0x8100, 0x8000,
  0x8401, 0xb7ff, 0xb7fe, 0xb557, 0xae66, 0x8100, 0x8000, 0x7f23,
  0x8400, 0xb7fd, 0xb555, 0xaa68, 0x8100, 0x8000, 0x7f23, 0x7e00,
  0x83ff, 0xb555, 0xaa66, 0x8080, 0x8000, 0x7f23, 0x7e00, 0x7f23,
  0x82ab, 0xaa66, 0x8080, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x8066, 0x8080, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00,
  0x8000, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf602,
  0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf402, 0xfc00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf401, 0xfc00, 0x7c00,
  0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7600,
  0x7f23, 0x7e01, 0xfc00, 0xf002, 0xfc00, 0x7c00, 0x7401, 0x4201,
  0x7e01, 0xfc00, 0xf001, 0xfc00, 0x7c00, 0x7400, 0x4002, 0x4200,
  0xd31c, 0xf001, 0xfc00, 0x7c00, 0x73ff, 0x4001, 0x4001, 0x41ff,
  0xbc01, 0xfc00, 0x7c00, 0x7001, 0x4000, 0x4000, 0x4000, 0x3e01,
  0xe400, 0x7c00, 0x7000, 0x3c02, 0x3fff, 0x3ffe, 0x3c02, 0x3e00,
  0x7c00, 0x6fff, 0x3c01, 0x3c01, 0x3ffd, 0x3c01, 0x3c01, 0x3dff,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x0801, 0x3bff, 0x3bfe, 0x3802, 0x3bff, 0x3bfe, 0x3957, 0x30cd,
  0x0800, 0x3bfd, 0x3801, 0x3801, 0x3bfd, 0x3955, 0x2e68, 0x0180,
  0x07fe, 0x3800, 0x3800, 0x3800, 0x3955, 0x2e66, 0x0100, 0x0000,
  0x0401, 0x37ff, 0x37fe, 0x3557, 0x2e66, 0x0100, 0x0000, 0xff23,
  0x0400, 0x37fd, 0x3555, 0x2a68, 0x0100, 0x0000, 0xff23, 0xfe00,
  0x03ff, 0x3555, 0x2a66, 0x0080, 0x0000, 0xff23, 0xfe00, 0xff23,
  0x02ab, 0x2a66, 0x0080, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x0066, 0x0080, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00,
  0x0000, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7602,
  0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7402, 0x7c00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7402, 0x7c00, 0xfc00,
  0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7401, 0x7c00, 0xfc00, 0xfc00,
  0xff23, 0xfe01, 0x7c00, 0x7401, 0x7c00, 0xfc00, 0xf600, 0xcd01,
  0xfe01, 0x7c00, 0x7002, 0x7c00, 0xfc00, 0xf401, 0xc201, 0xcd00,
  0x7c00, 0x7001, 0x7c00, 0xfc00, 0xf400, 0xc002, 0xc200, 0xccff,
  0x7001, 0x7c00, 0xfc00, 0xf3ff, 0xc001, 0xc001, 0xc1ff, 0xc901,
  0x7c00, 0xfc00, 0xf001, 0xc000, 0xc000, 0xc000, 0xbe01, 0xc900,
  0xfc00, 0xf000, 0xbc02, 0xbfff, 0xbffe, 0xbc02, 0xbe00, 0xc8ff,
  0xefff, 0xbc01, 0xbc01, 0xbffd, 0xbc01, 0xbc01, 0xbdff, 0xc6ab,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0xbbff, 0xbbfe, 0xb802, 0xbbff, 0xbbfe, 0xb957, 0xb0cd, 0x8901,
  0xbbfd, 0xb801, 0xb801, 0xbbfd, 0xb955, 0xae68, 0x8180, 0x8000,
  0xb800, 0xb800, 0xb800, 0xb955, 0xae66, 0x8100, 0x8000, 0x7f23,
  0xb7ff, 0xb7fe, 0xb557, 0xae66, 0x8100, 0x8000, 0x7f23, 0x7e00,
  0xb7fd, 0xb555, 0xaa68, 0x8100, 0x8000, 0x7f23, 0x7e00, 0x7f23,
  0xb555, 0xaa66, 0x8080, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xaa66, 0x8080, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00,
  0x8080, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xfc00,
  0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf602, 0xfc00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf402, 0xfc00, 0x7c00,
  0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7c00,
  0x7f23, 0x7e01, 0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7600, 0x4d01,
  0x7e01, 0xfc00, 0xf002, 0xfc00, 0x7c00, 0x7401, 0x4201, 0x4d00,
  0xfc00, 0xf001, 0xfc00, 0x7c00, 0x7400, 0x4002, 0x4200, 0x4cff,
  0xf001, 0xfc00, 0x7c00, 0x73ff, 0x4001, 0x4001, 0x41ff, 0x4901,
  0xfc00, 0x7c00, 0x7001, 0x4000, 0x4000, 0x4000, 0x3e01, 0x4900,
  0x7c00, 0x7000, 0x3c02, 0x3fff, 0x3ffe, 0x3c02, 0x3e00, 0x48ff,
  0x6fff, 0x3c01, 0x3c01, 0x3ffd, 0x3c01, 0x3c01, 0x3dff, 0x46ab,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x3bff, 0x3bfe, 0x3802, 0x3bff, 0x3bfe, 0x3957, 0x30cd, 0x0901,
  0x3bfd, 0x3801, 0x3801, 0x3bfd, 0x3955, 0x2e68, 0x0180, 0x0000,
  0x3800, 0x3800, 0x3800, 0x3955, 0x2e66, 0x0100, 0x0000, 0xff23,
  0x37ff, 0x37fe, 0x3557, 0x2e66, 0x0100, 0x0000, 0xff23, 0xfe00,
  0x37fd, 0x3555, 0x2a68, 0x0100, 0x0000, 0xff23, 0xfe00, 0xff23,
  0x3555, 0x2a66, 0x0080, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x2a66, 0x0080, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00,
  0x0080, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7c00,
  0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7602, 0x7c00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7602, 0x7c00, 0xfc00,
  0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7402, 0x7c00, 0xfc00, 0xfc00,
  0xff23, 0xfe01, 0x7c00, 0x7401, 0x7c00, 0xfc00, 0xfc00, 0xfc00,
  0xfe01, 0x7c00, 0x7401, 0x7c00, 0xfc00, 0xf600, 0xcd01, 0xfc00,
  0x7c00, 0x7002, 0x7c00, 0xfc00, 0xf401, 0xc201, 0xcd00, 0xfc00,
  0x7001, 0x7c00, 0xfc00, 0xf400, 0xc002, 0xc200, 0xccff, 0xfc00,
  0x7c00, 0xfc00, 0xf3ff, 0xc001, 0xc001, 0xc1ff, 0xc901, 0xfbff,
  0xfc00, 0xf001, 0xc000, 0xc000, 0xc000, 0xbe01, 0xc900, 0xfbfd,
  0xf000, 0xbc02, 0xbfff, 0xbffe, 0xbc02, 0xbe00, 0xc8ff, 0xf955,
  0xbc01, 0xbc01, 0xbffd, 0xbc01, 0xbc01, 0xbdff, 0xc6ab, 0xee66,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00,
  0xbbfe, 0xb802, 0xbbff, 0xbbfe, 0xb957, 0xb0cd, 0x8901, 0x8000,
  0xb801, 0xb801, 0xbbfd, 0xb955, 0xae68, 0x8180, 0x8000, 0x7f23,
  0xb800, 0xb800, 0xb955, 0xae66, 0x8100, 0x8000, 0x7f23, 0x7e00,
  0xb7fe, 0xb557, 0xae66, 0x8100, 0x8000, 0x7f23, 0x7e00, 0x7f23,
  0xb555, 0xaa68, 0x8100, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xaa66, 0x8080, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00,
  0x8080, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xfc00,
  0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xfc00, 0xfc00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf602, 0xfc00, 0x7c00,
  0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf402, 0xfc00, 0x7c00, 0x7c00,
  0x7f23, 0x7e01, 0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7c00, 0x7c00,
  0x7e01, 0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7600, 0x4d01, 0x7c00,
  0xfc00, 0xf002, 0xfc00, 0x7c00, 0x7401, 0x4201, 0x4d00, 0x7c00,
  0xf001, 0xfc00, 0x7c00, 0x7400, 0x4002, 0x4200, 0x4cff, 0x7c00,
  0xfc00, 0x7c00, 0x73ff, 0x4001, 0x4001, 0x41ff, 0x4901, 0x7bff,
  0x7c00, 0x7001, 0x4000, 0x4000, 0x4000, 0x3e01, 0x4900, 0x7bfd,
  0x7000, 0x3c02, 0x3fff, 0x3ffe, 0x3c02, 0x3e00, 0x48ff, 0x7955,
  0x3c01, 0x3c01, 0x3ffd, 0x3c01, 0x3c01, 0x3dff, 0x46ab, 0x6e66,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x3bfe, 0x3802, 0x3bff, 0x3bfe, 0x3957, 0x30cd, 0x0901, 0x0000,
  0x3801, 0x3801, 0x3bfd, 0x3955, 0x2e68, 0x0180, 0x0000, 0xff23,
  0x3800, 0x3800, 0x3955, 0x2e66, 0x0100, 0x0000, 0xff23, 0xfe00,
  0x37fe, 0x3557, 0x2e66, 0x0100, 0x0000, 0xff23, 0xfe00, 0xff23,
  0x3555, 0x2a68, 0x0100, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x2a66, 0x0080, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00,
  0x0080, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7c00,
  0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7c00, 0x7c00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7c00, 0x7c00, 0xfc00,
  0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7602, 0x7c00, 0xfc00, 0xfc00,
  0xff23, 0xfe01, 0x7c00, 0x7402, 0x7c00, 0xfc00, 0xfc00, 0xfc00,
  0xfe01, 0x7c00, 0x7401, 0x7c00, 0xfc00, 0xfc00, 0xfc00, 0xfc00,
  0x7c00, 0x7401, 0x7c00, 0xfc00, 0xf600, 0xcd01, 0xfc00, 0xfc00,
  0x7002, 0x7c00, 0xfc00, 0xf401, 0xc201, 0xcd00, 0xfc00, 0xfc00,
  0x7c00, 0xfc00, 0xf400, 0xc002, 0xc200, 0xccff, 0xfc00, 0xfc00,
  0xfc00, 0xf3ff, 0xc001, 0xc001, 0xc1ff, 0xc901, 0xfbff, 0xfc00,
  0xf001, 0xc000, 0xc000, 0xc000, 0xbe01, 0xc900, 0xfbfd, 0xfc00,
  0xbc02, 0xbfff, 0xbffe, 0xbc02, 0xbe00, 0xc8ff, 0xf955, 0xfc00,
  0xbc01, 0xbffd, 0xbc01, 0xbc01, 0xbdff, 0xc6ab, 0xee66, 0xfc00,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0x7e00,
  0xb802, 0xbbff, 0xbbfe, 0xb957, 0xb0cd, 0x8901, 0x8000, 0x7f23,
  0xb801, 0xbbfd, 0xb955, 0xae68, 0x8180, 0x8000, 0x7f23, 0x7e00,
  0xb800, 0xb955, 0xae66, 0x8100, 0x8000, 0x7f23, 0x7e00, 0x7f23,
  0xb557, 0xae66, 0x8100, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xaa68, 0x8100, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00,
  0x8080, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xfc00,
  0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xfc00, 0xfc00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xfc00, 0xfc00, 0x7c00,
  0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xf602, 0xfc00, 0x7c00, 0x7c00,
  0x7f23, 0x7e01, 0xfc00, 0xf402, 0xfc00, 0x7c00, 0x7c00, 0x7c00,
  0x7e01, 0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7c00, 0x7c00, 0x7c00,
  0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7600, 0x4d01, 0x7c00, 0x7c00,
  0xf002, 0xfc00, 0x7c00, 0x7401, 0x4201, 0x4d00, 0x7c00, 0x7c00,
  0xfc00, 0x7c00, 0x7400, 0x4002, 0x4200, 0x4cff, 0x7c00, 0x7c00,
  0x7c00, 0x73ff, 0x4001, 0x4001, 0x41ff, 0x4901, 0x7bff, 0x7c00,
  0x7001, 0x4000, 0x4000, 0x4000, 0x3e01, 0x4900, 0x7bfd, 0x7c00,
  0x3c02, 0x3fff, 0x3ffe, 0x3c02, 0x3e00, 0x48ff, 0x7955, 0x7c00,
  0x3c01, 0x3ffd, 0x3c01, 0x3c01, 0x3dff, 0x46ab, 0x6e66, 0x7c00,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x7e00,
  0x3802, 0x3bff, 0x3bfe, 0x3957, 0x30cd, 0x0901, 0x0000, 0xff23,
  0x3801, 0x3bfd, 0x3955, 0x2e68, 0x0180, 0x0000, 0xff23, 0xfe00,
  0x3800, 0x3955, 0x2e66, 0x0100, 0x0000, 0xff23, 0xfe00, 0xff23,
  0x3557, 0x2e66, 0x0100, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x2a68, 0x0100, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00,
  0x0080, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7c00,
  0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7c00, 0x7c00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7c00, 0x7c00, 0xff23,
  0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7c00, 0x7c00, 0xfc00, 0xff23,
  0xff23, 0xfe01, 0x7c00, 0x7602, 0x7c00, 0xfc00, 0xfc00, 0xff23,
  0xfe01, 0x7c00, 0x7402, 0x7c00, 0xfc00, 0xfc00, 0xfc00, 0xff23,
  0x7c00, 0x7401, 0x7c00, 0xfc00, 0xfc00, 0xfc00, 0xfc00, 0xff23,
  0x7401, 0x7c00, 0xfc00, 0xf600, 0xcd01, 0xfc00, 0xfc00, 0xff23,
  0x7c00, 0xfc00, 0xf401, 0xc201, 0xcd00, 0xfc00, 0xfc00, 0xff23,
  0xfc00, 0xf400, 0xc002, 0xc200, 0xccff, 0xfc00, 0xfc00, 0xff23,
  0xf3ff, 0xc001, 0xc001, 0xc1ff, 0xc901, 0xfbff, 0xfc00, 0xff23,
  0xc000, 0xc000, 0xc000, 0xbe01, 0xc900, 0xfbfd, 0xfc00, 0xff23,
  0xbfff, 0xbffe, 0xbc02, 0xbe00, 0xc8ff, 0xf955, 0xfc00, 0xff23,
  0xbffd, 0xbc01, 0xbc01, 0xbdff, 0xc6ab, 0xee66, 0xfc00, 0xff23,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0x7e00, 0xff23,
  0xbbff, 0xbbfe, 0xb957, 0xb0cd, 0x8901, 0x8000, 0x7f23, 0xff23,
  0xbbfd, 0xb955, 0xae68, 0x8180, 0x8000, 0x7f23, 0x7e00, 0x7f23,
  0xb955, 0xae66, 0x8100, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xae66, 0x8100, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23,
  0x8100, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xff23,
  0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xfc00, 0xff23,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xfc00, 0xfc00, 0xff23,
  0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xfc00, 0xfc00, 0x7c00, 0xff23,
  0x7f23, 0x7e01, 0xfc00, 0xf602, 0xfc00, 0x7c00, 0x7c00, 0xff23,
  0x7e01, 0xfc00, 0xf402, 0xfc00, 0x7c00, 0x7c00, 0x7c00, 0xff23,
  0xfc00, 0xf401, 0xfc00, 0x7c00, 0x7c00, 0x7c00, 0x7c00, 0xff23,
  0xf401, 0xfc00, 0x7c00, 0x7600, 0x4d01, 0x7c00, 0x7c00, 0xff23,
  0xfc00, 0x7c00, 0x7401, 0x4201, 0x4d00, 0x7c00, 0x7c00, 0xff23,
  0x7c00, 0x7400, 0x4002, 0x4200, 0x4cff, 0x7c00, 0x7c00, 0xff23,
  0x73ff, 0x4001, 0x4001, 0x41ff, 0x4901, 0x7bff, 0x7c00, 0xff23,
  0x4000, 0x4000, 0x4000, 0x3e01, 0x4900, 0x7bfd, 0x7c00, 0xff23,
  0x3fff, 0x3ffe, 0x3c02, 0x3e00, 0x48ff, 0x7955, 0x7c00, 0xff23,
  0x3ffd, 0x3c01, 0x3c01, 0x3dff, 0x46ab, 0x6e66, 0x7c00, 0xff23,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x7e00, 0xff23,
  0x3bff, 0x3bfe, 0x3957, 0x30cd, 0x0901, 0x0000, 0xff23, 0xff23,
  0x3bfd, 0x3955, 0x2e68, 0x0180, 0x0000, 0xff23, 0xfe00, 0xff23,
  0x3955, 0x2e66, 0x0100, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x2e66, 0x0100, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23,
  0x0100, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0xff23,
  0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7c00, 0xff23,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7c00, 0xff23, 0xfe00,
  0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7c00, 0x7c00, 0xff23, 0xfe00,
  0xff23, 0xfe01, 0x7c00, 0x7c00, 0x7c00, 0xfc00, 0xff23, 0xfe00,
  0xfe01, 0x7c00, 0x7602, 0x7c00, 0xfc00, 0xfc00, 0xff23, 0xfe00,
  0x7c00, 0x7402, 0x7c00, 0xfc00, 0xfc00, 0xfc00, 0xff23, 0xfe00,
  0x7401, 0x7c00, 0xfc00, 0xfc00, 0xfc00, 0xfc00, 0xff23, 0xfe00,
  0x7c00, 0xfc00, 0xf600, 0xcd01, 0xfc00, 0xfc00, 0xff23, 0xfe00,
  0xfc00, 0xf401, 0xc201, 0xcd00, 0xfc00, 0xfc00, 0xff23, 0xfe00,
  0xf400, 0xc002, 0xc200, 0xccff, 0xfc00, 0xfc00, 0xff23, 0xfe00,
  0xc001, 0xc001, 0xc1ff, 0xc901, 0xfbff, 0xfc00, 0xff23, 0xfe00,
  0xc000, 0xc000, 0xbe01, 0xc900, 0xfbfd, 0xfc00, 0xff23, 0xfe00,
  0xbffe, 0xbc02, 0xbe00, 0xc8ff, 0xf955, 0xfc00, 0xff23, 0xfe00,
  0xbc01, 0xbc01, 0xbdff, 0xc6ab, 0xee66, 0xfc00, 0xff23, 0xfe00,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0xbc00, 0x7e00, 0xff23, 0xfe00,
  0xbbfe, 0xb957, 0xb0cd, 0x8901, 0x8000, 0x7f23, 0xff23, 0x7f23,
  0xb955, 0xae68, 0x8180, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0xae66, 0x8100, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe00,
  0x8100, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe00,
  0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xff23, 0xfe00,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xfc00, 0xff23, 0xfe00,
  0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xfc00, 0xfc00, 0xff23, 0xfe00,
  0x7f23, 0x7e01, 0xfc00, 0xfc00, 0xfc00, 0x7c00, 0xff23, 0xfe00,
  0x7e01, 0xfc00, 0xf602, 0xfc00, 0x7c00, 0x7c00, 0xff23, 0xfe00,
  0xfc00, 0xf402, 0xfc00, 0x7c00, 0x7c00, 0x7c00, 0xff23, 0xfe00,
  0xf401, 0xfc00, 0x7c00, 0x7c00, 0x7c00, 0x7c00, 0xff23, 0xfe00,
  0xfc00, 0x7c00, 0x7600, 0x4d01, 0x7c00, 0x7c00, 0xff23, 0xfe00,
  0x7c00, 0x7401, 0x4201, 0x4d00, 0x7c00, 0x7c00, 0xff23, 0xfe00,
  0x7400, 0x4002, 0x4200, 0x4cff, 0x7c00, 0x7c00, 0xff23, 0xfe00,
  0x4001, 0x4001, 0x41ff, 0x4901, 0x7bff, 0x7c00, 0xff23, 0xfe00,
  0x4000, 0x4000, 0x3e01, 0x4900, 0x7bfd, 0x7c00, 0xff23, 0xfe00,
  0x3ffe, 0x3c02, 0x3e00, 0x48ff, 0x7955, 0x7c00, 0xff23, 0xfe00,
  0x3c01, 0x3c01, 0x3dff, 0x46ab, 0x6e66, 0x7c00, 0xff23, 0xfe00,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x7e00, 0xff23, 0xfe00,
  0x3bfe, 0x3957, 0x30cd, 0x0901, 0x0000, 0xff23, 0xff23, 0xff23,
  0x3955, 0x2e68, 0x0180, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x2e66, 0x0100, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfe00,
  0x0100, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23, 0xfe00,
  0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0xff23, 0xfe00,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0xfe00, 0xff23, 0xfe01, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0xff23, 0xfe01, 0x7c00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0xfe01, 0x7c00, 0x7c00, 0x7c00, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0x7c00, 0x7602, 0x7c00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0x7402, 0x7c00, 0xfc00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0x7c00, 0xfc00, 0xfc00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0xfc00, 0xf600, 0xcd01, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0xf401, 0xc201, 0xcd00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0xc002, 0xc200, 0xccff, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0xc001, 0xc1ff, 0xc901, 0xfbff, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0xc000, 0xbe01, 0xc900, 0xfbfd, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0xbc02, 0xbe00, 0xc8ff, 0xf955, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0xbc01, 0xbdff, 0xc6ab, 0xee66, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0xbc00, 0xbc00, 0xbc00, 0xbc00, 0x7e00, 0xff23, 0xfe00, 0xff23,
  0xb957, 0xb0cd, 0x8901, 0x8000, 0x7f23, 0xff23, 0x7f23, 0xff23,
  0xae68, 0x8180, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23,
  0x8100, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe00, 0xff23,
  0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe00, 0xff23,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0x7f23, 0x7e01, 0xfc00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0x7e01, 0xfc00, 0xfc00, 0xfc00, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0xfc00, 0xf602, 0xfc00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0xf402, 0xfc00, 0x7c00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0xfc00, 0x7c00, 0x7c00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0x7c00, 0x7600, 0x4d01, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0x7401, 0x4201, 0x4d00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0x4002, 0x4200, 0x4cff, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0x4001, 0x41ff, 0x4901, 0x7bff, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0x4000, 0x3e01, 0x4900, 0x7bfd, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0x3c02, 0x3e00, 0x48ff, 0x7955, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0x3c01, 0x3dff, 0x46ab, 0x6e66, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x7e00, 0xff23, 0xfe00, 0xff23,
  0x3957, 0x30cd, 0x0901, 0x0000, 0xff23, 0xff23, 0xff23, 0xff23,
  0x2e68, 0x0180, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23,
  0x0100, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfe00, 0xff23,
  0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23, 0xfe00, 0xff23,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xfe00, 0xff23, 0xfe01, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xff23, 0xfe01, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xfe01, 0x7c00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7c00, 0x7c00, 0x7c00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7602, 0x7c00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7c00, 0xfc00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xfc00, 0xfc00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xf600, 0xcd01, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xc201, 0xcd00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xc200, 0xccff, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xc1ff, 0xc901, 0xfbff, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xbe01, 0xc900, 0xfbfd, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xbe00, 0xc8ff, 0xf955, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xbdff, 0xc6ab, 0xee66, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xbc00, 0xbc00, 0xbc00, 0x7e00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xb0cd, 0x8901, 0x8000, 0x7f23, 0xff23, 0x7f23, 0xff23, 0xfe01,
  0x8180, 0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe01,
  0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe00, 0xff23, 0xfe01,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7e00, 0x7f23, 0x7e01, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7f23, 0x7e01, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7e01, 0xfc00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xfc00, 0xfc00, 0xfc00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xf602, 0xfc00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xfc00, 0x7c00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7c00, 0x7c00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x7600, 0x4d01, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x4201, 0x4d00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x4200, 0x4cff, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x41ff, 0x4901, 0x7bff, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x3e01, 0x4900, 0x7bfd, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x3e00, 0x48ff, 0x7955, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x3dff, 0x46ab, 0x6e66, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x3c00, 0x3c00, 0x3c00, 0x7e00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x30cd, 0x0901, 0x0000, 0xff23, 0xff23, 0xff23, 0xff23, 0xfe01,
  0x0180, 0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23, 0xfe01,
  0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfe00, 0xff23, 0xfe01,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xfe00, 0xff23, 0xfe01, 0xfc00,
  0xfe00, 0xff23, 0xfe01, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xa480,
  0xff23, 0xfe01, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8024,
  0xfe01, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8024,
  0x7c00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8024,
  0x7c00, 0x7c00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8012,
  0x7c00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8012,
  0xfc00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8012,
  0xfc00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x800c,
  0xcd01, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8002,
  0xcd00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8000,
  0xccff, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8000,
  0xc901, 0xfbff, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23,
  0xc900, 0xfbfd, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7e00,
  0xc8ff, 0xf955, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23,
  0xc6ab, 0xee66, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7e01,
  0xbc00, 0xbc00, 0x7e00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xbc00,
  0x8901, 0x8000, 0x7f23, 0xff23, 0x7f23, 0xff23, 0xfe01, 0xa481,
  0x8000, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0xcc80,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xfe00, 0xff23, 0xfe01, 0x7c00,
  0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x2480,
  0x7f23, 0x7e01, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0024,
  0x7e01, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0024,
  0xfc00, 0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0024,
  0xfc00, 0xfc00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0012,
  0xfc00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0012,
  0x7c00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0012,
  0x7c00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x000c,
  0x4d01, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0002,
  0x4d00, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0000,
  0x4cff, 0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0000,
  0x4901, 0x7bff, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23,
  0x4900, 0x7bfd, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfe00,
  0x48ff, 0x7955, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23,
  0x46ab, 0x6e66, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfe01,
  0x3c00, 0x3c00, 0x7e00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x3c00,
  0x0901, 0x0000, 0xff23, 0xff23, 0xff23, 0xff23, 0xfe01, 0x2481,
  0x0000, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23, 0xfe01, 0x4c80,
  0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23, 0xfe01, 0x4c80, 0xfc00,
  0xfe00, 0xff23, 0xfe01, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xbbfe,
  0xff23, 0xfe01, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xa480, 0x87ff,
  0xfe01, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8024, 0x87fe,
  0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8024, 0x87fc,
  0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8024, 0x83ff,
  0x7c00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8012, 0x83fe,
  0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8012, 0x82aa,
  0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x800c, 0x8066,
  0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8002, 0x8000,
  0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8000, 0x8000,
  0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8000, 0x7f23,
  0xfbff, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23, 0x7e00,
  0xfbfd, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7e00, 0x7f23,
  0xf955, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23, 0x7e01,
  0xee66, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7e01, 0xd31b,
  0xbc00, 0x7e00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xbc00, 0xbc00,
  0x8000, 0x7f23, 0xff23, 0x7f23, 0xff23, 0xfe01, 0xa481, 0xe3fe,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0xcc80, 0x7c00,
  0x7e00, 0x7f23, 0x7e01, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x3bfe,
  0x7f23, 0x7e01, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x2480, 0x07ff,
  0x7e01, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0024, 0x07fe,
  0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0024, 0x07fc,
  0xfc00, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0024, 0x03ff,
  0xfc00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0012, 0x03ff,
  0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0012, 0x03fe,
  0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0012, 0x02aa,
  0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x000c, 0x0066,
  0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0002, 0x0000,
  0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0000, 0x0000,
  0x7c00, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0000, 0xff23,
  0x7bff, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23, 0xfe00,
  0x7bfd, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfe00, 0xff23,
  0x7955, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23, 0xfe01,
  0x6e66, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfe01, 0x531b,
  0x3c00, 0x7e00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x3c00, 0x3c00,
  0x0000, 0xff23, 0xff23, 0xff23, 0xff23, 0xfe01, 0x2481, 0x63fe,
  0xff23, 0xff23, 0xff23, 0xff23, 0xfe01, 0x2481, 0x63fe, 0xfc00,
  0xfe00, 0xff23, 0xfe01, 0xff23, 0xfe01, 0x4c80, 0xfc00, 0x9400,
  0xff23, 0xfe01, 0xfe00, 0xff23, 0xfe01, 0xfc00, 0xbbfe, 0x8002,
  0xfe01, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xa480, 0x87ff, 0x8002,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8024, 0x87fe, 0x8002,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8024, 0x87fc, 0x8001,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8024, 0x83ff, 0x8001,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8012, 0x83fe, 0x8001,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8012, 0x82aa, 0x8000,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x800c, 0x8066, 0x8000,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8002, 0x8000, 0x8000,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8000, 0x8000, 0x7f23,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8000, 0x7f23, 0x7e00,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23, 0x7e00, 0x7f23,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7e00, 0x7f23, 0x7e01,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7f23, 0x7e01, 0xab1c,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x7e01, 0xd31b, 0x9401,
  0x7e00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xbc00, 0xbc00, 0xbc00,
  0x7f23, 0xff23, 0x7f23, 0xff23, 0xfe01, 0xa481, 0xe3fe, 0x7c00,
  0x7e00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0xcc80, 0x7c00, 0x1400,
  0x7f23, 0x7e01, 0xfe00, 0xff23, 0xfe01, 0x7c00, 0x3bfe, 0x0002,
  0x7e01, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x2480, 0x07ff, 0x0002,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0024, 0x07fe, 0x0002,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0024, 0x07fc, 0x0001,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0024, 0x03ff, 0x0001,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0012, 0x03fe, 0x0001,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0012, 0x02aa, 0x0000,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x000c, 0x0066, 0x0000,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0002, 0x0000, 0x0000,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0000, 0x0000, 0xff23,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0000, 0xff23, 0xfe00,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23, 0xfe00, 0xff23,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfe00, 0xff23, 0xfe01,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xff23, 0xfe01, 0x2b1c,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0xfe01, 0x531b, 0x1401,
  0x7e00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x3c00, 0x3c00, 0x3c00,
};
const unsigned kExpectedCount_NEON_fdiv_8H = 1444;

#endif  // VIXL_SIM_FDIV_8H_TRACE_AARCH64_H_
