#ifndef FUNCTION_DEFINITIONS_H
#define FUNCTION_DEFINITIONS_H 1

#include "known-syntaxes.h"

/* The functions exported by this module are the only ones which need
 * access to the data structures dumped into this file, which are
 * potentially subject to change.  The implementation of this header
 * file is generated by ../grammar/ParseFunctions.java, using the
 * function-definitions.c.template file in that directory.
 *
 * The structure elements with leading underscores are intended to be internal to
 * this function-definition.c module.
 */

/**
 * Represents the definition of a known function
 */
struct function_definition {
    /** A text description of the function */
    const char* description;
    /** The LaTeX representation of the function (eg "\log") */
    const char* latex_form;
};
typedef struct function_definition FunctionDef;

const FunctionDef* unity_get_functiondef_from_string(const char* abbrev, UnitySyntax syntax);
const char* unity_get_function_abbreviation(const FunctionDef* def, UnitySyntax syntax);

#endif /* FUNCTION_DEFINITIONS_H */
