/*******************************************************************************
 * Copyright (c) 2015 Eclipse RDF4J contributors, Aduna, and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Distribution License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *******************************************************************************/
package org.eclipse.rdf4j.queryrender.builder;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.parser.ParsedQuery;

/**
 * <p>
 * Interface for a QueryBuilder which provides a simple fluent API for constructing Sesame query object
 * programmatically.
 * </p>
 *
 * @author Michael Grove
 * @deprecated use {@link org.eclipse.rdf4j.sparqlbuilder.core.SparqlBuilder} instead.
 */
@Deprecated
public interface QueryBuilder<T extends ParsedQuery> extends SupportsGroups {

	/**
	 * Return the query constructed by this query builder
	 *
	 * @return the query
	 */
	T query();

	/**
	 * Specify an offset for the query
	 *
	 * @param theOffset the new offset
	 * @return this query builder
	 */
	QueryBuilder<T> offset(int theOffset);

	/**
	 * Specify a limit for the query
	 *
	 * @param theLimit the new limit for the query
	 * @return this query builder
	 */
	QueryBuilder<T> limit(int theLimit);

	/**
	 * Create an option sub-group
	 *
	 * @return the new group
	 */
	GroupBuilder<T, QueryBuilder<T>> optional();

	/**
	 * Create a new sub-group of the query
	 *
	 * @return the new group
	 */
	GroupBuilder<T, QueryBuilder<T>> group();

	/**
	 * Reset the state of the query builder
	 */
	void reset();

	/**
	 * Specify that this query should use the "distinct" keyword
	 *
	 * @return this query builder
	 */
	QueryBuilder<T> distinct();

	/**
	 * Specify that this query should use the "reduced" keyword
	 *
	 * @return this query builder
	 */
	QueryBuilder<T> reduced();

	/**
	 * Add projection variables to the query
	 *
	 * @param theNames the names of the variables to add to the projection
	 * @return this query builder
	 */
	QueryBuilder<T> addProjectionVar(String... theNames);

	/**
	 * Add a from clause to this query
	 *
	 * @param theURI the from URI
	 * @return this query builder
	 */
	QueryBuilder<T> from(IRI theURI);

	/**
	 * Add a 'from named' clause to this query
	 *
	 * @param theURI the graph URI
	 * @return this query builder
	 */
	QueryBuilder<T> fromNamed(IRI theURI);

	/**
	 * Specify ORDER BY clause with ASC modifier by default
	 *
	 * @param theNames the names of the variables to apply the ordering
	 * @return this query builder
	 */
	QueryBuilder<T> orderBy(String... theNames);

	/**
	 * Specify ORDER BY clause with ASC modifier
	 *
	 * @param theNames the names of the variables to apply the ordering
	 * @return this query builder
	 */
	QueryBuilder<T> orderByAsc(String... theNames);

	/**
	 * Specify ORDER BY clause with DESC modifier
	 *
	 * @param theNames the names of the variables to apply the ordering
	 * @return this query builder
	 */
	QueryBuilder<T> orderByDesc(String... theNames);

	QueryBuilder<T> addProjectionStatement(String theSubj, String thePred, String theObj);

	QueryBuilder<T> addProjectionStatement(String theSubj, String thePred, Value theObj);

	QueryBuilder<T> addProjectionStatement(String theSubj, IRI thePred, Value theObj);

	QueryBuilder<T> addProjectionStatement(IRI theSubj, String thePred, String theObj);

	QueryBuilder<T> addProjectionStatement(IRI theSubj, IRI thePred, String theObj);

	QueryBuilder<T> addProjectionStatement(String theSubj, IRI thePred, String theObj);
}
