% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npsurv.R
\name{km}
\alias{km}
\title{Kaplan-Meier Estimation}
\usage{
km(data, w = 1)
}
\arguments{
\item{data}{vector or matrix, or an object of class \code{icendata}.}

\item{w}{weights/multiplicities of observations.}
}
\value{
A list with components:

\item{f}{NPMLE, an object of class \code{idf}.}

\item{ll}{log-likelihood value of the NPMLE \code{f}.}
}
\description{
\code{km} computes the nonparametric maximum likelihood esimate (NPMLE) of a
survival function for right-censored data.
}
\details{
For details about the arguments, see \code{icendata}.
}
\examples{

x = cbind(1:5, c(1,Inf,3,4,Inf))
(f = km(x)$f)
plot(f)

data(leukemia)
i = leukemia[,"group"] == "Placebo"
plot(km(leukemia[i,1:2])$f, xlim=c(0,40), col="green3") # placebo
plot(km(leukemia[!i,1:2])$f, add=TRUE)                  # 6-MP

}
\references{
Kaplan, E. L. and Meier, P. (1958). Nonparametric estimation from incomplete
observations. \emph{Journal of the American Statistical Association},
\bold{53}, 457-481.
}
\seealso{
\code{\link{icendata}}, \code{\link{npsurv}}, \code{\link{idf}}.
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
\keyword{function}
