% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazy-eval.R
\name{lazy_eval}
\alias{lazy_eval}
\title{Evaluate a lazy expression.}
\usage{
lazy_eval(x, data = NULL)
}
\arguments{
\item{x}{A lazy object or a formula.}

\item{data}{Option, a data frame or list in which to preferentially look
for variables before using the environment associated with the lazy
object.}
}
\description{
Evaluate a lazy expression.
}
\examples{
f <- function(x) {
  z <- 100
  ~ x + z
}
z <- 10
lazy_eval(f(10))
lazy_eval(f(10), list(x = 100))
lazy_eval(f(10), list(x = 1, z = 1))

lazy_eval(lazy_dots(a = x, b = z), list(x = 10))
}
