# Security Policy

## Supported Versions

We take security vulnerabilities seriously. The following table outlines the versions of this project currently
supported with security updates:

| Version | Supported          |
|---------|--------------------|
| 1.x     | :white_check_mark: |
| < 1.0   | :x:                |

## Reporting a Vulnerability

If you discover a security vulnerability, please contact us as soon as possible. We appreciate your efforts in
responsibly disclosing vulnerabilities to help keep the project and its users safe.

### How to Report

- **Email:** [wolfgang@malgadey.de](mailto:wolfgang@malgadey.de)
  
Please include the following details to help us address the issue promptly:

- A clear description of the vulnerability and its potential impact.
- Steps to reproduce the vulnerability.
- Any relevant logs, screenshots, or supporting details.

We kindly ask that you do **not** disclose the vulnerability publicly until we have addressed it and released a patch.

## Response Time

We will acknowledge receipt of your report within **72 hours**. After our initial assessment, we will provide updates
on remediation progress as we work toward releasing a fix. We aim to issue a patch or provide a mitigation strategy
within **14 days** of confirming a legitimate vulnerability.

## Disclosure Policy

Once the vulnerability has been resolved, and a patch or mitigation has been made available, we will:

1. Notify the reporter with details on the fix and release timeline.
2. Credit the reporter in the release notes (if requested and appropriate).
3. Publicly disclose the nature of the vulnerability, its impact, and mitigation or patch information.

## Thank You

Your efforts to secure this project are greatly appreciated. Thank you for helping us maintain a safe and reliable
environment for our users.
