# PEEP-006: Include all deps in output of `pipenv lock -r --dev`

This proposal makes the behavior of `pipenv lock --requirements --dev`
consistent with the behaviour of other commands: converting all dependencies,
not just the development dependencies.

☤

If you type `pipenv lock --help` the help document says:

```bash
-d, --dev           Install both develop and default packages.  [env var:PIPENV_DEV]
```

That is not accurate and confusing for `pipenv lock -r`, which only produces the develop requirments.

This PEEP proposes to change the behavior of `pipenv lock -r -d` to produce **all** requirements, both develop
and default. The help string of `-d/--dev` will be changed to **"Generate both develop and default requirements"**.

As the existing behaviour was intended to support generating traditional `dev-requirements.txt`
files, a new flag, `--dev-only`, will be introduced to restrict output to development requirements only.

When the new `pipenv lock` specific flag is used, the common `-d/--dev` flag is redundant, but
ignored (i.e. `pipenv lock -r --dev-only` and `pipenv lock -r --dev --dev-only` do the same thing).
If `--dev-only` is specified without `-r/--requirements`, then `PipenvOptionsError` will be thrown.

As part of this change, `pipenv lock --requirements` will be updated to emit a comment header
indicating that the file was autogenerated, and the options passed to `pipenv lock`. This will use
the following `pip-compile` inspired format:

    #
    # These requirements were autogenerated by pipenv
    # To regenerate from the project's Pipfile, run:
    #
    #    pipenv lock --requirements
    #

`--dev` or `--dev-only` will be append to the emitted regeneration command if
those options are set.

To allow this new header to be turned off, `pipenv lock --requirements` will also support the same
`--header/--no-header` options that `pip-compile` offers.

In the first release including this change, and in releases for at least 6 months from that date,
the emitted header will include the following note when the `--dev` option is set:

    # Note: in pipenv 2020.x, "--dev" changed to emit both default and development
    # requirements. To emit only development requirements, pass "--dev-only".

## Impact

The users relying on the old behavior will get more requirements listed in the
``dev-requirements.txt`` file, which in most cases is harmless. They can pass
the `--dev-only` flag after updating `pipenv` to achieve the same thing as before.

## Related issues:

- #3316

## Related pull requests:

- #4183
