# Contributing to Jakarta Authentication

Thanks for your interest in this project.

## Project description

Jakarta Authentication defines a general low-level SPI for authentication mechanisms, which are controllers
that interact with a caller and a container's environment to obtain the caller's credentials, validate these,
and pass an authenticated identity (such as name and groups) to the container. 
        
Jakarta Authentication consists of several profiles, with each profile telling how a specific container
(such as Jakarta Servlet) can integrate with- and adapt to this SPI.

* https://projects.eclipse.org/projects/ee4j.authentication

## Developer resources

Information regarding source code management, builds, coding standards, and
more.

* https://projects.eclipse.org/projects/ee4j.authentication/developer

The project maintains the following source code repositories

* https://github.com/eclipse-ee4j/authentication

## Eclipse Contributor Agreement

Before your contribution can be accepted by the project team contributors must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

The credentials of the actual author must be used to populate the Author field.
The author credentials must specify the author’s actual (legal) name and email
address. The email address used must match the email address that the Eclipse
Foundation has on file for the author (case-sensitive).

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

## Eclipse Development Process

This Eclipse Foundation open project is governed by the Eclipse Foundation
Development Process and operates under the terms of the Eclipse IP Policy.

The Jakarta EE Specification Committee has adopted the Jakarta EE Specification
Process (JESP) in accordance with the Eclipse Foundation Specification Process
v1.2 (EFSP) to ensure that the specification process is complied with by all
Jakarta EE specification projects.

* https://eclipse.org/projects/dev_process
* https://www.eclipse.org/org/documents/Eclipse_IP_Policy.pdf
* https://jakarta.ee/about/jesp/
* https://www.eclipse.org/legal/efsp_non_assert.php

## Contact

The project developers can be contacted via the jaspic-dev@eclipse.org mailing
list.

Before emailing the list you must subscribe at:

* https://accounts.eclipse.org/mailing-list/jaspic-dev

