// Code generated by smithy-go-codegen DO NOT EDIT.

package macie2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/macie2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a subset of information about the sensitivity inspection template for
// an account.
func (c *Client) ListSensitivityInspectionTemplates(ctx context.Context, params *ListSensitivityInspectionTemplatesInput, optFns ...func(*Options)) (*ListSensitivityInspectionTemplatesOutput, error) {
	if params == nil {
		params = &ListSensitivityInspectionTemplatesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSensitivityInspectionTemplates", params, optFns, c.addOperationListSensitivityInspectionTemplatesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSensitivityInspectionTemplatesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSensitivityInspectionTemplatesInput struct {

	// The maximum number of items to include in each page of a paginated response.
	MaxResults *int32

	// The nextToken string that specifies which page of results to return in a
	// paginated response.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSensitivityInspectionTemplatesOutput struct {

	// The string to use in a subsequent request to get the next page of results in a
	// paginated response. This value is null if there are no additional pages.
	NextToken *string

	// An array that specifies the unique identifier and name of the sensitivity
	// inspection template for the account.
	SensitivityInspectionTemplates []types.SensitivityInspectionTemplatesEntry

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSensitivityInspectionTemplatesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSensitivityInspectionTemplates{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSensitivityInspectionTemplates{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSensitivityInspectionTemplates"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSensitivityInspectionTemplates(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSensitivityInspectionTemplatesAPIClient is a client that implements the
// ListSensitivityInspectionTemplates operation.
type ListSensitivityInspectionTemplatesAPIClient interface {
	ListSensitivityInspectionTemplates(context.Context, *ListSensitivityInspectionTemplatesInput, ...func(*Options)) (*ListSensitivityInspectionTemplatesOutput, error)
}

var _ ListSensitivityInspectionTemplatesAPIClient = (*Client)(nil)

// ListSensitivityInspectionTemplatesPaginatorOptions is the paginator options for
// ListSensitivityInspectionTemplates
type ListSensitivityInspectionTemplatesPaginatorOptions struct {
	// The maximum number of items to include in each page of a paginated response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSensitivityInspectionTemplatesPaginator is a paginator for
// ListSensitivityInspectionTemplates
type ListSensitivityInspectionTemplatesPaginator struct {
	options   ListSensitivityInspectionTemplatesPaginatorOptions
	client    ListSensitivityInspectionTemplatesAPIClient
	params    *ListSensitivityInspectionTemplatesInput
	nextToken *string
	firstPage bool
}

// NewListSensitivityInspectionTemplatesPaginator returns a new
// ListSensitivityInspectionTemplatesPaginator
func NewListSensitivityInspectionTemplatesPaginator(client ListSensitivityInspectionTemplatesAPIClient, params *ListSensitivityInspectionTemplatesInput, optFns ...func(*ListSensitivityInspectionTemplatesPaginatorOptions)) *ListSensitivityInspectionTemplatesPaginator {
	if params == nil {
		params = &ListSensitivityInspectionTemplatesInput{}
	}

	options := ListSensitivityInspectionTemplatesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSensitivityInspectionTemplatesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSensitivityInspectionTemplatesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSensitivityInspectionTemplates page.
func (p *ListSensitivityInspectionTemplatesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSensitivityInspectionTemplatesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListSensitivityInspectionTemplates(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListSensitivityInspectionTemplates(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSensitivityInspectionTemplates",
	}
}
