// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/discoveryengine/v1alpha/common.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The industry vertical associated with the
// [DataStore][google.cloud.discoveryengine.v1alpha.DataStore].
type IndustryVertical int32

const (
	// Value used when unset.
	IndustryVertical_INDUSTRY_VERTICAL_UNSPECIFIED IndustryVertical = 0
	// The generic vertical for documents that are not specific to any industry
	// vertical.
	IndustryVertical_GENERIC IndustryVertical = 1
	// The media industry vertical.
	IndustryVertical_MEDIA IndustryVertical = 2
)

// Enum value maps for IndustryVertical.
var (
	IndustryVertical_name = map[int32]string{
		0: "INDUSTRY_VERTICAL_UNSPECIFIED",
		1: "GENERIC",
		2: "MEDIA",
	}
	IndustryVertical_value = map[string]int32{
		"INDUSTRY_VERTICAL_UNSPECIFIED": 0,
		"GENERIC":                       1,
		"MEDIA":                         2,
	}
)

func (x IndustryVertical) Enum() *IndustryVertical {
	p := new(IndustryVertical)
	*p = x
	return p
}

func (x IndustryVertical) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndustryVertical) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_enumTypes[0].Descriptor()
}

func (IndustryVertical) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_common_proto_enumTypes[0]
}

func (x IndustryVertical) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IndustryVertical.Descriptor instead.
func (IndustryVertical) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{0}
}

// The type of solution.
type SolutionType int32

const (
	// Default value.
	SolutionType_SOLUTION_TYPE_UNSPECIFIED SolutionType = 0
	// Used for Recommendations AI.
	SolutionType_SOLUTION_TYPE_RECOMMENDATION SolutionType = 1
	// Used for Discovery Search.
	SolutionType_SOLUTION_TYPE_SEARCH SolutionType = 2
	// Used for use cases related to the Generative AI agent.
	SolutionType_SOLUTION_TYPE_CHAT SolutionType = 3
)

// Enum value maps for SolutionType.
var (
	SolutionType_name = map[int32]string{
		0: "SOLUTION_TYPE_UNSPECIFIED",
		1: "SOLUTION_TYPE_RECOMMENDATION",
		2: "SOLUTION_TYPE_SEARCH",
		3: "SOLUTION_TYPE_CHAT",
	}
	SolutionType_value = map[string]int32{
		"SOLUTION_TYPE_UNSPECIFIED":    0,
		"SOLUTION_TYPE_RECOMMENDATION": 1,
		"SOLUTION_TYPE_SEARCH":         2,
		"SOLUTION_TYPE_CHAT":           3,
	}
)

func (x SolutionType) Enum() *SolutionType {
	p := new(SolutionType)
	*p = x
	return p
}

func (x SolutionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SolutionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_enumTypes[1].Descriptor()
}

func (SolutionType) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_common_proto_enumTypes[1]
}

func (x SolutionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SolutionType.Descriptor instead.
func (SolutionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{1}
}

// Tiers of search features. Different tiers might have different
// pricing. To learn more, please check the pricing documentation.
type SearchTier int32

const (
	// Default value when the enum is unspecified. This is invalid to use.
	SearchTier_SEARCH_TIER_UNSPECIFIED SearchTier = 0
	// Standard tier.
	SearchTier_SEARCH_TIER_STANDARD SearchTier = 1
	// Enterprise tier.
	SearchTier_SEARCH_TIER_ENTERPRISE SearchTier = 2
)

// Enum value maps for SearchTier.
var (
	SearchTier_name = map[int32]string{
		0: "SEARCH_TIER_UNSPECIFIED",
		1: "SEARCH_TIER_STANDARD",
		2: "SEARCH_TIER_ENTERPRISE",
	}
	SearchTier_value = map[string]int32{
		"SEARCH_TIER_UNSPECIFIED": 0,
		"SEARCH_TIER_STANDARD":    1,
		"SEARCH_TIER_ENTERPRISE":  2,
	}
)

func (x SearchTier) Enum() *SearchTier {
	p := new(SearchTier)
	*p = x
	return p
}

func (x SearchTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_enumTypes[2].Descriptor()
}

func (SearchTier) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_common_proto_enumTypes[2]
}

func (x SearchTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchTier.Descriptor instead.
func (SearchTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{2}
}

// Add-on that provides additional functionality for search.
type SearchAddOn int32

const (
	// Default value when the enum is unspecified. This is invalid to use.
	SearchAddOn_SEARCH_ADD_ON_UNSPECIFIED SearchAddOn = 0
	// Large language model add-on.
	SearchAddOn_SEARCH_ADD_ON_LLM SearchAddOn = 1
)

// Enum value maps for SearchAddOn.
var (
	SearchAddOn_name = map[int32]string{
		0: "SEARCH_ADD_ON_UNSPECIFIED",
		1: "SEARCH_ADD_ON_LLM",
	}
	SearchAddOn_value = map[string]int32{
		"SEARCH_ADD_ON_UNSPECIFIED": 0,
		"SEARCH_ADD_ON_LLM":         1,
	}
)

func (x SearchAddOn) Enum() *SearchAddOn {
	p := new(SearchAddOn)
	*p = x
	return p
}

func (x SearchAddOn) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchAddOn) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_enumTypes[3].Descriptor()
}

func (SearchAddOn) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_common_proto_enumTypes[3]
}

func (x SearchAddOn) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchAddOn.Descriptor instead.
func (SearchAddOn) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{3}
}

// Identity Provider Type.
type IdpConfig_IdpType int32

const (
	// Default value. ACL search not enabled.
	IdpConfig_IDP_TYPE_UNSPECIFIED IdpConfig_IdpType = 0
	// Google 1P provider.
	IdpConfig_GSUITE IdpConfig_IdpType = 1
	// Third party provider.
	IdpConfig_THIRD_PARTY IdpConfig_IdpType = 2
)

// Enum value maps for IdpConfig_IdpType.
var (
	IdpConfig_IdpType_name = map[int32]string{
		0: "IDP_TYPE_UNSPECIFIED",
		1: "GSUITE",
		2: "THIRD_PARTY",
	}
	IdpConfig_IdpType_value = map[string]int32{
		"IDP_TYPE_UNSPECIFIED": 0,
		"GSUITE":               1,
		"THIRD_PARTY":          2,
	}
)

func (x IdpConfig_IdpType) Enum() *IdpConfig_IdpType {
	p := new(IdpConfig_IdpType)
	*p = x
	return p
}

func (x IdpConfig_IdpType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IdpConfig_IdpType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_enumTypes[4].Descriptor()
}

func (IdpConfig_IdpType) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_common_proto_enumTypes[4]
}

func (x IdpConfig_IdpType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IdpConfig_IdpType.Descriptor instead.
func (IdpConfig_IdpType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{7, 0}
}

// A floating point interval.
type Interval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The lower bound of the interval. If neither of the min fields are
	// set, then the lower bound is negative infinity.
	//
	// This field must be not larger than max.
	// Otherwise, an `INVALID_ARGUMENT` error is returned.
	//
	// Types that are assignable to Min:
	//
	//	*Interval_Minimum
	//	*Interval_ExclusiveMinimum
	Min isInterval_Min `protobuf_oneof:"min"`
	// The upper bound of the interval. If neither of the max fields are
	// set, then the upper bound is positive infinity.
	//
	// This field must be not smaller than min.
	// Otherwise, an `INVALID_ARGUMENT` error is returned.
	//
	// Types that are assignable to Max:
	//
	//	*Interval_Maximum
	//	*Interval_ExclusiveMaximum
	Max isInterval_Max `protobuf_oneof:"max"`
}

func (x *Interval) Reset() {
	*x = Interval{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Interval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Interval) ProtoMessage() {}

func (x *Interval) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Interval.ProtoReflect.Descriptor instead.
func (*Interval) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{0}
}

func (m *Interval) GetMin() isInterval_Min {
	if m != nil {
		return m.Min
	}
	return nil
}

func (x *Interval) GetMinimum() float64 {
	if x, ok := x.GetMin().(*Interval_Minimum); ok {
		return x.Minimum
	}
	return 0
}

func (x *Interval) GetExclusiveMinimum() float64 {
	if x, ok := x.GetMin().(*Interval_ExclusiveMinimum); ok {
		return x.ExclusiveMinimum
	}
	return 0
}

func (m *Interval) GetMax() isInterval_Max {
	if m != nil {
		return m.Max
	}
	return nil
}

func (x *Interval) GetMaximum() float64 {
	if x, ok := x.GetMax().(*Interval_Maximum); ok {
		return x.Maximum
	}
	return 0
}

func (x *Interval) GetExclusiveMaximum() float64 {
	if x, ok := x.GetMax().(*Interval_ExclusiveMaximum); ok {
		return x.ExclusiveMaximum
	}
	return 0
}

type isInterval_Min interface {
	isInterval_Min()
}

type Interval_Minimum struct {
	// Inclusive lower bound.
	Minimum float64 `protobuf:"fixed64,1,opt,name=minimum,proto3,oneof"`
}

type Interval_ExclusiveMinimum struct {
	// Exclusive lower bound.
	ExclusiveMinimum float64 `protobuf:"fixed64,2,opt,name=exclusive_minimum,json=exclusiveMinimum,proto3,oneof"`
}

func (*Interval_Minimum) isInterval_Min() {}

func (*Interval_ExclusiveMinimum) isInterval_Min() {}

type isInterval_Max interface {
	isInterval_Max()
}

type Interval_Maximum struct {
	// Inclusive upper bound.
	Maximum float64 `protobuf:"fixed64,3,opt,name=maximum,proto3,oneof"`
}

type Interval_ExclusiveMaximum struct {
	// Exclusive upper bound.
	ExclusiveMaximum float64 `protobuf:"fixed64,4,opt,name=exclusive_maximum,json=exclusiveMaximum,proto3,oneof"`
}

func (*Interval_Maximum) isInterval_Max() {}

func (*Interval_ExclusiveMaximum) isInterval_Max() {}

// A custom attribute that is not explicitly modeled in a resource, e.g.
// [UserEvent][google.cloud.discoveryengine.v1alpha.UserEvent].
type CustomAttribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The textual values of this custom attribute. For example, `["yellow",
	// "green"]` when the key is "color".
	//
	// Empty string is not allowed. Otherwise, an `INVALID_ARGUMENT` error is
	// returned.
	//
	// Exactly one of
	// [CustomAttribute.text][google.cloud.discoveryengine.v1alpha.CustomAttribute.text]
	// or
	// [CustomAttribute.numbers][google.cloud.discoveryengine.v1alpha.CustomAttribute.numbers]
	// should be set. Otherwise, an `INVALID_ARGUMENT` error is returned.
	Text []string `protobuf:"bytes,1,rep,name=text,proto3" json:"text,omitempty"`
	// The numerical values of this custom attribute. For example, `[2.3, 15.4]`
	// when the key is "lengths_cm".
	//
	// Exactly one of
	// [CustomAttribute.text][google.cloud.discoveryengine.v1alpha.CustomAttribute.text]
	// or
	// [CustomAttribute.numbers][google.cloud.discoveryengine.v1alpha.CustomAttribute.numbers]
	// should be set. Otherwise, an `INVALID_ARGUMENT` error is returned.
	Numbers []float64 `protobuf:"fixed64,2,rep,packed,name=numbers,proto3" json:"numbers,omitempty"`
}

func (x *CustomAttribute) Reset() {
	*x = CustomAttribute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomAttribute) ProtoMessage() {}

func (x *CustomAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomAttribute.ProtoReflect.Descriptor instead.
func (*CustomAttribute) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{1}
}

func (x *CustomAttribute) GetText() []string {
	if x != nil {
		return x.Text
	}
	return nil
}

func (x *CustomAttribute) GetNumbers() []float64 {
	if x != nil {
		return x.Numbers
	}
	return nil
}

// Information of an end user.
type UserInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Highly recommended for logged-in users. Unique identifier for logged-in
	// user, such as a user name. Don't set for anonymous users.
	//
	// Always use a hashed value for this ID.
	//
	// Don't set the field to the same fixed ID for different users. This mixes
	// the event history of those users together, which results in degraded
	// model quality.
	//
	// The field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// User agent as included in the HTTP header.
	//
	// The field must be a UTF-8 encoded string with a length limit of 1,000
	// characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
	//
	// This should not be set when using the client side event reporting with
	// GTM or JavaScript tag in
	// [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1alpha.UserEventService.CollectUserEvent]
	// or if
	// [UserEvent.direct_user_request][google.cloud.discoveryengine.v1alpha.UserEvent.direct_user_request]
	// is set.
	UserAgent string `protobuf:"bytes,2,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
}

func (x *UserInfo) Reset() {
	*x = UserInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserInfo) ProtoMessage() {}

func (x *UserInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserInfo.ProtoReflect.Descriptor instead.
func (*UserInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{2}
}

func (x *UserInfo) GetUserId() string {
	if x != nil {
		return x.UserId
	}
	return ""
}

func (x *UserInfo) GetUserAgent() string {
	if x != nil {
		return x.UserAgent
	}
	return ""
}

// Defines embedding config, used for bring your own embeddings feature.
type EmbeddingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full field path in the schema mapped as embedding field.
	FieldPath string `protobuf:"bytes,1,opt,name=field_path,json=fieldPath,proto3" json:"field_path,omitempty"`
}

func (x *EmbeddingConfig) Reset() {
	*x = EmbeddingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EmbeddingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EmbeddingConfig) ProtoMessage() {}

func (x *EmbeddingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EmbeddingConfig.ProtoReflect.Descriptor instead.
func (*EmbeddingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{3}
}

func (x *EmbeddingConfig) GetFieldPath() string {
	if x != nil {
		return x.FieldPath
	}
	return ""
}

// Double list.
type DoubleList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Double values.
	Values []float64 `protobuf:"fixed64,1,rep,packed,name=values,proto3" json:"values,omitempty"`
}

func (x *DoubleList) Reset() {
	*x = DoubleList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DoubleList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoubleList) ProtoMessage() {}

func (x *DoubleList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoubleList.ProtoReflect.Descriptor instead.
func (*DoubleList) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{4}
}

func (x *DoubleList) GetValues() []float64 {
	if x != nil {
		return x.Values
	}
	return nil
}

// Defines guided search spec.
type GuidedSearchSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether or not to enable and include refinement attributes in gudied search
	// result.
	EnableRefinementAttributes bool `protobuf:"varint,1,opt,name=enable_refinement_attributes,json=enableRefinementAttributes,proto3" json:"enable_refinement_attributes,omitempty"`
	// Whether or not to enable and include related questions in search response.
	EnableRelatedQuestions bool `protobuf:"varint,2,opt,name=enable_related_questions,json=enableRelatedQuestions,proto3" json:"enable_related_questions,omitempty"`
	// Max number of related questions to be returned. The valid range is [1, 5].
	// If enable_related_questions is true, the default value is 3.
	MaxRelatedQuestions int32 `protobuf:"varint,3,opt,name=max_related_questions,json=maxRelatedQuestions,proto3" json:"max_related_questions,omitempty"`
}

func (x *GuidedSearchSpec) Reset() {
	*x = GuidedSearchSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GuidedSearchSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuidedSearchSpec) ProtoMessage() {}

func (x *GuidedSearchSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuidedSearchSpec.ProtoReflect.Descriptor instead.
func (*GuidedSearchSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{5}
}

func (x *GuidedSearchSpec) GetEnableRefinementAttributes() bool {
	if x != nil {
		return x.EnableRefinementAttributes
	}
	return false
}

func (x *GuidedSearchSpec) GetEnableRelatedQuestions() bool {
	if x != nil {
		return x.EnableRelatedQuestions
	}
	return false
}

func (x *GuidedSearchSpec) GetMaxRelatedQuestions() int32 {
	if x != nil {
		return x.MaxRelatedQuestions
	}
	return 0
}

// Defines custom fine tuning spec.
type CustomFineTuningSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether or not to enable and include custom fine tuned search adaptor
	// model.
	EnableSearchAdaptor bool `protobuf:"varint,1,opt,name=enable_search_adaptor,json=enableSearchAdaptor,proto3" json:"enable_search_adaptor,omitempty"`
}

func (x *CustomFineTuningSpec) Reset() {
	*x = CustomFineTuningSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomFineTuningSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomFineTuningSpec) ProtoMessage() {}

func (x *CustomFineTuningSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomFineTuningSpec.ProtoReflect.Descriptor instead.
func (*CustomFineTuningSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{6}
}

func (x *CustomFineTuningSpec) GetEnableSearchAdaptor() bool {
	if x != nil {
		return x.EnableSearchAdaptor
	}
	return false
}

// Identity Provider Config.
type IdpConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identity provider type configured.
	IdpType IdpConfig_IdpType `protobuf:"varint,1,opt,name=idp_type,json=idpType,proto3,enum=google.cloud.discoveryengine.v1alpha.IdpConfig_IdpType" json:"idp_type,omitempty"`
	// External Identity provider config.
	ExternalIdpConfig *IdpConfig_ExternalIdpConfig `protobuf:"bytes,2,opt,name=external_idp_config,json=externalIdpConfig,proto3" json:"external_idp_config,omitempty"`
}

func (x *IdpConfig) Reset() {
	*x = IdpConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IdpConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IdpConfig) ProtoMessage() {}

func (x *IdpConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IdpConfig.ProtoReflect.Descriptor instead.
func (*IdpConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{7}
}

func (x *IdpConfig) GetIdpType() IdpConfig_IdpType {
	if x != nil {
		return x.IdpType
	}
	return IdpConfig_IDP_TYPE_UNSPECIFIED
}

func (x *IdpConfig) GetExternalIdpConfig() *IdpConfig_ExternalIdpConfig {
	if x != nil {
		return x.ExternalIdpConfig
	}
	return nil
}

// Principal identifier of a user or a group.
type Principal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Union field principal. Principal can be a user or a group.
	//
	// Types that are assignable to Principal:
	//
	//	*Principal_UserId
	//	*Principal_GroupId
	Principal isPrincipal_Principal `protobuf_oneof:"principal"`
}

func (x *Principal) Reset() {
	*x = Principal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Principal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Principal) ProtoMessage() {}

func (x *Principal) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Principal.ProtoReflect.Descriptor instead.
func (*Principal) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{8}
}

func (m *Principal) GetPrincipal() isPrincipal_Principal {
	if m != nil {
		return m.Principal
	}
	return nil
}

func (x *Principal) GetUserId() string {
	if x, ok := x.GetPrincipal().(*Principal_UserId); ok {
		return x.UserId
	}
	return ""
}

func (x *Principal) GetGroupId() string {
	if x, ok := x.GetPrincipal().(*Principal_GroupId); ok {
		return x.GroupId
	}
	return ""
}

type isPrincipal_Principal interface {
	isPrincipal_Principal()
}

type Principal_UserId struct {
	// User identifier.
	// For Google Workspace user account, user_id should be the google workspace
	// user email.
	// For non-google identity provider user account, user_id is the mapped user
	// identifier configured during the workforcepool config.
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3,oneof"`
}

type Principal_GroupId struct {
	// Group identifier.
	// For Google Workspace user account, group_id should be the google
	// workspace group email.
	// For non-google identity provider user account, group_id is the mapped
	// group identifier configured during the workforcepool config.
	GroupId string `protobuf:"bytes,2,opt,name=group_id,json=groupId,proto3,oneof"`
}

func (*Principal_UserId) isPrincipal_Principal() {}

func (*Principal_GroupId) isPrincipal_Principal() {}

// Third party IDP Config.
type IdpConfig_ExternalIdpConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Workforce pool name.
	// Example: "locations/global/workforcePools/pool_id"
	WorkforcePoolName string `protobuf:"bytes,1,opt,name=workforce_pool_name,json=workforcePoolName,proto3" json:"workforce_pool_name,omitempty"`
}

func (x *IdpConfig_ExternalIdpConfig) Reset() {
	*x = IdpConfig_ExternalIdpConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IdpConfig_ExternalIdpConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IdpConfig_ExternalIdpConfig) ProtoMessage() {}

func (x *IdpConfig_ExternalIdpConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IdpConfig_ExternalIdpConfig.ProtoReflect.Descriptor instead.
func (*IdpConfig_ExternalIdpConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP(), []int{7, 0}
}

func (x *IdpConfig_ExternalIdpConfig) GetWorkforcePoolName() string {
	if x != nil {
		return x.WorkforcePoolName
	}
	return ""
}

var File_google_cloud_discoveryengine_v1alpha_common_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1alpha_common_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xae, 0x01, 0x0a, 0x08, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x12, 0x1a, 0x0a, 0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x01, 0x48, 0x00, 0x52, 0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x12, 0x2d, 0x0a,
	0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x69, 0x6e, 0x69, 0x6d,
	0x75, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x76, 0x65, 0x4d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x12, 0x1a, 0x0a, 0x07,
	0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x48, 0x01, 0x52,
	0x07, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x12, 0x2d, 0x0a, 0x11, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x01, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65,
	0x4d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x42, 0x05, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x42, 0x05,
	0x0a, 0x03, 0x6d, 0x61, 0x78, 0x22, 0x3f, 0x0a, 0x0f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x18, 0x0a, 0x07,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x01, 0x52, 0x07, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x22, 0x42, 0x0a, 0x08, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x75, 0x73, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x22, 0x30, 0x0a, 0x0f, 0x45, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a,
	0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x22, 0x24, 0x0a, 0x0a,
	0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x01, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x22, 0xc2, 0x01, 0x0a, 0x10, 0x47, 0x75, 0x69, 0x64, 0x65, 0x64, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x12, 0x40, 0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x72, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x18, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x51, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x4a, 0x0a, 0x14, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x46, 0x69, 0x6e, 0x65, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x32, 0x0a, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x61, 0x70,
	0x74, 0x6f, 0x72, 0x22, 0xd9, 0x02, 0x0a, 0x09, 0x49, 0x64, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x52, 0x0a, 0x08, 0x69, 0x64, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x64, 0x70, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x64, 0x70, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x69, 0x64,
	0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x71, 0x0a, 0x13, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x5f, 0x69, 0x64, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x64, 0x70, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x70, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49,
	0x64, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x43, 0x0a, 0x11, 0x45, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a,
	0x13, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x77, 0x6f, 0x72, 0x6b,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x40, 0x0a,
	0x07, 0x49, 0x64, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x44, 0x50, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x47, 0x53, 0x55, 0x49, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0f,
	0x0a, 0x0b, 0x54, 0x48, 0x49, 0x52, 0x44, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x59, 0x10, 0x02, 0x22,
	0x50, 0x0a, 0x09, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x19, 0x0a, 0x07,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x64, 0x42, 0x0b, 0x0a, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x2a, 0x4d, 0x0a, 0x10, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x56, 0x65, 0x72,
	0x74, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x21, 0x0a, 0x1d, 0x49, 0x4e, 0x44, 0x55, 0x53, 0x54, 0x52,
	0x59, 0x5f, 0x56, 0x45, 0x52, 0x54, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x47, 0x45, 0x4e, 0x45,
	0x52, 0x49, 0x43, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x10, 0x02,
	0x2a, 0x81, 0x01, 0x0a, 0x0c, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x20, 0x0a, 0x1c, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x52, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x45, 0x4e, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12,
	0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x48,
	0x41, 0x54, 0x10, 0x03, 0x2a, 0x5f, 0x0a, 0x0a, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x69,
	0x65, 0x72, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x54, 0x49, 0x45,
	0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x18, 0x0a, 0x14, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x53,
	0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x45, 0x41,
	0x52, 0x43, 0x48, 0x5f, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52,
	0x49, 0x53, 0x45, 0x10, 0x02, 0x2a, 0x43, 0x0a, 0x0b, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41,
	0x64, 0x64, 0x4f, 0x6e, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x41,
	0x44, 0x44, 0x5f, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x41, 0x44,
	0x44, 0x5f, 0x4f, 0x4e, 0x5f, 0x4c, 0x4c, 0x4d, 0x10, 0x01, 0x42, 0xc6, 0x05, 0xea, 0x41, 0xe6,
	0x01, 0x0a, 0x25, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68,
	0x65, 0x73, 0x2f, 0x7b, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x7d, 0x12, 0x6a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x7b,
	0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x7d, 0xea, 0x41, 0x6d, 0x0a, 0x29, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0x52, 0x0a, 0x27, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x28, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x52, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43,
	0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x24, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70,
	0x68, 0x61, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0xea, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescData = file_google_cloud_discoveryengine_v1alpha_common_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1alpha_common_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1alpha_common_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_discoveryengine_v1alpha_common_proto_goTypes = []interface{}{
	(IndustryVertical)(0),               // 0: google.cloud.discoveryengine.v1alpha.IndustryVertical
	(SolutionType)(0),                   // 1: google.cloud.discoveryengine.v1alpha.SolutionType
	(SearchTier)(0),                     // 2: google.cloud.discoveryengine.v1alpha.SearchTier
	(SearchAddOn)(0),                    // 3: google.cloud.discoveryengine.v1alpha.SearchAddOn
	(IdpConfig_IdpType)(0),              // 4: google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType
	(*Interval)(nil),                    // 5: google.cloud.discoveryengine.v1alpha.Interval
	(*CustomAttribute)(nil),             // 6: google.cloud.discoveryengine.v1alpha.CustomAttribute
	(*UserInfo)(nil),                    // 7: google.cloud.discoveryengine.v1alpha.UserInfo
	(*EmbeddingConfig)(nil),             // 8: google.cloud.discoveryengine.v1alpha.EmbeddingConfig
	(*DoubleList)(nil),                  // 9: google.cloud.discoveryengine.v1alpha.DoubleList
	(*GuidedSearchSpec)(nil),            // 10: google.cloud.discoveryengine.v1alpha.GuidedSearchSpec
	(*CustomFineTuningSpec)(nil),        // 11: google.cloud.discoveryengine.v1alpha.CustomFineTuningSpec
	(*IdpConfig)(nil),                   // 12: google.cloud.discoveryengine.v1alpha.IdpConfig
	(*Principal)(nil),                   // 13: google.cloud.discoveryengine.v1alpha.Principal
	(*IdpConfig_ExternalIdpConfig)(nil), // 14: google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
}
var file_google_cloud_discoveryengine_v1alpha_common_proto_depIdxs = []int32{
	4,  // 0: google.cloud.discoveryengine.v1alpha.IdpConfig.idp_type:type_name -> google.cloud.discoveryengine.v1alpha.IdpConfig.IdpType
	14, // 1: google.cloud.discoveryengine.v1alpha.IdpConfig.external_idp_config:type_name -> google.cloud.discoveryengine.v1alpha.IdpConfig.ExternalIdpConfig
	2,  // [2:2] is the sub-list for method output_type
	2,  // [2:2] is the sub-list for method input_type
	2,  // [2:2] is the sub-list for extension type_name
	2,  // [2:2] is the sub-list for extension extendee
	0,  // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1alpha_common_proto_init() }
func file_google_cloud_discoveryengine_v1alpha_common_proto_init() {
	if File_google_cloud_discoveryengine_v1alpha_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Interval); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomAttribute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EmbeddingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DoubleList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GuidedSearchSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomFineTuningSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IdpConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Principal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IdpConfig_ExternalIdpConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Interval_Minimum)(nil),
		(*Interval_ExclusiveMinimum)(nil),
		(*Interval_Maximum)(nil),
		(*Interval_ExclusiveMaximum)(nil),
	}
	file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*Principal_UserId)(nil),
		(*Principal_GroupId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1alpha_common_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1alpha_common_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1alpha_common_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1alpha_common_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1alpha_common_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1alpha_common_proto = out.File
	file_google_cloud_discoveryengine_v1alpha_common_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1alpha_common_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1alpha_common_proto_depIdxs = nil
}
