# CiviCRM 5.43.0

Released November 3, 2021

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Use money formatting for currency in templates
  ([21783](https://github.com/civicrm/civicrm-core/pull/21783))**

  Receipt templates now use the more modern Brick/Money library to format
  currency amounts.  This will provide better formats in most cases, but it will
  be a change.

- **Add sort functionality to event summary report
  ([21501](https://github.com/civicrm/civicrm-core/pull/21501))**

  Improves Event Summary Report by making it possible to sort columns.

- **Add REGEXP/NOT REGEXP operators to API4
  ([dev/core#2793](https://lab.civicrm.org/dev/core/-/issues/2793):
  [21288](https://github.com/civicrm/civicrm-core/pull/21288))**

  Makes it so users can use regular expressions operators in APIv4.

- **APIv4 - Add Contact.age_years extra field to make age calculations easy
  ([21718](https://github.com/civicrm/civicrm-core/pull/21718))**

  Adds a calculated field to APIv4 which makes it simple to return or filter on
  a contact's age.

- **APIv4 - Add support for sql equations
  ([21551](https://github.com/civicrm/civicrm-core/pull/21551))**

  Allows equations e.g. (1 + 1) as sql expressions in APIv4 queries.

- **Apiv4 entity parity (Work Towards
  [dev/core#2486](https://lab.civicrm.org/dev/core/-/issues/2486):
  [21355](https://github.com/civicrm/civicrm-core/pull/21355) and
  [21500](https://github.com/civicrm/civicrm-core/pull/21500))**

  Adds APIv4 entity support for the PrintLabel and Survey entities.

- **APIv4 - Use event instead of hardcoded list to resolve entityName to
  className ([21771](https://github.com/civicrm/civicrm-core/pull/21771),
  [21803](https://github.com/civicrm/civicrm-core/pull/21803),
  [21819](https://github.com/civicrm/civicrm-core/pull/21819),
  [21824](https://github.com/civicrm/civicrm-core/pull/21824),
  [21828](https://github.com/civicrm/civicrm-core/pull/21828),
  [21839](https://github.com/civicrm/civicrm-core/pull/21839), and
  [21851](https://github.com/civicrm/civicrm-core/pull/21851))**

  This allows core and extension-introduced entities to have arbitrary class and
  entity names instead of requiring the two to agree.

- **activity import: prepend custom group title to custom fields
  ([21318](https://github.com/civicrm/civicrm-core/pull/21318))**

  Makes it possible to distinguish between core and custom fields on the
  Activity Import screen.

- **No way to distinguish the core and custom fields on Find and Merge Duplicate
  Contacts page
  ([dev/core#2766](https://lab.civicrm.org/dev/core/-/issues/2766):
  [21728](https://github.com/civicrm/civicrm-core/pull/21728))**

  Makes it possible to distinguish between core and custom fields on the Find
  and Merge Duplicate Contacts page.

- **Support participant & membership tokens in send-email tasks
  ([21745](https://github.com/civicrm/civicrm-core/pull/21745) and
  [dev/core#2895](https://lab.civicrm.org/dev/core/-/issues/2895):
  [21801](https://github.com/civicrm/civicrm-core/pull/21801))**

  Makes it so users can use participant & membership tokens in send-email tasks.

- **Add participant tokens to pdf task
  ([21695](https://github.com/civicrm/civicrm-core/pull/21695))**

  Makes it so users can use participant tokens in PDF tasks.

- **Meta - token usage 5.43 standardisation effort
  ([dev/core#2864](https://lab.civicrm.org/dev/core/-/issues/2864):
  [21428](https://github.com/civicrm/civicrm-core/pull/21428),
  [21605](https://github.com/civicrm/civicrm-core/pull/21605),
  [21713](https://github.com/civicrm/civicrm-core/pull/21713),
  [21584](https://github.com/civicrm/civicrm-core/pull/21584),
  [21523](https://github.com/civicrm/civicrm-core/pull/21523),
  [21706](https://github.com/civicrm/civicrm-core/pull/21706),
  [21806](https://github.com/civicrm/civicrm-core/pull/21806),
  [21821](https://github.com/civicrm/civicrm-core/pull/21821),
  [21530](https://github.com/civicrm/civicrm-core/pull/21530),
  [21537](https://github.com/civicrm/civicrm-core/pull/21537), and
  [21913](https://github.com/civicrm/civicrm-core/pull/21913))**

  Standardizes Token usage.

- **Add {domain.now}, supporting |crmDate
  ([21531](https://github.com/civicrm/civicrm-core/pull/21531))**

  Adds new token {domain.now} that provides the current date.

- **Afform - Use search display name as field prefix for url-based field
  defaults ([21645](https://github.com/civicrm/civicrm-core/pull/21645))**

   Makes field prefix optional for Afform url-based defaults, and uses search
   display name as prefix for search forms.

- **Afform - Accept default field values from the url
  ([21606](https://github.com/civicrm/civicrm-core/pull/21606))**

  Allows default Afform field values to be set from the url.

- **Afform Admin add link icon & template cleanup
  ([21764](https://github.com/civicrm/civicrm-core/pull/21764))**

  Minor cleanup to improve template efficiency, style afform page link, and add
  a page title.

- **Search kit - default filter - primary
  ([dev/core#2852](https://lab.civicrm.org/dev/core/-/issues/2852):
  [21574](https://github.com/civicrm/civicrm-core/pull/21574))**

  Adds is_primary as a default SearchKit filter.

- **SearchKit - Add UI for arithmetic equations
  ([21600](https://github.com/civicrm/civicrm-core/pull/21600))**

  Allows adding, subtracting, dividing and multiplying any number of values in
  SearchKit.

- **SearchKit - Support multiple arguments to field transformations aka SQL
  functions ([21528](https://github.com/civicrm/civicrm-core/pull/21528) and
  [21535](https://github.com/civicrm/civicrm-core/pull/21535))**

  Enhances the SearchKit UI to allow multiple fields to be acted upon at once in
  a function.

- **SearchKit - Add pseudo-fields for row number and current user
  ([21435](https://github.com/civicrm/civicrm-core/pull/21435))**

  Makes a couple calculated fields available for use as columns or tokens in
  SearchKit.

- **SearchKit - Support custom fields in bridge join entities
  ([21424](https://github.com/civicrm/civicrm-core/pull/21424))**

  Makes it possible to use relationship custom data throughout Search Kit.

- **SearchKit & Afform - Use Bootstrap table styles on admin screens
  ([21405](https://github.com/civicrm/civicrm-core/pull/21405) and
  [21397](https://github.com/civicrm/civicrm-core/pull/21397))**

  applies Bootstrap table styles to admin tables in SearchKit and Afform.

- **SearchKit - Filter search listing by creator
  ([21388](https://github.com/civicrm/civicrm-core/pull/21388))**

  Makes it so users can filter the search listing by creator.

- **SearchKit - enable tags for Saved Searches
  ([21376](https://github.com/civicrm/civicrm-core/pull/21376))**

  Enables tags for saved searches in searchkit.

- **SearchKit - Add 'array' option to download API and add test
  ([21363](https://github.com/civicrm/civicrm-core/pull/21363))**

  Adds a new option to the SearchKit "Download" api to return a normal array
  result, which makes testing easier.

- **SearchKit - Sortable column fixes/improvements
  ([21720](https://github.com/civicrm/civicrm-core/pull/21720) and
  [21894](https://github.com/civicrm/civicrm-core/pull/21894))**

  Fixes sortable column headers on SearchKit admin tables and makes
  click-sortable column headers configurable.

- **Add message admin to dist
  ([21670](https://github.com/civicrm/civicrm-core/pull/21670))**

  Adds Message admin extension.

- **message_admin - Add titles/hints to hyperlinks
  ([21698](https://github.com/civicrm/civicrm-core/pull/21698))**

  Adds help text to links on Message Admin Screen.

- **Replace expensive query with cheaper one
  ([21426](https://github.com/civicrm/civicrm-core/pull/21426))**

  Improves performance.

- **Add support for CiviCRM date formats in crmDate
  ([21508](https://github.com/civicrm/civicrm-core/pull/21508))**

  Adds support for CiviCRM date formats in crmDate.

- **Mailing Unsubscribe Form: Show if email is already unsubscribed
  ([21174](https://github.com/civicrm/civicrm-core/pull/21174))**

  Improves languaging on the Mailing Unsubscribe form regarding if the email is
  already unsubscribed.

- **Change Do Not SMS privacy icon
  ([dev/core#2754](https://lab.civicrm.org/dev/core/-/issues/2754):
  [21354](https://github.com/civicrm/civicrm-core/pull/21354))**

  Improves usability by improving the Do Not SMS icon.

### CiviContribute

- **Add workflow template for 'recurring edit' workflow
  ([21356](https://github.com/civicrm/civicrm-core/pull/21356) and
  [21826](https://github.com/civicrm/civicrm-core/pull/21826))**

  Adds workflow template for 'recurring edit' workflow

- **Can we re-order the 'recur links'
  ([dev/core#2843](https://lab.civicrm.org/dev/core/-/issues/2843):
  [21529](https://github.com/civicrm/civicrm-core/pull/21529))**

  Improves user experience by reordering the contribution recur links.

- **View Contribution page, move the Done button to the last button, currently
  shown in the middle
  ([21547](https://github.com/civicrm/civicrm-core/pull/21547))**

  Reorders buttons on the Contribution page to improve user experience.

- **Replace "Print Invoice" and "Print Invoice and Credit Note" buttons with
  label "Download Invoice" and "Download Invoice and Credit Note"
  ([21546](https://github.com/civicrm/civicrm-core/pull/21546))**

  Improves labels for Invoice buttons.

### CiviEvent

- **Custom Participant tokens not working in scheduled reminders
  ([dev/core#348](https://lab.civicrm.org/dev/core/-/issues/348):
  [21666](https://github.com/civicrm/civicrm-core/pull/21666))**

  Adds support for participant tokens in scheduled reminders.

### CiviMail

- **CRM-19236 - Fix Flexmailer extension to support unicode urls
  ([21597](https://github.com/civicrm/civicrm-core/pull/21597))**

  Updates flexmailer click tracking to support unicode urls.

- **Install flexmailer by default on new installs
  ([dev/core#2836](https://lab.civicrm.org/dev/core/-/issues/2836):
  [21522](https://github.com/civicrm/civicrm-core/pull/21522) and
  [21830](https://github.com/civicrm/civicrm-core/pull/21830))**

  Installs flexmailer on new installs by default.

### CiviMember

- **Fix code to use Order api to create Memberships in core forms (Work Towards
  [dev/core#2717](https://lab.civicrm.org/dev/core/-/issues/2717):
  [21152](https://github.com/civicrm/civicrm-core/pull/21152))**

  Use order api for new membership create in batch.

### WordPress integration

- **Add deduping to Quick Add Dashboard Widget
  ([256](https://github.com/civicrm/civicrm-wordpress/pull/256))**

  Adds a simple deduplication check when submitting details via the "Quick Add
  Contact to CiviCRM" Dashboard Widget.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Full Month Names: avoid relying on the operating system's locale for
  translation
  ([dev/translation#71](https://lab.civicrm.org/dev/translation/-/issues/71):
  [21157](https://github.com/civicrm/civicrm-core/pull/21157))**

- **CRM_Utils_Date - Month and day names should match active locale
  ([21569](https://github.com/civicrm/civicrm-core/pull/21569))**

- **System Workflow Messages - Improve localization experience (Work Towards
  [dev/mail#83](https://lab.civicrm.org/dev/mail/-/issues/83):
  [21773](https://github.com/civicrm/civicrm-core/pull/21773),
  [21747](https://github.com/civicrm/civicrm-core/pull/21747),
  [21774](https://github.com/civicrm/civicrm-core/pull/21774),
  [21772](https://github.com/civicrm/civicrm-core/pull/21772),
  [21590](https://github.com/civicrm/civicrm-core/pull/21590),
  [21338](https://github.com/civicrm/civicrm-core/pull/21338),
  [21480](https://github.com/civicrm/civicrm-core/pull/21480) and
  [21486](https://github.com/civicrm/civicrm-core/pull/21486))**

- **When extensions do upgrades and add fields to tables, trigger-based logging
  tables require the extension to do the right thing
  ([dev/core#1618](https://lab.civicrm.org/dev/core/-/issues/1618):
  [21135](https://github.com/civicrm/civicrm-core/pull/21135))**

- **Special characters become "?" On PDF report
  ([dev/core#2126](https://lab.civicrm.org/dev/core/-/issues/2126):
  [21423](https://github.com/civicrm/civicrm-core/pull/21423))**

- **Send an Email / Cancel button does not work
  ([dev/core#2318](https://lab.civicrm.org/dev/core/-/issues/2318):
  [21474](https://github.com/civicrm/civicrm-core/pull/21474))**

- **hook_civicrm_tokenValues inconsistent data
  ([dev/core#2554](https://lab.civicrm.org/dev/core/-/issues/2554):
  [21490](https://github.com/civicrm/civicrm-core/pull/21490))**

  Remove code to assign contact to the template in sendEmail.

- **Use consistent token syntax for pseudoconstants
  ([dev/core#2650](https://lab.civicrm.org/dev/core/-/issues/2650):
  [21477](https://github.com/civicrm/civicrm-core/pull/21477),
  [21464](https://github.com/civicrm/civicrm-core/pull/21464),
  [21570](https://github.com/civicrm/civicrm-core/pull/21570) and
  [21705](https://github.com/civicrm/civicrm-core/pull/21705))**

- **Remove unused token assigns (Work Towards
  [dev/core#2748](https://lab.civicrm.org/dev/core/-/issues/2748):
  [21059](https://github.com/civicrm/civicrm-core/pull/21059))**

  Removes some no-longer-used token assigns & adds an upgrade message in case
  people have templates still referring to them.

- **Something something tokens something tokens
  ([dev/core#2856](https://lab.civicrm.org/dev/core/-/issues/2856):
  [21580](https://github.com/civicrm/civicrm-core/pull/21580))**

  Token "filter" can be null so filter[0] doesn't exist.

- **Fix contact tokens class to load using apiv4
  ([21780](https://github.com/civicrm/civicrm-core/pull/21780))**

- **Remove case token listing from contact email task
  ([21787](https://github.com/civicrm/civicrm-core/pull/21787))**

- **Fix another instance of double token rendering
  ([21788](https://github.com/civicrm/civicrm-core/pull/21788))**

- **Fix token regression - re-add support for empty tokens
  ([21756](https://github.com/civicrm/civicrm-core/pull/21756))**

- **Fix event custom field tokens in scheduled reminders
  ([21374](https://github.com/civicrm/civicrm-core/pull/21374))**

- **Reference token metadata internally fix custom tokens label bug
  ([21767](https://github.com/civicrm/civicrm-core/pull/21767))**

- **Participant tokens - remove / replace unsupportable from badges (conversion
  preparation) ([21520](https://github.com/civicrm/civicrm-core/pull/21520))**

- **Fix activity tokens
  ([21489](https://github.com/civicrm/civicrm-core/pull/21489))**

- **Ensure TokenSmary::render returns an array
  ([21461](https://github.com/civicrm/civicrm-core/pull/21461))**

- **Replace event type token in action schedule changes event.event_type_id to
  participant.event_type_id:label
  ([dev/core#2892](https://lab.civicrm.org/dev/core/-/issues/2892):
  [21738](https://github.com/civicrm/civicrm-core/pull/21738))**

- **Custom field multiselect of type int crashes when saving
  ([dev/core#2772](https://lab.civicrm.org/dev/core/-/issues/2772):
  [21186](https://github.com/civicrm/civicrm-core/pull/21186))**

- **Deduping produces bad results after a rule change
  ([dev/core#2820](https://lab.civicrm.org/dev/core/-/issues/2820):
  [21509](https://github.com/civicrm/civicrm-core/pull/21509))**

- **[REF] Extend 'managed' api to provide information about 'status' (Clean up
  towards [dev/core#2823](https://lab.civicrm.org/dev/core/-/issues/2823):
  [21399](https://github.com/civicrm/civicrm-core/pull/21399),
  [21440](https://github.com/civicrm/civicrm-core/pull/21440),
  [21400](https://github.com/civicrm/civicrm-core/pull/21400),
  [21401](https://github.com/civicrm/civicrm-core/pull/21401),
  [21412](https://github.com/civicrm/civicrm-core/pull/21412) and
  [21395](https://github.com/civicrm/civicrm-core/pull/21395))**

- **Dashboard error `Trying to access array offset on value of type null`
  ([dev/core#2829](https://lab.civicrm.org/dev/core/-/issues/2829):
  [21441](https://github.com/civicrm/civicrm-core/pull/21441) and
  [21437](https://github.com/civicrm/civicrm-core/pull/21437))**

- **Upgrade error - upgrading to 5.43
  ([dev/core#2870](https://lab.civicrm.org/dev/core/-/issues/2870):
  [21640](https://github.com/civicrm/civicrm-core/pull/21640))**

  Fix upgrade error with rpow installed.

- **Search Builder: Fails validation when state_province location type is
  "primary" and operator is "IN"
  ([dev/core#2874](https://lab.civicrm.org/dev/core/-/issues/2874):
  [21646](https://github.com/civicrm/civicrm-core/pull/21646))**

- **APIv3 "replace" action is broken when there is > 25 records to replace.
  ([dev/core#2881](https://lab.civicrm.org/dev/core/-/issues/2881):
  [21681](https://github.com/civicrm/civicrm-core/pull/21681))**

- **Add contacts to Group action missing custom fields
  ([dev/core#2885](https://lab.civicrm.org/dev/core/-/issues/2885):
  [21716](https://github.com/civicrm/civicrm-core/pull/21716))**

- **Find Activities + Send Email task always says the contact is on hold or
  deceased etc ([dev/core#2901](https://lab.civicrm.org/dev/core/-/issues/2901):
  [21781](https://github.com/civicrm/civicrm-core/pull/21781))**

- **Afform - Fix chainSelect to work with anonymous users
  ([21759](https://github.com/civicrm/civicrm-core/pull/21759))**

- **Afform - Fix chain-select of country and address to work on SearchKit forms
  ([21749](https://github.com/civicrm/civicrm-core/pull/21749))**

- **Afform - gracefully handle missing html files
  ([21436](https://github.com/civicrm/civicrm-core/pull/21436))**

- **Afform - fix loading embedded blocks
  ([21609](https://github.com/civicrm/civicrm-core/pull/21609))**

- **Afform - ensure default value data type matches input type
  ([21643](https://github.com/civicrm/civicrm-core/pull/21643))**

- **api4 explorer - entity displays as `\undefined` in the generated code sample
  ([dev/core#2867](https://lab.civicrm.org/dev/core/-/issues/2867):
  [21634](https://github.com/civicrm/civicrm-core/pull/21634))**

- **APIv4 - Default select clause to exclude "Extra" fields
  ([21438](https://github.com/civicrm/civicrm-core/pull/21438))**

- **APIv4 - Give every SQL expression a title
  ([21691](https://github.com/civicrm/civicrm-core/pull/21691))**

- **APIv4 - Automatically coalesce potentially null field values in equations
  ([21647](https://github.com/civicrm/civicrm-core/pull/21647))**

- **UX: Deleting a saved Search Kit search should warn/delete associated afforms
  ([dev/core#2824](https://lab.civicrm.org/dev/core/-/issues/2824):
  [21457](https://github.com/civicrm/civicrm-core/pull/21457))**

- **search kit: deleting a search has weird confirmation dialog box
  ([dev/core#2826](https://lab.civicrm.org/dev/core/-/issues/2826):
  [21404](https://github.com/civicrm/civicrm-core/pull/21404))**

- **New download spreadsheet search kit feature broken
  ([dev/core#2888](https://lab.civicrm.org/dev/core/-/issues/2888):
  [21724](https://github.com/civicrm/civicrm-core/pull/21724))**

- **SearchKit - Style buttons for compatability with Shoreditch theme
  ([21627](https://github.com/civicrm/civicrm-core/pull/21627))**

- **SearchKit - tweak button styles for shorditch
  ([21726](https://github.com/civicrm/civicrm-core/pull/21726))**

  Tweaks the "Tags" and "Add" buttons in SearchKit to look better in Shoreditch,
  and tidies up some ts() calls.

- **SearchKit - A random stable genius
  ([21586](https://github.com/civicrm/civicrm-core/pull/21586))**

  Allows the pager, edit-in-place, and bulk updates to work properly with random
  sorting.

- **SearchKit - Exclude custom fields from ON clause selector
  ([21495](https://github.com/civicrm/civicrm-core/pull/21495))**

  Custom fields cannot as-yet be added to an ON clause in APIv4 because they do
  not belong to the tables being joined. This removes the tripping hazard from
  the UI, by making custom fields unavailable to select in an ON clause.

- **SearchKit - Fix links to non-aggregage join fields
  ([21482](https://github.com/civicrm/civicrm-core/pull/21482))**

- **SearchKit - Fix display of links in aggregated columns
  ([21420](https://github.com/civicrm/civicrm-core/pull/21420))**

- **SearchKit - Fix alignment in table headers
  ([21431](https://github.com/civicrm/civicrm-core/pull/21431))**

- **SearchKit - Correctly process filters passed through Afform from js
  ([21485](https://github.com/civicrm/civicrm-core/pull/21485))**

- **SearchKit - Prevent race conditions in search display loading
  ([21394](https://github.com/civicrm/civicrm-core/pull/21394))**

- **[search kit] Semicolon vs comma
  ([21406](https://github.com/civicrm/civicrm-core/pull/21406))**

- **message_admin Style fixes
  ([21712](https://github.com/civicrm/civicrm-core/pull/21712))**

- **message_admin - Fix quirk when using "Create Draft"
  ([21700](https://github.com/civicrm/civicrm-core/pull/21700))**

- **MessageTemplate API - Fix saving of templates with workflow_name sans
  workflow_id ([21694](https://github.com/civicrm/civicrm-core/pull/21694))**

- **Find Activities Search, default search option for Activity Text is set to
  "both" in the code, but should actually be set to 6 which is the value for
  "both" ([21598](https://github.com/civicrm/civicrm-core/pull/21598))**

- **UFMatch - E_NOTICE when nonexistent uf_id
  ([21576](https://github.com/civicrm/civicrm-core/pull/21576))**

- **flushCaches should respect permitCacheFlushMode. Also flush caches which
  have a NULL cache_date
  ([21430](https://github.com/civicrm/civicrm-core/pull/21430))**

- **Setting::getItem - use deprecatedWarning instead of just logging
  ([21625](https://github.com/civicrm/civicrm-core/pull/21625))**

- **Fix display of subscription frequency on 'Update Subscription' form
  ([21469](https://github.com/civicrm/civicrm-core/pull/21469))**

- **Fix bug where log hook is ignored on custom field create
  ([21557](https://github.com/civicrm/civicrm-core/pull/21557))**

- **Set default for civicrm_message_template.is_reserved
  ([21651](https://github.com/civicrm/civicrm-core/pull/21651))**

- **CiviReport - avoid error in test environments when using built-in php web
  server ([21560](https://github.com/civicrm/civicrm-core/pull/21560))**

- **Update SelfSvcUpdate.php
  ([21679](https://github.com/civicrm/civicrm-core/pull/21679))**

   Changes "cancel" text to read "cancel registration".

- **Import csv-Fix not importing extension in phones
  ([20995](https://github.com/civicrm/civicrm-core/pull/20995))**

- **Missed message template updates from 5.39/5.40
  ([21550](https://github.com/civicrm/civicrm-core/pull/21550))**

- **Don't clear the GroupContactCache until we're ready to insert the new
  version ([21384](https://github.com/civicrm/civicrm-core/pull/21384))**

- **Fix syntax error on a ts() function call
  ([21518](https://github.com/civicrm/civicrm-core/pull/21518))**

- **flushCaches should respect permitCacheFlushMode
  ([21468](https://github.com/civicrm/civicrm-core/pull/21468))**

- **Smarty warning about missing contact subtype on New Individual
  ([21410](https://github.com/civicrm/civicrm-core/pull/21410))**

- **Fix Upgrade step to ensure all fields are converted correctly as well
  ([21396](https://github.com/civicrm/civicrm-core/pull/21396))**

- **Don't specify character set for civicrm_relationship_cache table
  ([21382](https://github.com/civicrm/civicrm-core/pull/21382))**

- **Error about count() on New Email
  ([21714](https://github.com/civicrm/civicrm-core/pull/21714))**

- **Fix generating civicrm.settings.php by ensuring that CMSdbSSL and dbSSL
  variables are properly removed from the DSNs
  ([63](https://github.com/civicrm/civicrm-joomla/pull/63))**

- **Smarty notices on Find Activities results page
  ([21422](https://github.com/civicrm/civicrm-core/pull/21422))**

- **Smarty notice on Find Activities / Find Cases
  ([21421](https://github.com/civicrm/civicrm-core/pull/21421))**

- **Tpl notice fixes
  ([21503](https://github.com/civicrm/civicrm-core/pull/21503))**

- **Fix extra apostrophe added in 21636
  ([21650](https://github.com/civicrm/civicrm-core/pull/21650))**

- **avoid back trace when importing preferred communication method
  ([21433](https://github.com/civicrm/civicrm-core/pull/21433))**

- **Fixed issue with sending from do-not-reply@domain address
  ([21455](https://github.com/civicrm/civicrm-core/pull/21455))**

- **Find Activities Search, the default search option of "With" criteria
  excludes Activities by default. Confuses End Users when 0 results are returned
  when criteria appears to be correct.
  ([21595](https://github.com/civicrm/civicrm-core/pull/21595))**

- **Do not send email notification to the user if `notify` is not set in the
  params ([21562](https://github.com/civicrm/civicrm-core/pull/21562))**

- **ensure blank note date in UI defaults to current date.
  ([21717](https://github.com/civicrm/civicrm-core/pull/21717))**

- **System status checks only shows 25 messages
  ([21748](https://github.com/civicrm/civicrm-core/pull/21748))**

- **Enotice fixes
  ([21723](https://github.com/civicrm/civicrm-core/pull/21723))**

- **Enotice tpl fix
  ([21689](https://github.com/civicrm/civicrm-core/pull/21689))**

- **Enotice fix
  ([21782](https://github.com/civicrm/civicrm-core/pull/21782))**

- **Enotice fix
  ([21732](https://github.com/civicrm/civicrm-core/pull/21732))**

- **enotice fix
  ([21702](https://github.com/civicrm/civicrm-core/pull/21702))**

- **typo fixes
  ([21655](https://github.com/civicrm/civicrm-core/pull/21655))**

- **Enotice fix
  ([21636](https://github.com/civicrm/civicrm-core/pull/21636))**

- **enotice fix
  ([21631](https://github.com/civicrm/civicrm-core/pull/21631))**

- **Enotice fix
  ([21579](https://github.com/civicrm/civicrm-core/pull/21579))**

- **Fix header e-notices
  ([21633](https://github.com/civicrm/civicrm-core/pull/21633))**

- **Enotice fix
  ([21658](https://github.com/civicrm/civicrm-core/pull/21658))**

- **Enotice fixes
  ([21659](https://github.com/civicrm/civicrm-core/pull/21659))**

- **Enotice fixes
  ([21632](https://github.com/civicrm/civicrm-core/pull/21632))**

- **enotice fixes in fatal error template
  ([21639](https://github.com/civicrm/civicrm-core/pull/21639))**

- **Tpl notice fix
  ([21543](https://github.com/civicrm/civicrm-core/pull/21543))**

- **tpl enotice fixes on extensions page
  ([21545](https://github.com/civicrm/civicrm-core/pull/21545))**

- **Tpl notice fixes
  ([21544](https://github.com/civicrm/civicrm-core/pull/21544))**

- **Tpl enotice fixes
  ([21542](https://github.com/civicrm/civicrm-core/pull/21542))**

- **Enotice fixes in tpls
  ([21541](https://github.com/civicrm/civicrm-core/pull/21541))**

- **Add missing ts
  ([21711](https://github.com/civicrm/civicrm-core/pull/21711))**

- **Another enotice fix
  ([21682](https://github.com/civicrm/civicrm-core/pull/21682))**

- **And another one
  ([21683](https://github.com/civicrm/civicrm-core/pull/21683))**

- **Another one bites the dust
  ([21684](https://github.com/civicrm/civicrm-core/pull/21684))**

- **Fix possibly undefined $form variables in smarty templates
  ([21735](https://github.com/civicrm/civicrm-core/pull/21735))**

- **Fix regression from enotice fixes
  ([21743](https://github.com/civicrm/civicrm-core/pull/21743))**

- **Count of sent messages can be wrong in status popup for email form
  ([dev/core#2914](https://lab.civicrm.org/dev/core/-/issues/2914):
  [21827](https://github.com/civicrm/civicrm-core/pull/21827))

- **[REF] Fix pseduoconstant token rendering for contributions via legacy way on
  php8 and include campaign_id pseudoconsntants as well
  ([21958](https://github.com/civicrm/civicrm-core/pull/21958))**

### CiviCase

- **For latest iteration of case email form, don't fail when there's no To
  contact ([21737](https://github.com/civicrm/civicrm-core/pull/21737))**

### CiviContribute

- **Fix PHP notices in contributionrecur tpl
  ([21526](https://github.com/civicrm/civicrm-core/pull/21526))**

- **Follow up on removing contributeMode from templates
  ([21417](https://github.com/civicrm/civicrm-core/pull/21417))**

- **Getting system status message about contributeMode after upgrade to 5.43
  when it seems like it shouldn't
  ([dev/core#2828](https://lab.civicrm.org/dev/core/-/issues/2828):
  [21434](https://github.com/civicrm/civicrm-core/pull/21434))**

- **Participant Status: pending refund can have two conflicting meanings (Work
  Towards [dev/core#2629](https://lab.civicrm.org/dev/core/-/issues/2629):
  [21624](https://github.com/civicrm/civicrm-core/pull/21624))**

  Only show contribution statuses on contribution form.

- **Money - create new Civi:: facade - now format helper (Work Towards:
  [dev/core#2638](https://lab.civicrm.org/dev/core/-/issues/2638):
  [21599](https://github.com/civicrm/civicrm-core/pull/21599))**

  Adds a helper function for formatting.

- **CiviCRM 5.35.1, truncation of money values where $1,000 donation is recorded
  as $1 which appears to be truncating at the thousand separator when using the
  Australian (AU) and US Locale (Work Towards
  [dev/core#2493](https://lab.civicrm.org/dev/core/-/issues/2493):
  [21555](https://github.com/civicrm/civicrm-core/pull/21555))**

  Ensures that any money fields retrieved by getSubmittedValue are in a machine
  usable format.

- **[regression-ish] When a recurring contribution template has no line items,
  the contact contribution tab crashes
  ([dev/financial#187](https://lab.civicrm.org/dev/financial/-/issues/187):
  [21729](https://github.com/civicrm/civicrm-core/pull/21729))**

- **ContributionRecur modified_date should update to current_timestamp on update
  ([21472](https://github.com/civicrm/civicrm-core/pull/21472))**

- **ensure recur options are present on backend cc contribution form.
  ([21577](https://github.com/civicrm/civicrm-core/pull/21577))**

### CiviEvent

- **Flush metadata cache on event edit
  ([21740](https://github.com/civicrm/civicrm-core/pull/21740))**

- **Fix Badge to use token processor
  ([dev/core#2834](https://lab.civicrm.org/dev/core/-/issues/2834):
  [21458](https://github.com/civicrm/civicrm-core/pull/21458) and
  [21587](https://github.com/civicrm/civicrm-core/pull/21587))**

- **Event confirmation emails should go to the email submitted, not primary
  email ([dev/event#64](https://lab.civicrm.org/dev/event/-/issues/64):
  [21669](https://github.com/civicrm/civicrm-core/pull/21669))**

- **Fix label for participant role
  ([21656](https://github.com/civicrm/civicrm-core/pull/21656))**

### CiviMail

- **flexmailer - Update `[CiviMail Draft]` prefix to match BAO behavior
  ([21715](https://github.com/civicrm/civicrm-core/pull/21715))**

- **update_email_resetdate job does not consider opt out on hold
  ([dev/core#2850](https://lab.civicrm.org/dev/core/-/issues/2850):
  [21564](https://github.com/civicrm/civicrm-core/pull/21564))**

- **Start phasing out 'preferred_mail_format' (Work Towards
  [dev/core#2866](https://lab.civicrm.org/dev/core/-/issues/2866):
  [21676](https://github.com/civicrm/civicrm-core/pull/21676))**

### Drupal Integration

- **Contact Image uploaded from Drupal Webform doesn't render on Drupal View as
  a thumbnail. ([dev/drupal#13](https://lab.civicrm.org/dev/drupal/issues/13):
  [524](https://github.com/civicrm/civicrm-drupal/pull/524))**

- **Session erroneously getting set to NULL on Drupal user login
  ([dev/drupal#163](https://lab.civicrm.org/dev/drupal/-/issues/163):
  [21403](https://github.com/civicrm/civicrm-core/pull/21403))**

### WordPress integration

- **Wordpress Profile User Creation Sign On (v2)
  ([20807](https://github.com/civicrm/civicrm-core/pull/20807))**

  Ensures user is logged in on profile submission.

## <a name="misc"></a>Miscellany

- **MessageTemplate - Deprecate `valueName`. Emphasize `workflow`. Consolidate
  converters.  ([21657](https://github.com/civicrm/civicrm-core/pull/21657))**

- **Bump minimum upgradable version to 4.5.9
  ([21408](https://github.com/civicrm/civicrm-core/pull/21408))**

- **Use Case form for case email action
  ([21688](https://github.com/civicrm/civicrm-core/pull/21688))**

- **Consolidate building of contact token list
  ([21429](https://github.com/civicrm/civicrm-core/pull/21429),
  [21761](https://github.com/civicrm/civicrm-core/pull/21761), and
  [dev/core#2907](https://lab.civicrm.org/dev/core/-/issues/2907):
  [21812](https://github.com/civicrm/civicrm-core/pull/21812))**

- **Remove call to legacy getTokenDetails
  ([21786](https://github.com/civicrm/civicrm-core/pull/21786))**

- **Remove extraneous call to legacy token processing in sms task
  ([21785](https://github.com/civicrm/civicrm-core/pull/21785))**

- **Remove stray token code
  ([21763](https://github.com/civicrm/civicrm-core/pull/21763))**

- **Stop using `replaceContributionTokens` in core
  ([dev/core#2851](https://lab.civicrm.org/dev/core/-/issues/2851):
  [21525](https://github.com/civicrm/civicrm-core/pull/21525) and
  [21565](https://github.com/civicrm/civicrm-core/pull/21565))**

- **Add SqlFunction support in addWhere
  ([21301](https://github.com/civicrm/civicrm-core/pull/21301))**

- **Deprecate `replaceEntityTokens`, stop using in core
  ([dev/core#2832](https://lab.civicrm.org/dev/core/-/issues/2832):
  [21506](https://github.com/civicrm/civicrm-core/pull/21506),
  [21521](https://github.com/civicrm/civicrm-core/pull/21521),
  [21452](https://github.com/civicrm/civicrm-core/pull/21452) and
  [21453](https://github.com/civicrm/civicrm-core/pull/21453))**

- **Deprecate `replaceCaseTokens` in core
  ([dev/core#2817](https://lab.civicrm.org/dev/core/-/issues/2817):
  [21380](https://github.com/civicrm/civicrm-core/pull/21380),
  [21445](https://github.com/civicrm/civicrm-core/pull/21445),
  [21383](https://github.com/civicrm/civicrm-core/pull/21383),
  [21381](https://github.com/civicrm/civicrm-core/pull/21381),
  [21447](https://github.com/civicrm/civicrm-core/pull/21447) and
  [21475](https://github.com/civicrm/civicrm-core/pull/21475))**

- **Stop using replaceContactTokens in core (Work Towards
  [dev/core#2814](https://lab.civicrm.org/dev/core/-/issues/2814):
  [21365](https://github.com/civicrm/civicrm-core/pull/21365),
  [21414](https://github.com/civicrm/civicrm-core/pull/21414),
  [21364](https://github.com/civicrm/civicrm-core/pull/21364),
  [21379](https://github.com/civicrm/civicrm-core/pull/21379),
  [21377](https://github.com/civicrm/civicrm-core/pull/21377),
  [21378](https://github.com/civicrm/civicrm-core/pull/21378),
  [21568](https://github.com/civicrm/civicrm-core/pull/21568),
  [21494](https://github.com/civicrm/civicrm-core/pull/21494),
  [21367](https://github.com/civicrm/civicrm-core/pull/21367) and
  [21449](https://github.com/civicrm/civicrm-core/pull/21449))**

- **[REF] Cleanup pdf classes to use a trait like we do for email classes
  ([dev/core#2790](https://lab.civicrm.org/dev/core/-/issues/2790):
  [21478](https://github.com/civicrm/civicrm-core/pull/21478),
  [21479](https://github.com/civicrm/civicrm-core/pull/21479),
  [21366](https://github.com/civicrm/civicrm-core/pull/21366),
  [21359](https://github.com/civicrm/civicrm-core/pull/21359) and
  [21335](https://github.com/civicrm/civicrm-core/pull/21335))**

- **Afform - Add getters/setters to the AfformSubmitEvent class
  ([21572](https://github.com/civicrm/civicrm-core/pull/21572))**

- **Api v4 contact delete bug (Cleanup Towards
  [dev/core#2757](https://lab.civicrm.org/dev/core/-/issues/2757):
  [21210](https://github.com/civicrm/civicrm-core/pull/21210),
  [21198](https://github.com/civicrm/civicrm-core/pull/21198),
  [21211](https://github.com/civicrm/civicrm-core/pull/21211) and
  [21199](https://github.com/civicrm/civicrm-core/pull/21199))**

- **[REF] Separate repeattransaction from completeorder function - only call the
  latter from payment.create
  (Cleanup Towards [dev/core#2716](https://lab.civicrm.org/dev/core/-/issues/2716):
  [20856](https://github.com/civicrm/civicrm-core/pull/20856))**

- **Financial record processing - extract to new class to faciliate cleanup
  (Work Towards [dev/core#2715](https://lab.civicrm.org/dev/core/-/issues/2715):
  [20985](https://github.com/civicrm/civicrm-core/pull/20985) and
  [21370](https://github.com/civicrm/civicrm-core/pull/21370))**

- **Add unique class to price field template
  ([21484](https://github.com/civicrm/civicrm-core/pull/21484))**

- **Clean up UpdateBilling/UpdateSubscription/ContributionRecur to use getters
  ([21538](https://github.com/civicrm/civicrm-core/pull/21538))**

- **[REF] Fix form to call this->setTitle()
  ([21362](https://github.com/civicrm/civicrm-core/pull/21362))**

- **Update use of CRM_Utils_System::setTitle() for legacycustomsearches
  ([21375](https://github.com/civicrm/civicrm-core/pull/21375))**

- **Switch to CRM_Core_Form::setTitle() instead of CRM_Utils_System::setTitle()
  part 2 ([21202](https://github.com/civicrm/civicrm-core/pull/21202))**

- **Switch to CRM_Core_Form::setTitle() instead of CRM_Utils_System::setTitle()
  part 3 ([21352](https://github.com/civicrm/civicrm-core/pull/21352))**

- **Switch to CRM_Core_Form::setTitle() instead of CRM_Utils_System::setTitle()
  part 4 ([21368](https://github.com/civicrm/civicrm-core/pull/21368))**

- **Simplify getRecurFromAddress
  ([21613](https://github.com/civicrm/civicrm-core/pull/21613))**

- **Return another function to the email trait
  ([21677](https://github.com/civicrm/civicrm-core/pull/21677))**

- **Rename test clas to reflect tested class name
  ([21686](https://github.com/civicrm/civicrm-core/pull/21686))**

- **Remove unused function - convertDateFieldsToMySQL
  ([21617](https://github.com/civicrm/civicrm-core/pull/21617))**

- **Remove all references to safe_mode, DEPRECATED as of PHP 5.3.0 and REMOVED
  as of PHP 5.4.0
  ([21594](https://github.com/civicrm/civicrm-core/pull/21594))**

- **Remove duplicate global declaration in civicrm.settings.php template
  ([21409](https://github.com/civicrm/civicrm-core/pull/21409))**

- **Remove broken code
  ([21602](https://github.com/civicrm/civicrm-core/pull/21602))**

- **Remove call to the dreaded replaceMultipleContributionTokens
  ([21652](https://github.com/civicrm/civicrm-core/pull/21652))**

- **Remove handling for empty required field
  ([21623](https://github.com/civicrm/civicrm-core/pull/21623))**

- **Remove error handling for core error being returned
  ([21425](https://github.com/civicrm/civicrm-core/pull/21425))**

- **Remove over-copied function
  ([21641](https://github.com/civicrm/civicrm-core/pull/21641))**

- **Remove unused paramter
  ([21685](https://github.com/civicrm/civicrm-core/pull/21685))**

- **Remove deprecated code lines
  ([21566](https://github.com/civicrm/civicrm-core/pull/21566))**

- **Remove workflow_id reference
  ([21671](https://github.com/civicrm/civicrm-core/pull/21671))**

- **Remove now-silly function
  ([21680](https://github.com/civicrm/civicrm-core/pull/21680))**

- **Remove fugly bit
  ([21497](https://github.com/civicrm/civicrm-core/pull/21497))**

- **Remove requirement to enter email address on Opt Out
  ([21350](https://github.com/civicrm/civicrm-core/pull/21350))**

- **Remove requirement to enter email address on unsubscribe
  ([21175](https://github.com/civicrm/civicrm-core/pull/21175))**

- **Remove deprecated input variable
  ([21372](https://github.com/civicrm/civicrm-core/pull/21372))**

- **Remove unused private function
  ([21371](https://github.com/civicrm/civicrm-core/pull/21371))**

- **Remove deprecated function
  ([21361](https://github.com/civicrm/civicrm-core/pull/21361))**

- **Remove testing hack
  ([21360](https://github.com/civicrm/civicrm-core/pull/21360))**

- **Remove deprecated function
  ([21358](https://github.com/civicrm/civicrm-core/pull/21358))**

- **Removes duplicate replace on event fee amount.
  ([21739](https://github.com/civicrm/civicrm-core/pull/21739))**

- **Remove function duplicated in error
  ([21758](https://github.com/civicrm/civicrm-core/pull/21758))**

- **Remove now-obsolete getPseudoTokens
  ([21760](https://github.com/civicrm/civicrm-core/pull/21760))**

- **APIv4 - Minor code cleanup to improve efficiency in
  CreateApi4RequestSubscriber
  ([21775](https://github.com/civicrm/civicrm-core/pull/21775))**

- **Function cleanup following move to non-static function
  ([21693](https://github.com/civicrm/civicrm-core/pull/21693))**

- **[REF] Extract getRedirectUrl method
  ([21687](https://github.com/civicrm/civicrm-core/pull/21687))**

- **[REF] Copy another email trait function back to the trait
  ([21648](https://github.com/civicrm/civicrm-core/pull/21648))**

- **REF - Remove non-functional code from APIv3
  ([21727](https://github.com/civicrm/civicrm-core/pull/21727))**

- **[REF] Do not set input['line_item'] pointlessly
  ([21311](https://github.com/civicrm/civicrm-core/pull/21311))**

- **[REF] Use getSubmittedValue rather than passed values
  ([21668](https://github.com/civicrm/civicrm-core/pull/21668))**

- **(REF) MessageTemplate - Reverse renderTemplate()<=>sendTemplate() call
  ([21610](https://github.com/civicrm/civicrm-core/pull/21610))**

- **[REF] Separate contact tokens from 'tokenCompatSubscriber'
  ([21626](https://github.com/civicrm/civicrm-core/pull/21626))**

- **[Ref] Function signature cleanup
  ([21618](https://github.com/civicrm/civicrm-core/pull/21618))**

- **[REF] Return the sendEmail function to it's owner
  ([21608](https://github.com/civicrm/civicrm-core/pull/21608))**

- **[REF] Remove illusion of looping
  ([21554](https://github.com/civicrm/civicrm-core/pull/21554))**

- **[Ref] Extend email trait test, process more sanely
  ([21553](https://github.com/civicrm/civicrm-core/pull/21553))**

- **[REF] Extract domain tokens to their own class
  ([21510](https://github.com/civicrm/civicrm-core/pull/21510))**

- **[REF] add test & static array to participant values tokens
  ([21476](https://github.com/civicrm/civicrm-core/pull/21476))**

- **[REF] simplify member_tokens
  ([21481](https://github.com/civicrm/civicrm-core/pull/21481))**

- **[Ref] Cleanup on SelectValues::contributeTokens
  ([21465](https://github.com/civicrm/civicrm-core/pull/21465))**

- **[Ref] Remove pass-by-reference
  ([21466](https://github.com/civicrm/civicrm-core/pull/21466))**

- **[Ref] Remove unnecessary pass-by-reference
  ([21463](https://github.com/civicrm/civicrm-core/pull/21463))**

- **[REF] Use OO when determining what to suggest for settings.php prefixes for
  drupal/backdrop views, instead of scattered "if cms =="
  ([21042](https://github.com/civicrm/civicrm-core/pull/21042))**

- **[REF] Remove unused parameter
  ([21448](https://github.com/civicrm/civicrm-core/pull/21448))**

- **[REF] Remove unused variable
  ([21451](https://github.com/civicrm/civicrm-core/pull/21451))**

- **[REF] Extract code to load the contact in tokenCompat
  ([21450](https://github.com/civicrm/civicrm-core/pull/21450))**

- **[REF] Extract function to getDomainTokens
  ([21416](https://github.com/civicrm/civicrm-core/pull/21416))**

- **[REF] Remove cruft
  ([21418](https://github.com/civicrm/civicrm-core/pull/21418))**

- **[REF] Extract code to get the from address for a recurring contribution.
  ([21357](https://github.com/civicrm/civicrm-core/pull/21357))**

- **[Ref] Remove no-longer-used variables
  ([21459](https://github.com/civicrm/civicrm-core/pull/21459))**

- **[REF] Update Frequenecy template assignments in UpdateBilling to be
  consistent with #21469
  ([21635](https://github.com/civicrm/civicrm-core/pull/21635))**

- **[REF] Update Product Create to use hooks and also switch the manage
  product/premium page to use APIv4 Product Entity
  ([20822](https://github.com/civicrm/civicrm-core/pull/20822))**

- **[REF] Add in upgrade step to align the relationship cache table collation
  and charset with the other tables
  ([21389](https://github.com/civicrm/civicrm-core/pull/21389))**

- **[REF] stop passing form into createActivities
  ([21653](https://github.com/civicrm/civicrm-core/pull/21653))**

- **[REF] Extract function for re-use
  ([21778](https://github.com/civicrm/civicrm-core/pull/21778))**

- **[REF] Move getCustomFieldTokens to the tokens class, annotate more
  deprecations ([21660](https://github.com/civicrm/civicrm-core/pull/21660))**

- **Update contributors for Third Sector Design
  ([21516](https://github.com/civicrm/civicrm-core/pull/21516))**

- **[NFC/Unit test] - Fix test fail on php 7.4
  CRM_Core_BAO_MessageTemplateTest::testCaseActivityCopyTemplate
  ([21443](https://github.com/civicrm/civicrm-core/pull/21443))**

- **[NFC/Unit Test] Remove wombats and bananas from
  sites/default/files/civicrm/custom
  ([21768](https://github.com/civicrm/civicrm-core/pull/21768))**

- **[NFC/Unit test] - Fix secondary issue with case token consistency test
  ([21369](https://github.com/civicrm/civicrm-core/pull/21369))**

- **Authx: README: add note about CMS permissions
  ([21439](https://github.com/civicrm/civicrm-core/pull/21439))**

- **[NFC] Add test for new case email url
  ([21766](https://github.com/civicrm/civicrm-core/pull/21766))**

- **[NFC] Afform - Add array shape annotations to FormDataModel
  ([21765](https://github.com/civicrm/civicrm-core/pull/21765))**

- **[NFC] Unit test fixes for the problem of quickform rules going missing
  ([21725](https://github.com/civicrm/civicrm-core/pull/21725))**

- **NFC - Update code comments
  ([21675](https://github.com/civicrm/civicrm-core/pull/21675))**

- **[NFC] Unit test for file-on-case
  ([21678](https://github.com/civicrm/civicrm-core/pull/21678))**

- **[NFC] [test] minor cleanup in test
  ([21498](https://github.com/civicrm/civicrm-core/pull/21498))**

- **[NFC] Fix Fatal error on php 8 due to mis matched function declaration
  ([21487](https://github.com/civicrm/civicrm-core/pull/21487))**

- **[NFC] Put back email test without tokens and enhance a little
  ([21398](https://github.com/civicrm/civicrm-core/pull/21398))**

- **[NFC] Extend send email test to cover for contact tokens being replaced
  ([21386](https://github.com/civicrm/civicrm-core/pull/21386))**

- **[NFC] Add in type hints to template upgrade functions
  ([21390](https://github.com/civicrm/civicrm-core/pull/21390))**

- **NFC Clarify description for ckeditor4 plugin
  ([21349](https://github.com/civicrm/civicrm-core/pull/21349))**

- **Improve test readability, use schema labels for membership tokens
  ([21708](https://github.com/civicrm/civicrm-core/pull/21708))**

- **Add test to cancel subscription form
  ([21588](https://github.com/civicrm/civicrm-core/pull/21588))**

- **Fix test to test trait not deprecated function
  ([21373](https://github.com/civicrm/civicrm-core/pull/21373))**

- **Fix test
  ([21585](https://github.com/civicrm/civicrm-core/pull/21585))**

- **Tests -  update to use postProcess
  ([21637](https://github.com/civicrm/civicrm-core/pull/21637))**

- **Basic IDE cleanup on test class
  ([21661](https://github.com/civicrm/civicrm-core/pull/21661))**

- **Test fix
  ([21662](https://github.com/civicrm/civicrm-core/pull/21662))**

- **tests/events/*.php - Enforce general compliance with hook/event signatures
  ([21615](https://github.com/civicrm/civicrm-core/pull/21615))**

- **HttpTestTrait - Allow one to easily authenticate subrequests
  ([21261](https://github.com/civicrm/civicrm-core/pull/21261))**

- **Test regression fix
  ([21649](https://github.com/civicrm/civicrm-core/pull/21649))**

- **Test tearDown fixes
  ([21548](https://github.com/civicrm/civicrm-core/pull/21548))**

- **Convert more tests to call postProcess
  ([21628](https://github.com/civicrm/civicrm-core/pull/21628))**

- **Stop testing for gender_id output that was described as 'legacy' years ago
  ([21558](https://github.com/civicrm/civicrm-core/pull/21558))**

- **Test cleanup
  ([21622](https://github.com/civicrm/civicrm-core/pull/21622))**

- **Fix test to use postProcess
  ([21630](https://github.com/civicrm/civicrm-core/pull/21630))**

- **Test cleanup -convert to use postProcess
  ([21629](https://github.com/civicrm/civicrm-core/pull/21629))**

- **Add test and fix for API4 failing to decode strings stored as HTML
  ([21549](https://github.com/civicrm/civicrm-core/pull/21549))**

- **Initial test on event tokens
  ([21563](https://github.com/civicrm/civicrm-core/pull/21563))**

- **Cleanup on test tear downs
  ([21552](https://github.com/civicrm/civicrm-core/pull/21552))**

- **Attempt to fix test site 500 errors on activity pdf
  ([21504](https://github.com/civicrm/civicrm-core/pull/21504))**

- **(NFC) TokenConsistencyTest - Add some examples of HTML escaping
  ([21837](https://github.com/civicrm/civicrm-core/pull/21837))**

- **[REF] Fix PDF Test failure on php versions 7.4 and later
  ([21866](https://github.com/civicrm/civicrm-core/pull/21866))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Justin Freeman; Andy
Burns; Benjamin W; Christian Wach; CiviCoop - Jaap Jansma; CiviCRM - Coleman
Watts, Tim Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy;
Dave D; Digitalcourage - Detlev Sieber; Francesc Bassas i Bullich; Fuzion -
Jitendra Purohit; Greenpeace Central and Eastern Europe - Patrick Figel; iXiam -
Rubén Pineda; JMA Consulting - Monish Deb, Seamus Lee; John Kingsnorth;
Lighthouse Consulting and Design - Brian Shaughnessy; Megaphone Technology
Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; Progressive Technology
Project - Jamie McClelland; Third Sector Design - Kurund Jalmi, Michael
McAndrew, William Mortada; Valéry Gouleau; Wikimedia Foundation - Eileen
McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Eli Lisseck; Artful Robot - Rich Lott; Black Brick Software -
David Hayes; CiviCRM - Josh Gowans; CiviDesk - Yashodha Chaku; CompuCorp - Omar
Abu Hussein; Freeform Solutions - Herb van den Dool; Humanists UK - Andrew West;
Lemniscus - Noah Miller; OPEN - dewy; Richard Baugh; Richard van Oosterhout;
Semper IT - Karin Gerritsen; Skvare - Mark Hanna; Squiffle Consulting - Aidan
Saunders; Tadpole Collective - Kevin Cristiano

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
