/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */

package com.android.internal.graphics.palette;

import java.util.List;

/**
 * Definition of an algorithm that receives pixels and outputs a list of colors.
 */
public interface Quantizer {
    /**
     * Create colors representative of the colors present in pixels.
     * @param pixels Set of ARGB representation of a color.
     * @param maxColors number of colors to generate
     */
    void quantize(int[] pixels, int maxColors);

    /**
     * List of colors generated by previous call to quantize.
     */
    List<Palette.Swatch> getQuantizedColors();
}
