# I.7 Won't Libertarian Socialism destroy individuality?

No. Libertarian socialism only suppresses individuality for those who are so
shallow that they cannot separate their identity from what they own. However,
be that as it may, this is an important objection to any form of socialism
and, given the example of "socialist" Russia, needs to be discussed more.

The basic assumption behind this question is that capitalism encourages
individuality, but this assumption can be faulted on many levels. As Kropotkin
noted, _"individual freedom [has] remained, both in theory and in practice,
more illusory than real"_ and that the _"want of development of the
personality (leading to herd-psychology) and the lack of individual creative
power and initiative are certainly one of the chief defects of our time.
Economical individualism has not kept its promise: it did not result in any
striking development of individuality."_ [ **Ethics** , p. 27 and p. 28] In
effect, modern capitalism has reduced individuality to a parody of what it
could and should be (see [section I.7.4](secI7.md#seci74)). Little wonder
Emma Goldman argued that:

> _"The oft repeated slogan of our time is . . . that ours is an era of
> individualism . . . Only those who do not probe beneath the surface might be
> led to entertain this view. Have not the few accumulated the wealth of the
> world? Are they not the masters, the absolute kings of the situation? Their
> success, however, is due not to individualism, but the inertia, the
> cravenness, the utter submission of the mass. The latter wants but to be
> dominated, to be led, to be coerced. As to individualism, at no time in
> human history did it have less chance of expression, less opportunity to
> assert itself in a normal, healthy manner."_ [ **Anarchism and Other
> Essays** , pp. 70-1]

So we see a system which is apparently based on "egotism" and "individualism"
but whose members are free to be standardised individuals, who hardly express
their individuality at all. Far from increasing individuality, capitalism
standardises it and so restricts it -- that it survives at all is more an
expression of the strength of humanity than any benefits of the capitalist
system. This impoverishment of individuality is hardly surprising in a society
based on hierarchical institutions which are designed to assure obedience and
subordination. Given this, it comes as no surprise to find libertarian
communists like Kropotkin suggesting that _"as for knowing what will be the
essence of **individual** development, I do not think it **could** be along
individualist lines. Individual -- yes, without doubt, but individ **ualist**
\-- I have my doubts. That would mean: **narrow egoism** \-- regressive
evolution and even that would be limited to a certain number."_ [quoted by
Ruth Kinna, _"Kropotkin's theory of Mutual Aid in Historical Context"_ , pp.
259-283, **International Review of Social History** , No. 40, p. 268]

So, can we say that libertarian socialism will **increase** individuality or
is this conformity and lack of "individualism" a constant feature of the human
race? In order to make some sort of statement on this, we have to look at non-
hierarchical societies and organisations. We will discuss tribal cultures as
an example of non-hierarchical societies in [section
I.7.1](secI7.md#seci71). Here, however, we indicate how anarchist
organisations will protect and increase an individual's sense of self.

Anarchist organisations and tactics are designed to promote individuality.
They are decentralised, participatory organisations and so they give those
involved the "social space" required to express themselves and develop their
abilities and potential in ways restricted under capitalism. As Gaston Leval
noted in his book on the anarchist collectives during the Spanish Revolution,
_"so far as collective life is concerned, the freedom of each is the right to
participate spontaneously with one's thought, one's will, one's initiative to
the full extent of one's capacities. A negative liberty is not liberty; it is
nothingness."_ [ **Collectives in the Spanish Revolution** , p. 346]

By being able to take part in and manage the decision making processes which
directly affect you, your ability to think for yourself is increased and so
you are constantly developing your abilities and personality. The spontaneous
activity described by Leval has important psychological impacts. Thus Erich
Fromm: _"In all spontaneous activity, the individual embraces the world. Not
only does his [sic] individual self remain intact; it becomes stronger and
more solidified. **For the self is as strong as it is active.** "_ [ **Escape
from Freedom** , p. 225]

Therefore, individuality does not atrophy within an anarchist organisation as
it does under capitalism. It will become stronger as people participate and
act within the social organisation. In other words, individuality requires
community. As German philosopher and sociologist Max Horkheimer once observed,
_"individuality is impaired when each man decides to fend for himself . . .
The absolutely isolated individual has always been an illusion. The most
esteemed personal qualities, such as independence, will to freedom, sympathy,
and the sense of justice, are social as well as individual virtues. The fully
developed individual is the consummation of a fully developed society."_ [
**The Eclipse of Reason** , p. 135]

The sovereign, self-sufficient individual is as much a product of a healthy
community as it is of individual self-realisation and the fulfilment of
desire. There is a tendency for **community** to enrich and develop
**individuality** , with this tendency being seen throughout human history.
This suggests that the abstract individualism of capitalism is more the
exception than the rule in social life. In other words, history indicates that
by working together with others as equals individuality is strengthened far
more than in the so-called "individualism" associated with capitalism. Hence
the need, as Murray Bookchin put it, to _"arrest the ravaging and
simplification of the human spirit, of human personality, of human community,
of humanity's idea of the good."_ [ **The Ecology of Freedom** , p. 409]

Communal support for individuality is hardly surprising as individuality is a
product of the interaction between **social** forces and individual
attributes. The more an individual cuts themselves off from social life, the
more likely their individuality will suffer. This can be seen from the 1980s
when neo-liberal governments supporting the individualism associated with free
market capitalism were elected in both Britain and the USA. The promotion of
market forces lead to social atomisation, social disruption and a more
centralised state. As this swept across society, the resulting disruption of
social life ensured that many individuals became impoverished ethically and
culturally as society became increasingly privatised. Two decades later, David
Cameron, the leader of the Conservative party, complained of a broken society
in Britain while, of course, skilfully avoiding discussing the neo-liberal
reforms imposed by his predecessor Thatcher which made it so.

In other words, many of the characteristics which we associate with a
developed individuality (namely ability to think, to act, to hold your own
opinions and standards and so forth) are (essentially) **social** skills and
are encouraged by a well developed community. Remove that social background
and these valued aspects of individuality are undermined by lack of use, fear
of authority, atomisation and limited social interaction. Taking the case of
workplaces, for example, surely it is an obvious truism that a hierarchical
working environment will marginalise the individual and ensure that they
cannot express their opinions, exercise their thinking capacities to the full
or manage their own activity. This will have in impact in all aspects of an
individual's life.

Hierarchy in all its forms produces oppression and a crushing of individuality
(see [section B.1](secB1.md)). In such a system, as left-wing classical
liberal John Stuart Mill argued, the _"business"_ side of group activities
would be _"properly carried out"_ but at the expense of the individuals
involved. Anarchists agree with Mill when he called it _"benevolent
dictatorship"_ and asked _"what sort of human beings can be formed under such
a regimen? What development can either their thinking or their active
faculties attain under it? . . . Their moral capacities are equally stunted.
Wherever the sphere of action of human beings is artificially circumscribed,
their sentiments are narrowed and dwarfed."_ [ **Representative Government** ,
pp. 203-4] Like anarchists, he extended his critique of political
organisations into all forms of associations and stated that if _"mankind is
to continue to improve"_ then in the end one form of association will
predominate, _"not that which can exist between a capitalist as chief, and
workpeople without a voice in the management, but the association of labourers
themselves on terms of equality, collectively owning the capital with which
they carry on their operations, and working under managers elected and
removable by themselves."_ [ **The Principles of Political Economy** , p. 147]

Hence, anarchism will protect and develop individuality by creating the means
by which all individuals can participate in the decisions that affect them, in
all aspects of their lives. Anarchism is built upon the central assertion that
individuals and their institutions cannot be considered in isolation from one
another. Authoritarian organisations will create a servile personality, one
that feels safest conforming to authority and what is considered normal. A
libertarian organisation, one that is based upon participation and self-
management will encourage a strong personality, one that knows its own mind,
thinks for itself and feels confident in its own powers.

Therefore, as Bakunin argued, liberty _"is not a fact springing from isolation
but from reciprocal action, a fact not of exclusion, but, on the contrary, of
social interaction -- for freedom of every individual is simply the reflection
of his humanity or his human right in the consciousness of all free men, his
brothers, his equals."_ Freedom _"is something very positive, very complex,
and above all eminently social, since it can be realised only by society and
only under conditions of strict equality and solidarity."_ Hierarchical power,
by necessity, kills individual freedom as it is _"characteristic of privilege
and of every privileged position to kill the minds and hearts of men"_ and
_"power and authority corrupt those who exercise them as much as those who are
compelled to submit to them."_ [ **The Political Philosophy of Bakunin** , p.
266, p. 268, p. 269 and p. 249]

A libertarian re-organisation of society will be based upon, and encourage, a
self-empowerment and self-liberation of the individual and by participation
within self-managed organisations individuals will educate themselves for the
responsibilities and joys of freedom. As Carole Pateman points out,
_"participation develops and fosters the very qualities necessary for it; the
more individuals participate the better able they become to do so."_ [
**Participation and Democratic Theory** , pp. 42-43] This, of course, implies
a mutually interactive transformation of individuals, their social
relationships and organisations (in the words of Spanish anarchist Garcia
Oliver: _"Who hasn't been changed by the revolution? It wouldn't be worth
making it just to continue being the same."_ [quoted by Abel Paz, **Durruti in
the Spanish Revolution** , p. 498]).

Such a re-organisation (as we will see in [section J.2](secJ2.md)) is based
upon the tactic of **direct action.** This tactic also encourages
individuality by encouraging the individual to fight for themselves, by their
own self-activity, that which they consider to be wrong. As Voltairine de
Cleyre put it:

> _"Every person who ever thought he had a right to assert, and went boldly
> and asserted it, himself, or jointly with others that shared his
> convictions, was a direct actionist . . ._

> _"Every person who ever had a plan to do anything, and went and did it, or
> who laid his plan before others, and won their co-operation to do it with
> him, without going to external authorities to please do the thing for them,
> was a direct actionist. All co-operative experiments are essentially direct
> action._

> _"Every person who ever in his life had a difference with anyone to settle,
> and want straight to the other persons involved to settle it . . . was a
> direct actionist. Examples of such action are strikes and boycotts . . ._

> _"These actions . . . are the spontaneous retorts of those who feel
> oppressed by a situation."_ [ **The Voltairine de Cleyre Reader** , pp.
> 47-8]

Therefore, anarchist tactics base themselves upon self-assertion and this can
only develop individuality. Self-activity can only occur when there is a
independent, free-thinking self. As self-management is based upon the
principle of direct action ( _"all co-operative experiments are essentially
direct action"_ ) we can suggest that individuality will have little to fear
from an anarchist society. Indeed, anarchists strongly stress the importance
of individuality within a society. To quote communist-anarchist J. Burns-
Gibson:

> _"to destroy individuality is to destroy society. For society is only
> realised and alive in the individual members. Society has no motive that
> does not issue from its individual members, no end that does not centre in
> them, no mind that is not theirs. 'Spirit of the age,' 'public opinion,'
> 'commonweal or good,' and like phrases have no meaning if they are thought
> of as features of something that hovers or floats between man and woman.
> They name what resides in and proceeds from individuals. Individuality and
> community, therefore, are equally constitutive of our idea of human life."_
> [quoted by William R. McKercher, **Freedom and Authority** , p. 31]

Little wonder, then, that anarchism _"recognises and values individuality
which means character, conduct and the springs of conduct, free initiative,
creativeness, spontaneity, autonomy."_ [J. Burns-Gibson, quoted by McKercher,
**Op. Cit.** , p. 31f] As Kropotkin put it, anarchism _"seeks the most
complete development of individuality combined with the highest development of
voluntary association in all its aspects . . . ever changing, ever modified"_.
[ **Anarchism** , p. 123]

For anarchists real liberty requires social equality: _"If individuals are to
exercise the maximum amount of control over their own lives and environment
then authority structures in these areas most be so organised that they can
participate in decision making."_ [Pateman, **Op. Cit.** , p. 43] Hence
individuality will be protected, encouraged and developed in an anarchist
society far more than in a class ridden, hierarchical society like capitalism.
As Kropotkin argued:

> _"[Libertarian] Communism is the best basis for individual development and
> freedom; not that individualism which drives men to the war of each against
> all . . . but that which represents the full expansion of man's [and
> woman's] faculties, the superior development of what is original in him [or
> her], the greatest fruitfulness of intelligence, feeling and will."_ [ **Op.
> Cit.** , p. 141]

It is because wonders are so enriching to life, and none is more wonderful
than individuality, that anarchists oppose capitalism in the name of socialism
-- libertarian socialism, the free association of free individuals.

## I.7.1 Do tribal cultures indicate that communalism defends individuality?

Yes. In many tribal cultures (or aboriginal cultures), we find a strong
respect for individuality. As anthropologist Paul Radin pointed out, _"respect
for the individual, irrespective of age or sex"_ was one of _"the outstanding
features of aboriginal civilisation"_ as well as _"the amazing degree of
social and political integration achieved by them"_ and _"a concept of
personal security."_ [quoted by Murray Bookchin, **Remaking Society** , p. 48]
Murray Bookchin commented on Radin's statement:

> _"respect for the individual, which Radin lists first as an aboriginal
> attribute, deserves to be emphasised, today, in an era that rejects the
> collective as destructive of individuality on the one hand, and yet, in an
> orgy of pure egotism, has actually destroyed all the ego boundaries of free-
> floating, isolated, and atomised individuals on the other. A strong
> collectivity may be even more supportive of the individual as close studies
> of certain aboriginal societies reveal, than a 'free market' society with
> its emphasis on an egoistic, but impoverished, self."_ [ **Op. Cit.** , p.
> 48]

This individualisation associated with tribal cultures was also noted by
historian Howard Zinn. He quotes fellow historian Gary Nash describing
Iroquois culture:

> _"No laws and ordinances, sheriffs and constables, judges and juries, or
> courts or jails -- the apparatus of authority in European societies -- were
> to be found in the north-east woodlands prior to European arrival. Yet
> boundaries of acceptable behaviour were firmly set. Though priding
> themselves on the autonomous individual, the Iroquois maintained a strict
> sense of right and wrong."_ [quoted by Zinn, **A People's History of the
> United States** , p. 21]

This respect for individuality existed in a society based on communistic
principles. As Zinn notes, in the Iroquois _"land was owned in common and
worked in common. Hunting was done together, and the catch was divided among
the members of the village. Houses were considered common property and were
shared by several families. The concept of private ownership of land and homes
was foreign to the Iroquois."_ In this communal society women _"were important
and respected"_ and families were matrilineal. Power was shared between the
sexes (unlike the European idea of male domination). Similarly, children
_"while taught the cultural heritage of their people and solidarity with the
tribe, were also taught to be independent, not to submit to overbearing
authority. They were taught equality of status and the sharing of
possessions."_ As Zinn stresses, Native American tribes _"paid careful
attention to the development of personality, intensity of will, independence
and flexibility, passion and potency, to their partnership with one another
and with nature."_ [ **Op. Cit.** , p. 20 and pp. 21-2]

Thus tribal societies indicate that community defends individuality, with
communal living actually encouraging a strong sense of individuality. This is
to be expected, as equality is the only condition in which individuals can be
free and so in a position to develop their personality to its full.
Furthermore, this communal living took place within an anarchist environment:

> _"The foundation principle of Indian government had always been the
> rejection of government. The freedom of the individual was regarded by
> practically all Indians north of Mexico as a canon infinitely more precious
> than the individual's duty to his [or her] community or nation. This
> anarchistic attitude ruled all behaviour, beginning with the smallest social
> unity, the family. The Indian parent was constitutionally reluctant to
> discipline his [or her] children. Their every exhibition of self-will was
> accepted as a favourable indication of the development of maturing
> character."_ [Van Every, quoted by Zinn, **Op. Cit.** , p. 136]

In addition, Native American tribes also indicate that communal living and
high standards of living can and do go together. For example, during the 1870s
in the Cherokee Nation _"land was held collectively and life was contented and
prosperous"_ with the US Department of the Interior recognising that it was
_"a miracle of progress, with successful production by people living in
considerable comfort, a level of education 'equal to that furnished by an
ordinary college in the States,' flourishing industry and commerce, an
effective constitutional government, a high level of literacy, and a state of
'civilisation and enlightenment' comparable to anything known: 'What required
five hundred years for the Britons to accomplish in this direction they have
accomplished in one hundred years,' the Department declared in wonder."_ [Noam
Chomsky, **Year 501** , p. 231]

Senator Henry Dawes of Massachusetts visited in 1883 and described what he
found in glowing terms: _"There was not a pauper in that nation, and the
nation did not owe a dollar. It built its own capitol . . . and it built its
schools and its hospitals."_ No family lacked a home. In spite of this (or,
perhaps, more correctly, because of this), Dawes recommended that the society
must be destroyed: _"They have got as far as they can go, because they own
their land in common . . . there is no enterprise to make your home any better
than that of your neighbours. There is no selfishness, which is the bottom of
civilisation. Till this people will consent to give up their lands, and divide
them among their citizens so that each can own the land he cultivates, they
will not make much more progress."_ [quoted by Chomsky, **Op. Cit.** , p.
231-2] The introduction of capitalism -- as usual by state action -- resulted
in poverty and destitution, again showing the link between capitalism and high
living standards is not clear cut, regardless of claims otherwise.

Undoubtedly, having access to the means of life ensured that members of such
cultures did not have to place themselves in situations which could produce a
servile character structure. As they did not have to follow the orders of a
boss they did not have to learn to obey others and so could develop their own
abilities to govern themselves. This self-government allowed the development
of a custom in such tribes called _"the principle of non-interference"_ in
anthropology. This is the principle of defending someone's right to express
the opposing view and it is a pervasive principle in the tribal world, so much
so as to be safely called a universal.

The principle of non-interference is a powerful principle that extends from
the personal to the political, and into every facet of daily life
(significantly, tribal groups _"respect the personality of their children,
much as they do that of the adults in their communities."_ [Bookchin, **The
Ecology of Freedom** , p. 115]). Most people today, used as they are to
hierarchy everywhere, are aghast when they realise the extent to which it is
practised, but it has proven itself to be an integral part of living anarchy.
It means that people simply do not limit the activities of others, period
(unless that behaviour is threatening the survival of the tribe). This in
effect makes absolute tolerance a custom (the difference between law and
custom is important to point out: Law is dead, and Custom lives -- see
[section I.7.3](secI7.md#seci73)). This is not to idealise such communities
as they are must be considered imperfect anarchist societies in many ways
(mostly obviously in that many eventually evolved into hierarchical systems so
suggesting that informal hierarchies, undoubtedly a product of religion and
other factors, existed).

As people accustomed to authority we have so much baggage that relates to
"interfering" with the lives of others that merely visualising the situation
that would eliminate this daily pastime for many is impossible. But think
about it. First of all, in a society where people do not interfere with each
other's behaviour, people tend to feel trusted and empowered by this simple
social fact. Their self-esteem is already higher because they are trusted with
the responsibility for making learned and aware choices. This is not fiction;
individual responsibility is a key aspect of social responsibility.

Therefore, given the strength of individuality documented in tribes with no
private property, no state and little or no other hierarchical structures
within them, can we not conclude that anarchism will defend individuality and
even develop it in ways blocked by capitalism? At the very least we can say
"possibly", and that is enough to allow us to question the dogma that
capitalism is the only system based on respect for the individual.

## I.7.2 Do anarchists worship the past or the "noble savage"?

No. However, this is a common attack on socialists by supporters of capitalism
and on anarchists by Marxists. Both claim that anarchism is "backward
looking", opposed to "progress" and desire a society based on inappropriate
ideas of freedom. In particular, ideological capitalists maintain that all
forms of socialism base themselves on the ideal of the "noble savage" (see,
for example, free market capitalist guru Frederick von Hayek's work **Fatal
Conceit: The Errors of Socialism** ).

Anarchists are well aware of the limitations of the "primitive communist"
societies they have used as examples of anarchistic tendencies within history
or society. They are also aware of the problems associated with using **any**
historical period as an example of "anarchism in action." Take for example the
"free cities" of Medieval Europe, which was used by Kropotkin as an example of
the potential of decentralised, confederated communes. He was sometimes
accused of being a "Medievalist" (as was William Morris) while all he was
doing was indicating that capitalism need not equal progress and that
alternative social systems have existed which have encouraged freedom in ways
capitalism restricts.

In a similar way, Marxists often accuse Proudhon of being "petty-bourgeois"
and looking backward to a pre-industrial society of artisans and peasants. Of
course, nothing could be further from the truth. Proudhon lived in a France
which was predominantly pre-industrial and based on peasant and artisan
production. He, therefore, based his socialist ideas on the needs of working
people as they required them at the time. When Proudhon did look at large-
scale production (such as railways, factories and so on) he proposed co-
operative associations to run them. These associations would maintain the
dignity of the worker by maintaining the essential feature of artisan and
peasant life, namely the control of work and product by the labourer. Thus he
used "the past" (artisan production) to inform his analysis of current events
(industrialisation) to create a solution to the social problem which built
upon and extended a freedom crushed by capitalism (namely workers' self-
management in production). Rather than being backward looking and worshipping
a past which was disappearing, Proudhon analysed the present **and** past,
drew any positive features he could from both and applied them to the present
and the future (see also [section I.3.8](secI3.md#seci38)). Unlike Marx, who
argued that industrialisation (i.e. proletarianisation) was the pre-condition
of socialism, Proudhon wanted justice and freedom for working class people
during his lifetime, not some (unspecified) time in the future after
capitalism had fully developed.

Again it is hardly surprising to find that many supporters of capitalism
ignore the insights that can be gained by studying tribal cultures and the
questions they raise about capitalism and freedom. Instead, they duck the
issues raised and accuse socialists of idealising the "noble savage." As
indicated, nothing could be further from the truth. Indeed, this claim has
been directed towards Rousseau (often considered the father of socialist and
anarchist idealisation of the "noble savage") even though he explicitly asked
_"must societies be totally abolished? Must **meum** and **tuum** be
annihilated, and must we return again to the forests to live among bears? This
is a deduction in the manner of my adversaries, which I would as soon
anticipate as let them have the shame of drawing."_ Similarly, Rousseau is
often thought of idealising "natural man" but he actually wrote that _"men in
a state of nature, having no moral relations or determinate obligations one
with another, could not be either good or bad, virtuous or vicious."_ [ **The
Social Contract and Discourses** , p. 112 and p. 64] Rousseau failed to
understand that his adversaries, both then and now, seem to know no shame and
will happy suggest that he advocated the exact opposite of what he actually
wrote. Anarchists are also subject to this (particularly by Marxists),
particularly when we look through history, draw libertarian currents from it
and are then denounced as backward looking utopians.

What libertarian socialists point out from this analysis of history is that
the atomised individual associated with capitalist society is not "natural"
and that capitalist social relationships help to weaken individuality. All the
many attacks on libertarian socialist analysis of past societies are a product
of capitalists attempts to deny history and state that "Progress" reaches its
final resting place in capitalism. As David Watson argues:

> _"When we consider people living under some of the harshest, most commanding
> conditions on earth, who can nevertheless do what they like when the notion
> occurs to them, we should be able to witness the contemporary doubt about
> civilisation's superiority without growing indignant. Primitivism, after
> all, reflects not only a glimpse of life before the rise of the state, but
> also a legitimate response to real conditions of life under civilisation . .
> . Most people do not live in aboriginal societies, and most tribal peoples
> themselves now face wholly new contexts which will have to be confronted in
> new ways if they are to survive as peoples. But their lifeways, their
> histories, remind us that **other modes of being are possible.**
> Reaffirmation of our primal past offers insight into our history -- not the
> only possible insight, to be sure, but one important, legitimate entry point
> for a reasoned discussion about (and an impassioned reaction to) this world
> we must leave behind."_ [ **Beyond Bookchin** , p. 240]

This essential investigation of history and modern society to see what other
ways of living have and do exist is essential. It is too easy to forget that
what exists under modern capitalism has not always existed (as neo-classical
economics does with its atomistic and ahistoric analysis, for example). It is
also useful to remember what many people now consider as "normal" was not
always the case. As we discussed in [section F.8.6](secF8.md#secf86), the
first generation of industrial wage slaves **hated** the system, considering
it both tyranny and unnatural. Studying history, previous cultures and the
process of hierarchical society and the resistance of the oppressed to it can
enrich our analysis and activity in the here and now and help us to envision
an anarchist society, the problems it could face and possible solutions to
them.

If the challenge for anarchists is to smash power-relations and domination, it
would make sense to get to the root of the problem. Hierarchy, slavery,
coercion, patriarchy, and so on far outdate capitalism and it is hardly enough
to just analyse the economic system of capitalism, which is merely the current
and most insidious form of hierarchical civilisation. Similarly, without
looking to cultures and communities that functioned quite well before the rise
of the state, hierarchies and classes, anarchists do not really have much
solid ground to prove to people that anarchy is desirable or possible. For
this reason, historical analysis and the celebration of the positive aspects
of tribal and other societies is essential.

Moreover, as George Orwell pointed out, attacks that reject this critical
analysis as worshipping the "noble savage" miss the point:

> _"In the first place he [the defender of modern life] will tell you that it
> is impossible to 'go back' . . . and will then accuse you of being a
> medievalist and begin to descant upon the horrors of the Middle Ages . . .
> As a matter of fact, most attacks upon the Middle Ages and the past
> generally by apologists of modernity are beside the point, because their
> essential trick is to project a modern man, with his squeamishness and his
> high standard of comfort, into an age when such things were unheard of. But
> notice that in any case this is not an answer. For dislike of the mechanised
> future does not imply the smallest reverence for any period of the past . .
> . When one pictures it merely as an objective; there is no need to pretend
> that it has ever existed in space and time."_ [ **The Road to Wigan Pier** ,
> p. 183]

We should also note that such attacks on anarchist investigations of past
cultures assumes that these cultures have **no** good aspects at all and so
indicates a sort of intellectual "all or nothing" approach to modern life. The
idea that past (and current) civilisations may have got **some** things right
and others wrong and should be investigated is rejected for a totally
uncritical "love it or leave" approach to modern society. Of course, the well
known "free market" capitalist love of 19th century capitalist life and values
(specifically the grim reality of Victorian Britain or Gilded Age America)
warrants no such claims of "past worship" by the supporters of the system.

Therefore attacks on anarchists as supporters of the "noble savage" ideal
indicate more about the opponents of anarchism and their fear of looking at
the implications of the system they support than about anarchist theory.

## I.7.3 Is the law required to protect individual rights?

No, far from it. It is obvious that, as Kropotkin put it, _"[n]o society is
possible without certain principles of morality generally recognised. If
everyone grew accustomed to deceiving his fellow-men; if we never could rely
on each other's promise and words; if everyone treated his fellow as an enemy,
against whom every means of warfare is justified -- no society could exist."_
[ **Anarchism** , p. 73] However, this does not mean that a legal system (with
its resultant bureaucracy, vested interests and inhumanity) is the best way to
protect individual rights within a society.

What anarchists propose instead of the current legal system (or an alternative
law system based on religious or "natural" laws) is **custom** \-- namely the
development of living "rules of thumb" which express what a society considers
as right at any given moment. However, the question arises, if an agreed set
of principles is used to determine the just outcome, in what way would this
differ from laws?

The difference is that the "order of custom" would prevail rather than the
"rule of law". **Custom** is a body of living institutions that enjoys the
support of the body politic, whereas **law** is a codified (read dead) body of
institutions that separates social control from moral force. This, as anyone
observing modern Western society can testify, alienates everyone. A **just
outcome** is the predictable, but not necessarily the inevitable, outcome of
interpersonal conflict because in an anarchistic society people are trusted to
do it themselves. Anarchists think people have to grow up in a social
environment free from the confusions generated by a fundamental discrepancy
between morality, and social control, to fully appreciate the implications.
However, the essential ingredient is the investment of trust, by the
community, in people to come up with **functional solutions** to interpersonal
conflict. This stands in sharp contrast with the present situation of people
being infantilised by the state through a constant bombardment of fixed social
structures removing all possibility of people developing their own unique
solutions.

Therefore, anarchists recognise that social custom changes with society. What
was once considered "normal" or "natural" may become to be seen as oppressive
and hateful. This is because the _"conception of good or evil varies according
to the degree of intelligence or of knowledge acquired. There is nothing
unchangeable about it."_ [Kropotkin, **Op. Cit.** , p. 92] Only by removing
the dead hand of the past can society's ethical base develop and grow with the
individuals that make it up (see [section A.2.19](secA2.md#seca219) for a
discussion of anarchist ethics).

We should also like to point out here that laws (or _"The Law"_ ) also
restrict the development of an individual's sense of ethics or morality. This
is because it relieves them of the responsibility of determining if something
is right or wrong. All they need to know is whether it is legal. The morality
of the action is irrelevant. This "nationalisation" of ethics is very handy
for the would be capitalist, governor or other exploiter. In addition,
capitalism also restricts the development of an individual's ethics because it
creates the environment where these ethics can be bought. To quote
Shakespeare's **Richard III** :

> _"Second Murderer: Some certain dregs of conscience are yet within me._

> _First Murderer: Remember our reward, when the deed's done._

> _Second Murderer: Zounds! He dies. I had forgot the reward._

> _First Murderer: Where's thy conscience now?_

> _Second Murderer: O, in the Duke of Gloucester's purse."_

Therefore, as for _"The Law"_ defending individual rights, it creates the
necessary conditions (such as the de-personalisation of ethics, the existence
of concentrations wealth, and so on) for undermining individual ethical
behaviour, and so respect for other individual's rights. As English
libertarian socialist Edward Carpenter put it, _"I think we may fairly make
the following general statement, viz., that legal ownership is essentially a
negative and anti-social thing, and that unless qualified or antidoted by
human relationship, it is pretty certain to be positively **harmful.** In
fact, when a man's chief plea is 'The law allows it,' you may be pretty sure
he is up to some mischief!"_ The state forces an individual into a
relationship with a governing body. This means, as anarchist J. B. Smith put
it, _"taking away from the individual his [or her] direct interest in life and
in his surroundings . . . blunting his [or her] moral sense . . . teaching
that he [or she] must never rely on himself [or herself] . . . [but] upon a
small part of men who are elected to do everything . . . [which] destroys to a
large extent his [or her] perception of right and wrong."_ [quoted by William
R. McKercher, **Freedom and Authority** , p. 48 and p. 67f]

Individual rights, for anarchists, are best protected in a social environment
based on the self-respect and sympathy. Custom, because it is based on the
outcome of numerous individual actions and thought reflects (and so encourages
the development of) individual ethical standards and so a generalised respect
for others. Thus, _"under anarchism all rules and laws will be little more
than suggestions for the guidance of juries which will judge not only the
facts but the law, the justice of the law, its applicability to the given
circumstances, and the penalty or damage to be inflicted because if its
infraction . . . under Anarchism the law will be so flexible that it will
shape itself to every emergency and need no alteration. And it will be
regarded as **just** in proportion to its flexibility, instead of as now in
proportion to its rigidity."_ [Benjamin Tucker, **The Individualist
Anarchists** , pp. 160-1] Tucker, like other individualist Anarchists,
believed that the role of juries had been very substantial in the English
common-law tradition and that they had been gradually emasculated by the
state. This system of juries, based on common-law/custom could be the means of
ensuring justice in a free society.

Tolerance of other individuals depends far more on the attitudes of the
society in question that on its system of laws. In other words, even if the
law does respect individual rights, if others in society disapprove of an
action then they can and will act to stop it (or restrict individual rights).
All that the law can do is try to prevent this occurring but given the power
of social custom this is often limited in scope and has to wait until people
recognise the need for change. Needless to say, governments can, and have,
been far more at the forefront of denying and ignoring individual rights and
so appealing to it for justice is, to say the least, problematic!

As such, anarchists are well aware that social custom can be oppressive and,
as discussed in [section I.5.6](secI5.md#seci56), argue for direct action by
oppressed minorities to combat any tendency towards "dictatorship by the
majority". Anarchists, as Kropotkin suggested, are _"the last to underrate the
part which the self-assertion of the individual has played in the evolution of
mankind."_ However, this _"has often been, and continually is, something quite
different from, and far larger and deeper than, the petty, unintelligent
narrow-mindedness which, with a large class of writers goes for
'individualism' and 'self-assertion.'"_ There are _"two classes of revolted
individuals"_ , those who rise up and aim to _"purify the old institutions [of
mutual aid], or to work out a higher form of commonwealth, based on the same
Mutual Aid principles"_ and those who sought to _"break down the protective
institutions of mutual support, with no other intention but to increase their
own wealth and their own powers."_ [ **Mutual Aid** , pp. 18-9] We aim to
support and encourage the former.

However, while recognising the potential tyranny of custom anarchists stress
that, firstly, this is a natural part of human society and, secondly, it palls
into insignificance compared to the actual tyranny of the state and the laws
it imposes on society in the interests of the few. Facts which, needless to
say, ruling elites are at pains to hide. As Kropotkin explained _"all our
religious, historical, juridical, and social education is imbued with the idea
that human beings, if left to themselves, would revert to savagery; that
without authority men would eat one another; for nothing, they say, can be
expected from the 'multitude' but brutishness and the warring of each against
all. Men would perish if above them soared not the elect . . . These saviours
prevent, we are told, the battle of all against all."_ This, he argued, was
nonsense as _"a **scientific** study of societies and institutions brings us
to quite different views. It proves that usages and customs created by mankind
for the sake of mutual aid, mutual defence, and peace in general, were
precisely elaborated by the 'nameless multitude.' And it was these customs
that enabled man to survive in his struggle for existence in the midst of
extremely hard natural conditions."_ The notion that the state was merely the
instrument of the people is hardly supported by history nor current practice,
for what the state and its laws have done is to _"fix, or rather to
crystallise in a permanent form, such customs as already were in existence"_
and adding to them _"some new rules -- rules of inequality and servile
submission of the masses in the interest of the armed rich and the warlike
minorities."_ [ **Evolution and Environment** , pp. 48-9] Unsurprisingly,
then, the state perverts social customs for its own interests and those of the
economically and socially powerful:

> _"as society became more and more divided into two hostile classes, one
> seeking to establish its domination, the other struggling to escape, the
> strife began. Now the conqueror was in a hurry to secure the results of his
> actions in a permanent form, he tried to place them beyond question, to make
> them holy and venerable by every means in his power. Law made its appearance
> under the sanction of the priest, and the warriors club was placed at its
> service. Its office was to render immutable such customs as were to the
> advantage of the dominant minority . . . If law, however, presented nothing
> but a collection of prescriptions serviceable to rulers, it would find some
> difficulty in insuring acceptance and obedience. Well, the legislators
> confounded in one code the two currents of custom . . . , the maxims which
> represent principles of morality and social union wrought out as a result of
> life in common, and the mandates which are meant to ensure external
> existence to inequality. Customs, absolutely essential to the very being of
> society, are, in the code, cleverly intermingled with usages imposed by the
> ruling caste, and both claim equal respect from the crowd . . . Such was the
> law; and it has maintained its two-fold character to this day."_ [Kropotkin,
> **Anarchism** , p. 205]

In other words, the law has _"has used Man's social feelings to get passed not
only moral precepts which were acceptable to Man, but also orders which were
useful only to the minority of exploiters against whom he would have
rebelled."_ [Kropotkin quoted by Malatesta, **Anarchy** , pp. 24-5]

Therefore anarchists argue that state institutions are not only unneeded to
create an ethical society (i.e. one based on respecting individuality) but
actively undermines such a society. That the economically and politically
powerful assert that a state is a necessary condition for a free society and
individual space is hardly surprising for, as Malatesta put it, a ruling elite
_"cannot maintain itself for long without hiding its true nature behind a
pretence of general usefulness . . . it cannot impose acceptances of the
privileges of the few if it does not pretend to be the guardian of the rights
of all."_ [ **Op. Cit.** , p. 24] Thus laws _"exist to keep up the machinery
of government which serves to secure to capital the exploitation and monopoly
of wealth produced"_ and _"to facilitate the exploitation of the worker by the
capitalist."_ And people _"who long for freedom begin the attempt to obtain it
by entreating their masters to be kind enough to protect them by modifying the
laws which these masters themselves have created!"_ [Kropotkin, **Op. Cit.** ,
p. 200 and p. 210]

Therefore, its important to remember why the state exists and so whatever
actions and rights it promotes for the individual it exists to protect the
powerful against the powerless. Any human rights recognised by the state are a
product of social struggle and exist because of past victories in the class
war and not due to the kindness of ruling elites. In addition, capitalism
itself undermines the ethical foundations of any society by encouraging people
to grow accustomed to deceiving their fellows and treating them as a
competitor, against whom every means of action is justified. Hence capitalism
undermines the basic social context and customs within which individuals
develop and need to become fully human and free. Little wonder that a strong
state has always been required to introduce a free market -- firstly, to
protect wealth from the increasingly dispossessed and secondly, to try to hold
society together as capitalism destroys the social fabric which makes a
society worth living in.

For more on this issue, Kropotkin's classic essay _"Law and Authority"_ cannot
be bettered (contained in **Anarchism** and **Words of a Rebel** ).

## I.7.4 Does capitalism protect individuality?

Given that many people claim that **any** form of socialism will destroy
liberty (and so individuality) it is worthwhile to consider whether capitalism
actually does protect individuality. The answer must be no. Capitalism creates
a standardisation which helps to distort individuality and the fact that
individuality does exist under capitalism says more about the human spirit
than capitalist social relationships.

So, why does a system apparently based on the idea of individual profit result
in such a deadening of the individual? There are four main reasons:

> 1) capitalism produces a hierarchical system which crushes self-government
> in many areas of life;

> 2) there is the lack of community which does not provide the necessary
> supports for the encouragement of individuality;

> 3) there is the psychological impact of "individual profit" when it becomes
> identified purely with monetary gain (as in capitalism);

> 4) the effects of competition in creating conformity and mindless obedience
> to authority.

We have discussed point one on many occasions (see, for example, [section
B.4](secB4.md)). As Emma Goldman put it, under capitalism, the individual
_"must sell his [or her] labour"_ and so their _"inclination and judgement are
subordinated to the will of a master."_ This, naturally, represses individual
initiative and the skills needed to know and express ones own mind. This
_"condemns millions of people to be mere nonentities, living corpses without
originality or power of initiative . . . who pile up mountains of wealth for
others and pay for it with a grey, dull and wretched existence for
themselves."_ _"There can be no freedom in the large sense of the word,"_
Goldman stressed, _"so long as mercenary and commercial considerations play an
important part in the determination of personal conduct."_ [ **Red Emma
Speaks** , p. 50] Hence Bookchin:

> _"With the hollowing out of community by the market system . . . we witness
> the concomitant hollowing out of personality itself. Just as the spiritual
> and institutional ties that linked human beings together into vibrant social
> relations are eroded by the mass market, so the sinews that make for
> subjectivity, character and self-definition are divested of form and
> meaning. The isolated, seemingly autonomous ego of 'modernity' turns out to
> be the mere husk of a once fairly rounded individual whose very completeness
> as an ego was possible because he or she was rooted in a fairly rounded and
> complete community."_ [ **The Ecology of Freedom** , p. 211]

As regards point one, given the social relationships it is based on,
capitalism cannot foster individuality but only harm it. As Kropotkin argued,
_"obedience towards individuals or metaphysical entities . . . lead to
depression of initiative and servility of mind."_ [ **Anarchism** , p. 285] As
far as point two goes, we have discussed it above and will not repeat
ourselves (see [section I.7](secI7.md)). The last two points are worth
discussing more thoroughly, and we will do so here.

Taking the third point first, when this kind of "greed" becomes the guiding
aspect of an individual's life (and the society they live in) they usually end
up sacrificing their own ego to it. Instead of the individual dominating their
"greed," "greed" dominates them and so they end up being possessed by one
aspect of themselves. This "selfishness" hides the poverty of the ego who
practices it. As libertarian Marxist psychiatrist Erich Fromm argued:

> _"Selfishness is not identical with self-love but with its very opposite.
> Selfishness is one kind of greediness. Like all greediness, it contains an
> insatiability, as a consequence of which there is never any real
> satisfaction. Greed is a bottomless pit which exhausts the person in an
> endless effort to satisfy the need without ever reaching satisfaction . . .
> this type of person is basically not fond of himself, but deeply dislikes
> himself._

> _"The puzzle in this seeming contradiction is easy to solve. Selfishness is
> rooted in this very lack of fondness for oneself . . . He does not have the
> inner security which can exist only on the basis of genuine fondness and
> affirmation."_ [ **The Fear of Freedom** , pp. 99-100]

In other words, the "selfish" person allows their greed to dominate their ego
and they sacrifice their personality feeding this new God. This was clearly
seen by Max Stirner who denounced this as a _"one-sided, unopened, narrow
egoism"_ which leads the ego being _"ruled by a passion to which he brings the
rest as sacrifices"_ [ **The Ego and Its Own** , p. 76]. Like all _"spooks,"_
capitalism results in the self-negation of the individual and so the
impoverishment of individuality. Little wonder, then, that a system apparently
based upon "egotism" and "individualism" ends up weakening individuality.

As regards the fourth point, the effects of competition on individuality are
equally as destructive. Indeed, a _"culture dedicated to creating
standardised, specialised, predictable human components could find no better
way of grinding them out than by making every possible aspect of life a matter
of competition. 'Winning out' in this respect does not make rugged
individualists. It shapes conformist robots."_ [George Leonard, quoted by
Alfie Kohn, **No Contest: The Case Against Competition** , p. 129] Why is
this?

Competition is based upon outdoing others and this can only occur if you are
doing the same thing they are. However, individuality is the most unique thing
there is and _"unique characteristics by definition cannot be ranked and
participating in the process of ranking demands essential conformity."_ The
extensive research into the effects of competition suggests that it in fact
_"encourages rank conformity"_ as well as undermining the _"substantial and
authentic kind of individualism"_ associated by such free thinkers as Thoreau.
[Alfie Kohn, **Op. Cit.** , p. 130 and p. 129] As well as impoverishing
individuality by encouraging conformity, competition also makes us less free
thinking and rebellious:

> _"Attitude towards authorities and general conduct do count in the kinds of
> competitions that take place in the office or classroom. If I want to get
> the highest grades in class, I will not be likely to challenge the teacher's
> version of whatever topic is being covered. After a while, I may cease to
> think critically altogether . . . If people tend to 'go along to get along,'
> there is even more incentive to go along when the goal is to be number one.
> In the office or factory where co-workers are rivals, beating out the next
> person for a promotion means pleasing the boss. Competition acts to
> extinguish the Promethean fire of rebellion."_ [ **Op. Cit.** , p. 130]

In [section I.4.11](secI4.md#seci411) we noted that when an artistic task is
turned into a contest, children's work reveal significantly less spontaneity
and creativity. In other words, competition reduces creativity and so
individuality because creativity is _"anti-conformist at its core: it is
nothing if not a process of idiosyncratic thinking and risk-taking.
Competition inhibits this process."_ Competition, therefore, will result in a
narrowing of our lives, a failing to experience new challenges in favour of
trying to win and be "successful." It turns _"life into a series of contests
[and] turns us into cautious, obedient people. We do not sparkle as
individuals **or** embrace collective action when we are in a race."_ [Kohn,
**Op. Cit.** , p. 130 and p. 131]

So, far from defending individuality, capitalism places a lot of barriers
(both physical and mental) in the path of individuals who are trying to
express their freedom. Anarchism exists precisely because capitalism has not
created the free society it supporters claimed it would.

[‹ I.6 What about the "Tragedy of the Commons"?](secI6.md "Go to previous
page") [up](secIcon.md "Go to parent page") [I.8 Does revolutionary Spain
show that libertarian socialism can work in practice? ›](secI8.md "Go to
next page")

