#!/usr/bin/env sh

# Copyright (C) 2020 Uniontech Technology Co., Ltd.
#
# Author:     xinbo wang <wangxinbo@uniontech.com>
#
# Maintainer: xinbo wang <wangxinbo@uniontech.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

cmake -B build -DCMAKE_BUILD_TYPE=Debug
cmake --build build --target ut-displayjack -- -j $(nproc)
ctest --test-dir build -VV

lcov -d build/ -c -o build/coverage_all.info
lcov --remove build/coverage_all.info "*/tests/*" "*/usr/include*" "*/moc*.cpp" --output-file build/coverage.info
genhtml -o build/coverage_html build/coverage.info
