#if 0

Date: Thu, 15 Aug 91 15:27:00 -0600
From: angel@tiguex.cs.unm.edu (Ed Angel)
To: steve@unidata.ucar.edu
Subject: XGKS bug?

I've been testing my demo programs under version 2.4. All is well
except for sample mode input. The following simple program works fine
under the old version. Under the new version, it does not put up
the cross hairs correctly and never detects returns anything but the
initial cursor position. The code for gsample in locator.c seems the
same so the problem lies deeper. Any idea? (By the way samplepick 
demonstrates similar behavior). Did anyone test sample input?

Ed Angel
CS Dept
University of New Mexico

#endif

/* Sample locator test program, old binding */
/* samples two points and draws line between them */
/* waits for carriage return to terminate */
/* cc tsampleold.c -lxgks -lX11 -lm */

#include <udposix.h>
#include <stdio.h>
#include <stdlib.h>
#include <xgks.h>

/* GKS i/o defines */

#define WS_ID  1
#define INDEV  2
#define PET 2


main()
{
    static Glimit   echo_area = {.0, 1280.0, 0.0, 1024.0};
    Gpoint          xy[2];
    Gloc            loc, response;
    Glocrec         r;

    /* GKS Initialization */

    gopengks("stderr", 0);
    gopenws(WS_ID, (char*)NULL, (char*)NULL);
    gactivatews(WS_ID);

    /* initialize locator */

    loc.position.x = 0.5;
    loc.position.y = 0.5;
    loc.transform = 0;

    ginitloc(WS_ID, INDEV, &loc, PET, &echo_area, &r);

    /* set mode to sample and echo on */

    gsetlocmode(WS_ID, INDEV, GSAMPLE, GECHO);

    /* wait 5 seconds so user can position mouse and depress button */
    /* note sample are only generated if button is depressed */

    sleep(5);

    gsampleloc(WS_ID, INDEV, &response);

    xy[0].x = loc.position.x = response.position.x;
    xy[0].y = loc.position.y = response.position.y;

    /* set mode back to request so we can reinitialize locator */
    /* then set back to sample mode */

    gsetlocmode(WS_ID, INDEV, GREQUEST, GECHO);
    ginitloc(WS_ID, INDEV, &loc, PET, &echo_area, &r);
    gsetlocmode(WS_ID, INDEV, GSAMPLE, GECHO);

    /* wait 5 seconds so user can position mouse and depress button */
    /* note samples are only generated if button is depressed */

    sleep(5);

    gsampleloc(WS_ID, INDEV, &response);

    xy[1].x = response.position.x;
    xy[1].y = response.position.y;
    printf("%f\n%f\n%f\n%f\n", xy[0].x, xy[0].y, xy[1].x, xy[1].y);

    gpolyline(2, xy);

    /* wait for carriage return */

    getchar();

    /* termination */

    gdeactivatews(WS_ID);
    gclosews(WS_ID);
    gclosegks();

    return EXIT_SUCCESS;
}
