/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef UOSSTRINGTABLE_H__
#define UOSSTRINGTABLE_H__

#include "libsylph/stringtable.h"

typedef StringTable UosStringTable;

UosStringTable *uos_string_table_new     (void);
void         uos_string_table_free    (UosStringTable *table);

gchar *uos_string_table_lookup_string (UosStringTable *table, const gchar *str);
gchar *uos_string_table_insert_string (UosStringTable *table, const gchar *str);
void   uos_string_table_free_string   (UosStringTable *table, const gchar *str);

void   uos_string_table_get_stats     (UosStringTable *table);

#endif /* UOSSTRINGTABLE_H__ */
