/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "uossession.h"

void uos_session_init(UosSession *session){
     session_init(session);
}

gint uos_session_connect(UosSession *session,
                     const gchar *server,
                     gushort port){
    return session_connect(session,server,port);
}

gint uos_session_connect_full(UosSession *session,
                          const gchar *server,
                          gushort port,
                          UosSocksInfo *socks_info){
    return session_connect_full(session,server,port,socks_info);
}

gint uos_session_disconnect(UosSession *session){
    return session_disconnect(session);
}

void uos_session_destroy(UosSession *session){
    session_destroy(session);
}

gboolean uos_session_is_connected(UosSession *session){
    return session_is_connected(session);
}

UosSessionErrorValue uos_session_get_error(UosSession *session){
    return session_get_error(session);
}

void uos_session_set_access_time(UosSession *session){
    session_set_access_time(session);
}


void uos_session_set_timeout(UosSession *session,
                         guint interval){
    session_set_timeout(session,interval);
}

void uos_session_set_recv_message_notify(UosSession *session,
                                     UosRecvMsgNotify notify_func,
                                     gpointer data){
    session_set_recv_message_notify(session,notify_func,data);
}

void uos_session_set_recv_data_progressive_notify(UosSession *session,
                                              UosRecvDataProgressiveNotify notify_func,
                                              gpointer data){
    session_set_recv_data_progressive_notify(session,notify_func,data);
}

void uos_session_set_recv_data_notify(UosSession *session,
                                  UosRecvDataNotify notify_func,
                                  gpointer data){
    session_set_recv_data_notify(session,notify_func,data);
}

void uos_session_set_send_data_progressive_notify(UosSession *session,
                                              UosSendDataProgressiveNotify notify_func,
                                              gpointer data){
    session_set_send_data_progressive_notify(session,notify_func,data);
}

void uos_session_set_send_data_notify(UosSession *session,
                                  UosSendDataNotify notify_func,
                                  gpointer data){
    session_set_send_data_notify(session,notify_func,data);
}


#if USE_SSL
gint uos_session_start_tls(UosSession *session){
    return session_start_tls(session);
}

#endif

gint uos_session_send_msg(UosSession *session,
                      UosSessionMsgType type,
                      const gchar *msg){
    return session_send_msg(session,type,msg);
}

gint uos_session_recv_msg(UosSession *session){
    return session_recv_msg(session);
}

gint uos_session_send_data(UosSession *session,
                       FILE *data_fp,
                       guint size){
    return session_send_data(session,data_fp,size);
}

gint uos_session_recv_data(UosSession *session,
                       guint size,
                       const gchar *terminator){
    return session_recv_data(session,size,terminator);
}


gint uos_session_recv_data_as_file(UosSession *session,
                               guint size,
                               const gchar *terminator){
    return session_recv_data_as_file(session,size,terminator);
}

