# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** system environment, resource control and configuration details

** Author: Ralph Amissah
  [ralph@amissah.com]
  [ralph.amissah@gmail.com]

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see [http://www.gnu.org/licenses/].

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  [http://www.fsf.org/licensing/licenses/gpl.html]
  [http://www.gnu.org/licenses/gpl.html]

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  [http://www.jus.uio.no/sisu]
  [http://www.sisudoc.org]

** Git
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary]
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/ao_expand_insertions.rb;hb=HEAD]

=end
module SiSU_AO_Insertions
  class Insertions
    def initialize(md,data)
      @md,@data=md,data
    end
    def output_filetypes_in_cmd(cmd_shortcut,lnk=nil) #make list of file types in shortcut command (as configured), e.g. when sisu -3 is used
      act_defaults=SiSU_Env::InfoProcessingFlag.new
      cmd_list=case cmd_shortcut.inspect #check on expectation, string v array
      when /0/ then act_defaults.act_0.str
      when /1/ then act_defaults.act_1.str
      when /2/ then act_defaults.act_2.str
      when /3/ then act_defaults.act_3.str
      when /4/ then act_defaults.act_4.str
      when /5/ then act_defaults.act_5.str
      when /6/ then act_defaults.act_6.str
      when /7/ then act_defaults.act_7.str
      when /8/ then act_defaults.act_8.str
      when /9/ then act_defaults.act_9.str
      end
      file_type_names={}
      file_type_names[:gen],file_type_names[:src]=[],[]
      file_type_names[:gen] <<= if cmd_list =~ /\b--manifest\b/
        "~^ { document manifest }#{lnk[:manifest]}"
      end
      file_type_names[:gen] <<= if cmd_list =~ /\b--html\b/
        [
          " { html, segmented text }#{lnk[:html_toc]}",
          " { html, scroll, document in one }#{lnk[:html_doc]}",
        ]
      end
      file_type_names[:gen] <<= if cmd_list =~ /\b--epub\b/
        [" { epub }#{lnk[:epub]}"]
      end
      file_type_names[:gen] <<= if cmd_list =~ /\b--pdf\b/ \
      or cmd_list =~ /--pdf-landscape/
        [
          " { pdf, landscape }#{lnk[:pdf_landscape]}",
        ]
      end
      file_type_names[:gen] <<= if cmd_list =~ /\b--pdf\b/ \
      or cmd_list =~ /--pdf-portrait/
        [
          " { pdf, portrait }#{lnk[:pdf_portrait]}",
        ]
      end
      file_type_names[:gen] <<= if cmd_list =~ /\b(?:--odt|--odf)\b/
        " { odf:odt, open document text }#{lnk[:odt]}"
      end
      file_type_names[:gen] <<= if cmd_list =~ /\b--xhtml\b/
        " { xhtml scroll }#{lnk[:xhtml]}"
      end
      file_type_names[:gen] <<= if cmd_list =~ /\b--docbook\b/
        " { docbook }#{lnk[:docbook]}" #CHECK
      end
      file_type_names[:gen] <<= if cmd_list =~ /\b--xml-sax\b/
        " { xml, sax }#{lnk[:xml_sax]}"
      end
      file_type_names[:gen] <<= if cmd_list =~ /\b--xml-dom\b/
        " { xml, dom }#{lnk[:xml_dom]}"
      end
      file_type_names[:gen] <<= if cmd_list =~ /\b(?:--txt|--text|--plaintext)\b/
        " { plain text utf-8 }#{lnk[:txt]}"
      end
      #file_type_names[:gen] <<= if cmd_list =~ /g/
      #  'wiki.txt'
      #end
      file_type_names[:gen] <<= if cmd_list =~ /\b--concordance\b/
        " { concordance }#{lnk[:html_concordance]}"
      end
      file_type_names[:gen] <<= if cmd_list =~ /\b--digest\b/
        " { dcc, document content certificate (digests) }#{lnk[:digest]}"
      end
      file_type_names[:src] <<= if source and cmd_shortcut =~ /\b--source\b/
        " { markup source text }#{lnk[:source]}"
      end
      file_type_names[:src] <<= if cmd_shortcut =~ /\b--sisupod\b/
        " { markup source (zipped) pod }#{lnk[:sisupod]}"
      end
      file_type_names[:gen]=file_type_names[:gen].flatten
      file_type_names[:src]=file_type_names[:src].flatten
      file_type_names
    end
    def by_language(linked_doc,lng,src=nil)
      @linked_doc,@lng,@src=linked_doc,lng,src
      @base_path="#{@md.file.output_path.base.url}/#{lng}"
      def fnh
        {
          fn: @linked_doc,
        }
      end
      def path_and_file(fn,pth)
        @base_path + '/' + pth + '/' + fn
      end
      def manifest
        fn=@md.file.base_filename.manifest(fnh)
        path_and_file(fn,'manifest')
      end
      def html_toc
        fn=@md.file.base_filename.html_segtoc(fnh)
        @base_path + '/html/' + @linked_doc + '/' + fn
      end
      def html_doc
        fn=@md.file.base_filename.html_scroll(fnh)
        path_and_file(fn,'html')
      end
      def html_concordance
        fn=@md.file.base_filename.html_concordance
        @base_path + '/html/' + @linked_doc + '/' + fn
      end
      def epub
        fn=@md.file.base_filename.epub(fnh)
        path_and_file(fn,'epub')
      end
      def pdf_landscape
        fn=@md.file.base_filename.pdf_l_a4(fnh)
        path_and_file(fn,'pdf')
      end
      def pdf_portrait
        fn=@md.file.base_filename.pdf_p_a4(fnh)
        path_and_file(fn,'pdf')
      end
      def odt
        fn=@md.file.base_filename.odt(fnh)
        path_and_file(fn,'odt')
      end
      def xhtml
        fn=@md.file.base_filename.xhtml(fnh)
        path_and_file(fn,'xhtml')
      end
      def docbook
        fn=@md.file.base_filename.xml_docbook_book(fnh)
        path_and_file(fn,'docbook')
      end
      def xml_sax
        fn=@md.file.base_filename.xml_sax(fnh)
        path_and_file(fn,'xml_sax')
      end
      def xml_dom
        fn=@md.file.base_filename.xml_dom(fnh)
        path_and_file(fn,'xml_dom')
      end
      def txt
        fn=@md.file.base_filename.txt(fnh)
        path_and_file(fn,'txt')
      end
      def digest
        fn=@md.file.base_filename.hash_digest(fnh)
        path_and_file(fn,'digest')
      end
      def source
        @base_path + '/src/' + @src
      end
      def sisupod
        @base_path + '/src/' + @src + '.zip'
      end
      self
    end
    def by_filetype(linked_doc,lng,src=nil)
      @linked_doc,@lng,@src=linked_doc,lng,src
      @lc=SiSU_Env::FilenameLanguageCodeInsert.new(@md.opt,lng).
        language_code_insert
      @base_path="#{@md.file.output_path.base.url}"
      def fnh
        {
          fn: @linked_doc,
          lng: @lc,
        }
      end
      def path_and_file(fn,pth)
        @base_path + '/' + pth + '/' + fn
      end
      def manifest
        fn=@md.file.base_filename.manifest(fnh)
        path_and_file(fn,'manifest')
      end
      def html_toc
        fn=@md.file.base_filename.html_segtoc(fnh)
        path_and_file(fn,'html')
      end
      def html_doc
        fn=@md.file.base_filename.html_scroll(fnh)
        path_and_file(fn,'html')
      end
      def html_concordance
        fn=@md.file.base_filename.html_concordance
        path_and_file(fn,'html')
      end
      def epub
        fn=@md.file.base_filename.epub(fnh)
        path_and_file(fn,'epub')
      end
      def pdf_landscape
        fn=@md.file.base_filename.pdf_l_a4(fnh)
        path_and_file(fn,'pdf')
      end
      def pdf_portrait
        fn=@md.file.base_filename.pdf_p_a4(fnh)
        path_and_file(fn,'pdf')
      end
      def odt
        fn=@md.file.base_filename.odt(fnh)
        path_and_file(fn,'odt')
      end
      def xhtml
        fn=@md.file.base_filename.xhtml(fnh)
        path_and_file(fn,'xhtml')
      end
      def docbook
        fn=@md.file.base_filename.xml_docbook_book(fnh)
        path_and_file(fn,'docbook')
      end
      def xml_sax
        fn=@md.file.base_filename.xml_sax(fnh)
        path_and_file(fn,'xml_sax')
      end
      def xml_dom
        fn=@md.file.base_filename.xml_dom(fnh)
        path_and_file(fn,'xml_dom')
      end
      def txt
        fn=@md.file.base_filename.txt(fnh)
        path_and_file(fn,'txt')
      end
      def digest
        fn=@md.file.base_filename.hash_digest(fnh)
        path_and_file(fn,'digest')
      end
      def source
        @base_path + '/src/' + @src
      end
      def sisupod
        @base_path + '/src/' + @src + '.zip'
      end
      self
    end
    def by_filename(linked_doc,lng,src=nil)
      @linked_doc,@lng,@src=linked_doc,lng,src
      @lc=SiSU_Env::FilenameLanguageCodeInsert.new(@md.opt,lng).language_code_insert
      @base_path="#{@md.file.output_path.base.url}/#{@linked_doc}"
      def fnh
        {
          fn: @linked_doc,
          lng: @lc,
        }
      end
      def path_and_file(fn,pth=nil)
        (pth.nil?) \
        ? @base_path + '/' + fn
        : @base_path + '/' + pth + '/' + fn
      end
      def manifest
        fn=@md.file.base_filename.manifest(fnh)
        path_and_file(fn)
      end
      def html_toc
        fn=@md.file.base_filename.html_segtoc(fnh)
        path_and_file(fn)
      end
      def html_doc
        fn=@md.file.base_filename.html_scroll(fnh)
        path_and_file(fn)
      end
      def html_concordance
        fn=@md.file.base_filename.html_concordance
        path_and_file(fn)
      end
      def epub
        fn=@md.file.base_filename.epub(fnh)
        path_and_file(fn,'epub')
      end
      def pdf_landscape
        fn=@md.file.base_filename.pdf_l_a4(fnh)
        path_and_file(fn)
      end
      def pdf_portrait
        fn=@md.file.base_filename.pdf_p_a4(fnh)
        path_and_file(fn)
      end
      def odt
        fn=@md.file.base_filename.odt(fnh)
        path_and_file(fn)
      end
      def xhtml
        fn=@md.file.base_filename.xhtml(fnh)
        path_and_file(fn)
      end
      def docbook
        fn=@md.file.base_filename.xml_docbook_book(fnh)
        path_and_file(fn)
      end
      def xml_sax
        fn=@md.file.base_filename.xml_sax(fnh)
        path_and_file(fn)
      end
      def xml_dom
        fn=@md.file.base_filename.xml_dom(fnh)
        path_and_file(fn)
      end
      def txt
        fn=@md.file.base_filename.txt(fnh)
        path_and_file(fn)
      end
      def digest
        fn=@md.file.base_filename.hash_digest(fnh)
        path_and_file(fn)
      end
      def source
        @base_path + '/' + @src
      end
      def sisupod
        @base_path + '/' + @src + '.zip'
      end
      self
    end
    def expand_insertions?
      data=@data
      tuned_file,tuned_file_tmp=[],[]
      codeblock_={
        status: :false,
        type:   :na,
      }
      data.each do |para|
        codeblock_=if para =~/^code(?:\.[a-z][0-9a-z_]+)?\{/ \
        and codeblock_[:status]==:false
          {
            status: :true,
            type:   :curl,
          }
        elsif para =~/^```[ ]+code(?:\.[a-z][0-9a-z_]+)?/ \
        and codeblock_[:status]==:false
          {
            status: :true,
            type:   :tics,
          }
        elsif codeblock_[:type]==:curl \
        and para =~/^\}code/m
          {
            status: :false,
            type:   :na,
          }
        elsif codeblock_[:type]==:tics \
        and para =~/^```(?:\s|$)/m
          {
            status: :false,
            type:   :na,
          }
        else codeblock_
        end
        if para !~/^%+\s/ \
        and codeblock_[:status] != :true \
        and para =~/\{(?:~\^\s+)?(.+?)\s\[(?:\d(?:[sS]*))\]\}(?:\.\.\/\S+?\/|\S+?\.ss[tm]\b)/
          @u=SiSU_Env::InfoEnv.new.url
          m_cmd=''
          if defined? @u.remote
            if /(?<m_pre>.+?)\{(?<m_txt>.+?)\s\[(?<m_cmd>\d[sS]*)\]\}(?<m_source>(?<m_linked_doc>\S+?)\.ss[tm]\b)(?<m_note>.*)/m =~ para
              m_pre=m_pre.strip
            elsif /\{(?<m_txt>.+?)\s\[(?<m_cmd>\d[sS]*)\]\}(?<m_source>(?<m_linked_doc>\S+?)\.ss[tm]\b)(?<m_note>.*)/m =~ para
            end
            if m_linked_doc =~ /(\S+?)\/(\S+)/
              m_linked_doc,m_linked_doc_lang=$1,$2
            else
              m_linked_doc,m_linked_doc_lang=m_linked_doc,@md.opt.lng_base
            end
          else
            puts "error, does currently support relative paths (reltive paths were removed, as had problems for citation, and was not suited to all output types should possibly reconsider) #{__FILE__} #{__LINE__}"
            if /\{(?:~\^\s+)?(?<m_txt>.+?)\s\[(?<m_cmd>\d[sS]*)\]\}\.\.\/(?<m_linked_doc>\S+?)\/(?<m_note>\s+#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]})?/ =~ para
            end
          end
          lnk=case @md.opt.dir_structure_by
          when :language
            {
              manifest:         by_language(m_linked_doc,m_linked_doc_lang).manifest,
              html_toc:         by_language(m_linked_doc,m_linked_doc_lang).html_toc,
              html_doc:         by_language(m_linked_doc,m_linked_doc_lang).html_doc,
              epub:             by_language(m_linked_doc,m_linked_doc_lang).epub,
              pdf_landscape:    by_language(m_linked_doc,m_linked_doc_lang).pdf_landscape,
              pdf_portrait:     by_language(m_linked_doc,m_linked_doc_lang).pdf_landscape,
              odt:              by_language(m_linked_doc,m_linked_doc_lang).odt,
              xhtml:            by_language(m_linked_doc,m_linked_doc_lang).xhtml,
              docbook:          by_language(m_linked_doc,m_linked_doc_lang).docbook,
              xml_sax:          by_language(m_linked_doc,m_linked_doc_lang).xml_sax,
              xml_dom:          by_language(m_linked_doc,m_linked_doc_lang).xml_dom,
              txt:              by_language(m_linked_doc,m_linked_doc_lang).txt,
              html_concordance: by_language(m_linked_doc,m_linked_doc_lang).html_concordance,
              digest:           by_language(m_linked_doc,m_linked_doc_lang).digest,
              sisupod:          by_language(m_linked_doc,m_linked_doc_lang,m_source).sisupod,
              source:           by_language(m_linked_doc,m_linked_doc_lang,m_source).source,
            }
          when :filetype
            {
              manifest:         by_filetype(m_linked_doc,m_linked_doc_lang).manifest,
              html_toc:         by_filetype(m_linked_doc,m_linked_doc_lang).html_toc,
              html_doc:         by_filetype(m_linked_doc,m_linked_doc_lang).html_doc,
              epub:             by_filetype(m_linked_doc,m_linked_doc_lang).epub,
              pdf_landscape:    by_filetype(m_linked_doc,m_linked_doc_lang).pdf_landscape,
              pdf_portrait:     by_filetype(m_linked_doc,m_linked_doc_lang).pdf_landscape,
              odt:              by_filetype(m_linked_doc,m_linked_doc_lang).odt,
              xhtml:            by_filetype(m_linked_doc,m_linked_doc_lang).xhtml,
              docbook:          by_filetype(m_linked_doc,m_linked_doc_lang).docbook,
              xml_sax:          by_filetype(m_linked_doc,m_linked_doc_lang).xml_sax,
              xml_dom:          by_filetype(m_linked_doc,m_linked_doc_lang).xml_dom,
              txt:              by_filetype(m_linked_doc,m_linked_doc_lang).txt,
              html_concordance: by_filetype(m_linked_doc,m_linked_doc_lang).html_concordance,
              digest:           by_filetype(m_linked_doc,m_linked_doc_lang).digest,
              sisupod:          by_filetype(m_linked_doc,m_linked_doc_lang,m_source).sisupod,
              source:           by_filetype(m_linked_doc,m_linked_doc_lang,m_source).source,
            }
          else
            {
              manifest:         by_filename(m_linked_doc,m_linked_doc_lang).manifest,
              html_toc:         by_filename(m_linked_doc,m_linked_doc_lang).html_toc,
              html_doc:         by_filename(m_linked_doc,m_linked_doc_lang).html_doc,
              epub:             by_filename(m_linked_doc,m_linked_doc_lang).epub,
              pdf_landscape:    by_filename(m_linked_doc,m_linked_doc_lang).pdf_landscape,
              pdf_portrait:     by_filename(m_linked_doc,m_linked_doc_lang).pdf_landscape,
              odt:              by_filename(m_linked_doc,m_linked_doc_lang).odt,
              xhtml:            by_filename(m_linked_doc,m_linked_doc_lang).xhtml,
              docbook:          by_filename(m_linked_doc,m_linked_doc_lang).docbook,
              xml_sax:          by_filename(m_linked_doc,m_linked_doc_lang).xml_sax,
              xml_dom:          by_filename(m_linked_doc,m_linked_doc_lang).xml_dom,
              txt:              by_filename(m_linked_doc,m_linked_doc_lang).txt,
              html_concordance: by_filename(m_linked_doc,m_linked_doc_lang).html_concordance,
              digest:           by_filename(m_linked_doc,m_linked_doc_lang).digest,
              sisupod:          by_filename(m_linked_doc,m_linked_doc_lang,m_source).sisupod,
              source:           by_filename(m_linked_doc,m_linked_doc_lang,m_source).source,
            }
          end
          linked_title="#{m_pre}{#{m_txt} }#{lnk[:manifest]}#{m_note}\n\n"
          tuned_file_tmp << linked_title
          output_filetypes=output_filetypes_in_cmd(m_cmd,lnk)
          output_filetypes[:gen].each do |desc|
            if desc
              tuned_file_tmp << if @u.remote
                "#{Mx[:nbsp]*4} #{desc} "
              else # remove ...
                "[provide document placement host location]"
              end
            end
          end
          output_filetypes[:src].each do |desc|
            if desc
              tuned_file_tmp << if @u.remote
                "#{Mx[:nbsp]*4} #{desc} "
              else
                "[provide document placement host location]"
              end
            end
          end
          tuned_file << 'group{' << tuned_file_tmp.join("\n") << '}group'
          tuned_file_tmp=[]
        else tuned_file << para
        end
      end
      tuned_file
    end
  end
end
__END__
