// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Justification;
use TextDirection;
use TextIter;
use WrapMode;
use ffi;
use gdk;
use gdk_ffi;
use glib;
use glib::StaticType;
use glib::Value;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use pango;
use signal::Inhibit;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct TextTag(Object<ffi::GtkTextTag, ffi::GtkTextTagClass>);

    match fn {
        get_type => || ffi::gtk_text_tag_get_type(),
    }
}

impl TextTag {
    pub fn new<'a, P: Into<Option<&'a str>>>(name: P) -> TextTag {
        assert_initialized_main_thread!();
        let name = name.into();
        let name = name.to_glib_none();
        unsafe {
            from_glib_full(ffi::gtk_text_tag_new(name.0))
        }
    }
}

pub trait TextTagExt {
    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn changed(&self, size_changed: bool);

    fn event<P: IsA<glib::Object>>(&self, event_object: &P, event: &gdk::Event, iter: &TextIter) -> bool;

    fn get_priority(&self) -> i32;

    fn set_priority(&self, priority: i32);

    fn get_property_accumulative_margin(&self) -> bool;

    fn set_property_accumulative_margin(&self, accumulative_margin: bool);

    fn set_property_background(&self, background: Option<&str>);

    fn get_property_background_full_height(&self) -> bool;

    fn set_property_background_full_height(&self, background_full_height: bool);

    fn get_property_background_full_height_set(&self) -> bool;

    fn set_property_background_full_height_set(&self, background_full_height_set: bool);

    fn get_property_background_rgba(&self) -> Option<gdk::RGBA>;

    fn set_property_background_rgba(&self, background_rgba: Option<&gdk::RGBA>);

    fn get_property_background_set(&self) -> bool;

    fn set_property_background_set(&self, background_set: bool);

    fn get_property_direction(&self) -> TextDirection;

    fn set_property_direction(&self, direction: TextDirection);

    fn get_property_editable(&self) -> bool;

    fn set_property_editable(&self, editable: bool);

    fn get_property_editable_set(&self) -> bool;

    fn set_property_editable_set(&self, editable_set: bool);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_fallback(&self) -> bool;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_fallback(&self, fallback: bool);

    fn get_property_fallback_set(&self) -> bool;

    fn set_property_fallback_set(&self, fallback_set: bool);

    fn get_property_family(&self) -> Option<String>;

    fn set_property_family(&self, family: Option<&str>);

    fn get_property_family_set(&self) -> bool;

    fn set_property_family_set(&self, family_set: bool);

    fn get_property_font(&self) -> Option<String>;

    fn set_property_font(&self, font: Option<&str>);

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_property_font_features(&self) -> Option<String>;

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_property_font_features(&self, font_features: Option<&str>);

    fn get_property_font_features_set(&self) -> bool;

    fn set_property_font_features_set(&self, font_features_set: bool);

    fn set_property_foreground(&self, foreground: Option<&str>);

    fn get_property_foreground_rgba(&self) -> Option<gdk::RGBA>;

    fn set_property_foreground_rgba(&self, foreground_rgba: Option<&gdk::RGBA>);

    fn get_property_foreground_set(&self) -> bool;

    fn set_property_foreground_set(&self, foreground_set: bool);

    fn get_property_indent(&self) -> i32;

    fn set_property_indent(&self, indent: i32);

    fn get_property_indent_set(&self) -> bool;

    fn set_property_indent_set(&self, indent_set: bool);

    fn get_property_invisible(&self) -> bool;

    fn set_property_invisible(&self, invisible: bool);

    fn get_property_invisible_set(&self) -> bool;

    fn set_property_invisible_set(&self, invisible_set: bool);

    fn get_property_justification(&self) -> Justification;

    fn set_property_justification(&self, justification: Justification);

    fn get_property_justification_set(&self) -> bool;

    fn set_property_justification_set(&self, justification_set: bool);

    fn get_property_language(&self) -> Option<String>;

    fn set_property_language(&self, language: Option<&str>);

    fn get_property_language_set(&self) -> bool;

    fn set_property_language_set(&self, language_set: bool);

    fn get_property_left_margin(&self) -> i32;

    fn set_property_left_margin(&self, left_margin: i32);

    fn get_property_left_margin_set(&self) -> bool;

    fn set_property_left_margin_set(&self, left_margin_set: bool);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_letter_spacing(&self) -> i32;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_letter_spacing(&self, letter_spacing: i32);

    fn get_property_letter_spacing_set(&self) -> bool;

    fn set_property_letter_spacing_set(&self, letter_spacing_set: bool);

    fn get_property_name(&self) -> Option<String>;

    fn set_property_paragraph_background(&self, paragraph_background: Option<&str>);

    fn get_property_paragraph_background_rgba(&self) -> Option<gdk::RGBA>;

    fn set_property_paragraph_background_rgba(&self, paragraph_background_rgba: Option<&gdk::RGBA>);

    fn get_property_paragraph_background_set(&self) -> bool;

    fn set_property_paragraph_background_set(&self, paragraph_background_set: bool);

    fn get_property_pixels_above_lines(&self) -> i32;

    fn set_property_pixels_above_lines(&self, pixels_above_lines: i32);

    fn get_property_pixels_above_lines_set(&self) -> bool;

    fn set_property_pixels_above_lines_set(&self, pixels_above_lines_set: bool);

    fn get_property_pixels_below_lines(&self) -> i32;

    fn set_property_pixels_below_lines(&self, pixels_below_lines: i32);

    fn get_property_pixels_below_lines_set(&self) -> bool;

    fn set_property_pixels_below_lines_set(&self, pixels_below_lines_set: bool);

    fn get_property_pixels_inside_wrap(&self) -> i32;

    fn set_property_pixels_inside_wrap(&self, pixels_inside_wrap: i32);

    fn get_property_pixels_inside_wrap_set(&self) -> bool;

    fn set_property_pixels_inside_wrap_set(&self, pixels_inside_wrap_set: bool);

    fn get_property_right_margin(&self) -> i32;

    fn set_property_right_margin(&self, right_margin: i32);

    fn get_property_right_margin_set(&self) -> bool;

    fn set_property_right_margin_set(&self, right_margin_set: bool);

    fn get_property_rise(&self) -> i32;

    fn set_property_rise(&self, rise: i32);

    fn get_property_rise_set(&self) -> bool;

    fn set_property_rise_set(&self, rise_set: bool);

    fn get_property_scale(&self) -> f64;

    fn set_property_scale(&self, scale: f64);

    fn get_property_scale_set(&self) -> bool;

    fn set_property_scale_set(&self, scale_set: bool);

    fn get_property_size(&self) -> i32;

    fn set_property_size(&self, size: i32);

    fn get_property_size_points(&self) -> f64;

    fn set_property_size_points(&self, size_points: f64);

    fn get_property_size_set(&self) -> bool;

    fn set_property_size_set(&self, size_set: bool);

    fn get_property_stretch(&self) -> pango::Stretch;

    fn set_property_stretch(&self, stretch: pango::Stretch);

    fn get_property_stretch_set(&self) -> bool;

    fn set_property_stretch_set(&self, stretch_set: bool);

    fn get_property_strikethrough(&self) -> bool;

    fn set_property_strikethrough(&self, strikethrough: bool);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_strikethrough_rgba(&self) -> Option<gdk::RGBA>;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_strikethrough_rgba(&self, strikethrough_rgba: Option<&gdk::RGBA>);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_strikethrough_rgba_set(&self) -> bool;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_strikethrough_rgba_set(&self, strikethrough_rgba_set: bool);

    fn get_property_strikethrough_set(&self) -> bool;

    fn set_property_strikethrough_set(&self, strikethrough_set: bool);

    fn get_property_style(&self) -> pango::Style;

    fn set_property_style(&self, style: pango::Style);

    fn get_property_style_set(&self) -> bool;

    fn set_property_style_set(&self, style_set: bool);

    fn get_property_tabs_set(&self) -> bool;

    fn set_property_tabs_set(&self, tabs_set: bool);

    fn get_property_underline(&self) -> pango::Underline;

    fn set_property_underline(&self, underline: pango::Underline);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_underline_rgba(&self) -> Option<gdk::RGBA>;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_underline_rgba(&self, underline_rgba: Option<&gdk::RGBA>);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_underline_rgba_set(&self) -> bool;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_underline_rgba_set(&self, underline_rgba_set: bool);

    fn get_property_underline_set(&self) -> bool;

    fn set_property_underline_set(&self, underline_set: bool);

    fn get_property_variant(&self) -> pango::Variant;

    fn set_property_variant(&self, variant: pango::Variant);

    fn get_property_variant_set(&self) -> bool;

    fn set_property_variant_set(&self, variant_set: bool);

    fn get_property_weight(&self) -> i32;

    fn set_property_weight(&self, weight: i32);

    fn get_property_weight_set(&self) -> bool;

    fn set_property_weight_set(&self, weight_set: bool);

    fn get_property_wrap_mode(&self) -> WrapMode;

    fn set_property_wrap_mode(&self, wrap_mode: WrapMode);

    fn get_property_wrap_mode_set(&self) -> bool;

    fn set_property_wrap_mode_set(&self, wrap_mode_set: bool);

    fn connect_event<F: Fn(&Self, &glib::Object, &gdk::Event, &TextIter) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_accumulative_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_background_full_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_background_full_height_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_background_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_background_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_direction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_editable_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_fallback_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_fallback_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_family_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_font_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn connect_property_font_features_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_font_features_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_foreground_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_foreground_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_foreground_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_indent_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_invisible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_invisible_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_justification_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_justification_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_language_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_left_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_left_margin_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_letter_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_letter_spacing_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_paragraph_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_paragraph_background_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_paragraph_background_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_pixels_above_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_pixels_above_lines_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_pixels_below_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_pixels_below_lines_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_pixels_inside_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_pixels_inside_wrap_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_right_margin_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_rise_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_rise_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_scale_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_size_points_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_stretch_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_stretch_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_strikethrough_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_strikethrough_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_strikethrough_rgba_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_strikethrough_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_style_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_tabs_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_underline_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_underline_rgba_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_underline_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_variant_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_variant_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_weight_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_weight_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_wrap_mode_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<TextTag> + IsA<glib::object::Object>> TextTagExt for O {
    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn changed(&self, size_changed: bool) {
        unsafe {
            ffi::gtk_text_tag_changed(self.to_glib_none().0, size_changed.to_glib());
        }
    }

    fn event<P: IsA<glib::Object>>(&self, event_object: &P, event: &gdk::Event, iter: &TextIter) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_tag_event(self.to_glib_none().0, event_object.to_glib_none().0, mut_override(event.to_glib_none().0), iter.to_glib_none().0))
        }
    }

    fn get_priority(&self) -> i32 {
        unsafe {
            ffi::gtk_text_tag_get_priority(self.to_glib_none().0)
        }
    }

    fn set_priority(&self, priority: i32) {
        unsafe {
            ffi::gtk_text_tag_set_priority(self.to_glib_none().0, priority);
        }
    }

    fn get_property_accumulative_margin(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "accumulative-margin".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_accumulative_margin(&self, accumulative_margin: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "accumulative-margin".to_glib_none().0, Value::from(&accumulative_margin).to_glib_none().0);
        }
    }

    fn set_property_background(&self, background: Option<&str>) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "background".to_glib_none().0, Value::from(background).to_glib_none().0);
        }
    }

    fn get_property_background_full_height(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "background-full-height".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_background_full_height(&self, background_full_height: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "background-full-height".to_glib_none().0, Value::from(&background_full_height).to_glib_none().0);
        }
    }

    fn get_property_background_full_height_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "background-full-height-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_background_full_height_set(&self, background_full_height_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "background-full-height-set".to_glib_none().0, Value::from(&background_full_height_set).to_glib_none().0);
        }
    }

    fn get_property_background_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = Value::from_type(<gdk::RGBA as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "background-rgba".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    fn set_property_background_rgba(&self, background_rgba: Option<&gdk::RGBA>) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "background-rgba".to_glib_none().0, Value::from(background_rgba).to_glib_none().0);
        }
    }

    fn get_property_background_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "background-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_background_set(&self, background_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "background-set".to_glib_none().0, Value::from(&background_set).to_glib_none().0);
        }
    }

    fn get_property_direction(&self) -> TextDirection {
        unsafe {
            let mut value = Value::from_type(<TextDirection as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "direction".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_direction(&self, direction: TextDirection) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "direction".to_glib_none().0, Value::from(&direction).to_glib_none().0);
        }
    }

    fn get_property_editable(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "editable".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_editable(&self, editable: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "editable".to_glib_none().0, Value::from(&editable).to_glib_none().0);
        }
    }

    fn get_property_editable_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "editable-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_editable_set(&self, editable_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "editable-set".to_glib_none().0, Value::from(&editable_set).to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_fallback(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "fallback".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_fallback(&self, fallback: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "fallback".to_glib_none().0, Value::from(&fallback).to_glib_none().0);
        }
    }

    fn get_property_fallback_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "fallback-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_fallback_set(&self, fallback_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "fallback-set".to_glib_none().0, Value::from(&fallback_set).to_glib_none().0);
        }
    }

    fn get_property_family(&self) -> Option<String> {
        unsafe {
            let mut value = Value::from_type(<String as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "family".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    fn set_property_family(&self, family: Option<&str>) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "family".to_glib_none().0, Value::from(family).to_glib_none().0);
        }
    }

    fn get_property_family_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "family-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_family_set(&self, family_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "family-set".to_glib_none().0, Value::from(&family_set).to_glib_none().0);
        }
    }

    fn get_property_font(&self) -> Option<String> {
        unsafe {
            let mut value = Value::from_type(<String as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "font".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    fn set_property_font(&self, font: Option<&str>) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "font".to_glib_none().0, Value::from(font).to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_property_font_features(&self) -> Option<String> {
        unsafe {
            let mut value = Value::from_type(<String as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "font-features".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_property_font_features(&self, font_features: Option<&str>) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "font-features".to_glib_none().0, Value::from(font_features).to_glib_none().0);
        }
    }

    fn get_property_font_features_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "font-features-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_font_features_set(&self, font_features_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "font-features-set".to_glib_none().0, Value::from(&font_features_set).to_glib_none().0);
        }
    }

    fn set_property_foreground(&self, foreground: Option<&str>) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "foreground".to_glib_none().0, Value::from(foreground).to_glib_none().0);
        }
    }

    fn get_property_foreground_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = Value::from_type(<gdk::RGBA as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "foreground-rgba".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    fn set_property_foreground_rgba(&self, foreground_rgba: Option<&gdk::RGBA>) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "foreground-rgba".to_glib_none().0, Value::from(foreground_rgba).to_glib_none().0);
        }
    }

    fn get_property_foreground_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "foreground-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_foreground_set(&self, foreground_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "foreground-set".to_glib_none().0, Value::from(&foreground_set).to_glib_none().0);
        }
    }

    fn get_property_indent(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "indent".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_indent(&self, indent: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "indent".to_glib_none().0, Value::from(&indent).to_glib_none().0);
        }
    }

    fn get_property_indent_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "indent-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_indent_set(&self, indent_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "indent-set".to_glib_none().0, Value::from(&indent_set).to_glib_none().0);
        }
    }

    fn get_property_invisible(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "invisible".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_invisible(&self, invisible: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "invisible".to_glib_none().0, Value::from(&invisible).to_glib_none().0);
        }
    }

    fn get_property_invisible_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "invisible-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_invisible_set(&self, invisible_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "invisible-set".to_glib_none().0, Value::from(&invisible_set).to_glib_none().0);
        }
    }

    fn get_property_justification(&self) -> Justification {
        unsafe {
            let mut value = Value::from_type(<Justification as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "justification".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_justification(&self, justification: Justification) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "justification".to_glib_none().0, Value::from(&justification).to_glib_none().0);
        }
    }

    fn get_property_justification_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "justification-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_justification_set(&self, justification_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "justification-set".to_glib_none().0, Value::from(&justification_set).to_glib_none().0);
        }
    }

    fn get_property_language(&self) -> Option<String> {
        unsafe {
            let mut value = Value::from_type(<String as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "language".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    fn set_property_language(&self, language: Option<&str>) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "language".to_glib_none().0, Value::from(language).to_glib_none().0);
        }
    }

    fn get_property_language_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "language-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_language_set(&self, language_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "language-set".to_glib_none().0, Value::from(&language_set).to_glib_none().0);
        }
    }

    fn get_property_left_margin(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "left-margin".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_left_margin(&self, left_margin: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "left-margin".to_glib_none().0, Value::from(&left_margin).to_glib_none().0);
        }
    }

    fn get_property_left_margin_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "left-margin-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_left_margin_set(&self, left_margin_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "left-margin-set".to_glib_none().0, Value::from(&left_margin_set).to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_letter_spacing(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "letter-spacing".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_letter_spacing(&self, letter_spacing: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "letter-spacing".to_glib_none().0, Value::from(&letter_spacing).to_glib_none().0);
        }
    }

    fn get_property_letter_spacing_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "letter-spacing-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_letter_spacing_set(&self, letter_spacing_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "letter-spacing-set".to_glib_none().0, Value::from(&letter_spacing_set).to_glib_none().0);
        }
    }

    fn get_property_name(&self) -> Option<String> {
        unsafe {
            let mut value = Value::from_type(<String as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "name".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    fn set_property_paragraph_background(&self, paragraph_background: Option<&str>) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "paragraph-background".to_glib_none().0, Value::from(paragraph_background).to_glib_none().0);
        }
    }

    fn get_property_paragraph_background_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = Value::from_type(<gdk::RGBA as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "paragraph-background-rgba".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    fn set_property_paragraph_background_rgba(&self, paragraph_background_rgba: Option<&gdk::RGBA>) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "paragraph-background-rgba".to_glib_none().0, Value::from(paragraph_background_rgba).to_glib_none().0);
        }
    }

    fn get_property_paragraph_background_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "paragraph-background-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_paragraph_background_set(&self, paragraph_background_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "paragraph-background-set".to_glib_none().0, Value::from(&paragraph_background_set).to_glib_none().0);
        }
    }

    fn get_property_pixels_above_lines(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "pixels-above-lines".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_pixels_above_lines(&self, pixels_above_lines: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "pixels-above-lines".to_glib_none().0, Value::from(&pixels_above_lines).to_glib_none().0);
        }
    }

    fn get_property_pixels_above_lines_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "pixels-above-lines-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_pixels_above_lines_set(&self, pixels_above_lines_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "pixels-above-lines-set".to_glib_none().0, Value::from(&pixels_above_lines_set).to_glib_none().0);
        }
    }

    fn get_property_pixels_below_lines(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "pixels-below-lines".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_pixels_below_lines(&self, pixels_below_lines: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "pixels-below-lines".to_glib_none().0, Value::from(&pixels_below_lines).to_glib_none().0);
        }
    }

    fn get_property_pixels_below_lines_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "pixels-below-lines-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_pixels_below_lines_set(&self, pixels_below_lines_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "pixels-below-lines-set".to_glib_none().0, Value::from(&pixels_below_lines_set).to_glib_none().0);
        }
    }

    fn get_property_pixels_inside_wrap(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "pixels-inside-wrap".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_pixels_inside_wrap(&self, pixels_inside_wrap: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "pixels-inside-wrap".to_glib_none().0, Value::from(&pixels_inside_wrap).to_glib_none().0);
        }
    }

    fn get_property_pixels_inside_wrap_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "pixels-inside-wrap-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_pixels_inside_wrap_set(&self, pixels_inside_wrap_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "pixels-inside-wrap-set".to_glib_none().0, Value::from(&pixels_inside_wrap_set).to_glib_none().0);
        }
    }

    fn get_property_right_margin(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "right-margin".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_right_margin(&self, right_margin: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "right-margin".to_glib_none().0, Value::from(&right_margin).to_glib_none().0);
        }
    }

    fn get_property_right_margin_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "right-margin-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_right_margin_set(&self, right_margin_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "right-margin-set".to_glib_none().0, Value::from(&right_margin_set).to_glib_none().0);
        }
    }

    fn get_property_rise(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "rise".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_rise(&self, rise: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "rise".to_glib_none().0, Value::from(&rise).to_glib_none().0);
        }
    }

    fn get_property_rise_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "rise-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_rise_set(&self, rise_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "rise-set".to_glib_none().0, Value::from(&rise_set).to_glib_none().0);
        }
    }

    fn get_property_scale(&self) -> f64 {
        unsafe {
            let mut value = Value::from_type(<f64 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "scale".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_scale(&self, scale: f64) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "scale".to_glib_none().0, Value::from(&scale).to_glib_none().0);
        }
    }

    fn get_property_scale_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "scale-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_scale_set(&self, scale_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "scale-set".to_glib_none().0, Value::from(&scale_set).to_glib_none().0);
        }
    }

    fn get_property_size(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "size".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_size(&self, size: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "size".to_glib_none().0, Value::from(&size).to_glib_none().0);
        }
    }

    fn get_property_size_points(&self) -> f64 {
        unsafe {
            let mut value = Value::from_type(<f64 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "size-points".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_size_points(&self, size_points: f64) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "size-points".to_glib_none().0, Value::from(&size_points).to_glib_none().0);
        }
    }

    fn get_property_size_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "size-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_size_set(&self, size_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "size-set".to_glib_none().0, Value::from(&size_set).to_glib_none().0);
        }
    }

    fn get_property_stretch(&self) -> pango::Stretch {
        unsafe {
            let mut value = Value::from_type(<pango::Stretch as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "stretch".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_stretch(&self, stretch: pango::Stretch) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "stretch".to_glib_none().0, Value::from(&stretch).to_glib_none().0);
        }
    }

    fn get_property_stretch_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "stretch-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_stretch_set(&self, stretch_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "stretch-set".to_glib_none().0, Value::from(&stretch_set).to_glib_none().0);
        }
    }

    fn get_property_strikethrough(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "strikethrough".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_strikethrough(&self, strikethrough: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "strikethrough".to_glib_none().0, Value::from(&strikethrough).to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_strikethrough_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = Value::from_type(<gdk::RGBA as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "strikethrough-rgba".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_strikethrough_rgba(&self, strikethrough_rgba: Option<&gdk::RGBA>) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "strikethrough-rgba".to_glib_none().0, Value::from(strikethrough_rgba).to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_strikethrough_rgba_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "strikethrough-rgba-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_strikethrough_rgba_set(&self, strikethrough_rgba_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "strikethrough-rgba-set".to_glib_none().0, Value::from(&strikethrough_rgba_set).to_glib_none().0);
        }
    }

    fn get_property_strikethrough_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "strikethrough-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_strikethrough_set(&self, strikethrough_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "strikethrough-set".to_glib_none().0, Value::from(&strikethrough_set).to_glib_none().0);
        }
    }

    fn get_property_style(&self) -> pango::Style {
        unsafe {
            let mut value = Value::from_type(<pango::Style as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "style".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_style(&self, style: pango::Style) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "style".to_glib_none().0, Value::from(&style).to_glib_none().0);
        }
    }

    fn get_property_style_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "style-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_style_set(&self, style_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "style-set".to_glib_none().0, Value::from(&style_set).to_glib_none().0);
        }
    }

    fn get_property_tabs_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "tabs-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_tabs_set(&self, tabs_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "tabs-set".to_glib_none().0, Value::from(&tabs_set).to_glib_none().0);
        }
    }

    fn get_property_underline(&self) -> pango::Underline {
        unsafe {
            let mut value = Value::from_type(<pango::Underline as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "underline".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_underline(&self, underline: pango::Underline) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "underline".to_glib_none().0, Value::from(&underline).to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_underline_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = Value::from_type(<gdk::RGBA as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "underline-rgba".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_underline_rgba(&self, underline_rgba: Option<&gdk::RGBA>) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "underline-rgba".to_glib_none().0, Value::from(underline_rgba).to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_underline_rgba_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "underline-rgba-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_underline_rgba_set(&self, underline_rgba_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "underline-rgba-set".to_glib_none().0, Value::from(&underline_rgba_set).to_glib_none().0);
        }
    }

    fn get_property_underline_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "underline-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_underline_set(&self, underline_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "underline-set".to_glib_none().0, Value::from(&underline_set).to_glib_none().0);
        }
    }

    fn get_property_variant(&self) -> pango::Variant {
        unsafe {
            let mut value = Value::from_type(<pango::Variant as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "variant".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_variant(&self, variant: pango::Variant) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "variant".to_glib_none().0, Value::from(&variant).to_glib_none().0);
        }
    }

    fn get_property_variant_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "variant-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_variant_set(&self, variant_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "variant-set".to_glib_none().0, Value::from(&variant_set).to_glib_none().0);
        }
    }

    fn get_property_weight(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "weight".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_weight(&self, weight: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "weight".to_glib_none().0, Value::from(&weight).to_glib_none().0);
        }
    }

    fn get_property_weight_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "weight-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_weight_set(&self, weight_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "weight-set".to_glib_none().0, Value::from(&weight_set).to_glib_none().0);
        }
    }

    fn get_property_wrap_mode(&self) -> WrapMode {
        unsafe {
            let mut value = Value::from_type(<WrapMode as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "wrap-mode".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_wrap_mode(&self, wrap_mode: WrapMode) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "wrap-mode".to_glib_none().0, Value::from(&wrap_mode).to_glib_none().0);
        }
    }

    fn get_property_wrap_mode_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "wrap-mode-set".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_wrap_mode_set(&self, wrap_mode_set: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "wrap-mode-set".to_glib_none().0, Value::from(&wrap_mode_set).to_glib_none().0);
        }
    }

    fn connect_event<F: Fn(&Self, &glib::Object, &gdk::Event, &TextIter) -> Inhibit + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &glib::Object, &gdk::Event, &TextIter) -> Inhibit + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "event",
                transmute(event_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_accumulative_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::accumulative-margin",
                transmute(notify_accumulative_margin_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::background",
                transmute(notify_background_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_background_full_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::background-full-height",
                transmute(notify_background_full_height_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_background_full_height_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::background-full-height-set",
                transmute(notify_background_full_height_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_background_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::background-rgba",
                transmute(notify_background_rgba_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_background_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::background-set",
                transmute(notify_background_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_direction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::direction",
                transmute(notify_direction_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::editable",
                transmute(notify_editable_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_editable_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::editable-set",
                transmute(notify_editable_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_fallback_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::fallback",
                transmute(notify_fallback_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_fallback_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::fallback-set",
                transmute(notify_fallback_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::family",
                transmute(notify_family_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_family_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::family-set",
                transmute(notify_family_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_font_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::font",
                transmute(notify_font_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn connect_property_font_features_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::font-features",
                transmute(notify_font_features_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_font_features_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::font-features-set",
                transmute(notify_font_features_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_foreground_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::foreground",
                transmute(notify_foreground_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_foreground_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::foreground-rgba",
                transmute(notify_foreground_rgba_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_foreground_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::foreground-set",
                transmute(notify_foreground_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::indent",
                transmute(notify_indent_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_indent_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::indent-set",
                transmute(notify_indent_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_invisible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::invisible",
                transmute(notify_invisible_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_invisible_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::invisible-set",
                transmute(notify_invisible_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_justification_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::justification",
                transmute(notify_justification_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_justification_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::justification-set",
                transmute(notify_justification_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::language",
                transmute(notify_language_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_language_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::language-set",
                transmute(notify_language_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_left_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::left-margin",
                transmute(notify_left_margin_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_left_margin_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::left-margin-set",
                transmute(notify_left_margin_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_letter_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::letter-spacing",
                transmute(notify_letter_spacing_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_letter_spacing_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::letter-spacing-set",
                transmute(notify_letter_spacing_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::name",
                transmute(notify_name_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_paragraph_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::paragraph-background",
                transmute(notify_paragraph_background_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_paragraph_background_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::paragraph-background-rgba",
                transmute(notify_paragraph_background_rgba_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_paragraph_background_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::paragraph-background-set",
                transmute(notify_paragraph_background_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_pixels_above_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::pixels-above-lines",
                transmute(notify_pixels_above_lines_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_pixels_above_lines_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::pixels-above-lines-set",
                transmute(notify_pixels_above_lines_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_pixels_below_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::pixels-below-lines",
                transmute(notify_pixels_below_lines_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_pixels_below_lines_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::pixels-below-lines-set",
                transmute(notify_pixels_below_lines_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_pixels_inside_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::pixels-inside-wrap",
                transmute(notify_pixels_inside_wrap_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_pixels_inside_wrap_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::pixels-inside-wrap-set",
                transmute(notify_pixels_inside_wrap_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::right-margin",
                transmute(notify_right_margin_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_right_margin_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::right-margin-set",
                transmute(notify_right_margin_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_rise_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::rise",
                transmute(notify_rise_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_rise_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::rise-set",
                transmute(notify_rise_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::scale",
                transmute(notify_scale_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_scale_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::scale-set",
                transmute(notify_scale_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::size",
                transmute(notify_size_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_size_points_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::size-points",
                transmute(notify_size_points_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::size-set",
                transmute(notify_size_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_stretch_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::stretch",
                transmute(notify_stretch_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_stretch_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::stretch-set",
                transmute(notify_stretch_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_strikethrough_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::strikethrough",
                transmute(notify_strikethrough_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_strikethrough_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::strikethrough-rgba",
                transmute(notify_strikethrough_rgba_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_strikethrough_rgba_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::strikethrough-rgba-set",
                transmute(notify_strikethrough_rgba_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_strikethrough_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::strikethrough-set",
                transmute(notify_strikethrough_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::style",
                transmute(notify_style_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_style_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::style-set",
                transmute(notify_style_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_tabs_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::tabs-set",
                transmute(notify_tabs_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::underline",
                transmute(notify_underline_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_underline_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::underline-rgba",
                transmute(notify_underline_rgba_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_underline_rgba_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::underline-rgba-set",
                transmute(notify_underline_rgba_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_underline_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::underline-set",
                transmute(notify_underline_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_variant_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::variant",
                transmute(notify_variant_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_variant_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::variant-set",
                transmute(notify_variant_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_weight_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::weight",
                transmute(notify_weight_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_weight_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::weight-set",
                transmute(notify_weight_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::wrap-mode",
                transmute(notify_wrap_mode_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_wrap_mode_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::wrap-mode-set",
                transmute(notify_wrap_mode_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn event_trampoline<P>(this: *mut ffi::GtkTextTag, object: *mut gobject_ffi::GObject, event: *mut gdk_ffi::GdkEvent, iter: *mut ffi::GtkTextIter, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<TextTag> {
    let f: &&(Fn(&P, &glib::Object, &gdk::Event, &TextIter) -> Inhibit + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(object), &from_glib_none(event), &from_glib_borrow(iter)).to_glib()
}

unsafe extern "C" fn notify_accumulative_margin_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_background_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_background_full_height_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_background_full_height_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_background_rgba_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_background_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_direction_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_editable_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_editable_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
unsafe extern "C" fn notify_fallback_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_fallback_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_family_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_family_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_font_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_18", feature = "dox"))]
unsafe extern "C" fn notify_font_features_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_font_features_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_foreground_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_foreground_rgba_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_foreground_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_indent_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_indent_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_invisible_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_invisible_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_justification_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_justification_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_language_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_language_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_left_margin_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_left_margin_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
unsafe extern "C" fn notify_letter_spacing_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_letter_spacing_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_name_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_paragraph_background_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_paragraph_background_rgba_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_paragraph_background_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_pixels_above_lines_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_pixels_above_lines_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_pixels_below_lines_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_pixels_below_lines_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_pixels_inside_wrap_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_pixels_inside_wrap_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_right_margin_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_right_margin_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_rise_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_rise_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_scale_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_scale_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_size_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_size_points_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_size_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_stretch_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_stretch_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_strikethrough_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
unsafe extern "C" fn notify_strikethrough_rgba_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
unsafe extern "C" fn notify_strikethrough_rgba_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_strikethrough_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_style_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_style_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_tabs_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_underline_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
unsafe extern "C" fn notify_underline_rgba_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
unsafe extern "C" fn notify_underline_rgba_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_underline_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_variant_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_variant_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_weight_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_weight_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_wrap_mode_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_wrap_mode_set_trampoline<P>(this: *mut ffi::GtkTextTag, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<TextTag> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&TextTag::from_glib_borrow(this).downcast_unchecked())
}
