#ifndef _RHEOLEF_ERROR_ESTIMATOR_ZZ_H
#define _RHEOLEF_ERROR_ESTIMATOR_ZZ_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef/field.h"
namespace rheolef { 
// --------------------------------------------------------------------------
// main interface
// --------------------------------------------------------------------------
// return a local L2 error estimation
//   result is P0 scalar field when grad_uh is P0 or P1d vector field
//   default method="macro" is Zienkiewicz-Zhu error estimator
//   other:  method="prol2" is L2-projection based one (less efficient)
field estim2 (const field& grad_uh, std::string method = "macro");

// return a local dircetional L2 error estimation
//   result is P0 vector field when grad_uh is P0 or P1d vector field
field estim_vector (const field& grad_uh, std::string method = "macro");

// return Zh(grad_uh) = a continuous and enhanced version of grad_uh
//   result is P1 or P2 vector field when grad_uh is P0 or P1d vector field, resp.
field postprocessing (const field& grad_uh, std::string method = "macro");

// --------------------------------------------------------------------------
// Zienkiewics-Zhu projection-like i.e. local super-patch-recovery (SPR)
// --------------------------------------------------------------------------
//   Zh_uh = postprocessing_macro (grad_uh);
//   result is Pk when grad_uh in P(k-1)d and k=1,2
field postprocessing_macro (const field& grad_uh);

// --------------------------------------------------------------------------
// L2 projection: bad, but here for comparison purpose
// --------------------------------------------------------------------------
//   Rh_uh = postprocessing_prol2 (grad_uh)
field postprocessing_prol2 (const field& grad_uh);
field postprocessing_prol2 (const field& grad_uh, quadrature_option qopt);

}// namespace rheolef
#endif // _RHEOLEF_ERROR_ESTIMATOR_ZZ_H
