///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// input qmg boundary files:
//
//   istream& operator >> (istream&, cad&);
//
//   with some technical stuff with bison & flex
//
// author: Pierre.Saram;ito@imag.fr
//
// date: 27 august 2000
//
#include "rheolef/cad.h"
#include "compute-bbox.h"

#ifdef _RHEOLEF_HAVE_SLIST
# include <slist>
#elif defined(_RHEOLEF_HAVE_SLIST_H)
# include <slist.h>
#else
# include <list>
# ifndef slist
#  define slist list
# endif
#endif

/* AIX requires this to be the first thing in the file.  */
#ifndef __GNUC__
# if _RHEOLEF_HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifdef _AIX
#pragma alloca
#  else
#   ifndef alloca /* predefined by HP cc +Olibcalls */
char *alloca ();
#   endif
#  endif
# endif
#endif

using namespace rheolef;
using namespace std;

typedef cad::size_type size_type;

//#include "cad-qmg-yacc.cc"
//#include "cad-qmg-lex.cc"

static cad_rep *p_data = 0;
static size_type cad_qmg_line_no = 1;
static size_type cad_qmg_n_error = 0;

extern int cad_qmg_lex() ;
void cad_qmg_error (const char* msg)
{
        error_macro("cad input:" << cad_qmg_line_no << ": " << msg);
	cad_qmg_n_error++;
}
//extern "C" {
  int cad_qmg_wrap () { return 1; }
//}
static vector<string> symbol_table;

static string symbol(size_type i) {
	return symbol_table[i];
}
static size_type insert(const string& str) {
        size_type i = symbol_table.size();
        symbol_table.push_back(str);
        return i;
}

#include "cad-qmg-yacc.cc"

// avoid re-definition of YY_NULL within flex
#ifdef YY_NULL
#undef YY_NULL
#endif
#include "cad-qmg-lex.cc"

static yyFlexLexer input_cad;

int cad_qmg_lex() { return input_cad.yylex(); }

void
cad_rep::get_qmg (istream& is)
{
	p_data = this;
  	input_cad.yyrestart (is);
	cad_qmg_line_no = 1;
	cad_qmg_n_error = 0;
	if (cad_qmg_parse() != 0 || cad_qmg_n_error != 0) {
            is.setstate (ios::badbit);
        }
}
