% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_ignorer.R
\docType{data}
\name{RequestIgnorer}
\alias{RequestIgnorer}
\title{Request ignorer}
\arguments{
\item{LOCALHOST_ALIASES}{A constant with values: 'localhost', '127.0.0.1',
and '0.0.0.0'}

\item{ignored_hosts}{Vector of ignored hosts}

\item{fun}{A function, of the form: coming...}

\item{value}{A localhost value to ignore, e.g, 'localhost'}

\item{hosts}{Character vector of hosts to ignore}

\item{request}{A request}
}
\description{
Request ignorer
}
\details{
Hook to handle request ignorers, including:

\strong{Methods}
\describe{
\item{\code{ignore_request(fun)}}{
Will ignore any request for which the given function
returns \code{TRUE}
}
\item{\code{ignore_localhost()}}{
ignore all localhost values (localhost, 127.0.0.1, 0.0.0.0)
}
\item{\code{ignore_localhost_value(value)}}{
ignore a specific named localhost
}
\item{\code{ignore_hosts(hosts)}}{
ignore any named host
}
\item{\code{should_be_ignored(request)}}{
method to determine whether to ignore a request
}
}
\strong{Private Methods}
\describe{
\item{\code{ignored_hosts_init()}}{
Initialize an empty ignored hosts object on package load
}
}
}
\examples{
\dontrun{
(x <- RequestIgnorer$new())
x$LOCALHOST_ALIASES
x$ignored_hosts
x$ignore_hosts(hosts = "google.com")
x$ignored_hosts
x$ignore_localhost()
x$ignored_hosts
x$ignore_localhost_value('127.0.0.1')
x$ignored_hosts
}
}
\keyword{internal}
