% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmatrix_legend.R
\name{grab_legend}
\alias{grab_legend}
\alias{print.legend_guide_box}
\title{Grab the legend and print it as a plot}
\usage{
grab_legend(p)

\method{print}{legend_guide_box}(x, ..., plotNew = FALSE)
}
\arguments{
\item{p}{ggplot2 plot object}

\item{x}{legend object that has been grabbed from a ggplot2 object}

\item{...}{ignored}

\item{plotNew}{boolean to determine if the `grid.newpage()` command and a new blank rectangle should be printed}
}
\description{
Grab the legend and print it as a plot
}
\examples{
library(ggplot2)
histPlot <- qplot(
  x = Sepal.Length,
  data = iris,
  fill = Species,
  geom = "histogram",
  binwidth = 1/4
)
(right <- histPlot)
(bottom <- histPlot + theme(legend.position = "bottom"))
(top <- histPlot + theme(legend.position = "top"))
(left <- histPlot + theme(legend.position = "left"))

grab_legend(right)
grab_legend(bottom)
grab_legend(top)
grab_legend(left)
}
