// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/printing/browser/ipp_l10n.h"

#include "base/no_destructor.h"
#include "components/strings/grit/components_strings.h"

// TODO(crbug.com/964919) generate from csv.
const std::map<base::StringPiece, int>& CapabilityLocalizationMap() {
  static const base::NoDestructor<std::map<base::StringPiece, int>> l10n_map(
      {{"finishings/4", IDS_PRINT_FINISHINGS_STAPLE},
       {"finishings/5", IDS_PRINT_FINISHINGS_PUNCH},
       {"finishings/6", IDS_PRINT_FINISHINGS_COVER},
       {"finishings/7", IDS_PRINT_FINISHINGS_BIND},
       {"finishings/8", IDS_PRINT_FINISHINGS_SADDLE_STITCH},
       {"finishings/9", IDS_PRINT_FINISHINGS_EDGE_STITCH},
       {"finishings/10", IDS_PRINT_FINISHINGS_FOLD},
       {"finishings/11", IDS_PRINT_FINISHINGS_TRIM},
       {"finishings/12", IDS_PRINT_FINISHINGS_BALE},
       {"finishings/13", IDS_PRINT_FINISHINGS_BOOKLET_MAKER},
       {"finishings/14", IDS_PRINT_FINISHINGS_JOG_OFFSET},
       {"finishings/15", IDS_PRINT_FINISHINGS_COAT},
       {"finishings/16", IDS_PRINT_FINISHINGS_LAMINATE},
       {"finishings/20", IDS_PRINT_FINISHINGS_STAPLE_TOP_LEFT},
       {"finishings/21", IDS_PRINT_FINISHINGS_STAPLE_BOTTOM_LEFT},
       {"finishings/22", IDS_PRINT_FINISHINGS_STAPLE_TOP_RIGHT},
       {"finishings/23", IDS_PRINT_FINISHINGS_STAPLE_BOTTOM_RIGHT},
       {"finishings/24", IDS_PRINT_FINISHINGS_EDGE_STITCH_LEFT},
       {"finishings/25", IDS_PRINT_FINISHINGS_EDGE_STITCH_TOP},
       {"finishings/26", IDS_PRINT_FINISHINGS_EDGE_STITCH_RIGHT},
       {"finishings/27", IDS_PRINT_FINISHINGS_EDGE_STITCH_BOTTOM},
       {"finishings/28", IDS_PRINT_FINISHINGS_STAPLE_DUAL_LEFT},
       {"finishings/29", IDS_PRINT_FINISHINGS_STAPLE_DUAL_TOP},
       {"finishings/30", IDS_PRINT_FINISHINGS_STAPLE_DUAL_RIGHT},
       {"finishings/31", IDS_PRINT_FINISHINGS_STAPLE_DUAL_BOTTOM},
       {"finishings/32", IDS_PRINT_FINISHINGS_STAPLE_TRIPLE_LEFT},
       {"finishings/33", IDS_PRINT_FINISHINGS_STAPLE_TRIPLE_TOP},
       {"finishings/34", IDS_PRINT_FINISHINGS_STAPLE_TRIPLE_RIGHT},
       {"finishings/35", IDS_PRINT_FINISHINGS_STAPLE_TRIPLE_BOTTOM},
       {"finishings/50", IDS_PRINT_FINISHINGS_BIND_LEFT},
       {"finishings/51", IDS_PRINT_FINISHINGS_BIND_TOP},
       {"finishings/52", IDS_PRINT_FINISHINGS_BIND_RIGHT},
       {"finishings/53", IDS_PRINT_FINISHINGS_BIND_BOTTOM},
       {"finishings/60", IDS_PRINT_FINISHINGS_TRIM_AFTER_PAGES},
       {"finishings/61", IDS_PRINT_FINISHINGS_TRIM_AFTER_DOCUMENTS},
       {"finishings/62", IDS_PRINT_FINISHINGS_TRIM_AFTER_COPIES},
       {"finishings/63", IDS_PRINT_FINISHINGS_TRIM_AFTER_JOB},
       {"finishings/70", IDS_PRINT_FINISHINGS_PUNCH_TOP_LEFT},
       {"finishings/71", IDS_PRINT_FINISHINGS_PUNCH_BOTTOM_LEFT},
       {"finishings/72", IDS_PRINT_FINISHINGS_PUNCH_TOP_RIGHT},
       {"finishings/73", IDS_PRINT_FINISHINGS_PUNCH_BOTTOM_RIGHT},
       {"finishings/74", IDS_PRINT_FINISHINGS_PUNCH_DUAL_LEFT},
       {"finishings/75", IDS_PRINT_FINISHINGS_PUNCH_DUAL_TOP},
       {"finishings/76", IDS_PRINT_FINISHINGS_PUNCH_DUAL_RIGHT},
       {"finishings/77", IDS_PRINT_FINISHINGS_PUNCH_DUAL_BOTTOM},
       {"finishings/78", IDS_PRINT_FINISHINGS_PUNCH_TRIPLE_LEFT},
       {"finishings/79", IDS_PRINT_FINISHINGS_PUNCH_TRIPLE_TOP},
       {"finishings/80", IDS_PRINT_FINISHINGS_PUNCH_TRIPLE_RIGHT},
       {"finishings/81", IDS_PRINT_FINISHINGS_PUNCH_TRIPLE_BOTTOM},
       {"finishings/82", IDS_PRINT_FINISHINGS_PUNCH_QUAD_LEFT},
       {"finishings/83", IDS_PRINT_FINISHINGS_PUNCH_QUAD_TOP},
       {"finishings/84", IDS_PRINT_FINISHINGS_PUNCH_QUAD_RIGHT},
       {"finishings/85", IDS_PRINT_FINISHINGS_PUNCH_QUAD_BOTTOM},
       {"finishings/86", IDS_PRINT_FINISHINGS_PUNCH_MULTIPLE_LEFT},
       {"finishings/87", IDS_PRINT_FINISHINGS_PUNCH_MULTIPLE_TOP},
       {"finishings/88", IDS_PRINT_FINISHINGS_PUNCH_MULTIPLE_RIGHT},
       {"finishings/89", IDS_PRINT_FINISHINGS_PUNCH_MULTIPLE_BOTTOM},
       {"finishings/90", IDS_PRINT_FINISHINGS_FOLD_ACCORDION},
       {"finishings/91", IDS_PRINT_FINISHINGS_FOLD_DOUBLE_GATE},
       {"finishings/92", IDS_PRINT_FINISHINGS_FOLD_GATE},
       {"finishings/93", IDS_PRINT_FINISHINGS_FOLD_HALF},
       {"finishings/94", IDS_PRINT_FINISHINGS_FOLD_HALF_Z},
       {"finishings/95", IDS_PRINT_FINISHINGS_FOLD_LEFT_GATE},
       {"finishings/96", IDS_PRINT_FINISHINGS_FOLD_LETTER},
       {"finishings/97", IDS_PRINT_FINISHINGS_FOLD_PARALLEL},
       {"finishings/98", IDS_PRINT_FINISHINGS_FOLD_POSTER},
       {"finishings/99", IDS_PRINT_FINISHINGS_FOLD_RIGHT_GATE},
       {"finishings/100", IDS_PRINT_FINISHINGS_FOLD_Z},
       {"finishings/101", IDS_PRINT_FINISHINGS_FOLD_ENGINEERING_Z},
       {"print-quality/3", IDS_PRINT_PRINT_QUALITY_DRAFT},
       {"print-quality/4", IDS_PRINT_PRINT_QUALITY_NORMAL},
       {"print-quality/5", IDS_PRINT_PRINT_QUALITY_HIGH}});
  return *l10n_map;
}
