/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.resourceobject;

import com.sourceforge.knecs.dsm.resourceobject.IServiceConnection;
import com.sourceforge.knecs.dsm.resourceobject.ResourceObject;
import com.sourceforge.knecs.dsm.util.DAVResource;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;

public class RISNaming {
    protected IServiceConnection mServiceConnection;
    private Logger mLog;
    private static CMCSProperties mCmcsProps = CMCSProperties.getCMCSProperties();
    private static String ITERATOR = "iterator";

    private RISNaming() {
    }

    public RISNaming(IServiceConnection serviceConnection) {
        this.mServiceConnection = serviceConnection;
        this.mLog = LoggerUtils.getLogger(this);
    }

    public String getName(String resourcePathname) {
        if (resourcePathname.endsWith("/")) {
            resourcePathname = resourcePathname.substring(0, resourcePathname.length() - 1);
        }
        String nameId = resourcePathname;
        int pos = resourcePathname.lastIndexOf(47);
        if (pos != -1) {
            nameId = resourcePathname.substring(pos + 1);
        }
        return nameId;
    }

    public String getName(ResourceObject anRISObject) throws Exception {
        String parentPath = this.getParentPath(anRISObject.getClass());
        return RISNaming.getName(anRISObject, parentPath, this.mServiceConnection, this.mLog);
    }

    public static synchronized String getName(ResourceObject anRISObject, String parentPath, IServiceConnection connection, Logger logger) throws Exception {
        String nameId = anRISObject.getId();
        if (nameId == null || nameId.length() == 0) {
            String prefix = (String)anRISObject.get("http://purl.org/dc/elements/1.1/:type");
            int pos = prefix.lastIndexOf(46);
            if (pos != -1) {
                prefix = prefix.substring(pos + 1).toLowerCase();
            }
            String suffix = mCmcsProps.getProperty("portalobjectsuffix");
            String topLevelPath = RISNaming.getTopLevelPath();
            String namespace = mCmcsProps.getProperty("cmcsns");
            HashSet<NSProperty> propSet = new HashSet<NSProperty>();
            NSProperty iterPropName = new NSProperty(namespace, prefix + "." + ITERATOR);
            propSet.add(iterPropName);
            Vector results = connection.search(topLevelPath, propSet, null, 0);
            String iterator = null;
            int iteratorValue = 1;
            if (results.size() > 0) {
                DAVResource collection = (DAVResource)results.get(0);
                Vector iteratorVec = (Vector)collection.get(iterPropName);
                if (iteratorVec != null && iteratorVec.size() > 0) {
                    iterator = (String)iteratorVec.get(0);
                    if (iterator != null && iterator.length() > 0) {
                        iteratorValue = Integer.parseInt(iterator);
                        ++iteratorValue;
                    } else {
                        logger.warning("Iterator property exists but value is empty for: " + prefix + ", usng 1");
                    }
                } else {
                    logger.warning("No iterator value found for: " + prefix + ", using 1");
                }
            } else {
                logger.severe("No top level collection found to contain portal object iterators" + topLevelPath);
                throw new Exception("Top level portal object collection " + topLevelPath + " not found");
            }
            boolean exists = true;
            String fullPath = null;
            while (exists) {
                iterator = String.valueOf(iteratorValue);
                nameId = prefix + "-" + iterator + suffix;
                fullPath = parentPath + "/" + nameId;
                if (connection.exists(fullPath)) {
                    logger.warning("A resourceobject already exists at  location: " + fullPath + " - Incrementing" + " iterator and continuing.");
                    ++iteratorValue;
                    continue;
                }
                exists = false;
            }
            Hashtable<String, String> newProp = new Hashtable<String, String>();
            newProp.put(iterPropName.toString(), iterator);
            connection.modify(topLevelPath, null, newProp);
        }
        return nameId;
    }

    public String getPath(ResourceObject anRISObject) throws Exception {
        String parentPath = this.getParentPath(anRISObject);
        String resourceName = this.getName(anRISObject);
        StringBuffer fullPath = new StringBuffer(parentPath);
        if (!parentPath.endsWith("/")) {
            fullPath.append("/");
        }
        fullPath.append(resourceName);
        return fullPath.toString();
    }

    public String getParentPath(ResourceObject anRISObject) throws Exception {
        Class<?> anRISClass = anRISObject.getClass();
        return this.getParentPath(anRISClass);
    }

    public String getParentPath(Class anRISClass) throws Exception {
        String topLevelPath = RISNaming.getTopLevelPath();
        StringBuffer parentPath = new StringBuffer(topLevelPath);
        String risClassName = anRISClass.getName();
        Vector portalClasses = CMCSProperties.getPropertyAsVector("portalclasses");
        boolean notFound = true;
        for (int i = 0; i < portalClasses.size() && notFound; ++i) {
            String classStr = mCmcsProps.getProperty((String)portalClasses.get(i));
            if (!risClassName.equals(classStr)) continue;
            notFound = false;
            String pathLookupStr = (String)portalClasses.get(i);
            int pos = pathLookupStr.indexOf(46);
            if (pos != -1) {
                pathLookupStr = pathLookupStr.substring(0, pos);
            }
            if (!topLevelPath.endsWith("/")) {
                parentPath.append("/");
            }
            parentPath.append(mCmcsProps.getProperty(pathLookupStr));
        }
        if (notFound) {
            this.mLog.severe("ResourceObject class not found for " + anRISClass.getName());
            throw new Exception("Not able to find class for " + anRISClass.getName());
        }
        return parentPath.toString();
    }

    public static String getTopLevelPath() {
        String samServer = mCmcsProps.getProperty("samserver");
        String portalObjectsPath = mCmcsProps.getProperty("portalobjects");
        StringBuffer topLevelPath = new StringBuffer(samServer);
        topLevelPath.append(portalObjectsPath);
        return topLevelPath.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Class getClass(String resourcePathname) throws Exception {
        if (resourcePathname.endsWith("/")) {
            resourcePathname = resourcePathname.substring(0, resourcePathname.length() - 1);
        }
        Class<?> returnClass = null;
        int pos1 = resourcePathname.lastIndexOf(47);
        if (pos1 != -1) {
            int pos = pos1 - 1;
            int pos2 = resourcePathname.lastIndexOf(47, pos);
            if (pos2 != -1) {
                String classLookupStr = resourcePathname.substring(pos2 + 1, pos1);
                classLookupStr = classLookupStr + ".class";
                String classStr = mCmcsProps.getProperty(classLookupStr);
                try {
                    return Class.forName(classStr);
                }
                catch (ClassNotFoundException ex) {
                    this.mLog.severe("ClassNotFoundException caught when instantiating class for " + classLookupStr);
                    throw ex;
                }
            }
            this.mLog.severe("Not able to determine class from resourcePathname " + resourcePathname);
            throw new Exception("Not able to determine class from resourcePathname " + resourcePathname);
        }
        this.mLog.severe("Not able to determine class from resourcePathname " + resourcePathname);
        throw new Exception("Not able to determine class from resourcePathname " + resourcePathname);
    }
}

