//
// lambda_ccsdpr12_t2.cc
//
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki.toru@gmail.com>
// Maintainer: TS
//
// This file is part of the SC Toolkit.
//
// The SC Toolkit is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// The SC Toolkit is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the SC Toolkit; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The U.S. Government is granted a limited license as per AL 91-7.
//
  
// This is a C++ code generated by SMITH
  
#include <algorithm>
#include <chemistry/qc/ccr12/lambda_ccsdpr12_t2.h>
#include <chemistry/qc/ccr12/tensor.h>
using namespace sc;
  
  
LAMBDA_CCSDPR12_T2::LAMBDA_CCSDPR12_T2(CCR12_Info* info):z(info){};
LAMBDA_CCSDPR12_T2::~LAMBDA_CCSDPR12_T2(){};
  
  
  
void LAMBDA_CCSDPR12_T2::compute_amp(Ref<Tensor>& out){ //k_i0_offset,z->gt2(),z->f1(),z->in.at(0),z->lambda1(),z->lambda2(),z->glambda2(),z->ly(),z->qy(),z->t1(),z->t2(),z->v2(),z->vd2()=>z->vr2()
  
in.resize(8);
  
smith_0_1(out); //z->v2()=>out
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_0",z->mem());
offset_smith_0_2();
smith_0_2_0(); //z->v2()=>in.at(1)
smith_1_5(); //z->t1(),z->v2()=>in.at(1)
smith_0_2(out); //z->lambda1(),in.at(1)=>out
delete in.at(1);
smith_0_3(out); //z->lambda1(),z->v2()=>out
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_4",z->mem());
offset_smith_0_4();
smith_1_4(); //z->t1(),z->v2()=>in.at(1)
smith_0_4(out); //z->lambda1(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_1",z->mem());
offset_smith_0_6();
smith_1_6(); //z->t1(),z->lambda1()=>in.at(1)
smith_1_35(); //z->t2(),z->lambda2()=>in.at(1)
smith_0_6(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_2",z->mem());
offset_smith_0_7();
smith_0_7_0(); //z->f1()=>in.at(1)
smith_1_15(); //z->t1(),z->v2()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t2_2_24",z->mem());
offset_smith_1_24();
smith_2_24(); //z->t1(),z->v2()=>in.at(2)
smith_1_24(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_29(); //z->t2(),z->v2()=>in.at(1)
smith_1_36(); //z->gt2(),z->vr2()=>in.at(1)
smith_0_7(out); //z->lambda2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_3",z->mem());
offset_smith_0_8();
smith_0_8_0(); //z->f1()=>in.at(1)
smith_1_17(); //z->t1(),z->v2()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t2_2_26",z->mem());
offset_smith_1_26();
smith_2_26(); //z->t1(),z->v2()=>in.at(2)
smith_1_26(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_31(); //z->t2(),z->v2()=>in.at(1)
smith_1_38(); //z->qy(),z->v2()=>in.at(1)
smith_0_8(out); //z->lambda2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_4",z->mem());
offset_smith_0_9();
smith_0_9_0(); //z->f1()=>in.at(1)
smith_1_21(); //z->t1(),z->v2()=>in.at(1)
smith_0_9(out); //z->ly(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_5",z->mem());
offset_smith_0_10();
smith_0_10_0(); //z->v2()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t2_2_0",z->mem());
offset_smith_1_16();
smith_1_16_0(); //z->v2()=>in.at(2)
smith_2_25(); //z->t1(),z->v2()=>in.at(2)
smith_1_16(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_30(); //z->t2(),z->v2()=>in.at(1)
smith_1_37(); //z->gt2(),z->vr2()=>in.at(1)
smith_0_10(out); //z->lambda2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_6",z->mem());
offset_smith_0_11();
smith_0_11_0(); //z->v2()=>in.at(1)
smith_1_19(); //z->t1(),z->v2()=>in.at(1)
in.at(2)=new Tensor("lambda_ccsdpr12_t2_2_27",z->mem());
offset_smith_1_27();
smith_2_27(); //z->t1(),z->v2()=>in.at(2)
smith_1_27(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_39(); //z->qy(),z->v2()=>in.at(1)
smith_0_11(out); //z->lambda2(),in.at(1)=>out
delete in.at(1);
smith_0_12(out); //z->lambda2(),z->v2()=>out
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_7",z->mem());
offset_smith_0_13();
smith_0_13_0(); //z->v2()=>in.at(1)
smith_1_22(); //z->t1(),z->v2()=>in.at(1)
smith_0_13(out); //z->ly(),in.at(1)=>out
delete in.at(1);
smith_0_14(out); //z->glambda2(),z->vd2()=>out
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_18",z->mem());
offset_smith_0_18();
smith_1_18(); //z->t1(),z->lambda2()=>in.at(1)
smith_0_18(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_20",z->mem());
offset_smith_0_20();
smith_1_20(); //z->t1(),z->lambda2()=>in.at(1)
smith_0_20(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_23",z->mem());
offset_smith_0_23();
smith_1_23(); //z->t1(),z->ly()=>in.at(1)
smith_0_23(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_8",z->mem());
offset_smith_0_28();
in.at(2)=new Tensor("lambda_ccsdpr12_t2_2_28",z->mem());
offset_smith_1_28();
smith_2_28(); //z->t1(),z->lambda2()=>in.at(2)
smith_1_28(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_34(); //z->t2(),z->lambda2()=>in.at(1)
smith_0_28(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_32",z->mem());
offset_smith_0_32();
smith_1_32(); //z->t2(),z->lambda2()=>in.at(1)
smith_0_32(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_33",z->mem());
offset_smith_0_33();
smith_1_33(); //z->t2(),z->lambda2()=>in.at(1)
smith_0_33(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("lambda_ccsdpr12_t2_1_40",z->mem());
offset_smith_0_40();
smith_1_40(); //z->lambda2(),z->qy()=>in.at(1)
smith_0_40(out); //z->v2(),in.at(1)=>out
delete in.at(1);
  
}
  
void LAMBDA_CCSDPR12_T2::smith_0_1(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=p1b;p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==z->irrep_v()) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        long h3b_0,h4b_0,p1b_0,p2b_0; 
        z->restricted_4(h3b,h4b,p1b,p2b,h3b_0,h4b_0,p1b_0,p2b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p2b_0+(z->nab())*(p1b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p1b),z->get_range(p2b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h3b),z->get_range(h4b),z->get_range(p1b),z->get_range(p2b),0,1,2,3,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_10(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=p1b;p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_y()^z->irrep_v())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         for (long h6b=h5b;h6b<z->noab();++h6b) { 
          if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
           if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(p1b)^z->get_sym(p2b))))==z->irrep_y()) { 
            long h5b_0,h6b_0,p1b_0,p2b_0; 
            z->restricted_4(h5b,h6b,p1b,p2b,h5b_0,h6b_0,p1b_0,p2b_0); 
            long h3b_1,h4b_1,h5b_1,h6b_1; 
            z->restricted_4(h3b,h4b,h5b,h6b,h3b_1,h4b_1,h5b_1,h6b_1); 
            long dim_common=z->get_range(h5b)*z->get_range(h6b); 
            long dima0_sort=z->get_range(p1b)*z->get_range(p2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->lambda2()->get_block(p2b_0-z->noab()+z->nvab()*(p1b_0-z->noab()+z->nvab()*(h6b_0+z->noab()*(h5b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p1b),z->get_range(p2b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[1]->get_block(h6b_1+z->noab()*(h5b_1+z->noab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(h6b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (h5b==h6b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p2b),z->get_range(p1b),1,0,3,2,+0.5/0.5); 
        out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_10_0(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long h6b=h5b;h6b<z->noab();++h6b) { 
    long tileoffset; 
    tileoffset=(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(h6b))))==z->irrep_v()) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
        long h3b_0,h4b_0,h5b_0,h6b_0; 
        z->restricted_4(h3b,h4b,h5b,h6b,h3b_0,h4b_0,h5b_0,h6b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(h6b_0+(z->nab())*(h5b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(h6b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(h6b),0,1,2,3,+1.0); 
         in[1]->add_block(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_10(){ 
 
long size=0L; 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long h6b=h5b;h6b<z->noab();++h6b) { 
    if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
     if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(h6b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)!=8L) { 
       in[1]->input_offset(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),size); 
       size+=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_11(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    if (h3b<h4b && p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h3b<h4b && p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h4b<=h3b && p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    else if (h4b<=h3b && p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_y()^z->irrep_v())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
          if (z->get_spin(h3b)+z->get_spin(h5b)==z->get_spin(p1b)+z->get_spin(p6b)) { 
           if ((z->get_sym(h3b)^(z->get_sym(h5b)^(z->get_sym(p1b)^z->get_sym(p6b))))==z->irrep_y()) { 
            long h3b_0,h5b_0,p1b_0,p6b_0; 
            z->restricted_4(h3b,h5b,p1b,p6b,h3b_0,h5b_0,p1b_0,p6b_0); 
            long h4b_1,p6b_1,h5b_1,p2b_1; 
            z->restricted_4(h4b,p6b,h5b,p2b,h4b_1,p6b_1,h5b_1,p2b_1); 
            long dim_common=z->get_range(h5b)*z->get_range(p6b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(p1b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h4b)*z->get_range(p2b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (h3b<h5b && p1b<p6b) { 
              z->lambda2()->get_block(p6b_0-z->noab()+z->nvab()*(p1b_0-z->noab()+z->nvab()*(h5b_0+z->noab()*(h3b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h5b),z->get_range(p1b),z->get_range(p6b),2,0,3,1,+1.0); 
             } 
             else if (h3b<h5b && p6b<=p1b) { 
              z->lambda2()->get_block(p1b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(h5b_0+z->noab()*(h3b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h5b),z->get_range(p6b),z->get_range(p1b),3,0,2,1,-1.0); 
             } 
             else if (h5b<=h3b && p1b<p6b) { 
              z->lambda2()->get_block(p6b_0-z->noab()+z->nvab()*(p1b_0-z->noab()+z->nvab()*(h3b_0+z->noab()*(h5b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h3b),z->get_range(p1b),z->get_range(p6b),2,1,3,0,-1.0); 
             } 
             else if (h5b<=h3b && p6b<=p1b) { 
              z->lambda2()->get_block(p1b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(h3b_0+z->noab()*(h5b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h3b),z->get_range(p6b),z->get_range(p1b),3,1,2,0,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[1]->get_block(p2b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p6b),z->get_range(h5b),z->get_range(p2b),3,0,1,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b && p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),3,1,2,0,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h4b>=h3b && p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),3,1,0,2,-1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h3b>=h4b && p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),1,3,2,0,-1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        if (h3b>=h4b && p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),1,3,0,2,+1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_11_0(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(p6b-z->noab()+z->nvab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p6b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(p6b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(p6b)^(z->get_sym(h5b)^z->get_sym(p2b))))==z->irrep_v()) { 
        long dimc=z->get_range(h4b)*z->get_range(p6b)*z->get_range(h5b)*z->get_range(p2b); 
        long h4b_0,p6b_0,h5b_0,p2b_0; 
        z->restricted_4(h4b,p6b,h5b,p2b,h4b_0,p6b_0,h5b_0,p2b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h4b)*z->get_range(p6b)*z->get_range(h5b)*z->get_range(p2b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p2b_0+(z->nab())*(h5b_0+(z->nab())*(p6b_0+(z->nab())*(h4b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(p6b),z->get_range(h5b),z->get_range(p2b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h4b),z->get_range(p6b),z->get_range(h5b),z->get_range(p2b),0,1,2,3,-1.0); 
         in[1]->add_block(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(p6b-z->noab()+z->nvab()*(h4b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_11(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    if (z->get_spin(h4b)+z->get_spin(p6b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(p6b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p6b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
       in[1]->input_offset(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(p6b-z->noab()+z->nvab()*(h4b))),size); 
       size+=z->get_range(h4b)*z->get_range(p6b)*z->get_range(h5b)*z->get_range(p2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_12(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=p1b;p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_y()^z->irrep_v())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
          if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p5b)+z->get_spin(p6b)) { 
           if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p5b)^z->get_sym(p6b))))==z->irrep_y()) { 
            long h3b_0,h4b_0,p5b_0,p6b_0; 
            z->restricted_4(h3b,h4b,p5b,p6b,h3b_0,h4b_0,p5b_0,p6b_0); 
            long p5b_1,p6b_1,p1b_1,p2b_1; 
            z->restricted_4(p5b,p6b,p1b,p2b,p5b_1,p6b_1,p1b_1,p2b_1); 
            long dim_common=z->get_range(p5b)*z->get_range(p6b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(p1b)*z->get_range(p2b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->lambda2()->get_block(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(h4b_0+z->noab()*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p5b),z->get_range(p6b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->v2()->get_block(p2b_1+(z->nab())*(p1b_1+(z->nab())*(p6b_1+(z->nab())*(p5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p1b),z->get_range(p2b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (p5b==p6b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),z->get_range(h3b),3,2,1,0,+0.5/0.5); 
        out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_13(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    if (h3b<h4b && p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h3b<h4b && p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h4b<=h3b && p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    else if (h4b<=h3b && p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_y()^z->irrep_v())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
          if (z->get_spin(h3b)+z->get_spin(h5b)==z->get_spin(p1b)+z->get_spin(q6b)) { 
           if ((z->get_sym(h3b)^(z->get_sym(h5b)^(z->get_sym(p1b)^z->get_sym(q6b))))==z->irrep_y()) { 
            long h3b_0,h5b_0,p1b_0,q6b_0; 
            z->restricted_4(h3b,h5b,p1b,q6b,h3b_0,h5b_0,p1b_0,q6b_0); 
            long h4b_1,q6b_1,h5b_1,p2b_1; 
            z->restricted_4(h4b,q6b,h5b,p2b,h4b_1,q6b_1,h5b_1,p2b_1); 
            long dim_common=z->get_range(h5b)*z->get_range(q6b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(p1b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h4b)*z->get_range(p2b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (h3b<h5b) { 
              z->ly()->get_block(q6b_0-z->noab()-z->nvab()+z->ncab()*(p1b_0-z->noab()+z->nvab()*(h5b_0+z->noab()*(h3b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h5b),z->get_range(p1b),z->get_range(q6b),2,0,3,1,+1.0); 
             } 
             else if (h5b<=h3b) { 
              z->ly()->get_block(q6b_0-z->noab()-z->nvab()+z->ncab()*(p1b_0-z->noab()+z->nvab()*(h3b_0+z->noab()*(h5b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h3b),z->get_range(p1b),z->get_range(q6b),2,1,3,0,-1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[1]->get_block(p2b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(q6b_1-z->noab()-z->nvab()+z->ncab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(q6b),z->get_range(h5b),z->get_range(p2b),3,0,1,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b && p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),3,1,2,0,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h4b>=h3b && p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),3,1,0,2,-1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h3b>=h4b && p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),1,3,2,0,-1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        if (h3b>=h4b && p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),1,3,0,2,+1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_13_0(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(q6b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(q6b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(q6b)^(z->get_sym(h5b)^z->get_sym(p2b))))==z->irrep_v()) { 
        long dimc=z->get_range(h4b)*z->get_range(q6b)*z->get_range(h5b)*z->get_range(p2b); 
        long h4b_0,q6b_0,h5b_0,p2b_0; 
        z->restricted_4(h4b,q6b,h5b,p2b,h4b_0,q6b_0,h5b_0,p2b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h4b)*z->get_range(q6b)*z->get_range(h5b)*z->get_range(p2b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p2b_0+(z->nab())*(h5b_0+(z->nab())*(q6b_0+(z->nab())*(h4b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(q6b),z->get_range(h5b),z->get_range(p2b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h4b),z->get_range(q6b),z->get_range(h5b),z->get_range(p2b),0,1,2,3,-1.0); 
         in[1]->add_block(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(h4b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_13(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    if (z->get_spin(h4b)+z->get_spin(q6b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(q6b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h4b)+z->get_spin(q6b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
       in[1]->input_offset(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(h4b))),size); 
       size+=z->get_range(h4b)*z->get_range(q6b)*z->get_range(h5b)*z->get_range(p2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_14(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=p1b;p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_y()^z->irrep_e())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         for (long h6b=h5b;h6b<z->noab();++h6b) { 
          if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
           if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(h6b))))==z->irrep_y()) { 
            long h3b_0,h4b_0,h5b_0,h6b_0; 
            z->restricted_4(h3b,h4b,h5b,h6b,h3b_0,h4b_0,h5b_0,h6b_0); 
            long h5b_1,h6b_1,p1b_1,p2b_1; 
            z->restricted_4(h5b,h6b,p1b,p2b,h5b_1,h6b_1,p1b_1,p2b_1); 
            long dim_common=z->get_range(h5b)*z->get_range(h6b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(p1b)*z->get_range(p2b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->glambda2()->get_block(h6b_0+z->noab()*(h5b_0+z->noab()*(h4b_0+z->noab()*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(h6b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->vd2()->get_block(p2b_1+(z->nab())*(p1b_1+(z->nab())*(h6b_1+z->noab()*(h5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p1b),z->get_range(p2b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (h5b==h6b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),z->get_range(h3b),3,2,1,0,+0.5/0.5); 
        out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_18(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    if (h3b<h4b && p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h3b<h4b && p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h4b<=h3b && p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    else if (h4b<=h3b && p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         for (long h6b=0L;h6b<z->noab();++h6b) { 
          if (z->get_spin(h3b)+z->get_spin(h5b)==z->get_spin(h6b)+z->get_spin(p1b)) { 
           if ((z->get_sym(h3b)^(z->get_sym(h5b)^(z->get_sym(h6b)^z->get_sym(p1b))))==z->irrep_v()) { 
            long h3b_0,h5b_0,h6b_0,p1b_0; 
            z->restricted_4(h3b,h5b,h6b,p1b,h3b_0,h5b_0,h6b_0,p1b_0); 
            long h4b_1,h6b_1,h5b_1,p2b_1; 
            z->restricted_4(h4b,h6b,h5b,p2b,h4b_1,h6b_1,h5b_1,p2b_1); 
            long dim_common=z->get_range(h5b)*z->get_range(h6b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(p1b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h4b)*z->get_range(p2b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (h3b<h5b) { 
              z->v2()->get_block(p1b_0+(z->nab())*(h6b_0+(z->nab())*(h5b_0+(z->nab())*(h3b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h5b),z->get_range(h6b),z->get_range(p1b),3,0,2,1,+1.0); 
             } 
             else if (h5b<=h3b) { 
              z->v2()->get_block(p1b_0+(z->nab())*(h6b_0+(z->nab())*(h3b_0+(z->nab())*(h5b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h3b),z->get_range(h6b),z->get_range(p1b),3,1,2,0,-1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h4b<h6b) { 
              in[1]->get_block(p2b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h6b_1+z->noab()*(h4b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h6b),z->get_range(h5b),z->get_range(p2b),3,0,1,2,+1.0); 
             } 
             else if (h6b<=h4b) { 
              in[1]->get_block(p2b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h4b_1+z->noab()*(h6b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h4b),z->get_range(h5b),z->get_range(p2b),3,1,0,2,-1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b && p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),3,1,2,0,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h4b>=h3b && p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),3,1,0,2,-1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h3b>=h4b && p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),1,3,2,0,-1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        if (h3b>=h4b && p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),1,3,0,2,+1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_18(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h6b=h4b;h6b<z->noab();++h6b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    if (z->get_spin(h4b)+z->get_spin(h6b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(h6b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h6b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
       in[1]->input_offset(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(h6b+z->noab()*(h4b))),size); 
       size+=z->get_range(h4b)*z->get_range(h6b)*z->get_range(h5b)*z->get_range(p2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_2(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    if (p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_y()^z->irrep_v())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         if (z->get_spin(h5b)==z->get_spin(p1b)) { 
          if ((z->get_sym(h5b)^z->get_sym(p1b))==z->irrep_y()) { 
           long h5b_0,p1b_0; 
           z->restricted_2(h5b,p1b,h5b_0,p1b_0); 
           long h3b_1,h4b_1,h5b_1,p2b_1; 
           z->restricted_4(h3b,h4b,h5b,p2b,h3b_1,h4b_1,h5b_1,p2b_1); 
           long dim_common=z->get_range(h5b); 
           long dima0_sort=z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->lambda1()->get_block(p1b_0-z->noab()+z->nvab()*(h5b_0),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(p1b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(p2b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(p2b),3,1,0,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(h3b),z->get_range(p1b),2,1,3,0,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(h3b),z->get_range(p1b),2,1,0,3,-1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_20(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=p1b;p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
          if (z->get_spin(h5b)+z->get_spin(p6b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
           if ((z->get_sym(h5b)^(z->get_sym(p6b)^(z->get_sym(p1b)^z->get_sym(p2b))))==z->irrep_v()) { 
            long h5b_0,p6b_0,p1b_0,p2b_0; 
            z->restricted_4(h5b,p6b,p1b,p2b,h5b_0,p6b_0,p1b_0,p2b_0); 
            long h3b_1,h4b_1,h5b_1,p6b_1; 
            z->restricted_4(h3b,h4b,h5b,p6b,h3b_1,h4b_1,h5b_1,p6b_1); 
            long dim_common=z->get_range(h5b)*z->get_range(p6b); 
            long dima0_sort=z->get_range(p1b)*z->get_range(p2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->v2()->get_block(p2b_0+(z->nab())*(p1b_0+(z->nab())*(p6b_0+(z->nab())*(h5b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(p6b),z->get_range(p1b),z->get_range(p2b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[1]->get_block(p6b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(p6b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p2b),z->get_range(p1b),1,0,3,2,+1.0); 
        out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_20(){ 
 
long size=0L; 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(p6b)) { 
     if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(p6b)!=8L) { 
       in[1]->input_offset(p6b-z->noab()+z->nvab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),size); 
       size+=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(p6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_23(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=p1b;p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
          if (z->get_spin(h5b)+z->get_spin(q6b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
           if ((z->get_sym(h5b)^(z->get_sym(q6b)^(z->get_sym(p1b)^z->get_sym(p2b))))==z->irrep_v()) { 
            long h5b_0,q6b_0,p1b_0,p2b_0; 
            z->restricted_4(h5b,q6b,p1b,p2b,h5b_0,q6b_0,p1b_0,p2b_0); 
            long h3b_1,h4b_1,h5b_1,q6b_1; 
            z->restricted_4(h3b,h4b,h5b,q6b,h3b_1,h4b_1,h5b_1,q6b_1); 
            long dim_common=z->get_range(h5b)*z->get_range(q6b); 
            long dima0_sort=z->get_range(p1b)*z->get_range(p2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->v2()->get_block(p2b_0+(z->nab())*(p1b_0+(z->nab())*(q6b_0+(z->nab())*(h5b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(q6b),z->get_range(p1b),z->get_range(p2b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[1]->get_block(q6b_1-z->noab()-z->nvab()+z->ncab()*(h5b_1+z->noab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(q6b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p2b),z->get_range(p1b),1,0,3,2,+1.0); 
        out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_23(){ 
 
long size=0L; 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
    if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(q6b)) { 
     if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(q6b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(q6b)!=8L) { 
       in[1]->input_offset(q6b-z->noab()-z->nvab()+z->ncab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),size); 
       size+=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(q6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_28(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=p1b;p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_v()^(z->irrep_t()^(z->irrep_t()^z->irrep_y())))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         for (long h6b=h5b;h6b<z->noab();++h6b) { 
          if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
           if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(p1b)^z->get_sym(p2b))))==z->irrep_v()) { 
            long h5b_0,h6b_0,p1b_0,p2b_0; 
            z->restricted_4(h5b,h6b,p1b,p2b,h5b_0,h6b_0,p1b_0,p2b_0); 
            long h3b_1,h4b_1,h5b_1,h6b_1; 
            z->restricted_4(h3b,h4b,h5b,h6b,h3b_1,h4b_1,h5b_1,h6b_1); 
            long dim_common=z->get_range(h5b)*z->get_range(h6b); 
            long dima0_sort=z->get_range(p1b)*z->get_range(p2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->v2()->get_block(p2b_0+(z->nab())*(p1b_0+(z->nab())*(h6b_0+(z->nab())*(h5b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p1b),z->get_range(p2b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[1]->get_block(h6b_1+z->noab()*(h5b_1+z->noab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(h6b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (h5b==h6b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p2b),z->get_range(p1b),1,0,3,2,+0.5/0.5); 
        out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_28(){ 
 
long size=0L; 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long h6b=h5b;h6b<z->noab();++h6b) { 
    if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
     if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(h6b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
      if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)!=8L) { 
       in[1]->input_offset(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),size); 
       size+=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_2_0(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(p2b))))==z->irrep_v()) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(p2b); 
        long h3b_0,h4b_0,h5b_0,p2b_0; 
        z->restricted_4(h3b,h4b,h5b,p2b,h3b_0,h4b_0,h5b_0,p2b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(p2b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p2b_0+(z->nab())*(h5b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(p2b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(p2b),0,1,2,3,-1.0); 
         in[1]->add_block(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_2(){ 
 
long size=0L; 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
     if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
       in[1]->input_offset(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),size); 
       size+=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(p2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_3(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=p1b;p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_y()^z->irrep_v())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(h3b)==z->get_spin(p5b)) { 
          if ((z->get_sym(h3b)^z->get_sym(p5b))==z->irrep_y()) { 
           long h3b_0,p5b_0; 
           z->restricted_2(h3b,p5b,h3b_0,p5b_0); 
           long h4b_1,p5b_1,p1b_1,p2b_1; 
           z->restricted_4(h4b,p5b,p1b,p2b,h4b_1,p5b_1,p1b_1,p2b_1); 
           long dim_common=z->get_range(p5b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->lambda1()->get_block(p5b_0-z->noab()+z->nvab()*(h3b_0),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(p5b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->v2()->get_block(p2b_1+(z->nab())*(p1b_1+(z->nab())*(p5b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p5b),z->get_range(p1b),z->get_range(p2b),3,2,0,1,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),z->get_range(h3b),3,2,1,0,-1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),z->get_range(h3b),2,3,1,0,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_32(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    if (h3b<h4b && p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h3b<h4b && p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h4b<=h3b && p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    else if (h4b<=h3b && p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
          if (z->get_spin(h3b)+z->get_spin(h5b)==z->get_spin(p1b)+z->get_spin(p6b)) { 
           if ((z->get_sym(h3b)^(z->get_sym(h5b)^(z->get_sym(p1b)^z->get_sym(p6b))))==z->irrep_v()) { 
            long h3b_0,h5b_0,p1b_0,p6b_0; 
            z->restricted_4(h3b,h5b,p1b,p6b,h3b_0,h5b_0,p1b_0,p6b_0); 
            long h4b_1,p6b_1,h5b_1,p2b_1; 
            z->restricted_4(h4b,p6b,h5b,p2b,h4b_1,p6b_1,h5b_1,p2b_1); 
            long dim_common=z->get_range(h5b)*z->get_range(p6b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(p1b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h4b)*z->get_range(p2b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (h3b<h5b && p1b<p6b) { 
              z->v2()->get_block(p6b_0+(z->nab())*(p1b_0+(z->nab())*(h5b_0+(z->nab())*(h3b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h5b),z->get_range(p1b),z->get_range(p6b),2,0,3,1,+1.0); 
             } 
             else if (h3b<h5b && p6b<=p1b) { 
              z->v2()->get_block(p1b_0+(z->nab())*(p6b_0+(z->nab())*(h5b_0+(z->nab())*(h3b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h5b),z->get_range(p6b),z->get_range(p1b),3,0,2,1,-1.0); 
             } 
             else if (h5b<=h3b && p1b<p6b) { 
              z->v2()->get_block(p6b_0+(z->nab())*(p1b_0+(z->nab())*(h3b_0+(z->nab())*(h5b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h3b),z->get_range(p1b),z->get_range(p6b),2,1,3,0,-1.0); 
             } 
             else if (h5b<=h3b && p6b<=p1b) { 
              z->v2()->get_block(p1b_0+(z->nab())*(p6b_0+(z->nab())*(h3b_0+(z->nab())*(h5b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h3b),z->get_range(p6b),z->get_range(p1b),3,1,2,0,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[1]->get_block(p2b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p6b),z->get_range(h5b),z->get_range(p2b),3,0,1,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b && p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),3,1,2,0,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h4b>=h3b && p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),3,1,0,2,-1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h3b>=h4b && p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),1,3,2,0,-1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        if (h3b>=h4b && p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),1,3,0,2,+1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_32(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    if (z->get_spin(h4b)+z->get_spin(p6b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(p6b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p6b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
       in[1]->input_offset(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(p6b-z->noab()+z->nvab()*(h4b))),size); 
       size+=z->get_range(h4b)*z->get_range(p6b)*z->get_range(h5b)*z->get_range(p2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_33(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    if (p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p5b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p5b))))==z->irrep_v()) { 
           long h3b_0,h4b_0,p1b_0,p5b_0; 
           z->restricted_4(h3b,h4b,p1b,p5b,h3b_0,h4b_0,p1b_0,p5b_0); 
           long p5b_1,p2b_1; 
           z->restricted_2(p5b,p2b,p5b_1,p2b_1); 
           long dim_common=z->get_range(p5b); 
           long dima0_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p1b<p5b) { 
             z->v2()->get_block(p5b_0+(z->nab())*(p1b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p1b),z->get_range(p5b),2,1,0,3,+1.0); 
            } 
            else if (p5b<=p1b) { 
             z->v2()->get_block(p1b_0+(z->nab())*(p5b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p5b),z->get_range(p1b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(p2b_1-z->noab()+z->nvab()*(p5b_1-z->noab()),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(p5b),z->get_range(p2b),1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),z->get_range(h3b),3,2,1,0,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),z->get_range(h3b),3,2,0,1,-1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_33(){ 
 
long size=0L; 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  if (z->get_spin(p5b)==z->get_spin(p2b)) { 
   if ((z->get_sym(p5b)^z->get_sym(p2b))==(z->irrep_t()^z->irrep_y())) { 
    if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p2b)!=4L) { 
     in[1]->input_offset(p2b-z->noab()+z->nvab()*(p5b-z->noab()),size); 
     size+=z->get_range(p5b)*z->get_range(p2b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_4(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    if (h3b<h4b && p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h3b<h4b && p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h4b<=h3b && p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    else if (h4b<=h3b && p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_y()^(z->irrep_t()^z->irrep_v()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        if (z->get_spin(h3b)==z->get_spin(p1b)) { 
         if ((z->get_sym(h3b)^z->get_sym(p1b))==z->irrep_y()) { 
          long h3b_0,p1b_0; 
          z->restricted_2(h3b,p1b,h3b_0,p1b_0); 
          long h4b_1,p2b_1; 
          z->restricted_2(h4b,p2b,h4b_1,p2b_1); 
          long dim_common=1L; 
          long dima0_sort=z->get_range(h3b)*z->get_range(p1b); 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h4b)*z->get_range(p2b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->lambda1()->get_block(p1b_0-z->noab()+z->nvab()*(h3b_0),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(p1b),1,0,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           in[1]->get_block(p2b_1-z->noab()+z->nvab()*(h4b_1),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p2b),1,0,+1.0); 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b && p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),3,1,2,0,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h4b>=h3b && p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),3,1,0,2,-1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h3b>=h4b && p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),1,3,2,0,-1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        if (h3b>=h4b && p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(p1b),z->get_range(h3b),1,3,0,2,+1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_40(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    if (p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_v()^(z->irrep_y()^z->irrep_e()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
         if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(q5b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(q5b))))==z->irrep_v()) { 
           long h3b_0,h4b_0,p1b_0,q5b_0; 
           z->restricted_4(h3b,h4b,p1b,q5b,h3b_0,h4b_0,p1b_0,q5b_0); 
           long q5b_1,p2b_1; 
           z->restricted_2(q5b,p2b,q5b_1,p2b_1); 
           long dim_common=z->get_range(q5b); 
           long dima0_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->v2()->get_block(q5b_0+(z->nab())*(p1b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p1b),z->get_range(q5b),2,1,0,3,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(p2b_1-z->noab()+z->nvab()*(q5b_1-z->noab()-z->nvab()),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(q5b),z->get_range(p2b),1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),z->get_range(h3b),3,2,1,0,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),z->get_range(h3b),3,2,0,1,-1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_40(){ 
 
long size=0L; 
for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  if (z->get_spin(q5b)==z->get_spin(p2b)) { 
   if ((z->get_sym(q5b)^z->get_sym(p2b))==(z->irrep_y()^z->irrep_e())) { 
    if (!z->restricted() || z->get_spin(q5b)+z->get_spin(p2b)!=4L) { 
     in[1]->input_offset(p2b-z->noab()+z->nvab()*(q5b-z->noab()-z->nvab()),size); 
     size+=z->get_range(q5b)*z->get_range(p2b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_4(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  if (z->get_spin(h4b)==z->get_spin(p2b)) { 
   if ((z->get_sym(h4b)^z->get_sym(p2b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p2b)!=4L) { 
     in[1]->input_offset(p2b-z->noab()+z->nvab()*(h4b),size); 
     size+=z->get_range(h4b)*z->get_range(p2b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_6(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=p1b;p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         if (z->get_spin(h3b)+z->get_spin(h5b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h5b)^(z->get_sym(p1b)^z->get_sym(p2b))))==z->irrep_v()) { 
           long h3b_0,h5b_0,p1b_0,p2b_0; 
           z->restricted_4(h3b,h5b,p1b,p2b,h3b_0,h5b_0,p1b_0,p2b_0); 
           long h4b_1,h5b_1; 
           z->restricted_2(h4b,h5b,h4b_1,h5b_1); 
           long dim_common=z->get_range(h5b); 
           long dima0_sort=z->get_range(h3b)*z->get_range(p1b)*z->get_range(p2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h3b<h5b) { 
             z->v2()->get_block(p2b_0+(z->nab())*(p1b_0+(z->nab())*(h5b_0+(z->nab())*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h5b),z->get_range(p1b),z->get_range(p2b),3,2,0,1,+1.0); 
            } 
            else if (h5b<=h3b) { 
             z->v2()->get_block(p2b_0+(z->nab())*(p1b_0+(z->nab())*(h3b_0+(z->nab())*(h5b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h3b),z->get_range(p1b),z->get_range(p2b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(h5b_1+z->noab()*(h4b_1),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h5b),0,1,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(p2b),z->get_range(p1b),z->get_range(h3b),3,0,2,1,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(p2b),z->get_range(p1b),z->get_range(h3b),0,3,2,1,-1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_6(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=0L;h5b<z->noab();++h5b) { 
  if (z->get_spin(h4b)==z->get_spin(h5b)) { 
   if ((z->get_sym(h4b)^z->get_sym(h5b))==(z->irrep_t()^z->irrep_y())) { 
    if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)!=4L) { 
     in[1]->input_offset(h5b+z->noab()*(h4b),size); 
     size+=z->get_range(h4b)*z->get_range(h5b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_7(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=p1b;p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_y()^z->irrep_f())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         if (z->get_spin(h3b)+z->get_spin(h5b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h5b)^(z->get_sym(p1b)^z->get_sym(p2b))))==z->irrep_y()) { 
           long h3b_0,h5b_0,p1b_0,p2b_0; 
           z->restricted_4(h3b,h5b,p1b,p2b,h3b_0,h5b_0,p1b_0,p2b_0); 
           long h4b_1,h5b_1; 
           z->restricted_2(h4b,h5b,h4b_1,h5b_1); 
           long dim_common=z->get_range(h5b); 
           long dima0_sort=z->get_range(h3b)*z->get_range(p1b)*z->get_range(p2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h3b<h5b) { 
             z->lambda2()->get_block(p2b_0-z->noab()+z->nvab()*(p1b_0-z->noab()+z->nvab()*(h5b_0+z->noab()*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h5b),z->get_range(p1b),z->get_range(p2b),3,2,0,1,+1.0); 
            } 
            else if (h5b<=h3b) { 
             z->lambda2()->get_block(p2b_0-z->noab()+z->nvab()*(p1b_0-z->noab()+z->nvab()*(h3b_0+z->noab()*(h5b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h3b),z->get_range(p1b),z->get_range(p2b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(h5b_1+z->noab()*(h4b_1),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h5b),0,1,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(p2b),z->get_range(p1b),z->get_range(h3b),3,0,2,1,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(p2b),z->get_range(p1b),z->get_range(h3b),0,3,2,1,-1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_7_0(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=0L;h5b<z->noab();++h5b) { 
  long tileoffset; 
  tileoffset=(h5b+z->noab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(h5b)) { 
     if ((z->get_sym(h4b)^z->get_sym(h5b))==z->irrep_f()) { 
      long dimc=z->get_range(h4b)*z->get_range(h5b); 
      long h4b_0,h5b_0; 
      z->restricted_2(h4b,h5b,h4b_0,h5b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h4b)*z->get_range(h5b); 
      long dima0=dim_common*dima0_sort; 
      if (dima0>0L) { 
       double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
       double* k_a0=z->mem()->malloc_local_double(dima0); 
       z->f1()->get_block(h5b_0+(z->nab())*(h4b_0),k_a0); 
       z->sort_indices2(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(h5b),0,1,+1.0); 
       z->mem()->free_local_double(k_a0); 
       double* k_c=z->mem()->malloc_local_double(dimc); 
       z->sort_indices2(k_a0_sort,k_c,z->get_range(h4b),z->get_range(h5b),0,1,-1.0); 
       in[1]->add_block(h5b+z->noab()*(h4b),k_c); 
       z->mem()->free_local_double(k_c); 
       z->mem()->free_local_double(k_a0_sort); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_7(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=0L;h5b<z->noab();++h5b) { 
  if (z->get_spin(h4b)==z->get_spin(h5b)) { 
   if ((z->get_sym(h4b)^z->get_sym(h5b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)!=4L) { 
     in[1]->input_offset(h5b+z->noab()*(h4b),size); 
     size+=z->get_range(h4b)*z->get_range(h5b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_8(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    if (p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_y()^z->irrep_f())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p5b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p5b))))==z->irrep_y()) { 
           long h3b_0,h4b_0,p1b_0,p5b_0; 
           z->restricted_4(h3b,h4b,p1b,p5b,h3b_0,h4b_0,p1b_0,p5b_0); 
           long p5b_1,p2b_1; 
           z->restricted_2(p5b,p2b,p5b_1,p2b_1); 
           long dim_common=z->get_range(p5b); 
           long dima0_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p1b<p5b) { 
             z->lambda2()->get_block(p5b_0-z->noab()+z->nvab()*(p1b_0-z->noab()+z->nvab()*(h4b_0+z->noab()*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p1b),z->get_range(p5b),2,1,0,3,+1.0); 
            } 
            else if (p5b<=p1b) { 
             z->lambda2()->get_block(p1b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(h4b_0+z->noab()*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p5b),z->get_range(p1b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(p2b_1-z->noab()+z->nvab()*(p5b_1-z->noab()),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(p5b),z->get_range(p2b),1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),z->get_range(h3b),3,2,1,0,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),z->get_range(h3b),3,2,0,1,-1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_8_0(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  long tileoffset; 
  tileoffset=(p2b-z->noab()+z->nvab()*(p5b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p2b)!=4L) { 
    if (z->get_spin(p5b)==z->get_spin(p2b)) { 
     if ((z->get_sym(p5b)^z->get_sym(p2b))==z->irrep_f()) { 
      long dimc=z->get_range(p5b)*z->get_range(p2b); 
      long p5b_0,p2b_0; 
      z->restricted_2(p5b,p2b,p5b_0,p2b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(p5b)*z->get_range(p2b); 
      long dima0=dim_common*dima0_sort; 
      if (dima0>0L) { 
       double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
       double* k_a0=z->mem()->malloc_local_double(dima0); 
       z->f1()->get_block(p2b_0+(z->nab())*(p5b_0),k_a0); 
       z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p2b),0,1,+1.0); 
       z->mem()->free_local_double(k_a0); 
       double* k_c=z->mem()->malloc_local_double(dimc); 
       z->sort_indices2(k_a0_sort,k_c,z->get_range(p5b),z->get_range(p2b),0,1,+1.0); 
       in[1]->add_block(p2b-z->noab()+z->nvab()*(p5b-z->noab()),k_c); 
       z->mem()->free_local_double(k_c); 
       z->mem()->free_local_double(k_a0_sort); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_8(){ 
 
long size=0L; 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  if (z->get_spin(p5b)==z->get_spin(p2b)) { 
   if ((z->get_sym(p5b)^z->get_sym(p2b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p2b)!=4L) { 
     in[1]->input_offset(p2b-z->noab()+z->nvab()*(p5b-z->noab()),size); 
     size+=z->get_range(p5b)*z->get_range(p2b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_9(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long p1b=z->noab();p1b<z->noab()+z->nvab();++p1b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    if (p1b<p2b) { 
     tileoffset=(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (p2b<=p1b) { 
     tileoffset=(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p1b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(p2b))))==(z->irrep_y()^z->irrep_f())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
         if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p1b)+z->get_spin(q5b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p1b)^z->get_sym(q5b))))==z->irrep_y()) { 
           long h3b_0,h4b_0,p1b_0,q5b_0; 
           z->restricted_4(h3b,h4b,p1b,q5b,h3b_0,h4b_0,p1b_0,q5b_0); 
           long q5b_1,p2b_1; 
           z->restricted_2(q5b,p2b,q5b_1,p2b_1); 
           long dim_common=z->get_range(q5b); 
           long dima0_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->ly()->get_block(q5b_0-z->noab()-z->nvab()+z->ncab()*(p1b_0-z->noab()+z->nvab()*(h4b_0+z->noab()*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p1b),z->get_range(q5b),2,1,0,3,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(p2b_1-z->noab()+z->nvab()*(q5b_1-z->noab()-z->nvab()),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(q5b),z->get_range(p2b),1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (p2b>=p1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),z->get_range(h3b),3,2,1,0,+1.0); 
         out->add_block(p2b-z->noab()+z->nvab()*(p1b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (p1b>=p2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(p1b),z->get_range(h4b),z->get_range(h3b),3,2,0,1,-1.0); 
         out->add_block(p1b-z->noab()+z->nvab()*(p2b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_0_9_0(){ 
      
for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  long tileoffset; 
  tileoffset=(p2b-z->noab()+z->nvab()*(q5b-z->noab()-z->nvab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(q5b)+z->get_spin(p2b)!=4L) { 
    if (z->get_spin(q5b)==z->get_spin(p2b)) { 
     if ((z->get_sym(q5b)^z->get_sym(p2b))==z->irrep_f()) { 
      long dimc=z->get_range(q5b)*z->get_range(p2b); 
      long q5b_0,p2b_0; 
      z->restricted_2(q5b,p2b,q5b_0,p2b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(q5b)*z->get_range(p2b); 
      long dima0=dim_common*dima0_sort; 
      if (dima0>0L) { 
       double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
       double* k_a0=z->mem()->malloc_local_double(dima0); 
       z->f1()->get_block(p2b_0+(z->nab())*(q5b_0),k_a0); 
       z->sort_indices2(k_a0,k_a0_sort,z->get_range(q5b),z->get_range(p2b),0,1,+1.0); 
       z->mem()->free_local_double(k_a0); 
       double* k_c=z->mem()->malloc_local_double(dimc); 
       z->sort_indices2(k_a0_sort,k_c,z->get_range(q5b),z->get_range(p2b),0,1,+1.0); 
       in[1]->add_block(p2b-z->noab()+z->nvab()*(q5b-z->noab()-z->nvab()),k_c); 
       z->mem()->free_local_double(k_c); 
       z->mem()->free_local_double(k_a0_sort); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_0_9(){ 
 
long size=0L; 
for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  if (z->get_spin(q5b)==z->get_spin(p2b)) { 
   if ((z->get_sym(q5b)^z->get_sym(p2b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(q5b)+z->get_spin(p2b)!=4L) { 
     in[1]->input_offset(p2b-z->noab()+z->nvab()*(q5b-z->noab()-z->nvab()),size); 
     size+=z->get_range(q5b)*z->get_range(p2b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_15(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=0L;h5b<z->noab();++h5b) { 
  long tileoffset; 
  tileoffset=(h5b+z->noab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(h5b)) { 
     if ((z->get_sym(h4b)^z->get_sym(h5b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h4b)*z->get_range(h5b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h7b=0L;h7b<z->noab();++h7b) { 
       for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
        if (z->get_spin(p6b)==z->get_spin(h7b)) { 
         if ((z->get_sym(p6b)^z->get_sym(h7b))==z->irrep_t()) { 
          long p6b_0,h7b_0; 
          z->restricted_2(p6b,h7b,p6b_0,h7b_0); 
          long h4b_1,h7b_1,h5b_1,p6b_1; 
          z->restricted_4(h4b,h7b,h5b,p6b,h4b_1,h7b_1,h5b_1,p6b_1); 
          long dim_common=z->get_range(h7b)*z->get_range(p6b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h4b)*z->get_range(h5b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h7b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h7b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h4b<h7b) { 
            z->v2()->get_block(p6b_1+(z->nab())*(h5b_1+(z->nab())*(h7b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h7b),z->get_range(h5b),z->get_range(p6b),2,0,3,1,+1.0); 
           } 
           else if (h7b<=h4b) { 
            z->v2()->get_block(p6b_1+(z->nab())*(h5b_1+(z->nab())*(h4b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h4b),z->get_range(h5b),z->get_range(p6b),2,1,3,0,-1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h5b),z->get_range(h4b),1,0,-1.0); 
      in[1]->add_block(h5b+z->noab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_16(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long h6b=0L;h6b<z->noab();++h6b) { 
    long tileoffset; 
    if (h5b<h6b) { 
     tileoffset=(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h6b<=h5b) { 
     tileoffset=(h5b+z->noab()*(h6b+z->noab()*(h4b+z->noab()*(h3b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(h6b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h5b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h5b))==z->irrep_t()) { 
           long p7b_0,h5b_0; 
           z->restricted_2(p7b,h5b,p7b_0,h5b_0); 
           long h3b_1,h4b_1,h6b_1,p7b_1; 
           z->restricted_4(h3b,h4b,h6b,p7b,h3b_1,h4b_1,h6b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h5b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h5b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(p7b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h6b),z->get_range(p7b),2,1,0,3,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h6b>=h5b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h6b),z->get_range(h4b),z->get_range(h3b),z->get_range(h5b),2,1,3,0,+1.0); 
         in[1]->add_block(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h5b>=h6b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h6b),z->get_range(h4b),z->get_range(h3b),z->get_range(h5b),2,1,0,3,-1.0); 
         in[1]->add_block(h5b+z->noab()*(h6b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_16_0(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h6b=0L;h6b<z->noab();++h6b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h6b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h6b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h6b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h6b)^z->get_sym(p7b))))==z->irrep_v()) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h6b)*z->get_range(p7b); 
        long h3b_0,h4b_0,h6b_0,p7b_0; 
        z->restricted_4(h3b,h4b,h6b,p7b,h3b_0,h4b_0,h6b_0,p7b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h6b)*z->get_range(p7b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p7b_0+(z->nab())*(h6b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h6b),z->get_range(p7b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h3b),z->get_range(h4b),z->get_range(h6b),z->get_range(p7b),0,1,2,3,-1.0); 
         in[2]->add_block(p7b-z->noab()+z->nvab()*(h6b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_1_16(){ 
 
long size=0L; 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h6b=0L;h6b<z->noab();++h6b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h6b)+z->get_spin(p7b)) { 
     if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h6b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h6b)+z->get_spin(p7b)!=8L) { 
       in[2]->input_offset(p7b-z->noab()+z->nvab()*(h6b+z->noab()*(h4b+z->noab()*(h3b))),size); 
       size+=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h6b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_17(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  long tileoffset; 
  tileoffset=(p2b-z->noab()+z->nvab()*(p5b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p2b)!=4L) { 
    if (z->get_spin(p5b)==z->get_spin(p2b)) { 
     if ((z->get_sym(p5b)^z->get_sym(p2b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p5b)*z->get_range(p2b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h7b=0L;h7b<z->noab();++h7b) { 
       for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
        if (z->get_spin(p6b)==z->get_spin(h7b)) { 
         if ((z->get_sym(p6b)^z->get_sym(h7b))==z->irrep_t()) { 
          long p6b_0,h7b_0; 
          z->restricted_2(p6b,h7b,p6b_0,h7b_0); 
          long h7b_1,p5b_1,p2b_1,p6b_1; 
          z->restricted_4(h7b,p5b,p2b,p6b,h7b_1,p5b_1,p2b_1,p6b_1); 
          long dim_common=z->get_range(h7b)*z->get_range(p6b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(p5b)*z->get_range(p2b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h7b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h7b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (p2b<p6b) { 
            z->v2()->get_block(p6b_1+(z->nab())*(p2b_1+(z->nab())*(p5b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p5b),z->get_range(p2b),z->get_range(p6b),2,1,3,0,+1.0); 
           } 
           else if (p6b<=p2b) { 
            z->v2()->get_block(p2b_1+(z->nab())*(p6b_1+(z->nab())*(p5b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p5b),z->get_range(p6b),z->get_range(p2b),3,1,2,0,-1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p2b),z->get_range(p5b),1,0,-1.0); 
      in[1]->add_block(p2b-z->noab()+z->nvab()*(p5b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_18(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h6b=h4b;h6b<z->noab();++h6b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(h6b+z->noab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h6b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(h6b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(h6b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h4b)*z->get_range(h6b)*z->get_range(h5b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h5b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h5b))==z->irrep_t()) { 
           long p7b_0,h5b_0; 
           z->restricted_2(p7b,h5b,p7b_0,h5b_0); 
           long h4b_1,h6b_1,p2b_1,p7b_1; 
           z->restricted_4(h4b,h6b,p2b,p7b,h4b_1,h6b_1,p2b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(h6b)*z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h5b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h5b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p2b<p7b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p2b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h6b),z->get_range(p2b),z->get_range(p7b),2,1,0,3,+1.0); 
            } 
            else if (p7b<=p2b) { 
             z->lambda2()->get_block(p2b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h6b),z->get_range(p7b),z->get_range(p2b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h6b),z->get_range(h4b),z->get_range(h5b),2,1,3,0,+1.0); 
        in[1]->add_block(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(h6b+z->noab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_19(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(p6b-z->noab()+z->nvab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p6b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(p6b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(p6b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h4b)*z->get_range(p6b)*z->get_range(h5b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h5b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h5b))==z->irrep_t()) { 
           long p7b_0,h5b_0; 
           z->restricted_2(p7b,h5b,p7b_0,h5b_0); 
           long h4b_1,p6b_1,p2b_1,p7b_1; 
           z->restricted_4(h4b,p6b,p2b,p7b,h4b_1,p6b_1,p2b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(p6b)*z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h5b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h5b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p2b<p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p2b_1+(z->nab())*(p6b_1+(z->nab())*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p6b),z->get_range(p2b),z->get_range(p7b),2,1,0,3,+1.0); 
            } 
            else if (p7b<=p2b) { 
             z->v2()->get_block(p2b_1+(z->nab())*(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p6b),z->get_range(p7b),z->get_range(p2b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(p6b),z->get_range(h4b),z->get_range(h5b),2,1,3,0,+1.0); 
        in[1]->add_block(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(p6b-z->noab()+z->nvab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_20(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h5b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(p6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h5b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h5b))==z->irrep_t()) { 
           long p7b_0,h5b_0; 
           z->restricted_2(p7b,h5b,p7b_0,h5b_0); 
           long h3b_1,h4b_1,p6b_1,p7b_1; 
           z->restricted_4(h3b,h4b,p6b,p7b,h3b_1,h4b_1,p6b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h5b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h5b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p6b<p7b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p6b),z->get_range(p7b),2,1,0,3,+1.0); 
            } 
            else if (p7b<=p6b) { 
             z->lambda2()->get_block(p6b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p7b),z->get_range(p6b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(h4b),z->get_range(h3b),z->get_range(h5b),2,1,3,0,+1.0); 
        in[1]->add_block(p6b-z->noab()+z->nvab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_21(){ 
      
for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  long tileoffset; 
  tileoffset=(p2b-z->noab()+z->nvab()*(q5b-z->noab()-z->nvab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(q5b)+z->get_spin(p2b)!=4L) { 
    if (z->get_spin(q5b)==z->get_spin(p2b)) { 
     if ((z->get_sym(q5b)^z->get_sym(p2b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(q5b)*z->get_range(p2b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h7b=0L;h7b<z->noab();++h7b) { 
       for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
        if (z->get_spin(p6b)==z->get_spin(h7b)) { 
         if ((z->get_sym(p6b)^z->get_sym(h7b))==z->irrep_t()) { 
          long p6b_0,h7b_0; 
          z->restricted_2(p6b,h7b,p6b_0,h7b_0); 
          long h7b_1,q5b_1,p2b_1,p6b_1; 
          z->restricted_4(h7b,q5b,p2b,p6b,h7b_1,q5b_1,p2b_1,p6b_1); 
          long dim_common=z->get_range(h7b)*z->get_range(p6b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(q5b)*z->get_range(p2b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h7b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h7b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (p2b<p6b) { 
            z->v2()->get_block(p6b_1+(z->nab())*(p2b_1+(z->nab())*(q5b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(q5b),z->get_range(p2b),z->get_range(p6b),2,1,3,0,+1.0); 
           } 
           else if (p6b<=p2b) { 
            z->v2()->get_block(p2b_1+(z->nab())*(p6b_1+(z->nab())*(q5b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(q5b),z->get_range(p6b),z->get_range(p2b),3,1,2,0,-1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p2b),z->get_range(q5b),1,0,-1.0); 
      in[1]->add_block(p2b-z->noab()+z->nvab()*(q5b-z->noab()-z->nvab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_22(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(q6b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(q6b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(q6b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h4b)*z->get_range(q6b)*z->get_range(h5b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h5b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h5b))==z->irrep_t()) { 
           long p7b_0,h5b_0; 
           z->restricted_2(p7b,h5b,p7b_0,h5b_0); 
           long h4b_1,q6b_1,p2b_1,p7b_1; 
           z->restricted_4(h4b,q6b,p2b,p7b,h4b_1,q6b_1,p2b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(q6b)*z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h5b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h5b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p2b<p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p2b_1+(z->nab())*(q6b_1+(z->nab())*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(q6b),z->get_range(p2b),z->get_range(p7b),2,1,0,3,+1.0); 
            } 
            else if (p7b<=p2b) { 
             z->v2()->get_block(p2b_1+(z->nab())*(p7b_1+(z->nab())*(q6b_1+(z->nab())*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(q6b),z->get_range(p7b),z->get_range(p2b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(q6b),z->get_range(h4b),z->get_range(h5b),2,1,3,0,+1.0); 
        in[1]->add_block(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_23(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
    long tileoffset; 
    tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(h5b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(q6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(q6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(q6b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(q6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h5b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h5b))==z->irrep_t()) { 
           long p7b_0,h5b_0; 
           z->restricted_2(p7b,h5b,p7b_0,h5b_0); 
           long h3b_1,h4b_1,p7b_1,q6b_1; 
           z->restricted_4(h3b,h4b,p7b,q6b,h3b_1,h4b_1,p7b_1,q6b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(q6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h5b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h5b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->ly()->get_block(q6b_1-z->noab()-z->nvab()+z->ncab()*(p7b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p7b),z->get_range(q6b),3,1,0,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(q6b),z->get_range(h4b),z->get_range(h3b),z->get_range(h5b),2,1,3,0,-1.0); 
        in[1]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_24(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=0L;h5b<z->noab();++h5b) { 
  long tileoffset; 
  tileoffset=(h5b+z->noab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(h5b)) { 
     if ((z->get_sym(h4b)^z->get_sym(h5b))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
      long dimc=z->get_range(h4b)*z->get_range(h5b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
       if (z->get_spin(p6b)==z->get_spin(h5b)) { 
        if ((z->get_sym(p6b)^z->get_sym(h5b))==z->irrep_t()) { 
         long p6b_0,h5b_0; 
         z->restricted_2(p6b,h5b,p6b_0,h5b_0); 
         long h4b_1,p6b_1; 
         z->restricted_2(h4b,p6b,h4b_1,p6b_1); 
         long dim_common=z->get_range(p6b); 
         long dima0_sort=z->get_range(h5b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(h4b); 
         long dima1=dim_common*dima1_sort; 
         if (dima0>0L && dima1>0L) { 
          double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
          double* k_a0=z->mem()->malloc_local_double(dima0); 
          z->t1()->get_block(h5b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h5b),1,0,+1.0); 
          z->mem()->free_local_double(k_a0); 
          double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
          double* k_a1=z->mem()->malloc_local_double(dima1); 
          in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h4b_1),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p6b),0,1,+1.0); 
          z->mem()->free_local_double(k_a1); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          z->mem()->free_local_double(k_a1_sort); 
          z->mem()->free_local_double(k_a0_sort); 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h4b),z->get_range(h5b),0,1,+1.0); 
      in[1]->add_block(h5b+z->noab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_1_24(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  if (z->get_spin(h4b)==z->get_spin(p6b)) { 
   if ((z->get_sym(h4b)^z->get_sym(p6b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p6b)!=4L) { 
     in[2]->input_offset(p6b-z->noab()+z->nvab()*(h4b),size); 
     size+=z->get_range(h4b)*z->get_range(p6b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_26(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  long tileoffset; 
  tileoffset=(p2b-z->noab()+z->nvab()*(p5b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p2b)!=4L) { 
    if (z->get_spin(p5b)==z->get_spin(p2b)) { 
     if ((z->get_sym(p5b)^z->get_sym(p2b))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
      long dimc=z->get_range(p5b)*z->get_range(p2b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       if (z->get_spin(p5b)==z->get_spin(h6b)) { 
        if ((z->get_sym(p5b)^z->get_sym(h6b))==z->irrep_t()) { 
         long p5b_0,h6b_0; 
         z->restricted_2(p5b,h6b,p5b_0,h6b_0); 
         long h6b_1,p2b_1; 
         z->restricted_2(h6b,p2b,h6b_1,p2b_1); 
         long dim_common=z->get_range(h6b); 
         long dima0_sort=z->get_range(p5b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(p2b); 
         long dima1=dim_common*dima1_sort; 
         if (dima0>0L && dima1>0L) { 
          double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
          double* k_a0=z->mem()->malloc_local_double(dima0); 
          z->t1()->get_block(h6b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h6b),0,1,+1.0); 
          z->mem()->free_local_double(k_a0); 
          double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
          double* k_a1=z->mem()->malloc_local_double(dima1); 
          in[2]->get_block(p2b_1-z->noab()+z->nvab()*(h6b_1),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(p2b),1,0,+1.0); 
          z->mem()->free_local_double(k_a1); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          z->mem()->free_local_double(k_a1_sort); 
          z->mem()->free_local_double(k_a0_sort); 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p2b),z->get_range(p5b),1,0,+1.0); 
      in[1]->add_block(p2b-z->noab()+z->nvab()*(p5b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_1_26(){ 
 
long size=0L; 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  if (z->get_spin(h6b)==z->get_spin(p2b)) { 
   if ((z->get_sym(h6b)^z->get_sym(p2b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h6b)+z->get_spin(p2b)!=4L) { 
     in[2]->input_offset(p2b-z->noab()+z->nvab()*(h6b),size); 
     size+=z->get_range(h6b)*z->get_range(p2b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_27(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(p6b-z->noab()+z->nvab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p6b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(p6b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(p6b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
        long dimc=z->get_range(h4b)*z->get_range(p6b)*z->get_range(h5b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         if (z->get_spin(p6b)==z->get_spin(h7b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h7b))==z->irrep_t()) { 
           long p6b_0,h7b_0; 
           z->restricted_2(p6b,h7b,p6b_0,h7b_0); 
           long h4b_1,h7b_1,h5b_1,p2b_1; 
           z->restricted_4(h4b,h7b,h5b,p2b,h4b_1,h7b_1,h5b_1,p2b_1); 
           long dim_common=z->get_range(h7b); 
           long dima0_sort=z->get_range(p6b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(h5b)*z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h7b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h7b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h4b<h7b) { 
             in[2]->get_block(p2b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h7b_1+z->noab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h7b),z->get_range(h5b),z->get_range(p2b),3,2,0,1,+1.0); 
            } 
            else if (h7b<=h4b) { 
             in[2]->get_block(p2b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h4b_1+z->noab()*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h4b),z->get_range(h5b),z->get_range(p2b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h5b),z->get_range(h4b),z->get_range(p6b),2,3,1,0,+1.0); 
        in[1]->add_block(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(p6b-z->noab()+z->nvab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_1_27(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h7b=h4b;h7b<z->noab();++h7b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    if (z->get_spin(h4b)+z->get_spin(h7b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(h7b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h7b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
       in[2]->input_offset(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(h7b+z->noab()*(h4b))),size); 
       size+=z->get_range(h4b)*z->get_range(h7b)*z->get_range(h5b)*z->get_range(p2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_28(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long h6b=0L;h6b<z->noab();++h6b) { 
    long tileoffset; 
    if (h5b<h6b) { 
     tileoffset=(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h6b<=h5b) { 
     tileoffset=(h5b+z->noab()*(h6b+z->noab()*(h4b+z->noab()*(h3b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(h6b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h5b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h5b))==z->irrep_t()) { 
           long p7b_0,h5b_0; 
           z->restricted_2(p7b,h5b,p7b_0,h5b_0); 
           long h3b_1,h4b_1,h6b_1,p7b_1; 
           z->restricted_4(h3b,h4b,h6b,p7b,h3b_1,h4b_1,h6b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h5b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h5b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(p7b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h6b),z->get_range(p7b),2,1,0,3,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h6b>=h5b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h6b),z->get_range(h4b),z->get_range(h3b),z->get_range(h5b),2,1,3,0,+1.0); 
         in[1]->add_block(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h5b>=h6b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h6b),z->get_range(h4b),z->get_range(h3b),z->get_range(h5b),2,1,0,3,-1.0); 
         in[1]->add_block(h5b+z->noab()*(h6b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::offset_smith_1_28(){ 
 
long size=0L; 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h6b=0L;h6b<z->noab();++h6b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h6b)+z->get_spin(p7b)) { 
     if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h6b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h6b)+z->get_spin(p7b)!=8L) { 
       in[2]->input_offset(p7b-z->noab()+z->nvab()*(h6b+z->noab()*(h4b+z->noab()*(h3b))),size); 
       size+=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h6b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_29(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=0L;h5b<z->noab();++h5b) { 
  long tileoffset; 
  tileoffset=(h5b+z->noab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(h5b)) { 
     if ((z->get_sym(h4b)^z->get_sym(h5b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h4b)*z->get_range(h5b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
        for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h5b)+z->get_spin(h8b)) { 
          if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h5b)^z->get_sym(h8b))))==z->irrep_t()) { 
           long p6b_0,p7b_0,h5b_0,h8b_0; 
           z->restricted_4(p6b,p7b,h5b,h8b,p6b_0,p7b_0,h5b_0,h8b_0); 
           long h4b_1,h8b_1,p6b_1,p7b_1; 
           z->restricted_4(h4b,h8b,p6b,p7b,h4b_1,h8b_1,p6b_1,p7b_1); 
           long dim_common=z->get_range(h8b)*z->get_range(p6b)*z->get_range(p7b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h5b<h8b) { 
             z->t2()->get_block(h8b_0+z->noab()*(h5b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h5b),z->get_range(h8b),2,1,0,3,+1.0); 
            } 
            else if (h8b<=h5b) { 
             z->t2()->get_block(h5b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h8b),z->get_range(h5b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h4b<h8b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h8b_1+(z->nab())*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h8b),z->get_range(p6b),z->get_range(p7b),0,3,2,1,+1.0); 
            } 
            else if (h8b<=h4b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h4b_1+(z->nab())*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h4b),z->get_range(p6b),z->get_range(p7b),1,3,2,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (p6b==p7b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h4b),z->get_range(h5b),0,1,-0.5/0.5); 
      in[1]->add_block(h5b+z->noab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_30(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long h6b=h5b;h6b<z->noab();++h6b) { 
    long tileoffset; 
    tileoffset=(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(h6b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
          if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
           if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h5b)^z->get_sym(h6b))))==z->irrep_t()) { 
            long p7b_0,p8b_0,h5b_0,h6b_0; 
            z->restricted_4(p7b,p8b,h5b,h6b,p7b_0,p8b_0,h5b_0,h6b_0); 
            long h3b_1,h4b_1,p7b_1,p8b_1; 
            z->restricted_4(h3b,h4b,p7b,p8b,h3b_1,h4b_1,p7b_1,p8b_1); 
            long dim_common=z->get_range(p7b)*z->get_range(p8b); 
            long dima0_sort=z->get_range(h5b)*z->get_range(h6b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->t2()->get_block(h6b_0+z->noab()*(h5b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h5b),z->get_range(h6b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(h4b_1+(z->nab())*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p7b),z->get_range(p8b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (p7b==p8b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h6b),z->get_range(h5b),1,0,3,2,+0.5/0.5); 
        in[1]->add_block(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_31(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  long tileoffset; 
  tileoffset=(p2b-z->noab()+z->nvab()*(p5b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p2b)!=4L) { 
    if (z->get_spin(p5b)==z->get_spin(p2b)) { 
     if ((z->get_sym(p5b)^z->get_sym(p2b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p5b)*z->get_range(p2b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h7b=0L;h7b<z->noab();++h7b) { 
       for (long h8b=h7b;h8b<z->noab();++h8b) { 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h7b)+z->get_spin(h8b)) { 
          if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h7b)^z->get_sym(h8b))))==z->irrep_t()) { 
           long p5b_0,p6b_0,h7b_0,h8b_0; 
           z->restricted_4(p5b,p6b,h7b,h8b,p5b_0,p6b_0,h7b_0,h8b_0); 
           long h7b_1,h8b_1,p2b_1,p6b_1; 
           z->restricted_4(h7b,h8b,p2b,p6b,h7b_1,h8b_1,p2b_1,p6b_1); 
           long dim_common=z->get_range(h7b)*z->get_range(h8b)*z->get_range(p6b); 
           long dima0_sort=z->get_range(p5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p5b<p6b) { 
             z->t2()->get_block(h8b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h7b),z->get_range(h8b),0,1,3,2,+1.0); 
            } 
            else if (p6b<=p5b) { 
             z->t2()->get_block(h8b_0+z->noab()*(h7b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p5b),z->get_range(h7b),z->get_range(h8b),1,0,3,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p2b<p6b) { 
             z->v2()->get_block(p6b_1+(z->nab())*(p2b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p2b),z->get_range(p6b),2,3,1,0,+1.0); 
            } 
            else if (p6b<=p2b) { 
             z->v2()->get_block(p2b_1+(z->nab())*(p6b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p6b),z->get_range(p2b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h7b==h8b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p2b),z->get_range(p5b),1,0,-0.5/0.5); 
      in[1]->add_block(p2b-z->noab()+z->nvab()*(p5b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_32(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(p6b-z->noab()+z->nvab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p6b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(p6b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(p6b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h4b)*z->get_range(p6b)*z->get_range(h5b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h8b=0L;h8b<z->noab();++h8b) { 
         for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
          if (z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h5b)+z->get_spin(h8b)) { 
           if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h5b)^z->get_sym(h8b))))==z->irrep_t()) { 
            long p6b_0,p7b_0,h5b_0,h8b_0; 
            z->restricted_4(p6b,p7b,h5b,h8b,p6b_0,p7b_0,h5b_0,h8b_0); 
            long h4b_1,h8b_1,p2b_1,p7b_1; 
            z->restricted_4(h4b,h8b,p2b,p7b,h4b_1,h8b_1,p2b_1,p7b_1); 
            long dim_common=z->get_range(h8b)*z->get_range(p7b); 
            long dima0_sort=z->get_range(p6b)*z->get_range(h5b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h4b)*z->get_range(p2b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (p6b<p7b && h5b<h8b) { 
              z->t2()->get_block(h8b_0+z->noab()*(h5b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h5b),z->get_range(h8b),2,0,1,3,+1.0); 
             } 
             else if (p6b<p7b && h8b<=h5b) { 
              z->t2()->get_block(h5b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h8b),z->get_range(h5b),3,0,1,2,-1.0); 
             } 
             else if (p7b<=p6b && h5b<h8b) { 
              z->t2()->get_block(h8b_0+z->noab()*(h5b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p6b),z->get_range(h5b),z->get_range(h8b),2,1,0,3,-1.0); 
             } 
             else if (p7b<=p6b && h8b<=h5b) { 
              z->t2()->get_block(h5b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p6b),z->get_range(h8b),z->get_range(h5b),3,1,0,2,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h4b<h8b && p2b<p7b) { 
              z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p2b_1-z->noab()+z->nvab()*(h8b_1+z->noab()*(h4b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h8b),z->get_range(p2b),z->get_range(p7b),2,0,3,1,+1.0); 
             } 
             else if (h4b<h8b && p7b<=p2b) { 
              z->lambda2()->get_block(p2b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h8b_1+z->noab()*(h4b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h8b),z->get_range(p7b),z->get_range(p2b),3,0,2,1,-1.0); 
             } 
             else if (h8b<=h4b && p2b<p7b) { 
              z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p2b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h8b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h4b),z->get_range(p2b),z->get_range(p7b),2,1,3,0,-1.0); 
             } 
             else if (h8b<=h4b && p7b<=p2b) { 
              z->lambda2()->get_block(p2b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h8b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h4b),z->get_range(p7b),z->get_range(p2b),3,1,2,0,+1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(h5b),z->get_range(p6b),1,3,2,0,+1.0); 
        in[1]->add_block(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(p6b-z->noab()+z->nvab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_33(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  long tileoffset; 
  tileoffset=(p2b-z->noab()+z->nvab()*(p5b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p2b)!=4L) { 
    if (z->get_spin(p5b)==z->get_spin(p2b)) { 
     if ((z->get_sym(p5b)^z->get_sym(p2b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(p5b)*z->get_range(p2b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h7b=0L;h7b<z->noab();++h7b) { 
       for (long h8b=h7b;h8b<z->noab();++h8b) { 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h7b)+z->get_spin(h8b)) { 
          if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h7b)^z->get_sym(h8b))))==z->irrep_t()) { 
           long p5b_0,p6b_0,h7b_0,h8b_0; 
           z->restricted_4(p5b,p6b,h7b,h8b,p5b_0,p6b_0,h7b_0,h8b_0); 
           long h7b_1,h8b_1,p2b_1,p6b_1; 
           z->restricted_4(h7b,h8b,p2b,p6b,h7b_1,h8b_1,p2b_1,p6b_1); 
           long dim_common=z->get_range(h7b)*z->get_range(h8b)*z->get_range(p6b); 
           long dima0_sort=z->get_range(p5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p5b<p6b) { 
             z->t2()->get_block(h8b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h7b),z->get_range(h8b),0,1,3,2,+1.0); 
            } 
            else if (p6b<=p5b) { 
             z->t2()->get_block(h8b_0+z->noab()*(h7b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p5b),z->get_range(h7b),z->get_range(h8b),1,0,3,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p2b<p6b) { 
             z->lambda2()->get_block(p6b_1-z->noab()+z->nvab()*(p2b_1-z->noab()+z->nvab()*(h8b_1+z->noab()*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p2b),z->get_range(p6b),2,3,1,0,+1.0); 
            } 
            else if (p6b<=p2b) { 
             z->lambda2()->get_block(p2b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h8b_1+z->noab()*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p6b),z->get_range(p2b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h7b==h8b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p2b),z->get_range(p5b),1,0,-0.5/0.5); 
      in[1]->add_block(p2b-z->noab()+z->nvab()*(p5b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_34(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long h6b=h5b;h6b<z->noab();++h6b) { 
    long tileoffset; 
    tileoffset=(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(h6b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
          if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
           if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h5b)^z->get_sym(h6b))))==z->irrep_t()) { 
            long p7b_0,p8b_0,h5b_0,h6b_0; 
            z->restricted_4(p7b,p8b,h5b,h6b,p7b_0,p8b_0,h5b_0,h6b_0); 
            long h3b_1,h4b_1,p7b_1,p8b_1; 
            z->restricted_4(h3b,h4b,p7b,p8b,h3b_1,h4b_1,p7b_1,p8b_1); 
            long dim_common=z->get_range(p7b)*z->get_range(p8b); 
            long dima0_sort=z->get_range(h5b)*z->get_range(h6b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->t2()->get_block(h6b_0+z->noab()*(h5b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h5b),z->get_range(h6b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->lambda2()->get_block(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p7b),z->get_range(p8b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (p7b==p8b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h6b),z->get_range(h5b),1,0,3,2,+0.5/0.5); 
        in[1]->add_block(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_35(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=0L;h5b<z->noab();++h5b) { 
  long tileoffset; 
  tileoffset=(h5b+z->noab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(h5b)) { 
     if ((z->get_sym(h4b)^z->get_sym(h5b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(h4b)*z->get_range(h5b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
        for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h5b)+z->get_spin(h8b)) { 
          if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h5b)^z->get_sym(h8b))))==z->irrep_t()) { 
           long p6b_0,p7b_0,h5b_0,h8b_0; 
           z->restricted_4(p6b,p7b,h5b,h8b,p6b_0,p7b_0,h5b_0,h8b_0); 
           long h4b_1,h8b_1,p6b_1,p7b_1; 
           z->restricted_4(h4b,h8b,p6b,p7b,h4b_1,h8b_1,p6b_1,p7b_1); 
           long dim_common=z->get_range(h8b)*z->get_range(p6b)*z->get_range(p7b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h5b<h8b) { 
             z->t2()->get_block(h8b_0+z->noab()*(h5b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h5b),z->get_range(h8b),2,1,0,3,+1.0); 
            } 
            else if (h8b<=h5b) { 
             z->t2()->get_block(h5b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h8b),z->get_range(h5b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h4b<h8b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h8b_1+z->noab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h8b),z->get_range(p6b),z->get_range(p7b),0,3,2,1,+1.0); 
            } 
            else if (h8b<=h4b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h4b),z->get_range(p6b),z->get_range(p7b),1,3,2,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (p6b==p7b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h4b),z->get_range(h5b),0,1,-0.5/0.5); 
      in[1]->add_block(h5b+z->noab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_36(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=0L;h5b<z->noab();++h5b) { 
  long tileoffset; 
  tileoffset=(h5b+z->noab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(h5b)) { 
     if ((z->get_sym(h4b)^z->get_sym(h5b))==(z->irrep_t()^z->irrep_e())) { 
      long dimc=z->get_range(h4b)*z->get_range(h5b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long h7b=h6b;h7b<z->noab();++h7b) { 
        for (long h8b=0L;h8b<z->noab();++h8b) { 
         if (z->get_spin(h6b)+z->get_spin(h7b)==z->get_spin(h5b)+z->get_spin(h8b)) { 
          if ((z->get_sym(h6b)^(z->get_sym(h7b)^(z->get_sym(h5b)^z->get_sym(h8b))))==z->irrep_t()) { 
           long h6b_0,h7b_0,h5b_0,h8b_0; 
           z->restricted_4(h6b,h7b,h5b,h8b,h6b_0,h7b_0,h5b_0,h8b_0); 
           long h4b_1,h8b_1,h6b_1,h7b_1; 
           z->restricted_4(h4b,h8b,h6b,h7b,h4b_1,h8b_1,h6b_1,h7b_1); 
           long dim_common=z->get_range(h6b)*z->get_range(h7b)*z->get_range(h8b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h5b<h8b) { 
             z->gt2()->get_block(h8b_0+z->noab()*(h5b_0+z->noab()*(h7b_0+z->noab()*(h6b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(h5b),z->get_range(h8b),2,3,1,0,+1.0); 
            } 
            else if (h8b<=h5b) { 
             z->gt2()->get_block(h5b_0+z->noab()*(h8b_0+z->noab()*(h7b_0+z->noab()*(h6b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(h8b),z->get_range(h5b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h4b<h8b) { 
             z->vr2()->get_block(h7b_1+z->noab()*(h6b_1+z->noab()*(h8b_1+(z->nab())*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h8b),z->get_range(h6b),z->get_range(h7b),0,1,3,2,+1.0); 
            } 
            else if (h8b<=h4b) { 
             z->vr2()->get_block(h7b_1+z->noab()*(h6b_1+z->noab()*(h4b_1+(z->nab())*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h4b),z->get_range(h6b),z->get_range(h7b),1,0,3,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h6b==h7b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h4b),z->get_range(h5b),0,1,-0.5/0.5); 
      in[1]->add_block(h5b+z->noab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_37(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long h6b=h5b;h6b<z->noab();++h6b) { 
    long tileoffset; 
    tileoffset=(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(h6b))))==(z->irrep_t()^z->irrep_e())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         for (long h8b=h7b;h8b<z->noab();++h8b) { 
          if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
           if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h5b)^z->get_sym(h6b))))==z->irrep_t()) { 
            long h7b_0,h8b_0,h5b_0,h6b_0; 
            z->restricted_4(h7b,h8b,h5b,h6b,h7b_0,h8b_0,h5b_0,h6b_0); 
            long h3b_1,h4b_1,h7b_1,h8b_1; 
            z->restricted_4(h3b,h4b,h7b,h8b,h3b_1,h4b_1,h7b_1,h8b_1); 
            long dim_common=z->get_range(h7b)*z->get_range(h8b); 
            long dima0_sort=z->get_range(h5b)*z->get_range(h6b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->gt2()->get_block(h6b_0+z->noab()*(h5b_0+z->noab()*(h8b_0+z->noab()*(h7b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h5b),z->get_range(h6b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->vr2()->get_block(h8b_1+z->noab()*(h7b_1+z->noab()*(h4b_1+(z->nab())*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h7b),z->get_range(h8b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (h7b==h8b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h6b),z->get_range(h5b),1,0,3,2,+0.5/0.5); 
        in[1]->add_block(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_38(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  long tileoffset; 
  tileoffset=(p2b-z->noab()+z->nvab()*(p5b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p2b)!=4L) { 
    if (z->get_spin(p5b)==z->get_spin(p2b)) { 
     if ((z->get_sym(p5b)^z->get_sym(p2b))==(z->irrep_e()^z->irrep_v())) { 
      long dimc=z->get_range(p5b)*z->get_range(p2b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h7b=0L;h7b<z->noab();++h7b) { 
       for (long h8b=h7b;h8b<z->noab();++h8b) { 
        for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
         if (z->get_spin(p5b)+z->get_spin(q6b)==z->get_spin(h7b)+z->get_spin(h8b)) { 
          if ((z->get_sym(p5b)^(z->get_sym(q6b)^(z->get_sym(h7b)^z->get_sym(h8b))))==z->irrep_e()) { 
           long p5b_0,q6b_0,h7b_0,h8b_0; 
           z->restricted_4(p5b,q6b,h7b,h8b,p5b_0,q6b_0,h7b_0,h8b_0); 
           long h7b_1,h8b_1,p2b_1,q6b_1; 
           z->restricted_4(h7b,h8b,p2b,q6b,h7b_1,h8b_1,p2b_1,q6b_1); 
           long dim_common=z->get_range(h7b)*z->get_range(h8b)*z->get_range(q6b); 
           long dima0_sort=z->get_range(p5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->qy()->get_block(h8b_0+z->noab()*(h7b_0+z->noab()*(q6b_0-z->noab()-z->nvab()+z->ncab()*(p5b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(q6b),z->get_range(h7b),z->get_range(h8b),0,1,3,2,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->v2()->get_block(q6b_1+(z->nab())*(p2b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p2b),z->get_range(q6b),2,3,1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h7b==h8b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p2b),z->get_range(p5b),1,0,-0.5/0.5); 
      in[1]->add_block(p2b-z->noab()+z->nvab()*(p5b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_39(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(p6b-z->noab()+z->nvab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p6b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(p6b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(p6b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_e()^z->irrep_v())) { 
        long dimc=z->get_range(h4b)*z->get_range(p6b)*z->get_range(h5b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h8b=0L;h8b<z->noab();++h8b) { 
         for (long q7b=z->noab()+z->nvab();q7b<z->nab();++q7b) { 
          if (z->get_spin(p6b)+z->get_spin(q7b)==z->get_spin(h5b)+z->get_spin(h8b)) { 
           if ((z->get_sym(p6b)^(z->get_sym(q7b)^(z->get_sym(h5b)^z->get_sym(h8b))))==z->irrep_e()) { 
            long p6b_0,q7b_0,h5b_0,h8b_0; 
            z->restricted_4(p6b,q7b,h5b,h8b,p6b_0,q7b_0,h5b_0,h8b_0); 
            long h4b_1,h8b_1,p2b_1,q7b_1; 
            z->restricted_4(h4b,h8b,p2b,q7b,h4b_1,h8b_1,p2b_1,q7b_1); 
            long dim_common=z->get_range(h8b)*z->get_range(q7b); 
            long dima0_sort=z->get_range(p6b)*z->get_range(h5b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h4b)*z->get_range(p2b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (h5b<h8b) { 
              z->qy()->get_block(h8b_0+z->noab()*(h5b_0+z->noab()*(q7b_0-z->noab()-z->nvab()+z->ncab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(q7b),z->get_range(h5b),z->get_range(h8b),2,0,1,3,+1.0); 
             } 
             else if (h8b<=h5b) { 
              z->qy()->get_block(h5b_0+z->noab()*(h8b_0+z->noab()*(q7b_0-z->noab()-z->nvab()+z->ncab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(q7b),z->get_range(h8b),z->get_range(h5b),3,0,1,2,-1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h4b<h8b) { 
              z->v2()->get_block(q7b_1+(z->nab())*(p2b_1+(z->nab())*(h8b_1+(z->nab())*(h4b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h8b),z->get_range(p2b),z->get_range(q7b),2,0,3,1,+1.0); 
             } 
             else if (h8b<=h4b) { 
              z->v2()->get_block(q7b_1+(z->nab())*(p2b_1+(z->nab())*(h4b_1+(z->nab())*(h8b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h4b),z->get_range(p2b),z->get_range(q7b),2,1,3,0,-1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(h5b),z->get_range(p6b),1,3,2,0,+1.0); 
        in[1]->add_block(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(p6b-z->noab()+z->nvab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_4(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  long tileoffset; 
  tileoffset=(p2b-z->noab()+z->nvab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p2b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(p2b)) { 
     if ((z->get_sym(h4b)^z->get_sym(p2b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h4b)*z->get_range(p2b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
        if (z->get_spin(p5b)==z->get_spin(h6b)) { 
         if ((z->get_sym(p5b)^z->get_sym(h6b))==z->irrep_t()) { 
          long p5b_0,h6b_0; 
          z->restricted_2(p5b,h6b,p5b_0,h6b_0); 
          long h4b_1,h6b_1,p2b_1,p5b_1; 
          z->restricted_4(h4b,h6b,p2b,p5b,h4b_1,h6b_1,p2b_1,p5b_1); 
          long dim_common=z->get_range(h6b)*z->get_range(p5b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h4b)*z->get_range(p2b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h6b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h6b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h4b<h6b && p2b<p5b) { 
            z->v2()->get_block(p5b_1+(z->nab())*(p2b_1+(z->nab())*(h6b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h6b),z->get_range(p2b),z->get_range(p5b),2,0,3,1,+1.0); 
           } 
           else if (h4b<h6b && p5b<=p2b) { 
            z->v2()->get_block(p2b_1+(z->nab())*(p5b_1+(z->nab())*(h6b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h6b),z->get_range(p5b),z->get_range(p2b),3,0,2,1,-1.0); 
           } 
           else if (h6b<=h4b && p2b<p5b) { 
            z->v2()->get_block(p5b_1+(z->nab())*(p2b_1+(z->nab())*(h4b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h4b),z->get_range(p2b),z->get_range(p5b),2,1,3,0,-1.0); 
           } 
           else if (h6b<=h4b && p5b<=p2b) { 
            z->v2()->get_block(p2b_1+(z->nab())*(p5b_1+(z->nab())*(h4b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h4b),z->get_range(p5b),z->get_range(p2b),3,1,2,0,+1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),1,0,+1.0); 
      in[1]->add_block(p2b-z->noab()+z->nvab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_40(){ 
      
for (long q5b=z->noab()+z->nvab();q5b<z->nab();++q5b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  long tileoffset; 
  tileoffset=(p2b-z->noab()+z->nvab()*(q5b-z->noab()-z->nvab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(q5b)+z->get_spin(p2b)!=4L) { 
    if (z->get_spin(q5b)==z->get_spin(p2b)) { 
     if ((z->get_sym(q5b)^z->get_sym(p2b))==(z->irrep_y()^z->irrep_e())) { 
      long dimc=z->get_range(q5b)*z->get_range(p2b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long h7b=h6b;h7b<z->noab();++h7b) { 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(h6b)+z->get_spin(h7b)==z->get_spin(p2b)+z->get_spin(p8b)) { 
          if ((z->get_sym(h6b)^(z->get_sym(h7b)^(z->get_sym(p2b)^z->get_sym(p8b))))==z->irrep_y()) { 
           long h6b_0,h7b_0,p2b_0,p8b_0; 
           z->restricted_4(h6b,h7b,p2b,p8b,h6b_0,h7b_0,p2b_0,p8b_0); 
           long p8b_1,q5b_1,h6b_1,h7b_1; 
           z->restricted_4(p8b,q5b,h6b,h7b,p8b_1,q5b_1,h6b_1,h7b_1); 
           long dim_common=z->get_range(h6b)*z->get_range(h7b)*z->get_range(p8b); 
           long dima0_sort=z->get_range(p2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(q5b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p2b<p8b) { 
             z->lambda2()->get_block(p8b_0-z->noab()+z->nvab()*(p2b_0-z->noab()+z->nvab()*(h7b_0+z->noab()*(h6b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(p2b),z->get_range(p8b),2,3,1,0,+1.0); 
            } 
            else if (p8b<=p2b) { 
             z->lambda2()->get_block(p2b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(h7b_0+z->noab()*(h6b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(p8b),z->get_range(p2b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->qy()->get_block(h7b_1+z->noab()*(h6b_1+z->noab()*(q5b_1-z->noab()-z->nvab()+z->ncab()*(p8b_1-z->noab()))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p8b),z->get_range(q5b),z->get_range(h6b),z->get_range(h7b),1,0,3,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h6b==h7b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(q5b),z->get_range(p2b),0,1,+0.5/0.5); 
      in[1]->add_block(p2b-z->noab()+z->nvab()*(q5b-z->noab()-z->nvab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_5(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p6b)==z->get_spin(h5b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h5b))==z->irrep_t()) { 
           long p6b_0,h5b_0; 
           z->restricted_2(p6b,h5b,p6b_0,h5b_0); 
           long h3b_1,h4b_1,p2b_1,p6b_1; 
           z->restricted_4(h3b,h4b,p2b,p6b,h3b_1,h4b_1,p2b_1,p6b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h5b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h5b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p2b<p6b) { 
             z->v2()->get_block(p6b_1+(z->nab())*(p2b_1+(z->nab())*(h4b_1+(z->nab())*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p2b),z->get_range(p6b),2,1,0,3,+1.0); 
            } 
            else if (p6b<=p2b) { 
             z->v2()->get_block(p2b_1+(z->nab())*(p6b_1+(z->nab())*(h4b_1+(z->nab())*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p6b),z->get_range(p2b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h4b),z->get_range(h3b),z->get_range(h5b),2,1,3,0,+1.0); 
        in[1]->add_block(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_1_6(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=0L;h5b<z->noab();++h5b) { 
  long tileoffset; 
  tileoffset=(h5b+z->noab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(h5b)) { 
     if ((z->get_sym(h4b)^z->get_sym(h5b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(h4b)*z->get_range(h5b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
       if (z->get_spin(p6b)==z->get_spin(h5b)) { 
        if ((z->get_sym(p6b)^z->get_sym(h5b))==z->irrep_t()) { 
         long p6b_0,h5b_0; 
         z->restricted_2(p6b,h5b,p6b_0,h5b_0); 
         long h4b_1,p6b_1; 
         z->restricted_2(h4b,p6b,h4b_1,p6b_1); 
         long dim_common=z->get_range(p6b); 
         long dima0_sort=z->get_range(h5b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(h4b); 
         long dima1=dim_common*dima1_sort; 
         if (dima0>0L && dima1>0L) { 
          double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
          double* k_a0=z->mem()->malloc_local_double(dima0); 
          z->t1()->get_block(h5b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h5b),1,0,+1.0); 
          z->mem()->free_local_double(k_a0); 
          double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
          double* k_a1=z->mem()->malloc_local_double(dima1); 
          z->lambda1()->get_block(p6b_1-z->noab()+z->nvab()*(h4b_1),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p6b),0,1,+1.0); 
          z->mem()->free_local_double(k_a1); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          z->mem()->free_local_double(k_a1_sort); 
          z->mem()->free_local_double(k_a0_sort); 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h4b),z->get_range(h5b),0,1,-1.0); 
      in[1]->add_block(h5b+z->noab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_2_24(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  long tileoffset; 
  tileoffset=(p6b-z->noab()+z->nvab()*(h4b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p6b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(p6b)) { 
     if ((z->get_sym(h4b)^z->get_sym(p6b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h4b)*z->get_range(p6b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
        if (z->get_spin(p7b)==z->get_spin(h8b)) { 
         if ((z->get_sym(p7b)^z->get_sym(h8b))==z->irrep_t()) { 
          long p7b_0,h8b_0; 
          z->restricted_2(p7b,h8b,p7b_0,h8b_0); 
          long h4b_1,h8b_1,p6b_1,p7b_1; 
          z->restricted_4(h4b,h8b,p6b,p7b,h4b_1,h8b_1,p6b_1,p7b_1); 
          long dim_common=z->get_range(h8b)*z->get_range(p7b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h4b)*z->get_range(p6b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h8b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h8b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h4b<h8b && p6b<p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h8b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h8b),z->get_range(p6b),z->get_range(p7b),2,0,3,1,+1.0); 
           } 
           else if (h4b<h8b && p7b<=p6b) { 
            z->v2()->get_block(p6b_1+(z->nab())*(p7b_1+(z->nab())*(h8b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h8b),z->get_range(p7b),z->get_range(p6b),3,0,2,1,-1.0); 
           } 
           else if (h8b<=h4b && p6b<p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h4b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h4b),z->get_range(p6b),z->get_range(p7b),2,1,3,0,-1.0); 
           } 
           else if (h8b<=h4b && p7b<=p6b) { 
            z->v2()->get_block(p6b_1+(z->nab())*(p7b_1+(z->nab())*(h4b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h4b),z->get_range(p7b),z->get_range(p6b),3,1,2,0,+1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p6b),z->get_range(h4b),1,0,-1.0); 
      in[2]->add_block(p6b-z->noab()+z->nvab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_2_25(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h6b=0L;h6b<z->noab();++h6b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h6b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h6b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h6b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h6b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h6b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h6b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h6b))==z->irrep_t()) { 
           long p8b_0,h6b_0; 
           z->restricted_2(p8b,h6b,p8b_0,h6b_0); 
           long h3b_1,h4b_1,p7b_1,p8b_1; 
           z->restricted_4(h3b,h4b,p7b,p8b,h3b_1,h4b_1,p7b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h6b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h6b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h6b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p7b<p8b) { 
             z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(h4b_1+(z->nab())*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p7b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p8b_1+(z->nab())*(h4b_1+(z->nab())*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(h6b),2,1,3,0,+0.5); 
        in[2]->add_block(p7b-z->noab()+z->nvab()*(h6b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_2_26(){ 
      
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
  long tileoffset; 
  tileoffset=(p2b-z->noab()+z->nvab()*(h6b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h6b)+z->get_spin(p2b)!=4L) { 
    if (z->get_spin(h6b)==z->get_spin(p2b)) { 
     if ((z->get_sym(h6b)^z->get_sym(p2b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h6b)*z->get_range(p2b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
        if (z->get_spin(p7b)==z->get_spin(h8b)) { 
         if ((z->get_sym(p7b)^z->get_sym(h8b))==z->irrep_t()) { 
          long p7b_0,h8b_0; 
          z->restricted_2(p7b,h8b,p7b_0,h8b_0); 
          long h6b_1,h8b_1,p2b_1,p7b_1; 
          z->restricted_4(h6b,h8b,p2b,p7b,h6b_1,h8b_1,p2b_1,p7b_1); 
          long dim_common=z->get_range(h8b)*z->get_range(p7b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h6b)*z->get_range(p2b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h8b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h8b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h6b<h8b && p2b<p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p2b_1+(z->nab())*(h8b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h8b),z->get_range(p2b),z->get_range(p7b),2,0,3,1,+1.0); 
           } 
           else if (h6b<h8b && p7b<=p2b) { 
            z->v2()->get_block(p2b_1+(z->nab())*(p7b_1+(z->nab())*(h8b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h8b),z->get_range(p7b),z->get_range(p2b),3,0,2,1,-1.0); 
           } 
           else if (h8b<=h6b && p2b<p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p2b_1+(z->nab())*(h6b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h6b),z->get_range(p2b),z->get_range(p7b),2,1,3,0,-1.0); 
           } 
           else if (h8b<=h6b && p7b<=p2b) { 
            z->v2()->get_block(p2b_1+(z->nab())*(p7b_1+(z->nab())*(h6b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h6b),z->get_range(p7b),z->get_range(p2b),3,1,2,0,+1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p2b),z->get_range(h6b),1,0,-1.0); 
      in[2]->add_block(p2b-z->noab()+z->nvab()*(h6b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_2_27(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h7b=h4b;h7b<z->noab();++h7b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
    long tileoffset; 
    tileoffset=(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(h7b+z->noab()*(h4b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h7b)+z->get_spin(h5b)+z->get_spin(p2b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(h7b)==z->get_spin(h5b)+z->get_spin(p2b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(h7b)^(z->get_sym(h5b)^z->get_sym(p2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h4b)*z->get_range(h7b)*z->get_range(h5b)*z->get_range(p2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h5b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h5b))==z->irrep_t()) { 
           long p8b_0,h5b_0; 
           z->restricted_2(p8b,h5b,p8b_0,h5b_0); 
           long h4b_1,h7b_1,p2b_1,p8b_1; 
           z->restricted_4(h4b,h7b,p2b,p8b,h4b_1,h7b_1,p2b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(h7b)*z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h5b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h5b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p2b<p8b) { 
             z->v2()->get_block(p8b_1+(z->nab())*(p2b_1+(z->nab())*(h7b_1+(z->nab())*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h7b),z->get_range(p2b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p2b) { 
             z->v2()->get_block(p2b_1+(z->nab())*(p8b_1+(z->nab())*(h7b_1+(z->nab())*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h7b),z->get_range(p8b),z->get_range(p2b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p2b),z->get_range(h7b),z->get_range(h4b),z->get_range(h5b),2,1,3,0,-1.0); 
        in[2]->add_block(p2b-z->noab()+z->nvab()*(h5b+z->noab()*(h7b+z->noab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void LAMBDA_CCSDPR12_T2::smith_2_28(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h6b=0L;h6b<z->noab();++h6b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h6b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h6b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h6b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h6b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h6b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h6b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h6b))==z->irrep_t()) { 
           long p8b_0,h6b_0; 
           z->restricted_2(p8b,h6b,p8b_0,h6b_0); 
           long h3b_1,h4b_1,p7b_1,p8b_1; 
           z->restricted_4(h3b,h4b,p7b,p8b,h3b_1,h4b_1,p7b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h6b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h6b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h6b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p7b<p8b) { 
             z->lambda2()->get_block(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p7b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p7b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p8b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(h6b),2,1,3,0,+0.5); 
        in[2]->add_block(p7b-z->noab()+z->nvab()*(h6b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
