"use strict";

var helpers = require("../../helpers/helpers");

exports["Australia/Yancowinna"] = {

	"guess:by:offset" : helpers.makeTestGuess("Australia/Yancowinna", { offset: true, expect: "Australia/Adelaide" }),

	"guess:by:abbr" : helpers.makeTestGuess("Australia/Yancowinna", { abbr: true, expect: "Australia/Adelaide" }),

	"1896" : helpers.makeTestYear("Australia/Yancowinna", [
		["1896-08-22T13:59:59+00:00", "23:59:59", "AEST", -600],
		["1896-08-22T14:00:00+00:00", "23:00:00", "ACST", -540]
	]),

	"1899" : helpers.makeTestYear("Australia/Yancowinna", [
		["1899-04-30T14:59:59+00:00", "23:59:59", "ACST", -540],
		["1899-04-30T15:00:00+00:00", "00:30:00", "ACST", -570]
	]),

	"1916" : helpers.makeTestYear("Australia/Yancowinna", [
		["1916-12-31T14:30:59+00:00", "00:00:59", "ACST", -570],
		["1916-12-31T14:31:00+00:00", "01:01:00", "ACDT", -630]
	]),

	"1917" : helpers.makeTestYear("Australia/Yancowinna", [
		["1917-03-24T15:29:59+00:00", "01:59:59", "ACDT", -630],
		["1917-03-24T15:30:00+00:00", "01:00:00", "ACST", -570]
	]),

	"1941" : helpers.makeTestYear("Australia/Yancowinna", [
		["1941-12-31T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1941-12-31T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1942" : helpers.makeTestYear("Australia/Yancowinna", [
		["1942-03-28T15:29:59+00:00", "01:59:59", "ACDT", -630],
		["1942-03-28T15:30:00+00:00", "01:00:00", "ACST", -570],
		["1942-09-26T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1942-09-26T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1943" : helpers.makeTestYear("Australia/Yancowinna", [
		["1943-03-27T15:29:59+00:00", "01:59:59", "ACDT", -630],
		["1943-03-27T15:30:00+00:00", "01:00:00", "ACST", -570],
		["1943-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1943-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1944" : helpers.makeTestYear("Australia/Yancowinna", [
		["1944-03-25T15:29:59+00:00", "01:59:59", "ACDT", -630],
		["1944-03-25T15:30:00+00:00", "01:00:00", "ACST", -570]
	]),

	"1971" : helpers.makeTestYear("Australia/Yancowinna", [
		["1971-10-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1971-10-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1972" : helpers.makeTestYear("Australia/Yancowinna", [
		["1972-02-26T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1972-02-26T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1972-10-28T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1972-10-28T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1973" : helpers.makeTestYear("Australia/Yancowinna", [
		["1973-03-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1973-03-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1973-10-27T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1973-10-27T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1974" : helpers.makeTestYear("Australia/Yancowinna", [
		["1974-03-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1974-03-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1974-10-26T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1974-10-26T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1975" : helpers.makeTestYear("Australia/Yancowinna", [
		["1975-03-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1975-03-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1975-10-25T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1975-10-25T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1976" : helpers.makeTestYear("Australia/Yancowinna", [
		["1976-03-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1976-03-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1976-10-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1976-10-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1977" : helpers.makeTestYear("Australia/Yancowinna", [
		["1977-03-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1977-03-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1977-10-29T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1977-10-29T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1978" : helpers.makeTestYear("Australia/Yancowinna", [
		["1978-03-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1978-03-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1978-10-28T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1978-10-28T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1979" : helpers.makeTestYear("Australia/Yancowinna", [
		["1979-03-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1979-03-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1979-10-27T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1979-10-27T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1980" : helpers.makeTestYear("Australia/Yancowinna", [
		["1980-03-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1980-03-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1980-10-25T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1980-10-25T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1981" : helpers.makeTestYear("Australia/Yancowinna", [
		["1981-02-28T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1981-02-28T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1981-10-24T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1981-10-24T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1982" : helpers.makeTestYear("Australia/Yancowinna", [
		["1982-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1982-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1982-10-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1982-10-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1983" : helpers.makeTestYear("Australia/Yancowinna", [
		["1983-03-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1983-03-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1983-10-29T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1983-10-29T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1984" : helpers.makeTestYear("Australia/Yancowinna", [
		["1984-03-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1984-03-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1984-10-27T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1984-10-27T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1985" : helpers.makeTestYear("Australia/Yancowinna", [
		["1985-03-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1985-03-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1985-10-26T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1985-10-26T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1986" : helpers.makeTestYear("Australia/Yancowinna", [
		["1986-03-15T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1986-03-15T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1986-10-18T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1986-10-18T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1987" : helpers.makeTestYear("Australia/Yancowinna", [
		["1987-03-14T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1987-03-14T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1987-10-24T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1987-10-24T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1988" : helpers.makeTestYear("Australia/Yancowinna", [
		["1988-03-19T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1988-03-19T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1988-10-29T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1988-10-29T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1989" : helpers.makeTestYear("Australia/Yancowinna", [
		["1989-03-18T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1989-03-18T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1989-10-28T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1989-10-28T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1990" : helpers.makeTestYear("Australia/Yancowinna", [
		["1990-03-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1990-03-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1990-10-27T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1990-10-27T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1991" : helpers.makeTestYear("Australia/Yancowinna", [
		["1991-03-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1991-03-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1991-10-26T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1991-10-26T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1992" : helpers.makeTestYear("Australia/Yancowinna", [
		["1992-02-29T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1992-02-29T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1992-10-24T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1992-10-24T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1993" : helpers.makeTestYear("Australia/Yancowinna", [
		["1993-03-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1993-03-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1993-10-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1993-10-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1994" : helpers.makeTestYear("Australia/Yancowinna", [
		["1994-03-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1994-03-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1994-10-29T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1994-10-29T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1995" : helpers.makeTestYear("Australia/Yancowinna", [
		["1995-03-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1995-03-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1995-10-28T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1995-10-28T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1996" : helpers.makeTestYear("Australia/Yancowinna", [
		["1996-03-30T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1996-03-30T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1996-10-26T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1996-10-26T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1997" : helpers.makeTestYear("Australia/Yancowinna", [
		["1997-03-29T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1997-03-29T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1997-10-25T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1997-10-25T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1998" : helpers.makeTestYear("Australia/Yancowinna", [
		["1998-03-28T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1998-03-28T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1998-10-24T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1998-10-24T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"1999" : helpers.makeTestYear("Australia/Yancowinna", [
		["1999-03-27T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["1999-03-27T16:30:00+00:00", "02:00:00", "ACST", -570],
		["1999-10-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["1999-10-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2000" : helpers.makeTestYear("Australia/Yancowinna", [
		["2000-03-25T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2000-03-25T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2000-10-28T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2000-10-28T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2001" : helpers.makeTestYear("Australia/Yancowinna", [
		["2001-03-24T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2001-03-24T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2001-10-27T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2001-10-27T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2002" : helpers.makeTestYear("Australia/Yancowinna", [
		["2002-03-30T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2002-03-30T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2002-10-26T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2002-10-26T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2003" : helpers.makeTestYear("Australia/Yancowinna", [
		["2003-03-29T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2003-03-29T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2003-10-25T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2003-10-25T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2004" : helpers.makeTestYear("Australia/Yancowinna", [
		["2004-03-27T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2004-03-27T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2004-10-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2004-10-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2005" : helpers.makeTestYear("Australia/Yancowinna", [
		["2005-03-26T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2005-03-26T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2005-10-29T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2005-10-29T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2006" : helpers.makeTestYear("Australia/Yancowinna", [
		["2006-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2006-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2006-10-28T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2006-10-28T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2007" : helpers.makeTestYear("Australia/Yancowinna", [
		["2007-03-24T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2007-03-24T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2007-10-27T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2007-10-27T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2008" : helpers.makeTestYear("Australia/Yancowinna", [
		["2008-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2008-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2008-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2008-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2009" : helpers.makeTestYear("Australia/Yancowinna", [
		["2009-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2009-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2009-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2009-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2010" : helpers.makeTestYear("Australia/Yancowinna", [
		["2010-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2010-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2010-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2010-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2011" : helpers.makeTestYear("Australia/Yancowinna", [
		["2011-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2011-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2011-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2011-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2012" : helpers.makeTestYear("Australia/Yancowinna", [
		["2012-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2012-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2012-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2012-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2013" : helpers.makeTestYear("Australia/Yancowinna", [
		["2013-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2013-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2013-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2013-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2014" : helpers.makeTestYear("Australia/Yancowinna", [
		["2014-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2014-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2014-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2014-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2015" : helpers.makeTestYear("Australia/Yancowinna", [
		["2015-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2015-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2015-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2015-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2016" : helpers.makeTestYear("Australia/Yancowinna", [
		["2016-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2016-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2016-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2016-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2017" : helpers.makeTestYear("Australia/Yancowinna", [
		["2017-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2017-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2017-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2017-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2018" : helpers.makeTestYear("Australia/Yancowinna", [
		["2018-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2018-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2018-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2018-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2019" : helpers.makeTestYear("Australia/Yancowinna", [
		["2019-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2019-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2019-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2019-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2020" : helpers.makeTestYear("Australia/Yancowinna", [
		["2020-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2020-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2020-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2020-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2021" : helpers.makeTestYear("Australia/Yancowinna", [
		["2021-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2021-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2021-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2021-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2022" : helpers.makeTestYear("Australia/Yancowinna", [
		["2022-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2022-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2022-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2022-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2023" : helpers.makeTestYear("Australia/Yancowinna", [
		["2023-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2023-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2023-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2023-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2024" : helpers.makeTestYear("Australia/Yancowinna", [
		["2024-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2024-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2024-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2024-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2025" : helpers.makeTestYear("Australia/Yancowinna", [
		["2025-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2025-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2025-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2025-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2026" : helpers.makeTestYear("Australia/Yancowinna", [
		["2026-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2026-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2026-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2026-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2027" : helpers.makeTestYear("Australia/Yancowinna", [
		["2027-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2027-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2027-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2027-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2028" : helpers.makeTestYear("Australia/Yancowinna", [
		["2028-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2028-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2028-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2028-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2029" : helpers.makeTestYear("Australia/Yancowinna", [
		["2029-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2029-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2029-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2029-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2030" : helpers.makeTestYear("Australia/Yancowinna", [
		["2030-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2030-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2030-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2030-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2031" : helpers.makeTestYear("Australia/Yancowinna", [
		["2031-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2031-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2031-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2031-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2032" : helpers.makeTestYear("Australia/Yancowinna", [
		["2032-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2032-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2032-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2032-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2033" : helpers.makeTestYear("Australia/Yancowinna", [
		["2033-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2033-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2033-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2033-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2034" : helpers.makeTestYear("Australia/Yancowinna", [
		["2034-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2034-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2034-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2034-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2035" : helpers.makeTestYear("Australia/Yancowinna", [
		["2035-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2035-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2035-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2035-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2036" : helpers.makeTestYear("Australia/Yancowinna", [
		["2036-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2036-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2036-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2036-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2037" : helpers.makeTestYear("Australia/Yancowinna", [
		["2037-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2037-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2037-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2037-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2038" : helpers.makeTestYear("Australia/Yancowinna", [
		["2038-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2038-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2038-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2038-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2039" : helpers.makeTestYear("Australia/Yancowinna", [
		["2039-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2039-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2039-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2039-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2040" : helpers.makeTestYear("Australia/Yancowinna", [
		["2040-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2040-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2040-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2040-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2041" : helpers.makeTestYear("Australia/Yancowinna", [
		["2041-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2041-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2041-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2041-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2042" : helpers.makeTestYear("Australia/Yancowinna", [
		["2042-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2042-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2042-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2042-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2043" : helpers.makeTestYear("Australia/Yancowinna", [
		["2043-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2043-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2043-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2043-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2044" : helpers.makeTestYear("Australia/Yancowinna", [
		["2044-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2044-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2044-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2044-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2045" : helpers.makeTestYear("Australia/Yancowinna", [
		["2045-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2045-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2045-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2045-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2046" : helpers.makeTestYear("Australia/Yancowinna", [
		["2046-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2046-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2046-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2046-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2047" : helpers.makeTestYear("Australia/Yancowinna", [
		["2047-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2047-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2047-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2047-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2048" : helpers.makeTestYear("Australia/Yancowinna", [
		["2048-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2048-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2048-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2048-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2049" : helpers.makeTestYear("Australia/Yancowinna", [
		["2049-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2049-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2049-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2049-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2050" : helpers.makeTestYear("Australia/Yancowinna", [
		["2050-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2050-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2050-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2050-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2051" : helpers.makeTestYear("Australia/Yancowinna", [
		["2051-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2051-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2051-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2051-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2052" : helpers.makeTestYear("Australia/Yancowinna", [
		["2052-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2052-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2052-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2052-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2053" : helpers.makeTestYear("Australia/Yancowinna", [
		["2053-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2053-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2053-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2053-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2054" : helpers.makeTestYear("Australia/Yancowinna", [
		["2054-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2054-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2054-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2054-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2055" : helpers.makeTestYear("Australia/Yancowinna", [
		["2055-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2055-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2055-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2055-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2056" : helpers.makeTestYear("Australia/Yancowinna", [
		["2056-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2056-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2056-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2056-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2057" : helpers.makeTestYear("Australia/Yancowinna", [
		["2057-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2057-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2057-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2057-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2058" : helpers.makeTestYear("Australia/Yancowinna", [
		["2058-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2058-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2058-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2058-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2059" : helpers.makeTestYear("Australia/Yancowinna", [
		["2059-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2059-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2059-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2059-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2060" : helpers.makeTestYear("Australia/Yancowinna", [
		["2060-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2060-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2060-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2060-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2061" : helpers.makeTestYear("Australia/Yancowinna", [
		["2061-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2061-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2061-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2061-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2062" : helpers.makeTestYear("Australia/Yancowinna", [
		["2062-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2062-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2062-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2062-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2063" : helpers.makeTestYear("Australia/Yancowinna", [
		["2063-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2063-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2063-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2063-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2064" : helpers.makeTestYear("Australia/Yancowinna", [
		["2064-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2064-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2064-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2064-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2065" : helpers.makeTestYear("Australia/Yancowinna", [
		["2065-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2065-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2065-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2065-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2066" : helpers.makeTestYear("Australia/Yancowinna", [
		["2066-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2066-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2066-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2066-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2067" : helpers.makeTestYear("Australia/Yancowinna", [
		["2067-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2067-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2067-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2067-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2068" : helpers.makeTestYear("Australia/Yancowinna", [
		["2068-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2068-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2068-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2068-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2069" : helpers.makeTestYear("Australia/Yancowinna", [
		["2069-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2069-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2069-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2069-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2070" : helpers.makeTestYear("Australia/Yancowinna", [
		["2070-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2070-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2070-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2070-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2071" : helpers.makeTestYear("Australia/Yancowinna", [
		["2071-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2071-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2071-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2071-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2072" : helpers.makeTestYear("Australia/Yancowinna", [
		["2072-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2072-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2072-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2072-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2073" : helpers.makeTestYear("Australia/Yancowinna", [
		["2073-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2073-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2073-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2073-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2074" : helpers.makeTestYear("Australia/Yancowinna", [
		["2074-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2074-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2074-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2074-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2075" : helpers.makeTestYear("Australia/Yancowinna", [
		["2075-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2075-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2075-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2075-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2076" : helpers.makeTestYear("Australia/Yancowinna", [
		["2076-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2076-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2076-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2076-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2077" : helpers.makeTestYear("Australia/Yancowinna", [
		["2077-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2077-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2077-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2077-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2078" : helpers.makeTestYear("Australia/Yancowinna", [
		["2078-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2078-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2078-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2078-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2079" : helpers.makeTestYear("Australia/Yancowinna", [
		["2079-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2079-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2079-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2079-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2080" : helpers.makeTestYear("Australia/Yancowinna", [
		["2080-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2080-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2080-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2080-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2081" : helpers.makeTestYear("Australia/Yancowinna", [
		["2081-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2081-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2081-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2081-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2082" : helpers.makeTestYear("Australia/Yancowinna", [
		["2082-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2082-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2082-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2082-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2083" : helpers.makeTestYear("Australia/Yancowinna", [
		["2083-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2083-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2083-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2083-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2084" : helpers.makeTestYear("Australia/Yancowinna", [
		["2084-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2084-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2084-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2084-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2085" : helpers.makeTestYear("Australia/Yancowinna", [
		["2085-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2085-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2085-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2085-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2086" : helpers.makeTestYear("Australia/Yancowinna", [
		["2086-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2086-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2086-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2086-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2087" : helpers.makeTestYear("Australia/Yancowinna", [
		["2087-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2087-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2087-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2087-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2088" : helpers.makeTestYear("Australia/Yancowinna", [
		["2088-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2088-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2088-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2088-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2089" : helpers.makeTestYear("Australia/Yancowinna", [
		["2089-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2089-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2089-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2089-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2090" : helpers.makeTestYear("Australia/Yancowinna", [
		["2090-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2090-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2090-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2090-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2091" : helpers.makeTestYear("Australia/Yancowinna", [
		["2091-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2091-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2091-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2091-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2092" : helpers.makeTestYear("Australia/Yancowinna", [
		["2092-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2092-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2092-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2092-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2093" : helpers.makeTestYear("Australia/Yancowinna", [
		["2093-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2093-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2093-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2093-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2094" : helpers.makeTestYear("Australia/Yancowinna", [
		["2094-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2094-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2094-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2094-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2095" : helpers.makeTestYear("Australia/Yancowinna", [
		["2095-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2095-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2095-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2095-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2096" : helpers.makeTestYear("Australia/Yancowinna", [
		["2096-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2096-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2096-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2096-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2097" : helpers.makeTestYear("Australia/Yancowinna", [
		["2097-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2097-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2097-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2097-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2098" : helpers.makeTestYear("Australia/Yancowinna", [
		["2098-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2098-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2098-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2098-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2099" : helpers.makeTestYear("Australia/Yancowinna", [
		["2099-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2099-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2099-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2099-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2100" : helpers.makeTestYear("Australia/Yancowinna", [
		["2100-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2100-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2100-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2100-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2101" : helpers.makeTestYear("Australia/Yancowinna", [
		["2101-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2101-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2101-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2101-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2102" : helpers.makeTestYear("Australia/Yancowinna", [
		["2102-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2102-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2102-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2102-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2103" : helpers.makeTestYear("Australia/Yancowinna", [
		["2103-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2103-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2103-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2103-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2104" : helpers.makeTestYear("Australia/Yancowinna", [
		["2104-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2104-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2104-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2104-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2105" : helpers.makeTestYear("Australia/Yancowinna", [
		["2105-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2105-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2105-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2105-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2106" : helpers.makeTestYear("Australia/Yancowinna", [
		["2106-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2106-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2106-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2106-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2107" : helpers.makeTestYear("Australia/Yancowinna", [
		["2107-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2107-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2107-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2107-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2108" : helpers.makeTestYear("Australia/Yancowinna", [
		["2108-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2108-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2108-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2108-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2109" : helpers.makeTestYear("Australia/Yancowinna", [
		["2109-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2109-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2109-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2109-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2110" : helpers.makeTestYear("Australia/Yancowinna", [
		["2110-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2110-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2110-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2110-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2111" : helpers.makeTestYear("Australia/Yancowinna", [
		["2111-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2111-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2111-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2111-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2112" : helpers.makeTestYear("Australia/Yancowinna", [
		["2112-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2112-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2112-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2112-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2113" : helpers.makeTestYear("Australia/Yancowinna", [
		["2113-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2113-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2113-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2113-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2114" : helpers.makeTestYear("Australia/Yancowinna", [
		["2114-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2114-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2114-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2114-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2115" : helpers.makeTestYear("Australia/Yancowinna", [
		["2115-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2115-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2115-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2115-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2116" : helpers.makeTestYear("Australia/Yancowinna", [
		["2116-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2116-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2116-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2116-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2117" : helpers.makeTestYear("Australia/Yancowinna", [
		["2117-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2117-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2117-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2117-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2118" : helpers.makeTestYear("Australia/Yancowinna", [
		["2118-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2118-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2118-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2118-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2119" : helpers.makeTestYear("Australia/Yancowinna", [
		["2119-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2119-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2119-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2119-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2120" : helpers.makeTestYear("Australia/Yancowinna", [
		["2120-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2120-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2120-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2120-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2121" : helpers.makeTestYear("Australia/Yancowinna", [
		["2121-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2121-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2121-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2121-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2122" : helpers.makeTestYear("Australia/Yancowinna", [
		["2122-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2122-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2122-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2122-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2123" : helpers.makeTestYear("Australia/Yancowinna", [
		["2123-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2123-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2123-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2123-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2124" : helpers.makeTestYear("Australia/Yancowinna", [
		["2124-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2124-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2124-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2124-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2125" : helpers.makeTestYear("Australia/Yancowinna", [
		["2125-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2125-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2125-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2125-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2126" : helpers.makeTestYear("Australia/Yancowinna", [
		["2126-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2126-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2126-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2126-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2127" : helpers.makeTestYear("Australia/Yancowinna", [
		["2127-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2127-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2127-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2127-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2128" : helpers.makeTestYear("Australia/Yancowinna", [
		["2128-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2128-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2128-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2128-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2129" : helpers.makeTestYear("Australia/Yancowinna", [
		["2129-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2129-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2129-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2129-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2130" : helpers.makeTestYear("Australia/Yancowinna", [
		["2130-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2130-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2130-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2130-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2131" : helpers.makeTestYear("Australia/Yancowinna", [
		["2131-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2131-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2131-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2131-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2132" : helpers.makeTestYear("Australia/Yancowinna", [
		["2132-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2132-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2132-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2132-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2133" : helpers.makeTestYear("Australia/Yancowinna", [
		["2133-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2133-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2133-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2133-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2134" : helpers.makeTestYear("Australia/Yancowinna", [
		["2134-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2134-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2134-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2134-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2135" : helpers.makeTestYear("Australia/Yancowinna", [
		["2135-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2135-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2135-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2135-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2136" : helpers.makeTestYear("Australia/Yancowinna", [
		["2136-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2136-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2136-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2136-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2137" : helpers.makeTestYear("Australia/Yancowinna", [
		["2137-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2137-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2137-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2137-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2138" : helpers.makeTestYear("Australia/Yancowinna", [
		["2138-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2138-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2138-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2138-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2139" : helpers.makeTestYear("Australia/Yancowinna", [
		["2139-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2139-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2139-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2139-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2140" : helpers.makeTestYear("Australia/Yancowinna", [
		["2140-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2140-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2140-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2140-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2141" : helpers.makeTestYear("Australia/Yancowinna", [
		["2141-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2141-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2141-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2141-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2142" : helpers.makeTestYear("Australia/Yancowinna", [
		["2142-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2142-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2142-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2142-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2143" : helpers.makeTestYear("Australia/Yancowinna", [
		["2143-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2143-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2143-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2143-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2144" : helpers.makeTestYear("Australia/Yancowinna", [
		["2144-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2144-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2144-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2144-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2145" : helpers.makeTestYear("Australia/Yancowinna", [
		["2145-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2145-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2145-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2145-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2146" : helpers.makeTestYear("Australia/Yancowinna", [
		["2146-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2146-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2146-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2146-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2147" : helpers.makeTestYear("Australia/Yancowinna", [
		["2147-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2147-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2147-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2147-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2148" : helpers.makeTestYear("Australia/Yancowinna", [
		["2148-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2148-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2148-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2148-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2149" : helpers.makeTestYear("Australia/Yancowinna", [
		["2149-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2149-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2149-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2149-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2150" : helpers.makeTestYear("Australia/Yancowinna", [
		["2150-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2150-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2150-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2150-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2151" : helpers.makeTestYear("Australia/Yancowinna", [
		["2151-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2151-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2151-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2151-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2152" : helpers.makeTestYear("Australia/Yancowinna", [
		["2152-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2152-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2152-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2152-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2153" : helpers.makeTestYear("Australia/Yancowinna", [
		["2153-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2153-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2153-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2153-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2154" : helpers.makeTestYear("Australia/Yancowinna", [
		["2154-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2154-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2154-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2154-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2155" : helpers.makeTestYear("Australia/Yancowinna", [
		["2155-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2155-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2155-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2155-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2156" : helpers.makeTestYear("Australia/Yancowinna", [
		["2156-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2156-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2156-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2156-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2157" : helpers.makeTestYear("Australia/Yancowinna", [
		["2157-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2157-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2157-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2157-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2158" : helpers.makeTestYear("Australia/Yancowinna", [
		["2158-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2158-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2158-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2158-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2159" : helpers.makeTestYear("Australia/Yancowinna", [
		["2159-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2159-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2159-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2159-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2160" : helpers.makeTestYear("Australia/Yancowinna", [
		["2160-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2160-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2160-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2160-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2161" : helpers.makeTestYear("Australia/Yancowinna", [
		["2161-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2161-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2161-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2161-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2162" : helpers.makeTestYear("Australia/Yancowinna", [
		["2162-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2162-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2162-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2162-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2163" : helpers.makeTestYear("Australia/Yancowinna", [
		["2163-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2163-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2163-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2163-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2164" : helpers.makeTestYear("Australia/Yancowinna", [
		["2164-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2164-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2164-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2164-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2165" : helpers.makeTestYear("Australia/Yancowinna", [
		["2165-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2165-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2165-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2165-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2166" : helpers.makeTestYear("Australia/Yancowinna", [
		["2166-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2166-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2166-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2166-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2167" : helpers.makeTestYear("Australia/Yancowinna", [
		["2167-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2167-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2167-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2167-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2168" : helpers.makeTestYear("Australia/Yancowinna", [
		["2168-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2168-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2168-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2168-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2169" : helpers.makeTestYear("Australia/Yancowinna", [
		["2169-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2169-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2169-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2169-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2170" : helpers.makeTestYear("Australia/Yancowinna", [
		["2170-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2170-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2170-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2170-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2171" : helpers.makeTestYear("Australia/Yancowinna", [
		["2171-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2171-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2171-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2171-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2172" : helpers.makeTestYear("Australia/Yancowinna", [
		["2172-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2172-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2172-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2172-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2173" : helpers.makeTestYear("Australia/Yancowinna", [
		["2173-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2173-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2173-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2173-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2174" : helpers.makeTestYear("Australia/Yancowinna", [
		["2174-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2174-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2174-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2174-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2175" : helpers.makeTestYear("Australia/Yancowinna", [
		["2175-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2175-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2175-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2175-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2176" : helpers.makeTestYear("Australia/Yancowinna", [
		["2176-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2176-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2176-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2176-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2177" : helpers.makeTestYear("Australia/Yancowinna", [
		["2177-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2177-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2177-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2177-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2178" : helpers.makeTestYear("Australia/Yancowinna", [
		["2178-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2178-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2178-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2178-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2179" : helpers.makeTestYear("Australia/Yancowinna", [
		["2179-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2179-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2179-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2179-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2180" : helpers.makeTestYear("Australia/Yancowinna", [
		["2180-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2180-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2180-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2180-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2181" : helpers.makeTestYear("Australia/Yancowinna", [
		["2181-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2181-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2181-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2181-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2182" : helpers.makeTestYear("Australia/Yancowinna", [
		["2182-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2182-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2182-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2182-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2183" : helpers.makeTestYear("Australia/Yancowinna", [
		["2183-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2183-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2183-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2183-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2184" : helpers.makeTestYear("Australia/Yancowinna", [
		["2184-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2184-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2184-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2184-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2185" : helpers.makeTestYear("Australia/Yancowinna", [
		["2185-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2185-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2185-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2185-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2186" : helpers.makeTestYear("Australia/Yancowinna", [
		["2186-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2186-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2186-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2186-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2187" : helpers.makeTestYear("Australia/Yancowinna", [
		["2187-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2187-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2187-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2187-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2188" : helpers.makeTestYear("Australia/Yancowinna", [
		["2188-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2188-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2188-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2188-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2189" : helpers.makeTestYear("Australia/Yancowinna", [
		["2189-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2189-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2189-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2189-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2190" : helpers.makeTestYear("Australia/Yancowinna", [
		["2190-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2190-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2190-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2190-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2191" : helpers.makeTestYear("Australia/Yancowinna", [
		["2191-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2191-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2191-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2191-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2192" : helpers.makeTestYear("Australia/Yancowinna", [
		["2192-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2192-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2192-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2192-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2193" : helpers.makeTestYear("Australia/Yancowinna", [
		["2193-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2193-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2193-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2193-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2194" : helpers.makeTestYear("Australia/Yancowinna", [
		["2194-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2194-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2194-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2194-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2195" : helpers.makeTestYear("Australia/Yancowinna", [
		["2195-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2195-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2195-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2195-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2196" : helpers.makeTestYear("Australia/Yancowinna", [
		["2196-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2196-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2196-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2196-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2197" : helpers.makeTestYear("Australia/Yancowinna", [
		["2197-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2197-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2197-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2197-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2198" : helpers.makeTestYear("Australia/Yancowinna", [
		["2198-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2198-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2198-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2198-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2199" : helpers.makeTestYear("Australia/Yancowinna", [
		["2199-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2199-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2199-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2199-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2200" : helpers.makeTestYear("Australia/Yancowinna", [
		["2200-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2200-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2200-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2200-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2201" : helpers.makeTestYear("Australia/Yancowinna", [
		["2201-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2201-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2201-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2201-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2202" : helpers.makeTestYear("Australia/Yancowinna", [
		["2202-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2202-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2202-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2202-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2203" : helpers.makeTestYear("Australia/Yancowinna", [
		["2203-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2203-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2203-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2203-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2204" : helpers.makeTestYear("Australia/Yancowinna", [
		["2204-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2204-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2204-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2204-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2205" : helpers.makeTestYear("Australia/Yancowinna", [
		["2205-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2205-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2205-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2205-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2206" : helpers.makeTestYear("Australia/Yancowinna", [
		["2206-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2206-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2206-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2206-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2207" : helpers.makeTestYear("Australia/Yancowinna", [
		["2207-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2207-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2207-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2207-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2208" : helpers.makeTestYear("Australia/Yancowinna", [
		["2208-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2208-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2208-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2208-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2209" : helpers.makeTestYear("Australia/Yancowinna", [
		["2209-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2209-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2209-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2209-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2210" : helpers.makeTestYear("Australia/Yancowinna", [
		["2210-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2210-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2210-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2210-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2211" : helpers.makeTestYear("Australia/Yancowinna", [
		["2211-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2211-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2211-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2211-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2212" : helpers.makeTestYear("Australia/Yancowinna", [
		["2212-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2212-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2212-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2212-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2213" : helpers.makeTestYear("Australia/Yancowinna", [
		["2213-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2213-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2213-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2213-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2214" : helpers.makeTestYear("Australia/Yancowinna", [
		["2214-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2214-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2214-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2214-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2215" : helpers.makeTestYear("Australia/Yancowinna", [
		["2215-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2215-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2215-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2215-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2216" : helpers.makeTestYear("Australia/Yancowinna", [
		["2216-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2216-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2216-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2216-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2217" : helpers.makeTestYear("Australia/Yancowinna", [
		["2217-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2217-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2217-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2217-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2218" : helpers.makeTestYear("Australia/Yancowinna", [
		["2218-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2218-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2218-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2218-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2219" : helpers.makeTestYear("Australia/Yancowinna", [
		["2219-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2219-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2219-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2219-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2220" : helpers.makeTestYear("Australia/Yancowinna", [
		["2220-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2220-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2220-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2220-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2221" : helpers.makeTestYear("Australia/Yancowinna", [
		["2221-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2221-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2221-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2221-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2222" : helpers.makeTestYear("Australia/Yancowinna", [
		["2222-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2222-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2222-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2222-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2223" : helpers.makeTestYear("Australia/Yancowinna", [
		["2223-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2223-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2223-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2223-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2224" : helpers.makeTestYear("Australia/Yancowinna", [
		["2224-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2224-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2224-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2224-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2225" : helpers.makeTestYear("Australia/Yancowinna", [
		["2225-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2225-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2225-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2225-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2226" : helpers.makeTestYear("Australia/Yancowinna", [
		["2226-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2226-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2226-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2226-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2227" : helpers.makeTestYear("Australia/Yancowinna", [
		["2227-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2227-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2227-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2227-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2228" : helpers.makeTestYear("Australia/Yancowinna", [
		["2228-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2228-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2228-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2228-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2229" : helpers.makeTestYear("Australia/Yancowinna", [
		["2229-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2229-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2229-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2229-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2230" : helpers.makeTestYear("Australia/Yancowinna", [
		["2230-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2230-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2230-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2230-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2231" : helpers.makeTestYear("Australia/Yancowinna", [
		["2231-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2231-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2231-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2231-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2232" : helpers.makeTestYear("Australia/Yancowinna", [
		["2232-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2232-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2232-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2232-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2233" : helpers.makeTestYear("Australia/Yancowinna", [
		["2233-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2233-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2233-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2233-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2234" : helpers.makeTestYear("Australia/Yancowinna", [
		["2234-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2234-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2234-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2234-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2235" : helpers.makeTestYear("Australia/Yancowinna", [
		["2235-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2235-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2235-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2235-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2236" : helpers.makeTestYear("Australia/Yancowinna", [
		["2236-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2236-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2236-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2236-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2237" : helpers.makeTestYear("Australia/Yancowinna", [
		["2237-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2237-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2237-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2237-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2238" : helpers.makeTestYear("Australia/Yancowinna", [
		["2238-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2238-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2238-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2238-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2239" : helpers.makeTestYear("Australia/Yancowinna", [
		["2239-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2239-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2239-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2239-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2240" : helpers.makeTestYear("Australia/Yancowinna", [
		["2240-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2240-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2240-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2240-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2241" : helpers.makeTestYear("Australia/Yancowinna", [
		["2241-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2241-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2241-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2241-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2242" : helpers.makeTestYear("Australia/Yancowinna", [
		["2242-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2242-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2242-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2242-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2243" : helpers.makeTestYear("Australia/Yancowinna", [
		["2243-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2243-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2243-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2243-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2244" : helpers.makeTestYear("Australia/Yancowinna", [
		["2244-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2244-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2244-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2244-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2245" : helpers.makeTestYear("Australia/Yancowinna", [
		["2245-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2245-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2245-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2245-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2246" : helpers.makeTestYear("Australia/Yancowinna", [
		["2246-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2246-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2246-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2246-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2247" : helpers.makeTestYear("Australia/Yancowinna", [
		["2247-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2247-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2247-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2247-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2248" : helpers.makeTestYear("Australia/Yancowinna", [
		["2248-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2248-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2248-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2248-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2249" : helpers.makeTestYear("Australia/Yancowinna", [
		["2249-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2249-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2249-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2249-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2250" : helpers.makeTestYear("Australia/Yancowinna", [
		["2250-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2250-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2250-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2250-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2251" : helpers.makeTestYear("Australia/Yancowinna", [
		["2251-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2251-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2251-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2251-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2252" : helpers.makeTestYear("Australia/Yancowinna", [
		["2252-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2252-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2252-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2252-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2253" : helpers.makeTestYear("Australia/Yancowinna", [
		["2253-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2253-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2253-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2253-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2254" : helpers.makeTestYear("Australia/Yancowinna", [
		["2254-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2254-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2254-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2254-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2255" : helpers.makeTestYear("Australia/Yancowinna", [
		["2255-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2255-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2255-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2255-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2256" : helpers.makeTestYear("Australia/Yancowinna", [
		["2256-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2256-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2256-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2256-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2257" : helpers.makeTestYear("Australia/Yancowinna", [
		["2257-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2257-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2257-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2257-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2258" : helpers.makeTestYear("Australia/Yancowinna", [
		["2258-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2258-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2258-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2258-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2259" : helpers.makeTestYear("Australia/Yancowinna", [
		["2259-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2259-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2259-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2259-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2260" : helpers.makeTestYear("Australia/Yancowinna", [
		["2260-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2260-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2260-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2260-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2261" : helpers.makeTestYear("Australia/Yancowinna", [
		["2261-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2261-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2261-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2261-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2262" : helpers.makeTestYear("Australia/Yancowinna", [
		["2262-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2262-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2262-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2262-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2263" : helpers.makeTestYear("Australia/Yancowinna", [
		["2263-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2263-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2263-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2263-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2264" : helpers.makeTestYear("Australia/Yancowinna", [
		["2264-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2264-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2264-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2264-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2265" : helpers.makeTestYear("Australia/Yancowinna", [
		["2265-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2265-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2265-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2265-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2266" : helpers.makeTestYear("Australia/Yancowinna", [
		["2266-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2266-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2266-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2266-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2267" : helpers.makeTestYear("Australia/Yancowinna", [
		["2267-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2267-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2267-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2267-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2268" : helpers.makeTestYear("Australia/Yancowinna", [
		["2268-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2268-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2268-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2268-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2269" : helpers.makeTestYear("Australia/Yancowinna", [
		["2269-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2269-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2269-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2269-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2270" : helpers.makeTestYear("Australia/Yancowinna", [
		["2270-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2270-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2270-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2270-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2271" : helpers.makeTestYear("Australia/Yancowinna", [
		["2271-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2271-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2271-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2271-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2272" : helpers.makeTestYear("Australia/Yancowinna", [
		["2272-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2272-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2272-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2272-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2273" : helpers.makeTestYear("Australia/Yancowinna", [
		["2273-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2273-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2273-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2273-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2274" : helpers.makeTestYear("Australia/Yancowinna", [
		["2274-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2274-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2274-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2274-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2275" : helpers.makeTestYear("Australia/Yancowinna", [
		["2275-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2275-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2275-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2275-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2276" : helpers.makeTestYear("Australia/Yancowinna", [
		["2276-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2276-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2276-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2276-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2277" : helpers.makeTestYear("Australia/Yancowinna", [
		["2277-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2277-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2277-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2277-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2278" : helpers.makeTestYear("Australia/Yancowinna", [
		["2278-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2278-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2278-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2278-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2279" : helpers.makeTestYear("Australia/Yancowinna", [
		["2279-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2279-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2279-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2279-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2280" : helpers.makeTestYear("Australia/Yancowinna", [
		["2280-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2280-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2280-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2280-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2281" : helpers.makeTestYear("Australia/Yancowinna", [
		["2281-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2281-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2281-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2281-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2282" : helpers.makeTestYear("Australia/Yancowinna", [
		["2282-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2282-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2282-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2282-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2283" : helpers.makeTestYear("Australia/Yancowinna", [
		["2283-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2283-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2283-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2283-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2284" : helpers.makeTestYear("Australia/Yancowinna", [
		["2284-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2284-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2284-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2284-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2285" : helpers.makeTestYear("Australia/Yancowinna", [
		["2285-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2285-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2285-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2285-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2286" : helpers.makeTestYear("Australia/Yancowinna", [
		["2286-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2286-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2286-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2286-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2287" : helpers.makeTestYear("Australia/Yancowinna", [
		["2287-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2287-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2287-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2287-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2288" : helpers.makeTestYear("Australia/Yancowinna", [
		["2288-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2288-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2288-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2288-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2289" : helpers.makeTestYear("Australia/Yancowinna", [
		["2289-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2289-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2289-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2289-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2290" : helpers.makeTestYear("Australia/Yancowinna", [
		["2290-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2290-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2290-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2290-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2291" : helpers.makeTestYear("Australia/Yancowinna", [
		["2291-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2291-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2291-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2291-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2292" : helpers.makeTestYear("Australia/Yancowinna", [
		["2292-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2292-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2292-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2292-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2293" : helpers.makeTestYear("Australia/Yancowinna", [
		["2293-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2293-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2293-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2293-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2294" : helpers.makeTestYear("Australia/Yancowinna", [
		["2294-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2294-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2294-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2294-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2295" : helpers.makeTestYear("Australia/Yancowinna", [
		["2295-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2295-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2295-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2295-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2296" : helpers.makeTestYear("Australia/Yancowinna", [
		["2296-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2296-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2296-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2296-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2297" : helpers.makeTestYear("Australia/Yancowinna", [
		["2297-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2297-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2297-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2297-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2298" : helpers.makeTestYear("Australia/Yancowinna", [
		["2298-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2298-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2298-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2298-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2299" : helpers.makeTestYear("Australia/Yancowinna", [
		["2299-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2299-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2299-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2299-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2300" : helpers.makeTestYear("Australia/Yancowinna", [
		["2300-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2300-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2300-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2300-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2301" : helpers.makeTestYear("Australia/Yancowinna", [
		["2301-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2301-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2301-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2301-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2302" : helpers.makeTestYear("Australia/Yancowinna", [
		["2302-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2302-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2302-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2302-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2303" : helpers.makeTestYear("Australia/Yancowinna", [
		["2303-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2303-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2303-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2303-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2304" : helpers.makeTestYear("Australia/Yancowinna", [
		["2304-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2304-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2304-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2304-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2305" : helpers.makeTestYear("Australia/Yancowinna", [
		["2305-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2305-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2305-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2305-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2306" : helpers.makeTestYear("Australia/Yancowinna", [
		["2306-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2306-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2306-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2306-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2307" : helpers.makeTestYear("Australia/Yancowinna", [
		["2307-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2307-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2307-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2307-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2308" : helpers.makeTestYear("Australia/Yancowinna", [
		["2308-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2308-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2308-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2308-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2309" : helpers.makeTestYear("Australia/Yancowinna", [
		["2309-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2309-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2309-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2309-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2310" : helpers.makeTestYear("Australia/Yancowinna", [
		["2310-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2310-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2310-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2310-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2311" : helpers.makeTestYear("Australia/Yancowinna", [
		["2311-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2311-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2311-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2311-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2312" : helpers.makeTestYear("Australia/Yancowinna", [
		["2312-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2312-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2312-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2312-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2313" : helpers.makeTestYear("Australia/Yancowinna", [
		["2313-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2313-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2313-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2313-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2314" : helpers.makeTestYear("Australia/Yancowinna", [
		["2314-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2314-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2314-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2314-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2315" : helpers.makeTestYear("Australia/Yancowinna", [
		["2315-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2315-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2315-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2315-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2316" : helpers.makeTestYear("Australia/Yancowinna", [
		["2316-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2316-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2316-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2316-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2317" : helpers.makeTestYear("Australia/Yancowinna", [
		["2317-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2317-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2317-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2317-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2318" : helpers.makeTestYear("Australia/Yancowinna", [
		["2318-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2318-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2318-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2318-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2319" : helpers.makeTestYear("Australia/Yancowinna", [
		["2319-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2319-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2319-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2319-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2320" : helpers.makeTestYear("Australia/Yancowinna", [
		["2320-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2320-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2320-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2320-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2321" : helpers.makeTestYear("Australia/Yancowinna", [
		["2321-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2321-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2321-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2321-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2322" : helpers.makeTestYear("Australia/Yancowinna", [
		["2322-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2322-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2322-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2322-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2323" : helpers.makeTestYear("Australia/Yancowinna", [
		["2323-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2323-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2323-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2323-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2324" : helpers.makeTestYear("Australia/Yancowinna", [
		["2324-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2324-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2324-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2324-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2325" : helpers.makeTestYear("Australia/Yancowinna", [
		["2325-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2325-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2325-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2325-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2326" : helpers.makeTestYear("Australia/Yancowinna", [
		["2326-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2326-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2326-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2326-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2327" : helpers.makeTestYear("Australia/Yancowinna", [
		["2327-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2327-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2327-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2327-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2328" : helpers.makeTestYear("Australia/Yancowinna", [
		["2328-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2328-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2328-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2328-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2329" : helpers.makeTestYear("Australia/Yancowinna", [
		["2329-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2329-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2329-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2329-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2330" : helpers.makeTestYear("Australia/Yancowinna", [
		["2330-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2330-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2330-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2330-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2331" : helpers.makeTestYear("Australia/Yancowinna", [
		["2331-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2331-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2331-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2331-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2332" : helpers.makeTestYear("Australia/Yancowinna", [
		["2332-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2332-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2332-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2332-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2333" : helpers.makeTestYear("Australia/Yancowinna", [
		["2333-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2333-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2333-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2333-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2334" : helpers.makeTestYear("Australia/Yancowinna", [
		["2334-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2334-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2334-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2334-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2335" : helpers.makeTestYear("Australia/Yancowinna", [
		["2335-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2335-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2335-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2335-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2336" : helpers.makeTestYear("Australia/Yancowinna", [
		["2336-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2336-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2336-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2336-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2337" : helpers.makeTestYear("Australia/Yancowinna", [
		["2337-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2337-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2337-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2337-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2338" : helpers.makeTestYear("Australia/Yancowinna", [
		["2338-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2338-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2338-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2338-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2339" : helpers.makeTestYear("Australia/Yancowinna", [
		["2339-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2339-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2339-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2339-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2340" : helpers.makeTestYear("Australia/Yancowinna", [
		["2340-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2340-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2340-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2340-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2341" : helpers.makeTestYear("Australia/Yancowinna", [
		["2341-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2341-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2341-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2341-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2342" : helpers.makeTestYear("Australia/Yancowinna", [
		["2342-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2342-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2342-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2342-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2343" : helpers.makeTestYear("Australia/Yancowinna", [
		["2343-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2343-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2343-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2343-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2344" : helpers.makeTestYear("Australia/Yancowinna", [
		["2344-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2344-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2344-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2344-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2345" : helpers.makeTestYear("Australia/Yancowinna", [
		["2345-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2345-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2345-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2345-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2346" : helpers.makeTestYear("Australia/Yancowinna", [
		["2346-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2346-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2346-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2346-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2347" : helpers.makeTestYear("Australia/Yancowinna", [
		["2347-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2347-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2347-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2347-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2348" : helpers.makeTestYear("Australia/Yancowinna", [
		["2348-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2348-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2348-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2348-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2349" : helpers.makeTestYear("Australia/Yancowinna", [
		["2349-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2349-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2349-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2349-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2350" : helpers.makeTestYear("Australia/Yancowinna", [
		["2350-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2350-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2350-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2350-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2351" : helpers.makeTestYear("Australia/Yancowinna", [
		["2351-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2351-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2351-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2351-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2352" : helpers.makeTestYear("Australia/Yancowinna", [
		["2352-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2352-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2352-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2352-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2353" : helpers.makeTestYear("Australia/Yancowinna", [
		["2353-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2353-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2353-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2353-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2354" : helpers.makeTestYear("Australia/Yancowinna", [
		["2354-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2354-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2354-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2354-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2355" : helpers.makeTestYear("Australia/Yancowinna", [
		["2355-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2355-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2355-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2355-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2356" : helpers.makeTestYear("Australia/Yancowinna", [
		["2356-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2356-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2356-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2356-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2357" : helpers.makeTestYear("Australia/Yancowinna", [
		["2357-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2357-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2357-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2357-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2358" : helpers.makeTestYear("Australia/Yancowinna", [
		["2358-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2358-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2358-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2358-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2359" : helpers.makeTestYear("Australia/Yancowinna", [
		["2359-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2359-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2359-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2359-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2360" : helpers.makeTestYear("Australia/Yancowinna", [
		["2360-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2360-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2360-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2360-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2361" : helpers.makeTestYear("Australia/Yancowinna", [
		["2361-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2361-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2361-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2361-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2362" : helpers.makeTestYear("Australia/Yancowinna", [
		["2362-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2362-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2362-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2362-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2363" : helpers.makeTestYear("Australia/Yancowinna", [
		["2363-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2363-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2363-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2363-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2364" : helpers.makeTestYear("Australia/Yancowinna", [
		["2364-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2364-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2364-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2364-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2365" : helpers.makeTestYear("Australia/Yancowinna", [
		["2365-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2365-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2365-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2365-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2366" : helpers.makeTestYear("Australia/Yancowinna", [
		["2366-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2366-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2366-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2366-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2367" : helpers.makeTestYear("Australia/Yancowinna", [
		["2367-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2367-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2367-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2367-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2368" : helpers.makeTestYear("Australia/Yancowinna", [
		["2368-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2368-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2368-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2368-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2369" : helpers.makeTestYear("Australia/Yancowinna", [
		["2369-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2369-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2369-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2369-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2370" : helpers.makeTestYear("Australia/Yancowinna", [
		["2370-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2370-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2370-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2370-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2371" : helpers.makeTestYear("Australia/Yancowinna", [
		["2371-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2371-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2371-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2371-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2372" : helpers.makeTestYear("Australia/Yancowinna", [
		["2372-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2372-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2372-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2372-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2373" : helpers.makeTestYear("Australia/Yancowinna", [
		["2373-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2373-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2373-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2373-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2374" : helpers.makeTestYear("Australia/Yancowinna", [
		["2374-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2374-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2374-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2374-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2375" : helpers.makeTestYear("Australia/Yancowinna", [
		["2375-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2375-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2375-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2375-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2376" : helpers.makeTestYear("Australia/Yancowinna", [
		["2376-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2376-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2376-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2376-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2377" : helpers.makeTestYear("Australia/Yancowinna", [
		["2377-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2377-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2377-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2377-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2378" : helpers.makeTestYear("Australia/Yancowinna", [
		["2378-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2378-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2378-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2378-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2379" : helpers.makeTestYear("Australia/Yancowinna", [
		["2379-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2379-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2379-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2379-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2380" : helpers.makeTestYear("Australia/Yancowinna", [
		["2380-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2380-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2380-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2380-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2381" : helpers.makeTestYear("Australia/Yancowinna", [
		["2381-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2381-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2381-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2381-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2382" : helpers.makeTestYear("Australia/Yancowinna", [
		["2382-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2382-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2382-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2382-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2383" : helpers.makeTestYear("Australia/Yancowinna", [
		["2383-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2383-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2383-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2383-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2384" : helpers.makeTestYear("Australia/Yancowinna", [
		["2384-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2384-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2384-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2384-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2385" : helpers.makeTestYear("Australia/Yancowinna", [
		["2385-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2385-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2385-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2385-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2386" : helpers.makeTestYear("Australia/Yancowinna", [
		["2386-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2386-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2386-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2386-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2387" : helpers.makeTestYear("Australia/Yancowinna", [
		["2387-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2387-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2387-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2387-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2388" : helpers.makeTestYear("Australia/Yancowinna", [
		["2388-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2388-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2388-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2388-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2389" : helpers.makeTestYear("Australia/Yancowinna", [
		["2389-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2389-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2389-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2389-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2390" : helpers.makeTestYear("Australia/Yancowinna", [
		["2390-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2390-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2390-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2390-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2391" : helpers.makeTestYear("Australia/Yancowinna", [
		["2391-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2391-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2391-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2391-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2392" : helpers.makeTestYear("Australia/Yancowinna", [
		["2392-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2392-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2392-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2392-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2393" : helpers.makeTestYear("Australia/Yancowinna", [
		["2393-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2393-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2393-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2393-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2394" : helpers.makeTestYear("Australia/Yancowinna", [
		["2394-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2394-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2394-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2394-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2395" : helpers.makeTestYear("Australia/Yancowinna", [
		["2395-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2395-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2395-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2395-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2396" : helpers.makeTestYear("Australia/Yancowinna", [
		["2396-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2396-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2396-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2396-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2397" : helpers.makeTestYear("Australia/Yancowinna", [
		["2397-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2397-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2397-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2397-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2398" : helpers.makeTestYear("Australia/Yancowinna", [
		["2398-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2398-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2398-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2398-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2399" : helpers.makeTestYear("Australia/Yancowinna", [
		["2399-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2399-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2399-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2399-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2400" : helpers.makeTestYear("Australia/Yancowinna", [
		["2400-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2400-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2400-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2400-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2401" : helpers.makeTestYear("Australia/Yancowinna", [
		["2401-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2401-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2401-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2401-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2402" : helpers.makeTestYear("Australia/Yancowinna", [
		["2402-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2402-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2402-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2402-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2403" : helpers.makeTestYear("Australia/Yancowinna", [
		["2403-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2403-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2403-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2403-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2404" : helpers.makeTestYear("Australia/Yancowinna", [
		["2404-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2404-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2404-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2404-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2405" : helpers.makeTestYear("Australia/Yancowinna", [
		["2405-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2405-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2405-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2405-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2406" : helpers.makeTestYear("Australia/Yancowinna", [
		["2406-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2406-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2406-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2406-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2407" : helpers.makeTestYear("Australia/Yancowinna", [
		["2407-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2407-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2407-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2407-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2408" : helpers.makeTestYear("Australia/Yancowinna", [
		["2408-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2408-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2408-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2408-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2409" : helpers.makeTestYear("Australia/Yancowinna", [
		["2409-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2409-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2409-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2409-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2410" : helpers.makeTestYear("Australia/Yancowinna", [
		["2410-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2410-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2410-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2410-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2411" : helpers.makeTestYear("Australia/Yancowinna", [
		["2411-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2411-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2411-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2411-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2412" : helpers.makeTestYear("Australia/Yancowinna", [
		["2412-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2412-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2412-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2412-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2413" : helpers.makeTestYear("Australia/Yancowinna", [
		["2413-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2413-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2413-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2413-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2414" : helpers.makeTestYear("Australia/Yancowinna", [
		["2414-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2414-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2414-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2414-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2415" : helpers.makeTestYear("Australia/Yancowinna", [
		["2415-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2415-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2415-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2415-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2416" : helpers.makeTestYear("Australia/Yancowinna", [
		["2416-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2416-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2416-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2416-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2417" : helpers.makeTestYear("Australia/Yancowinna", [
		["2417-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2417-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2417-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2417-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2418" : helpers.makeTestYear("Australia/Yancowinna", [
		["2418-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2418-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2418-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2418-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2419" : helpers.makeTestYear("Australia/Yancowinna", [
		["2419-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2419-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2419-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2419-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2420" : helpers.makeTestYear("Australia/Yancowinna", [
		["2420-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2420-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2420-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2420-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2421" : helpers.makeTestYear("Australia/Yancowinna", [
		["2421-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2421-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2421-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2421-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2422" : helpers.makeTestYear("Australia/Yancowinna", [
		["2422-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2422-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2422-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2422-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2423" : helpers.makeTestYear("Australia/Yancowinna", [
		["2423-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2423-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2423-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2423-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2424" : helpers.makeTestYear("Australia/Yancowinna", [
		["2424-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2424-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2424-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2424-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2425" : helpers.makeTestYear("Australia/Yancowinna", [
		["2425-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2425-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2425-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2425-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2426" : helpers.makeTestYear("Australia/Yancowinna", [
		["2426-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2426-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2426-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2426-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2427" : helpers.makeTestYear("Australia/Yancowinna", [
		["2427-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2427-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2427-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2427-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2428" : helpers.makeTestYear("Australia/Yancowinna", [
		["2428-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2428-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2428-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2428-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2429" : helpers.makeTestYear("Australia/Yancowinna", [
		["2429-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2429-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2429-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2429-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2430" : helpers.makeTestYear("Australia/Yancowinna", [
		["2430-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2430-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2430-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2430-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2431" : helpers.makeTestYear("Australia/Yancowinna", [
		["2431-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2431-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2431-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2431-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2432" : helpers.makeTestYear("Australia/Yancowinna", [
		["2432-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2432-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2432-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2432-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2433" : helpers.makeTestYear("Australia/Yancowinna", [
		["2433-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2433-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2433-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2433-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2434" : helpers.makeTestYear("Australia/Yancowinna", [
		["2434-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2434-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2434-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2434-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2435" : helpers.makeTestYear("Australia/Yancowinna", [
		["2435-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2435-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2435-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2435-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2436" : helpers.makeTestYear("Australia/Yancowinna", [
		["2436-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2436-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2436-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2436-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2437" : helpers.makeTestYear("Australia/Yancowinna", [
		["2437-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2437-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2437-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2437-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2438" : helpers.makeTestYear("Australia/Yancowinna", [
		["2438-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2438-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2438-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2438-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2439" : helpers.makeTestYear("Australia/Yancowinna", [
		["2439-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2439-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2439-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2439-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2440" : helpers.makeTestYear("Australia/Yancowinna", [
		["2440-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2440-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2440-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2440-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2441" : helpers.makeTestYear("Australia/Yancowinna", [
		["2441-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2441-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2441-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2441-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2442" : helpers.makeTestYear("Australia/Yancowinna", [
		["2442-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2442-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2442-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2442-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2443" : helpers.makeTestYear("Australia/Yancowinna", [
		["2443-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2443-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2443-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2443-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2444" : helpers.makeTestYear("Australia/Yancowinna", [
		["2444-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2444-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2444-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2444-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2445" : helpers.makeTestYear("Australia/Yancowinna", [
		["2445-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2445-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2445-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2445-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2446" : helpers.makeTestYear("Australia/Yancowinna", [
		["2446-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2446-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2446-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2446-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2447" : helpers.makeTestYear("Australia/Yancowinna", [
		["2447-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2447-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2447-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2447-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2448" : helpers.makeTestYear("Australia/Yancowinna", [
		["2448-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2448-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2448-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2448-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2449" : helpers.makeTestYear("Australia/Yancowinna", [
		["2449-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2449-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2449-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2449-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2450" : helpers.makeTestYear("Australia/Yancowinna", [
		["2450-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2450-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2450-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2450-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2451" : helpers.makeTestYear("Australia/Yancowinna", [
		["2451-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2451-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2451-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2451-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2452" : helpers.makeTestYear("Australia/Yancowinna", [
		["2452-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2452-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2452-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2452-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2453" : helpers.makeTestYear("Australia/Yancowinna", [
		["2453-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2453-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2453-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2453-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2454" : helpers.makeTestYear("Australia/Yancowinna", [
		["2454-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2454-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2454-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2454-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2455" : helpers.makeTestYear("Australia/Yancowinna", [
		["2455-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2455-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2455-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2455-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2456" : helpers.makeTestYear("Australia/Yancowinna", [
		["2456-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2456-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2456-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2456-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2457" : helpers.makeTestYear("Australia/Yancowinna", [
		["2457-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2457-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2457-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2457-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2458" : helpers.makeTestYear("Australia/Yancowinna", [
		["2458-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2458-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2458-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2458-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2459" : helpers.makeTestYear("Australia/Yancowinna", [
		["2459-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2459-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2459-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2459-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2460" : helpers.makeTestYear("Australia/Yancowinna", [
		["2460-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2460-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2460-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2460-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2461" : helpers.makeTestYear("Australia/Yancowinna", [
		["2461-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2461-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2461-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2461-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2462" : helpers.makeTestYear("Australia/Yancowinna", [
		["2462-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2462-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2462-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2462-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2463" : helpers.makeTestYear("Australia/Yancowinna", [
		["2463-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2463-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2463-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2463-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2464" : helpers.makeTestYear("Australia/Yancowinna", [
		["2464-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2464-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2464-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2464-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2465" : helpers.makeTestYear("Australia/Yancowinna", [
		["2465-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2465-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2465-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2465-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2466" : helpers.makeTestYear("Australia/Yancowinna", [
		["2466-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2466-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2466-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2466-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2467" : helpers.makeTestYear("Australia/Yancowinna", [
		["2467-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2467-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2467-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2467-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2468" : helpers.makeTestYear("Australia/Yancowinna", [
		["2468-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2468-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2468-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2468-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2469" : helpers.makeTestYear("Australia/Yancowinna", [
		["2469-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2469-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2469-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2469-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2470" : helpers.makeTestYear("Australia/Yancowinna", [
		["2470-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2470-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2470-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2470-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2471" : helpers.makeTestYear("Australia/Yancowinna", [
		["2471-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2471-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2471-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2471-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2472" : helpers.makeTestYear("Australia/Yancowinna", [
		["2472-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2472-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2472-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2472-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2473" : helpers.makeTestYear("Australia/Yancowinna", [
		["2473-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2473-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2473-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2473-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2474" : helpers.makeTestYear("Australia/Yancowinna", [
		["2474-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2474-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2474-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2474-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2475" : helpers.makeTestYear("Australia/Yancowinna", [
		["2475-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2475-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2475-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2475-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2476" : helpers.makeTestYear("Australia/Yancowinna", [
		["2476-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2476-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2476-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2476-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2477" : helpers.makeTestYear("Australia/Yancowinna", [
		["2477-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2477-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2477-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2477-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2478" : helpers.makeTestYear("Australia/Yancowinna", [
		["2478-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2478-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2478-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2478-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2479" : helpers.makeTestYear("Australia/Yancowinna", [
		["2479-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2479-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2479-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2479-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2480" : helpers.makeTestYear("Australia/Yancowinna", [
		["2480-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2480-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2480-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2480-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2481" : helpers.makeTestYear("Australia/Yancowinna", [
		["2481-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2481-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2481-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2481-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2482" : helpers.makeTestYear("Australia/Yancowinna", [
		["2482-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2482-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2482-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2482-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2483" : helpers.makeTestYear("Australia/Yancowinna", [
		["2483-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2483-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2483-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2483-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2484" : helpers.makeTestYear("Australia/Yancowinna", [
		["2484-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2484-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2484-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2484-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2485" : helpers.makeTestYear("Australia/Yancowinna", [
		["2485-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2485-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2485-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2485-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2486" : helpers.makeTestYear("Australia/Yancowinna", [
		["2486-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2486-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2486-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2486-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2487" : helpers.makeTestYear("Australia/Yancowinna", [
		["2487-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2487-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2487-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2487-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2488" : helpers.makeTestYear("Australia/Yancowinna", [
		["2488-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2488-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2488-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2488-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2489" : helpers.makeTestYear("Australia/Yancowinna", [
		["2489-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2489-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2489-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2489-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2490" : helpers.makeTestYear("Australia/Yancowinna", [
		["2490-04-01T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2490-04-01T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2490-09-30T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2490-09-30T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2491" : helpers.makeTestYear("Australia/Yancowinna", [
		["2491-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2491-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2491-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2491-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2492" : helpers.makeTestYear("Australia/Yancowinna", [
		["2492-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2492-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2492-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2492-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2493" : helpers.makeTestYear("Australia/Yancowinna", [
		["2493-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2493-04-04T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2493-10-03T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2493-10-03T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2494" : helpers.makeTestYear("Australia/Yancowinna", [
		["2494-04-03T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2494-04-03T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2494-10-02T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2494-10-02T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2495" : helpers.makeTestYear("Australia/Yancowinna", [
		["2495-04-02T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2495-04-02T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2495-10-01T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2495-10-01T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2496" : helpers.makeTestYear("Australia/Yancowinna", [
		["2496-03-31T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2496-03-31T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2496-10-06T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2496-10-06T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2497" : helpers.makeTestYear("Australia/Yancowinna", [
		["2497-04-06T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2497-04-06T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2497-10-05T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2497-10-05T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2498" : helpers.makeTestYear("Australia/Yancowinna", [
		["2498-04-05T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2498-04-05T16:30:00+00:00", "02:00:00", "ACST", -570],
		["2498-10-04T16:29:59+00:00", "01:59:59", "ACST", -570],
		["2498-10-04T16:30:00+00:00", "03:00:00", "ACDT", -630]
	]),

	"2499" : helpers.makeTestYear("Australia/Yancowinna", [
		["2499-04-04T16:29:59+00:00", "02:59:59", "ACDT", -630],
		["2499-04-04T16:30:00+00:00", "02:00:00", "ACST", -570]
	])
};