"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Asuncion"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Asuncion", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Asuncion", { abbr: true }),

	"1931" : helpers.makeTestYear("America/Asuncion", [
		["1931-10-10T03:50:39+00:00", "23:59:59", "AMT", 13840 / 60],
		["1931-10-10T03:50:40+00:00", "23:50:40", "-04", 240]
	]),

	"1972" : helpers.makeTestYear("America/Asuncion", [
		["1972-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1972-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1974" : helpers.makeTestYear("America/Asuncion", [
		["1974-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1974-04-01T03:00:00+00:00", "23:00:00", "-04", 240]
	]),

	"1975" : helpers.makeTestYear("America/Asuncion", [
		["1975-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1975-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1976" : helpers.makeTestYear("America/Asuncion", [
		["1976-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1976-03-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1976-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1976-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1977" : helpers.makeTestYear("America/Asuncion", [
		["1977-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1977-03-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1977-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1977-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1978" : helpers.makeTestYear("America/Asuncion", [
		["1978-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1978-03-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1978-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1978-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1979" : helpers.makeTestYear("America/Asuncion", [
		["1979-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1979-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1979-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1979-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1980" : helpers.makeTestYear("America/Asuncion", [
		["1980-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1980-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1980-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1980-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1981" : helpers.makeTestYear("America/Asuncion", [
		["1981-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1981-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1981-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1981-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1982" : helpers.makeTestYear("America/Asuncion", [
		["1982-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1982-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1982-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1982-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1983" : helpers.makeTestYear("America/Asuncion", [
		["1983-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1983-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1983-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1983-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1984" : helpers.makeTestYear("America/Asuncion", [
		["1984-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1984-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1984-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1984-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1985" : helpers.makeTestYear("America/Asuncion", [
		["1985-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1985-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1985-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1985-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1986" : helpers.makeTestYear("America/Asuncion", [
		["1986-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1986-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1986-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1986-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1987" : helpers.makeTestYear("America/Asuncion", [
		["1987-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1987-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1987-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1987-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1988" : helpers.makeTestYear("America/Asuncion", [
		["1988-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1988-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1988-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1988-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1989" : helpers.makeTestYear("America/Asuncion", [
		["1989-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1989-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1989-10-22T03:59:59+00:00", "23:59:59", "-04", 240],
		["1989-10-22T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1990" : helpers.makeTestYear("America/Asuncion", [
		["1990-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1990-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1990-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1990-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1991" : helpers.makeTestYear("America/Asuncion", [
		["1991-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1991-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1991-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["1991-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1992" : helpers.makeTestYear("America/Asuncion", [
		["1992-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1992-03-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1992-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["1992-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1993" : helpers.makeTestYear("America/Asuncion", [
		["1993-03-31T02:59:59+00:00", "23:59:59", "-03", 180],
		["1993-03-31T03:00:00+00:00", "23:00:00", "-04", 240],
		["1993-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1993-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1994" : helpers.makeTestYear("America/Asuncion", [
		["1994-02-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["1994-02-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["1994-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1994-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1995" : helpers.makeTestYear("America/Asuncion", [
		["1995-02-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["1995-02-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["1995-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1995-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1996" : helpers.makeTestYear("America/Asuncion", [
		["1996-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1996-03-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1996-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["1996-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1997" : helpers.makeTestYear("America/Asuncion", [
		["1997-02-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["1997-02-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["1997-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["1997-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1998" : helpers.makeTestYear("America/Asuncion", [
		["1998-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1998-03-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1998-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["1998-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1999" : helpers.makeTestYear("America/Asuncion", [
		["1999-03-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["1999-03-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["1999-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["1999-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2000" : helpers.makeTestYear("America/Asuncion", [
		["2000-03-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2000-03-05T03:00:00+00:00", "23:00:00", "-04", 240],
		["2000-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2000-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2001" : helpers.makeTestYear("America/Asuncion", [
		["2001-03-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2001-03-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2001-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2001-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2002" : helpers.makeTestYear("America/Asuncion", [
		["2002-04-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2002-04-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["2002-09-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2002-09-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2003" : helpers.makeTestYear("America/Asuncion", [
		["2003-04-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2003-04-06T03:00:00+00:00", "23:00:00", "-04", 240],
		["2003-09-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2003-09-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2004" : helpers.makeTestYear("America/Asuncion", [
		["2004-04-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2004-04-04T03:00:00+00:00", "23:00:00", "-04", 240],
		["2004-10-17T03:59:59+00:00", "23:59:59", "-04", 240],
		["2004-10-17T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2005" : helpers.makeTestYear("America/Asuncion", [
		["2005-03-13T02:59:59+00:00", "23:59:59", "-03", 180],
		["2005-03-13T03:00:00+00:00", "23:00:00", "-04", 240],
		["2005-10-16T03:59:59+00:00", "23:59:59", "-04", 240],
		["2005-10-16T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2006" : helpers.makeTestYear("America/Asuncion", [
		["2006-03-12T02:59:59+00:00", "23:59:59", "-03", 180],
		["2006-03-12T03:00:00+00:00", "23:00:00", "-04", 240],
		["2006-10-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["2006-10-15T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2007" : helpers.makeTestYear("America/Asuncion", [
		["2007-03-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["2007-03-11T03:00:00+00:00", "23:00:00", "-04", 240],
		["2007-10-21T03:59:59+00:00", "23:59:59", "-04", 240],
		["2007-10-21T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2008" : helpers.makeTestYear("America/Asuncion", [
		["2008-03-09T02:59:59+00:00", "23:59:59", "-03", 180],
		["2008-03-09T03:00:00+00:00", "23:00:00", "-04", 240],
		["2008-10-19T03:59:59+00:00", "23:59:59", "-04", 240],
		["2008-10-19T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2009" : helpers.makeTestYear("America/Asuncion", [
		["2009-03-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2009-03-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2009-10-18T03:59:59+00:00", "23:59:59", "-04", 240],
		["2009-10-18T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2010" : helpers.makeTestYear("America/Asuncion", [
		["2010-04-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["2010-04-11T03:00:00+00:00", "23:00:00", "-04", 240],
		["2010-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2010-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2011" : helpers.makeTestYear("America/Asuncion", [
		["2011-04-10T02:59:59+00:00", "23:59:59", "-03", 180],
		["2011-04-10T03:00:00+00:00", "23:00:00", "-04", 240],
		["2011-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2011-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2012" : helpers.makeTestYear("America/Asuncion", [
		["2012-04-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2012-04-08T03:00:00+00:00", "23:00:00", "-04", 240],
		["2012-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2012-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2013" : helpers.makeTestYear("America/Asuncion", [
		["2013-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2013-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2013-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2013-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2014" : helpers.makeTestYear("America/Asuncion", [
		["2014-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2014-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2014-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2014-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2015" : helpers.makeTestYear("America/Asuncion", [
		["2015-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2015-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2015-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2015-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2016" : helpers.makeTestYear("America/Asuncion", [
		["2016-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2016-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2016-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2016-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2017" : helpers.makeTestYear("America/Asuncion", [
		["2017-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2017-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2017-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2017-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2018" : helpers.makeTestYear("America/Asuncion", [
		["2018-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2018-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2018-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2018-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2019" : helpers.makeTestYear("America/Asuncion", [
		["2019-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2019-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2019-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2019-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2020" : helpers.makeTestYear("America/Asuncion", [
		["2020-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2020-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2020-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2020-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2021" : helpers.makeTestYear("America/Asuncion", [
		["2021-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2021-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2021-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2021-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2022" : helpers.makeTestYear("America/Asuncion", [
		["2022-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2022-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2022-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2022-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2023" : helpers.makeTestYear("America/Asuncion", [
		["2023-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2023-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2023-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2023-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2024" : helpers.makeTestYear("America/Asuncion", [
		["2024-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2024-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2024-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2024-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2025" : helpers.makeTestYear("America/Asuncion", [
		["2025-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2025-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2025-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2025-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2026" : helpers.makeTestYear("America/Asuncion", [
		["2026-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2026-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2026-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2026-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2027" : helpers.makeTestYear("America/Asuncion", [
		["2027-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2027-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2027-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2027-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2028" : helpers.makeTestYear("America/Asuncion", [
		["2028-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2028-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2028-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2028-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2029" : helpers.makeTestYear("America/Asuncion", [
		["2029-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2029-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2029-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2029-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2030" : helpers.makeTestYear("America/Asuncion", [
		["2030-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2030-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2030-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2030-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2031" : helpers.makeTestYear("America/Asuncion", [
		["2031-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2031-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2031-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2031-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2032" : helpers.makeTestYear("America/Asuncion", [
		["2032-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2032-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2032-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2032-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2033" : helpers.makeTestYear("America/Asuncion", [
		["2033-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2033-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2033-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2033-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2034" : helpers.makeTestYear("America/Asuncion", [
		["2034-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2034-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2034-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2034-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2035" : helpers.makeTestYear("America/Asuncion", [
		["2035-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2035-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2035-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2035-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2036" : helpers.makeTestYear("America/Asuncion", [
		["2036-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2036-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2036-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2036-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2037" : helpers.makeTestYear("America/Asuncion", [
		["2037-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2037-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2037-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2037-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2038" : helpers.makeTestYear("America/Asuncion", [
		["2038-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2038-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2038-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2038-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2039" : helpers.makeTestYear("America/Asuncion", [
		["2039-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2039-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2039-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2039-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2040" : helpers.makeTestYear("America/Asuncion", [
		["2040-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2040-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2040-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2040-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2041" : helpers.makeTestYear("America/Asuncion", [
		["2041-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2041-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2041-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2041-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2042" : helpers.makeTestYear("America/Asuncion", [
		["2042-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2042-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2042-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2042-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2043" : helpers.makeTestYear("America/Asuncion", [
		["2043-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2043-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2043-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2043-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2044" : helpers.makeTestYear("America/Asuncion", [
		["2044-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2044-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2044-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2044-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2045" : helpers.makeTestYear("America/Asuncion", [
		["2045-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2045-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2045-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2045-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2046" : helpers.makeTestYear("America/Asuncion", [
		["2046-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2046-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2046-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2046-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2047" : helpers.makeTestYear("America/Asuncion", [
		["2047-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2047-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2047-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2047-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2048" : helpers.makeTestYear("America/Asuncion", [
		["2048-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2048-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2048-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2048-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2049" : helpers.makeTestYear("America/Asuncion", [
		["2049-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2049-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2049-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2049-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2050" : helpers.makeTestYear("America/Asuncion", [
		["2050-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2050-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2050-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2050-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2051" : helpers.makeTestYear("America/Asuncion", [
		["2051-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2051-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2051-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2051-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2052" : helpers.makeTestYear("America/Asuncion", [
		["2052-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2052-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2052-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2052-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2053" : helpers.makeTestYear("America/Asuncion", [
		["2053-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2053-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2053-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2053-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2054" : helpers.makeTestYear("America/Asuncion", [
		["2054-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2054-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2054-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2054-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2055" : helpers.makeTestYear("America/Asuncion", [
		["2055-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2055-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2055-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2055-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2056" : helpers.makeTestYear("America/Asuncion", [
		["2056-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2056-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2056-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2056-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2057" : helpers.makeTestYear("America/Asuncion", [
		["2057-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2057-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2057-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2057-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2058" : helpers.makeTestYear("America/Asuncion", [
		["2058-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2058-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2058-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2058-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2059" : helpers.makeTestYear("America/Asuncion", [
		["2059-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2059-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2059-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2059-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2060" : helpers.makeTestYear("America/Asuncion", [
		["2060-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2060-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2060-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2060-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2061" : helpers.makeTestYear("America/Asuncion", [
		["2061-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2061-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2061-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2061-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2062" : helpers.makeTestYear("America/Asuncion", [
		["2062-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2062-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2062-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2062-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2063" : helpers.makeTestYear("America/Asuncion", [
		["2063-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2063-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2063-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2063-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2064" : helpers.makeTestYear("America/Asuncion", [
		["2064-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2064-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2064-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2064-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2065" : helpers.makeTestYear("America/Asuncion", [
		["2065-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2065-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2065-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2065-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2066" : helpers.makeTestYear("America/Asuncion", [
		["2066-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2066-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2066-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2066-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2067" : helpers.makeTestYear("America/Asuncion", [
		["2067-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2067-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2067-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2067-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2068" : helpers.makeTestYear("America/Asuncion", [
		["2068-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2068-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2068-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2068-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2069" : helpers.makeTestYear("America/Asuncion", [
		["2069-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2069-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2069-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2069-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2070" : helpers.makeTestYear("America/Asuncion", [
		["2070-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2070-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2070-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2070-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2071" : helpers.makeTestYear("America/Asuncion", [
		["2071-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2071-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2071-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2071-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2072" : helpers.makeTestYear("America/Asuncion", [
		["2072-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2072-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2072-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2072-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2073" : helpers.makeTestYear("America/Asuncion", [
		["2073-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2073-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2073-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2073-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2074" : helpers.makeTestYear("America/Asuncion", [
		["2074-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2074-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2074-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2074-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2075" : helpers.makeTestYear("America/Asuncion", [
		["2075-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2075-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2075-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2075-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2076" : helpers.makeTestYear("America/Asuncion", [
		["2076-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2076-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2076-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2076-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2077" : helpers.makeTestYear("America/Asuncion", [
		["2077-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2077-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2077-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2077-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2078" : helpers.makeTestYear("America/Asuncion", [
		["2078-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2078-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2078-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2078-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2079" : helpers.makeTestYear("America/Asuncion", [
		["2079-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2079-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2079-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2079-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2080" : helpers.makeTestYear("America/Asuncion", [
		["2080-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2080-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2080-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2080-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2081" : helpers.makeTestYear("America/Asuncion", [
		["2081-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2081-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2081-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2081-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2082" : helpers.makeTestYear("America/Asuncion", [
		["2082-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2082-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2082-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2082-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2083" : helpers.makeTestYear("America/Asuncion", [
		["2083-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2083-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2083-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2083-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2084" : helpers.makeTestYear("America/Asuncion", [
		["2084-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2084-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2084-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2084-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2085" : helpers.makeTestYear("America/Asuncion", [
		["2085-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2085-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2085-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2085-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2086" : helpers.makeTestYear("America/Asuncion", [
		["2086-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2086-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2086-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2086-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2087" : helpers.makeTestYear("America/Asuncion", [
		["2087-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2087-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2087-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2087-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2088" : helpers.makeTestYear("America/Asuncion", [
		["2088-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2088-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2088-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2088-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2089" : helpers.makeTestYear("America/Asuncion", [
		["2089-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2089-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2089-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2089-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2090" : helpers.makeTestYear("America/Asuncion", [
		["2090-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2090-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2090-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2090-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2091" : helpers.makeTestYear("America/Asuncion", [
		["2091-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2091-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2091-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2091-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2092" : helpers.makeTestYear("America/Asuncion", [
		["2092-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2092-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2092-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2092-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2093" : helpers.makeTestYear("America/Asuncion", [
		["2093-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2093-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2093-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2093-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2094" : helpers.makeTestYear("America/Asuncion", [
		["2094-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2094-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2094-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2094-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2095" : helpers.makeTestYear("America/Asuncion", [
		["2095-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2095-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2095-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2095-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2096" : helpers.makeTestYear("America/Asuncion", [
		["2096-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2096-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2096-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2096-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2097" : helpers.makeTestYear("America/Asuncion", [
		["2097-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2097-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2097-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2097-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2098" : helpers.makeTestYear("America/Asuncion", [
		["2098-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2098-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2098-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2098-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2099" : helpers.makeTestYear("America/Asuncion", [
		["2099-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2099-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2099-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2099-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2100" : helpers.makeTestYear("America/Asuncion", [
		["2100-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2100-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2100-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2100-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2101" : helpers.makeTestYear("America/Asuncion", [
		["2101-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2101-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2101-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2101-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2102" : helpers.makeTestYear("America/Asuncion", [
		["2102-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2102-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2102-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2102-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2103" : helpers.makeTestYear("America/Asuncion", [
		["2103-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2103-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2103-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2103-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2104" : helpers.makeTestYear("America/Asuncion", [
		["2104-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2104-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2104-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2104-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2105" : helpers.makeTestYear("America/Asuncion", [
		["2105-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2105-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2105-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2105-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2106" : helpers.makeTestYear("America/Asuncion", [
		["2106-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2106-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2106-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2106-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2107" : helpers.makeTestYear("America/Asuncion", [
		["2107-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2107-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2107-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2107-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2108" : helpers.makeTestYear("America/Asuncion", [
		["2108-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2108-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2108-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2108-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2109" : helpers.makeTestYear("America/Asuncion", [
		["2109-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2109-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2109-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2109-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2110" : helpers.makeTestYear("America/Asuncion", [
		["2110-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2110-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2110-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2110-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2111" : helpers.makeTestYear("America/Asuncion", [
		["2111-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2111-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2111-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2111-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2112" : helpers.makeTestYear("America/Asuncion", [
		["2112-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2112-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2112-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2112-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2113" : helpers.makeTestYear("America/Asuncion", [
		["2113-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2113-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2113-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2113-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2114" : helpers.makeTestYear("America/Asuncion", [
		["2114-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2114-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2114-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2114-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2115" : helpers.makeTestYear("America/Asuncion", [
		["2115-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2115-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2115-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2115-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2116" : helpers.makeTestYear("America/Asuncion", [
		["2116-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2116-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2116-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2116-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2117" : helpers.makeTestYear("America/Asuncion", [
		["2117-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2117-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2117-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2117-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2118" : helpers.makeTestYear("America/Asuncion", [
		["2118-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2118-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2118-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2118-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2119" : helpers.makeTestYear("America/Asuncion", [
		["2119-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2119-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2119-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2119-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2120" : helpers.makeTestYear("America/Asuncion", [
		["2120-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2120-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2120-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2120-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2121" : helpers.makeTestYear("America/Asuncion", [
		["2121-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2121-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2121-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2121-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2122" : helpers.makeTestYear("America/Asuncion", [
		["2122-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2122-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2122-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2122-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2123" : helpers.makeTestYear("America/Asuncion", [
		["2123-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2123-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2123-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2123-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2124" : helpers.makeTestYear("America/Asuncion", [
		["2124-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2124-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2124-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2124-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2125" : helpers.makeTestYear("America/Asuncion", [
		["2125-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2125-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2125-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2125-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2126" : helpers.makeTestYear("America/Asuncion", [
		["2126-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2126-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2126-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2126-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2127" : helpers.makeTestYear("America/Asuncion", [
		["2127-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2127-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2127-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2127-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2128" : helpers.makeTestYear("America/Asuncion", [
		["2128-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2128-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2128-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2128-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2129" : helpers.makeTestYear("America/Asuncion", [
		["2129-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2129-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2129-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2129-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2130" : helpers.makeTestYear("America/Asuncion", [
		["2130-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2130-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2130-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2130-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2131" : helpers.makeTestYear("America/Asuncion", [
		["2131-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2131-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2131-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2131-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2132" : helpers.makeTestYear("America/Asuncion", [
		["2132-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2132-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2132-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2132-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2133" : helpers.makeTestYear("America/Asuncion", [
		["2133-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2133-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2133-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2133-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2134" : helpers.makeTestYear("America/Asuncion", [
		["2134-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2134-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2134-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2134-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2135" : helpers.makeTestYear("America/Asuncion", [
		["2135-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2135-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2135-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2135-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2136" : helpers.makeTestYear("America/Asuncion", [
		["2136-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2136-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2136-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2136-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2137" : helpers.makeTestYear("America/Asuncion", [
		["2137-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2137-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2137-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2137-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2138" : helpers.makeTestYear("America/Asuncion", [
		["2138-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2138-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2138-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2138-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2139" : helpers.makeTestYear("America/Asuncion", [
		["2139-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2139-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2139-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2139-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2140" : helpers.makeTestYear("America/Asuncion", [
		["2140-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2140-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2140-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2140-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2141" : helpers.makeTestYear("America/Asuncion", [
		["2141-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2141-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2141-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2141-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2142" : helpers.makeTestYear("America/Asuncion", [
		["2142-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2142-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2142-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2142-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2143" : helpers.makeTestYear("America/Asuncion", [
		["2143-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2143-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2143-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2143-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2144" : helpers.makeTestYear("America/Asuncion", [
		["2144-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2144-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2144-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2144-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2145" : helpers.makeTestYear("America/Asuncion", [
		["2145-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2145-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2145-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2145-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2146" : helpers.makeTestYear("America/Asuncion", [
		["2146-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2146-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2146-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2146-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2147" : helpers.makeTestYear("America/Asuncion", [
		["2147-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2147-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2147-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2147-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2148" : helpers.makeTestYear("America/Asuncion", [
		["2148-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2148-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2148-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2148-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2149" : helpers.makeTestYear("America/Asuncion", [
		["2149-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2149-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2149-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2149-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2150" : helpers.makeTestYear("America/Asuncion", [
		["2150-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2150-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2150-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2150-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2151" : helpers.makeTestYear("America/Asuncion", [
		["2151-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2151-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2151-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2151-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2152" : helpers.makeTestYear("America/Asuncion", [
		["2152-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2152-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2152-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2152-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2153" : helpers.makeTestYear("America/Asuncion", [
		["2153-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2153-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2153-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2153-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2154" : helpers.makeTestYear("America/Asuncion", [
		["2154-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2154-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2154-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2154-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2155" : helpers.makeTestYear("America/Asuncion", [
		["2155-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2155-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2155-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2155-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2156" : helpers.makeTestYear("America/Asuncion", [
		["2156-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2156-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2156-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2156-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2157" : helpers.makeTestYear("America/Asuncion", [
		["2157-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2157-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2157-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2157-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2158" : helpers.makeTestYear("America/Asuncion", [
		["2158-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2158-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2158-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2158-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2159" : helpers.makeTestYear("America/Asuncion", [
		["2159-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2159-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2159-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2159-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2160" : helpers.makeTestYear("America/Asuncion", [
		["2160-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2160-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2160-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2160-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2161" : helpers.makeTestYear("America/Asuncion", [
		["2161-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2161-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2161-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2161-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2162" : helpers.makeTestYear("America/Asuncion", [
		["2162-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2162-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2162-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2162-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2163" : helpers.makeTestYear("America/Asuncion", [
		["2163-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2163-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2163-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2163-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2164" : helpers.makeTestYear("America/Asuncion", [
		["2164-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2164-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2164-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2164-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2165" : helpers.makeTestYear("America/Asuncion", [
		["2165-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2165-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2165-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2165-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2166" : helpers.makeTestYear("America/Asuncion", [
		["2166-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2166-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2166-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2166-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2167" : helpers.makeTestYear("America/Asuncion", [
		["2167-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2167-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2167-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2167-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2168" : helpers.makeTestYear("America/Asuncion", [
		["2168-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2168-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2168-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2168-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2169" : helpers.makeTestYear("America/Asuncion", [
		["2169-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2169-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2169-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2169-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2170" : helpers.makeTestYear("America/Asuncion", [
		["2170-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2170-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2170-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2170-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2171" : helpers.makeTestYear("America/Asuncion", [
		["2171-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2171-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2171-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2171-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2172" : helpers.makeTestYear("America/Asuncion", [
		["2172-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2172-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2172-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2172-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2173" : helpers.makeTestYear("America/Asuncion", [
		["2173-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2173-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2173-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2173-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2174" : helpers.makeTestYear("America/Asuncion", [
		["2174-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2174-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2174-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2174-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2175" : helpers.makeTestYear("America/Asuncion", [
		["2175-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2175-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2175-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2175-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2176" : helpers.makeTestYear("America/Asuncion", [
		["2176-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2176-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2176-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2176-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2177" : helpers.makeTestYear("America/Asuncion", [
		["2177-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2177-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2177-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2177-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2178" : helpers.makeTestYear("America/Asuncion", [
		["2178-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2178-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2178-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2178-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2179" : helpers.makeTestYear("America/Asuncion", [
		["2179-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2179-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2179-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2179-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2180" : helpers.makeTestYear("America/Asuncion", [
		["2180-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2180-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2180-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2180-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2181" : helpers.makeTestYear("America/Asuncion", [
		["2181-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2181-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2181-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2181-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2182" : helpers.makeTestYear("America/Asuncion", [
		["2182-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2182-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2182-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2182-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2183" : helpers.makeTestYear("America/Asuncion", [
		["2183-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2183-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2183-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2183-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2184" : helpers.makeTestYear("America/Asuncion", [
		["2184-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2184-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2184-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2184-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2185" : helpers.makeTestYear("America/Asuncion", [
		["2185-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2185-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2185-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2185-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2186" : helpers.makeTestYear("America/Asuncion", [
		["2186-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2186-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2186-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2186-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2187" : helpers.makeTestYear("America/Asuncion", [
		["2187-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2187-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2187-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2187-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2188" : helpers.makeTestYear("America/Asuncion", [
		["2188-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2188-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2188-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2188-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2189" : helpers.makeTestYear("America/Asuncion", [
		["2189-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2189-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2189-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2189-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2190" : helpers.makeTestYear("America/Asuncion", [
		["2190-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2190-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2190-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2190-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2191" : helpers.makeTestYear("America/Asuncion", [
		["2191-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2191-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2191-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2191-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2192" : helpers.makeTestYear("America/Asuncion", [
		["2192-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2192-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2192-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2192-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2193" : helpers.makeTestYear("America/Asuncion", [
		["2193-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2193-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2193-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2193-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2194" : helpers.makeTestYear("America/Asuncion", [
		["2194-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2194-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2194-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2194-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2195" : helpers.makeTestYear("America/Asuncion", [
		["2195-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2195-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2195-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2195-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2196" : helpers.makeTestYear("America/Asuncion", [
		["2196-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2196-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2196-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2196-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2197" : helpers.makeTestYear("America/Asuncion", [
		["2197-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2197-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2197-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2197-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2198" : helpers.makeTestYear("America/Asuncion", [
		["2198-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2198-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2198-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2198-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2199" : helpers.makeTestYear("America/Asuncion", [
		["2199-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2199-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2199-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2199-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2200" : helpers.makeTestYear("America/Asuncion", [
		["2200-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2200-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2200-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2200-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2201" : helpers.makeTestYear("America/Asuncion", [
		["2201-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2201-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2201-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2201-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2202" : helpers.makeTestYear("America/Asuncion", [
		["2202-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2202-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2202-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2202-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2203" : helpers.makeTestYear("America/Asuncion", [
		["2203-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2203-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2203-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2203-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2204" : helpers.makeTestYear("America/Asuncion", [
		["2204-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2204-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2204-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2204-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2205" : helpers.makeTestYear("America/Asuncion", [
		["2205-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2205-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2205-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2205-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2206" : helpers.makeTestYear("America/Asuncion", [
		["2206-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2206-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2206-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2206-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2207" : helpers.makeTestYear("America/Asuncion", [
		["2207-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2207-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2207-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2207-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2208" : helpers.makeTestYear("America/Asuncion", [
		["2208-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2208-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2208-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2208-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2209" : helpers.makeTestYear("America/Asuncion", [
		["2209-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2209-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2209-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2209-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2210" : helpers.makeTestYear("America/Asuncion", [
		["2210-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2210-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2210-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2210-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2211" : helpers.makeTestYear("America/Asuncion", [
		["2211-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2211-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2211-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2211-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2212" : helpers.makeTestYear("America/Asuncion", [
		["2212-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2212-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2212-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2212-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2213" : helpers.makeTestYear("America/Asuncion", [
		["2213-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2213-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2213-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2213-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2214" : helpers.makeTestYear("America/Asuncion", [
		["2214-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2214-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2214-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2214-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2215" : helpers.makeTestYear("America/Asuncion", [
		["2215-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2215-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2215-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2215-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2216" : helpers.makeTestYear("America/Asuncion", [
		["2216-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2216-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2216-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2216-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2217" : helpers.makeTestYear("America/Asuncion", [
		["2217-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2217-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2217-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2217-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2218" : helpers.makeTestYear("America/Asuncion", [
		["2218-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2218-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2218-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2218-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2219" : helpers.makeTestYear("America/Asuncion", [
		["2219-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2219-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2219-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2219-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2220" : helpers.makeTestYear("America/Asuncion", [
		["2220-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2220-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2220-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2220-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2221" : helpers.makeTestYear("America/Asuncion", [
		["2221-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2221-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2221-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2221-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2222" : helpers.makeTestYear("America/Asuncion", [
		["2222-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2222-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2222-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2222-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2223" : helpers.makeTestYear("America/Asuncion", [
		["2223-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2223-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2223-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2223-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2224" : helpers.makeTestYear("America/Asuncion", [
		["2224-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2224-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2224-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2224-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2225" : helpers.makeTestYear("America/Asuncion", [
		["2225-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2225-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2225-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2225-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2226" : helpers.makeTestYear("America/Asuncion", [
		["2226-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2226-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2226-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2226-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2227" : helpers.makeTestYear("America/Asuncion", [
		["2227-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2227-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2227-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2227-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2228" : helpers.makeTestYear("America/Asuncion", [
		["2228-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2228-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2228-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2228-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2229" : helpers.makeTestYear("America/Asuncion", [
		["2229-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2229-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2229-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2229-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2230" : helpers.makeTestYear("America/Asuncion", [
		["2230-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2230-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2230-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2230-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2231" : helpers.makeTestYear("America/Asuncion", [
		["2231-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2231-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2231-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2231-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2232" : helpers.makeTestYear("America/Asuncion", [
		["2232-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2232-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2232-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2232-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2233" : helpers.makeTestYear("America/Asuncion", [
		["2233-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2233-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2233-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2233-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2234" : helpers.makeTestYear("America/Asuncion", [
		["2234-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2234-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2234-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2234-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2235" : helpers.makeTestYear("America/Asuncion", [
		["2235-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2235-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2235-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2235-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2236" : helpers.makeTestYear("America/Asuncion", [
		["2236-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2236-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2236-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2236-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2237" : helpers.makeTestYear("America/Asuncion", [
		["2237-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2237-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2237-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2237-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2238" : helpers.makeTestYear("America/Asuncion", [
		["2238-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2238-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2238-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2238-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2239" : helpers.makeTestYear("America/Asuncion", [
		["2239-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2239-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2239-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2239-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2240" : helpers.makeTestYear("America/Asuncion", [
		["2240-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2240-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2240-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2240-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2241" : helpers.makeTestYear("America/Asuncion", [
		["2241-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2241-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2241-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2241-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2242" : helpers.makeTestYear("America/Asuncion", [
		["2242-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2242-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2242-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2242-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2243" : helpers.makeTestYear("America/Asuncion", [
		["2243-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2243-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2243-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2243-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2244" : helpers.makeTestYear("America/Asuncion", [
		["2244-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2244-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2244-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2244-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2245" : helpers.makeTestYear("America/Asuncion", [
		["2245-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2245-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2245-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2245-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2246" : helpers.makeTestYear("America/Asuncion", [
		["2246-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2246-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2246-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2246-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2247" : helpers.makeTestYear("America/Asuncion", [
		["2247-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2247-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2247-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2247-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2248" : helpers.makeTestYear("America/Asuncion", [
		["2248-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2248-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2248-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2248-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2249" : helpers.makeTestYear("America/Asuncion", [
		["2249-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2249-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2249-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2249-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2250" : helpers.makeTestYear("America/Asuncion", [
		["2250-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2250-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2250-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2250-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2251" : helpers.makeTestYear("America/Asuncion", [
		["2251-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2251-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2251-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2251-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2252" : helpers.makeTestYear("America/Asuncion", [
		["2252-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2252-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2252-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2252-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2253" : helpers.makeTestYear("America/Asuncion", [
		["2253-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2253-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2253-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2253-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2254" : helpers.makeTestYear("America/Asuncion", [
		["2254-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2254-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2254-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2254-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2255" : helpers.makeTestYear("America/Asuncion", [
		["2255-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2255-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2255-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2255-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2256" : helpers.makeTestYear("America/Asuncion", [
		["2256-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2256-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2256-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2256-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2257" : helpers.makeTestYear("America/Asuncion", [
		["2257-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2257-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2257-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2257-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2258" : helpers.makeTestYear("America/Asuncion", [
		["2258-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2258-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2258-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2258-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2259" : helpers.makeTestYear("America/Asuncion", [
		["2259-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2259-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2259-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2259-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2260" : helpers.makeTestYear("America/Asuncion", [
		["2260-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2260-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2260-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2260-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2261" : helpers.makeTestYear("America/Asuncion", [
		["2261-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2261-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2261-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2261-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2262" : helpers.makeTestYear("America/Asuncion", [
		["2262-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2262-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2262-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2262-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2263" : helpers.makeTestYear("America/Asuncion", [
		["2263-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2263-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2263-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2263-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2264" : helpers.makeTestYear("America/Asuncion", [
		["2264-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2264-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2264-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2264-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2265" : helpers.makeTestYear("America/Asuncion", [
		["2265-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2265-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2265-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2265-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2266" : helpers.makeTestYear("America/Asuncion", [
		["2266-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2266-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2266-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2266-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2267" : helpers.makeTestYear("America/Asuncion", [
		["2267-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2267-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2267-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2267-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2268" : helpers.makeTestYear("America/Asuncion", [
		["2268-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2268-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2268-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2268-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2269" : helpers.makeTestYear("America/Asuncion", [
		["2269-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2269-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2269-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2269-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2270" : helpers.makeTestYear("America/Asuncion", [
		["2270-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2270-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2270-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2270-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2271" : helpers.makeTestYear("America/Asuncion", [
		["2271-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2271-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2271-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2271-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2272" : helpers.makeTestYear("America/Asuncion", [
		["2272-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2272-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2272-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2272-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2273" : helpers.makeTestYear("America/Asuncion", [
		["2273-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2273-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2273-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2273-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2274" : helpers.makeTestYear("America/Asuncion", [
		["2274-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2274-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2274-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2274-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2275" : helpers.makeTestYear("America/Asuncion", [
		["2275-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2275-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2275-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2275-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2276" : helpers.makeTestYear("America/Asuncion", [
		["2276-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2276-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2276-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2276-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2277" : helpers.makeTestYear("America/Asuncion", [
		["2277-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2277-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2277-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2277-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2278" : helpers.makeTestYear("America/Asuncion", [
		["2278-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2278-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2278-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2278-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2279" : helpers.makeTestYear("America/Asuncion", [
		["2279-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2279-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2279-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2279-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2280" : helpers.makeTestYear("America/Asuncion", [
		["2280-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2280-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2280-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2280-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2281" : helpers.makeTestYear("America/Asuncion", [
		["2281-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2281-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2281-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2281-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2282" : helpers.makeTestYear("America/Asuncion", [
		["2282-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2282-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2282-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2282-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2283" : helpers.makeTestYear("America/Asuncion", [
		["2283-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2283-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2283-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2283-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2284" : helpers.makeTestYear("America/Asuncion", [
		["2284-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2284-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2284-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2284-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2285" : helpers.makeTestYear("America/Asuncion", [
		["2285-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2285-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2285-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2285-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2286" : helpers.makeTestYear("America/Asuncion", [
		["2286-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2286-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2286-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2286-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2287" : helpers.makeTestYear("America/Asuncion", [
		["2287-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2287-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2287-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2287-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2288" : helpers.makeTestYear("America/Asuncion", [
		["2288-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2288-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2288-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2288-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2289" : helpers.makeTestYear("America/Asuncion", [
		["2289-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2289-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2289-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2289-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2290" : helpers.makeTestYear("America/Asuncion", [
		["2290-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2290-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2290-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2290-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2291" : helpers.makeTestYear("America/Asuncion", [
		["2291-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2291-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2291-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2291-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2292" : helpers.makeTestYear("America/Asuncion", [
		["2292-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2292-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2292-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2292-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2293" : helpers.makeTestYear("America/Asuncion", [
		["2293-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2293-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2293-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2293-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2294" : helpers.makeTestYear("America/Asuncion", [
		["2294-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2294-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2294-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2294-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2295" : helpers.makeTestYear("America/Asuncion", [
		["2295-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2295-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2295-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2295-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2296" : helpers.makeTestYear("America/Asuncion", [
		["2296-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2296-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2296-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2296-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2297" : helpers.makeTestYear("America/Asuncion", [
		["2297-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2297-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2297-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2297-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2298" : helpers.makeTestYear("America/Asuncion", [
		["2298-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2298-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2298-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2298-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2299" : helpers.makeTestYear("America/Asuncion", [
		["2299-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2299-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2299-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2299-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2300" : helpers.makeTestYear("America/Asuncion", [
		["2300-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2300-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2300-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2300-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2301" : helpers.makeTestYear("America/Asuncion", [
		["2301-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2301-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2301-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2301-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2302" : helpers.makeTestYear("America/Asuncion", [
		["2302-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2302-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2302-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2302-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2303" : helpers.makeTestYear("America/Asuncion", [
		["2303-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2303-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2303-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2303-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2304" : helpers.makeTestYear("America/Asuncion", [
		["2304-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2304-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2304-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2304-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2305" : helpers.makeTestYear("America/Asuncion", [
		["2305-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2305-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2305-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2305-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2306" : helpers.makeTestYear("America/Asuncion", [
		["2306-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2306-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2306-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2306-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2307" : helpers.makeTestYear("America/Asuncion", [
		["2307-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2307-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2307-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2307-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2308" : helpers.makeTestYear("America/Asuncion", [
		["2308-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2308-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2308-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2308-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2309" : helpers.makeTestYear("America/Asuncion", [
		["2309-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2309-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2309-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2309-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2310" : helpers.makeTestYear("America/Asuncion", [
		["2310-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2310-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2310-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2310-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2311" : helpers.makeTestYear("America/Asuncion", [
		["2311-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2311-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2311-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2311-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2312" : helpers.makeTestYear("America/Asuncion", [
		["2312-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2312-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2312-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2312-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2313" : helpers.makeTestYear("America/Asuncion", [
		["2313-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2313-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2313-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2313-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2314" : helpers.makeTestYear("America/Asuncion", [
		["2314-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2314-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2314-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2314-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2315" : helpers.makeTestYear("America/Asuncion", [
		["2315-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2315-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2315-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2315-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2316" : helpers.makeTestYear("America/Asuncion", [
		["2316-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2316-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2316-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2316-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2317" : helpers.makeTestYear("America/Asuncion", [
		["2317-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2317-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2317-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2317-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2318" : helpers.makeTestYear("America/Asuncion", [
		["2318-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2318-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2318-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2318-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2319" : helpers.makeTestYear("America/Asuncion", [
		["2319-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2319-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2319-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2319-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2320" : helpers.makeTestYear("America/Asuncion", [
		["2320-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2320-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2320-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2320-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2321" : helpers.makeTestYear("America/Asuncion", [
		["2321-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2321-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2321-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2321-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2322" : helpers.makeTestYear("America/Asuncion", [
		["2322-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2322-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2322-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2322-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2323" : helpers.makeTestYear("America/Asuncion", [
		["2323-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2323-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2323-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2323-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2324" : helpers.makeTestYear("America/Asuncion", [
		["2324-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2324-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2324-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2324-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2325" : helpers.makeTestYear("America/Asuncion", [
		["2325-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2325-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2325-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2325-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2326" : helpers.makeTestYear("America/Asuncion", [
		["2326-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2326-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2326-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2326-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2327" : helpers.makeTestYear("America/Asuncion", [
		["2327-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2327-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2327-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2327-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2328" : helpers.makeTestYear("America/Asuncion", [
		["2328-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2328-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2328-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2328-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2329" : helpers.makeTestYear("America/Asuncion", [
		["2329-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2329-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2329-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2329-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2330" : helpers.makeTestYear("America/Asuncion", [
		["2330-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2330-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2330-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2330-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2331" : helpers.makeTestYear("America/Asuncion", [
		["2331-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2331-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2331-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2331-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2332" : helpers.makeTestYear("America/Asuncion", [
		["2332-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2332-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2332-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2332-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2333" : helpers.makeTestYear("America/Asuncion", [
		["2333-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2333-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2333-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2333-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2334" : helpers.makeTestYear("America/Asuncion", [
		["2334-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2334-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2334-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2334-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2335" : helpers.makeTestYear("America/Asuncion", [
		["2335-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2335-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2335-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2335-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2336" : helpers.makeTestYear("America/Asuncion", [
		["2336-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2336-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2336-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2336-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2337" : helpers.makeTestYear("America/Asuncion", [
		["2337-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2337-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2337-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2337-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2338" : helpers.makeTestYear("America/Asuncion", [
		["2338-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2338-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2338-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2338-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2339" : helpers.makeTestYear("America/Asuncion", [
		["2339-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2339-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2339-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2339-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2340" : helpers.makeTestYear("America/Asuncion", [
		["2340-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2340-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2340-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2340-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2341" : helpers.makeTestYear("America/Asuncion", [
		["2341-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2341-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2341-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2341-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2342" : helpers.makeTestYear("America/Asuncion", [
		["2342-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2342-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2342-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2342-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2343" : helpers.makeTestYear("America/Asuncion", [
		["2343-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2343-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2343-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2343-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2344" : helpers.makeTestYear("America/Asuncion", [
		["2344-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2344-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2344-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2344-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2345" : helpers.makeTestYear("America/Asuncion", [
		["2345-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2345-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2345-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2345-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2346" : helpers.makeTestYear("America/Asuncion", [
		["2346-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2346-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2346-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2346-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2347" : helpers.makeTestYear("America/Asuncion", [
		["2347-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2347-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2347-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2347-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2348" : helpers.makeTestYear("America/Asuncion", [
		["2348-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2348-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2348-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2348-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2349" : helpers.makeTestYear("America/Asuncion", [
		["2349-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2349-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2349-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2349-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2350" : helpers.makeTestYear("America/Asuncion", [
		["2350-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2350-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2350-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2350-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2351" : helpers.makeTestYear("America/Asuncion", [
		["2351-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2351-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2351-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2351-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2352" : helpers.makeTestYear("America/Asuncion", [
		["2352-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2352-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2352-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2352-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2353" : helpers.makeTestYear("America/Asuncion", [
		["2353-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2353-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2353-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2353-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2354" : helpers.makeTestYear("America/Asuncion", [
		["2354-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2354-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2354-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2354-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2355" : helpers.makeTestYear("America/Asuncion", [
		["2355-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2355-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2355-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2355-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2356" : helpers.makeTestYear("America/Asuncion", [
		["2356-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2356-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2356-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2356-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2357" : helpers.makeTestYear("America/Asuncion", [
		["2357-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2357-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2357-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2357-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2358" : helpers.makeTestYear("America/Asuncion", [
		["2358-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2358-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2358-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2358-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2359" : helpers.makeTestYear("America/Asuncion", [
		["2359-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2359-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2359-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2359-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2360" : helpers.makeTestYear("America/Asuncion", [
		["2360-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2360-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2360-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2360-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2361" : helpers.makeTestYear("America/Asuncion", [
		["2361-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2361-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2361-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2361-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2362" : helpers.makeTestYear("America/Asuncion", [
		["2362-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2362-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2362-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2362-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2363" : helpers.makeTestYear("America/Asuncion", [
		["2363-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2363-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2363-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2363-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2364" : helpers.makeTestYear("America/Asuncion", [
		["2364-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2364-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2364-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2364-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2365" : helpers.makeTestYear("America/Asuncion", [
		["2365-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2365-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2365-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2365-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2366" : helpers.makeTestYear("America/Asuncion", [
		["2366-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2366-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2366-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2366-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2367" : helpers.makeTestYear("America/Asuncion", [
		["2367-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2367-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2367-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2367-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2368" : helpers.makeTestYear("America/Asuncion", [
		["2368-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2368-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2368-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2368-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2369" : helpers.makeTestYear("America/Asuncion", [
		["2369-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2369-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2369-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2369-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2370" : helpers.makeTestYear("America/Asuncion", [
		["2370-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2370-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2370-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2370-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2371" : helpers.makeTestYear("America/Asuncion", [
		["2371-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2371-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2371-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2371-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2372" : helpers.makeTestYear("America/Asuncion", [
		["2372-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2372-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2372-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2372-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2373" : helpers.makeTestYear("America/Asuncion", [
		["2373-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2373-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2373-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2373-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2374" : helpers.makeTestYear("America/Asuncion", [
		["2374-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2374-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2374-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2374-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2375" : helpers.makeTestYear("America/Asuncion", [
		["2375-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2375-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2375-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2375-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2376" : helpers.makeTestYear("America/Asuncion", [
		["2376-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2376-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2376-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2376-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2377" : helpers.makeTestYear("America/Asuncion", [
		["2377-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2377-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2377-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2377-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2378" : helpers.makeTestYear("America/Asuncion", [
		["2378-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2378-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2378-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2378-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2379" : helpers.makeTestYear("America/Asuncion", [
		["2379-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2379-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2379-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2379-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2380" : helpers.makeTestYear("America/Asuncion", [
		["2380-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2380-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2380-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2380-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2381" : helpers.makeTestYear("America/Asuncion", [
		["2381-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2381-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2381-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2381-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2382" : helpers.makeTestYear("America/Asuncion", [
		["2382-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2382-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2382-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2382-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2383" : helpers.makeTestYear("America/Asuncion", [
		["2383-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2383-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2383-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2383-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2384" : helpers.makeTestYear("America/Asuncion", [
		["2384-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2384-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2384-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2384-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2385" : helpers.makeTestYear("America/Asuncion", [
		["2385-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2385-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2385-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2385-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2386" : helpers.makeTestYear("America/Asuncion", [
		["2386-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2386-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2386-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2386-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2387" : helpers.makeTestYear("America/Asuncion", [
		["2387-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2387-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2387-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2387-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2388" : helpers.makeTestYear("America/Asuncion", [
		["2388-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2388-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2388-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2388-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2389" : helpers.makeTestYear("America/Asuncion", [
		["2389-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2389-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2389-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2389-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2390" : helpers.makeTestYear("America/Asuncion", [
		["2390-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2390-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2390-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2390-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2391" : helpers.makeTestYear("America/Asuncion", [
		["2391-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2391-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2391-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2391-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2392" : helpers.makeTestYear("America/Asuncion", [
		["2392-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2392-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2392-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2392-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2393" : helpers.makeTestYear("America/Asuncion", [
		["2393-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2393-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2393-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2393-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2394" : helpers.makeTestYear("America/Asuncion", [
		["2394-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2394-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2394-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2394-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2395" : helpers.makeTestYear("America/Asuncion", [
		["2395-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2395-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2395-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2395-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2396" : helpers.makeTestYear("America/Asuncion", [
		["2396-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2396-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2396-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2396-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2397" : helpers.makeTestYear("America/Asuncion", [
		["2397-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2397-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2397-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2397-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2398" : helpers.makeTestYear("America/Asuncion", [
		["2398-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2398-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2398-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2398-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2399" : helpers.makeTestYear("America/Asuncion", [
		["2399-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2399-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2399-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2399-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2400" : helpers.makeTestYear("America/Asuncion", [
		["2400-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2400-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2400-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2400-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2401" : helpers.makeTestYear("America/Asuncion", [
		["2401-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2401-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2401-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2401-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2402" : helpers.makeTestYear("America/Asuncion", [
		["2402-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2402-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2402-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2402-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2403" : helpers.makeTestYear("America/Asuncion", [
		["2403-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2403-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2403-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2403-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2404" : helpers.makeTestYear("America/Asuncion", [
		["2404-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2404-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2404-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2404-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2405" : helpers.makeTestYear("America/Asuncion", [
		["2405-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2405-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2405-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2405-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2406" : helpers.makeTestYear("America/Asuncion", [
		["2406-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2406-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2406-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2406-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2407" : helpers.makeTestYear("America/Asuncion", [
		["2407-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2407-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2407-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2407-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2408" : helpers.makeTestYear("America/Asuncion", [
		["2408-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2408-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2408-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2408-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2409" : helpers.makeTestYear("America/Asuncion", [
		["2409-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2409-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2409-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2409-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2410" : helpers.makeTestYear("America/Asuncion", [
		["2410-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2410-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2410-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2410-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2411" : helpers.makeTestYear("America/Asuncion", [
		["2411-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2411-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2411-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2411-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2412" : helpers.makeTestYear("America/Asuncion", [
		["2412-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2412-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2412-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2412-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2413" : helpers.makeTestYear("America/Asuncion", [
		["2413-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2413-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2413-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2413-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2414" : helpers.makeTestYear("America/Asuncion", [
		["2414-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2414-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2414-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2414-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2415" : helpers.makeTestYear("America/Asuncion", [
		["2415-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2415-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2415-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2415-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2416" : helpers.makeTestYear("America/Asuncion", [
		["2416-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2416-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2416-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2416-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2417" : helpers.makeTestYear("America/Asuncion", [
		["2417-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2417-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2417-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2417-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2418" : helpers.makeTestYear("America/Asuncion", [
		["2418-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2418-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2418-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2418-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2419" : helpers.makeTestYear("America/Asuncion", [
		["2419-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2419-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2419-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2419-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2420" : helpers.makeTestYear("America/Asuncion", [
		["2420-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2420-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2420-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2420-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2421" : helpers.makeTestYear("America/Asuncion", [
		["2421-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2421-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2421-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2421-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2422" : helpers.makeTestYear("America/Asuncion", [
		["2422-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2422-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2422-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2422-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2423" : helpers.makeTestYear("America/Asuncion", [
		["2423-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2423-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2423-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2423-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2424" : helpers.makeTestYear("America/Asuncion", [
		["2424-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2424-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2424-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2424-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2425" : helpers.makeTestYear("America/Asuncion", [
		["2425-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2425-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2425-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2425-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2426" : helpers.makeTestYear("America/Asuncion", [
		["2426-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2426-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2426-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2426-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2427" : helpers.makeTestYear("America/Asuncion", [
		["2427-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2427-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2427-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2427-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2428" : helpers.makeTestYear("America/Asuncion", [
		["2428-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2428-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2428-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2428-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2429" : helpers.makeTestYear("America/Asuncion", [
		["2429-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2429-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2429-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2429-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2430" : helpers.makeTestYear("America/Asuncion", [
		["2430-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2430-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2430-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2430-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2431" : helpers.makeTestYear("America/Asuncion", [
		["2431-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2431-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2431-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2431-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2432" : helpers.makeTestYear("America/Asuncion", [
		["2432-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2432-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2432-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2432-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2433" : helpers.makeTestYear("America/Asuncion", [
		["2433-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2433-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2433-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2433-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2434" : helpers.makeTestYear("America/Asuncion", [
		["2434-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2434-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2434-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2434-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2435" : helpers.makeTestYear("America/Asuncion", [
		["2435-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2435-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2435-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2435-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2436" : helpers.makeTestYear("America/Asuncion", [
		["2436-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2436-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2436-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2436-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2437" : helpers.makeTestYear("America/Asuncion", [
		["2437-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2437-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2437-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2437-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2438" : helpers.makeTestYear("America/Asuncion", [
		["2438-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2438-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2438-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2438-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2439" : helpers.makeTestYear("America/Asuncion", [
		["2439-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2439-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2439-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2439-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2440" : helpers.makeTestYear("America/Asuncion", [
		["2440-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2440-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2440-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2440-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2441" : helpers.makeTestYear("America/Asuncion", [
		["2441-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2441-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2441-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2441-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2442" : helpers.makeTestYear("America/Asuncion", [
		["2442-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2442-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2442-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2442-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2443" : helpers.makeTestYear("America/Asuncion", [
		["2443-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2443-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2443-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2443-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2444" : helpers.makeTestYear("America/Asuncion", [
		["2444-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2444-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2444-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2444-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2445" : helpers.makeTestYear("America/Asuncion", [
		["2445-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2445-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2445-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2445-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2446" : helpers.makeTestYear("America/Asuncion", [
		["2446-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2446-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2446-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2446-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2447" : helpers.makeTestYear("America/Asuncion", [
		["2447-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2447-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2447-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2447-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2448" : helpers.makeTestYear("America/Asuncion", [
		["2448-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2448-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2448-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2448-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2449" : helpers.makeTestYear("America/Asuncion", [
		["2449-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2449-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2449-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2449-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2450" : helpers.makeTestYear("America/Asuncion", [
		["2450-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2450-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2450-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2450-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2451" : helpers.makeTestYear("America/Asuncion", [
		["2451-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2451-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2451-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2451-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2452" : helpers.makeTestYear("America/Asuncion", [
		["2452-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2452-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2452-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2452-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2453" : helpers.makeTestYear("America/Asuncion", [
		["2453-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2453-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2453-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2453-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2454" : helpers.makeTestYear("America/Asuncion", [
		["2454-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2454-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2454-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2454-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2455" : helpers.makeTestYear("America/Asuncion", [
		["2455-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2455-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2455-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2455-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2456" : helpers.makeTestYear("America/Asuncion", [
		["2456-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2456-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2456-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2456-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2457" : helpers.makeTestYear("America/Asuncion", [
		["2457-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2457-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2457-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2457-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2458" : helpers.makeTestYear("America/Asuncion", [
		["2458-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2458-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2458-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2458-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2459" : helpers.makeTestYear("America/Asuncion", [
		["2459-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2459-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2459-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2459-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2460" : helpers.makeTestYear("America/Asuncion", [
		["2460-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2460-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2460-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2460-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2461" : helpers.makeTestYear("America/Asuncion", [
		["2461-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2461-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2461-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2461-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2462" : helpers.makeTestYear("America/Asuncion", [
		["2462-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2462-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2462-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2462-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2463" : helpers.makeTestYear("America/Asuncion", [
		["2463-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2463-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2463-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2463-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2464" : helpers.makeTestYear("America/Asuncion", [
		["2464-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2464-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2464-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2464-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2465" : helpers.makeTestYear("America/Asuncion", [
		["2465-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2465-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2465-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2465-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2466" : helpers.makeTestYear("America/Asuncion", [
		["2466-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2466-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2466-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2466-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2467" : helpers.makeTestYear("America/Asuncion", [
		["2467-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2467-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2467-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2467-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2468" : helpers.makeTestYear("America/Asuncion", [
		["2468-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2468-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2468-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2468-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2469" : helpers.makeTestYear("America/Asuncion", [
		["2469-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2469-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2469-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2469-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2470" : helpers.makeTestYear("America/Asuncion", [
		["2470-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2470-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2470-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2470-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2471" : helpers.makeTestYear("America/Asuncion", [
		["2471-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2471-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2471-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2471-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2472" : helpers.makeTestYear("America/Asuncion", [
		["2472-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2472-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2472-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2472-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2473" : helpers.makeTestYear("America/Asuncion", [
		["2473-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2473-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2473-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2473-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2474" : helpers.makeTestYear("America/Asuncion", [
		["2474-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2474-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2474-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2474-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2475" : helpers.makeTestYear("America/Asuncion", [
		["2475-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2475-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2475-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2475-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2476" : helpers.makeTestYear("America/Asuncion", [
		["2476-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2476-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2476-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2476-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2477" : helpers.makeTestYear("America/Asuncion", [
		["2477-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2477-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2477-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2477-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2478" : helpers.makeTestYear("America/Asuncion", [
		["2478-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2478-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2478-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2478-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2479" : helpers.makeTestYear("America/Asuncion", [
		["2479-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2479-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2479-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2479-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2480" : helpers.makeTestYear("America/Asuncion", [
		["2480-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2480-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2480-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2480-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2481" : helpers.makeTestYear("America/Asuncion", [
		["2481-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2481-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2481-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2481-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2482" : helpers.makeTestYear("America/Asuncion", [
		["2482-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2482-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2482-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2482-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2483" : helpers.makeTestYear("America/Asuncion", [
		["2483-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2483-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2483-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2483-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2484" : helpers.makeTestYear("America/Asuncion", [
		["2484-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2484-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2484-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2484-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2485" : helpers.makeTestYear("America/Asuncion", [
		["2485-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2485-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2485-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2485-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2486" : helpers.makeTestYear("America/Asuncion", [
		["2486-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2486-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2486-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2486-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2487" : helpers.makeTestYear("America/Asuncion", [
		["2487-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2487-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2487-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2487-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2488" : helpers.makeTestYear("America/Asuncion", [
		["2488-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2488-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2488-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2488-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2489" : helpers.makeTestYear("America/Asuncion", [
		["2489-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2489-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2489-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2489-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2490" : helpers.makeTestYear("America/Asuncion", [
		["2490-03-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2490-03-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2490-10-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2490-10-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2491" : helpers.makeTestYear("America/Asuncion", [
		["2491-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2491-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2491-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2491-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2492" : helpers.makeTestYear("America/Asuncion", [
		["2492-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2492-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2492-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2492-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2493" : helpers.makeTestYear("America/Asuncion", [
		["2493-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2493-03-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2493-10-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2493-10-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2494" : helpers.makeTestYear("America/Asuncion", [
		["2494-03-28T02:59:59+00:00", "23:59:59", "-03", 180],
		["2494-03-28T03:00:00+00:00", "23:00:00", "-04", 240],
		["2494-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2494-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2495" : helpers.makeTestYear("America/Asuncion", [
		["2495-03-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2495-03-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2495-10-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2495-10-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2496" : helpers.makeTestYear("America/Asuncion", [
		["2496-03-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2496-03-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2496-10-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2496-10-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2497" : helpers.makeTestYear("America/Asuncion", [
		["2497-03-24T02:59:59+00:00", "23:59:59", "-03", 180],
		["2497-03-24T03:00:00+00:00", "23:00:00", "-04", 240],
		["2497-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2497-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2498" : helpers.makeTestYear("America/Asuncion", [
		["2498-03-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["2498-03-23T03:00:00+00:00", "23:00:00", "-04", 240],
		["2498-10-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2498-10-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2499" : helpers.makeTestYear("America/Asuncion", [
		["2499-03-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2499-03-22T03:00:00+00:00", "23:00:00", "-04", 240]
	])
};