/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.parsing.impl;

import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;

import org.openide.util.Exceptions;


/**
 *
 * @author Jan Jancura
 */
public abstract class SchedulerAccessor {
    
    private static volatile SchedulerAccessor INSTANCE;    
    
    
    public static synchronized SchedulerAccessor get () {
        if (INSTANCE == null) {
            try {
                Class.forName ("org.netbeans.modules.parsing.api.Source", true, SourceAccessor.class.getClassLoader());   //NOI18N            
                assert INSTANCE != null;
            } catch (ClassNotFoundException e) {
                Exceptions.printStackTrace (e);
            }
        }
        return INSTANCE;
    }
    
    public static void set (SchedulerAccessor instance) {
        assert instance != null;
        INSTANCE = instance;
    }

    public abstract SchedulerEvent createSchedulerEvent (Scheduler scheduler, SourceModificationEvent event);
}
