# Joe's Own Editor Installation Instructions

## Typical Installation

	./configure --prefix=/usr --sysconfdir=/etc

		- executables in /usr/bin
		- man pages in /usr/man
		- configuration files in /etc/joe
		- syntax files in /usr/share/joe

	make

	sudo make install

For OS X, use:

	sudo LC_ALL=C make install

(This fixes an issue where sed on OS X is unhappy with binary files and will
be fixed in the next release of JOE.  If you tried 'make' without the
LC_ALL=C, you may have to delete the source distribution directory and start
over).

You may have to delete or update user custom configuration files (otherwise
new features will not work):

	rm ~/.joerc
	rm ~/.jmacsrc
	rm ~/.rjoerc
	rm ~/.jstarrc
	rm ~/.jpicorc

## Mercurial

### Developer checkout

	hg clone ssh://jhallen@hg.code.sf.net/p/joe-editor/mercurial joe-editor-mercurial

### Read-only checkout

	hg clone http://hg.code.sf.net/p/joe-editor/mercurial joe-editor-mercurial

### Update to the branch you want to build

	hg update -C default	Not yet released main-line branch

	hg update -C joe-3	Released branch for joe-3.x

### Run autotools to build configure scripts

	./autojoe

	(You might find that you need to install automake and autoconf
	first).

## Installation procedure

To create a Cygwin binary distribution, use the 'cygbuild' script
instead of these instructions.

JOE uses the GNU Automake and Autoconf suites to build itself.

Usually you want JOE to use the terminfo database. JOE needs
a termcap emulation library to do this.  In modern versions of
UNIX, this library is part of ncurses so you need the ncurses
library:

	apt-get install ncurses-dev

Run configure script, type one of these:

    Normal installation:

	./configure --prefix=/usr --sysconfdir=/etc

		- executables in /usr/bin
		- man pages in /usr/man
		- configuration files in /etc/joe
		- syntax files in /usr/share/joe

    Install into your home directory:

	./configure --prefix=$HOME

		- executables in ~/bin
		- man pages in ~/man
		- configuration files in ~/etc/joe
		- syntax files in ~/share/joe

    Install into /usr/local:

	./configure

		- executables in /usr/local/bin
		- man pages in /usr/local/man
		- configuration files in /usr/local/etc/joe
		- syntax files in /usr/local/share/joe

For Cygwin, I've found that you need to add
  "--disable-curses --disable-termcap" to the above commands.

Build JOE, type:

	make

Optionally strip JOE of debugging information:

	strip joe

Install JOE, type one of:

	sudo make install	(system installation)

	make install		(home directory)

Delete or update user custom configuration files (otherwise new features
will not work):

	rm ~/.joerc
	rm ~/.jmacsrc
	rm ~/.rjoerc
	rm ~/.jstarrc
	rm ~/.jpicorc
	rm -r ~/.joe

Try running JOE:

	joe

Note: please install xterm version 212 or higher, and use these
xterm 'configure' options:

	--enable-256-color

	--enable-paste64

'--enable-paste64' allows you to use JOE's '-joexterm' option (see JOERC
file), which allows mouse left and middle button cut & paste to work with
properly with JOE.

## Common ./configure options

  To force JOE to use /etc/termcap file using its built-in termcap file parser
  (which is useful if you want to compile JOE so that it doesn't depend on any
  libraries other than libc and libm):

	./configure --disable-curses --disable-termcap

  (--disable-termcap prevents JOE from using the termcap emulation functions
   in the -ltermcap library.  --disable-curses prevents JOE from using the
   termcap emulation functions in the -lcurses library).

  Otherwise, JOE tries to use the terminfo database via termcap
  emulation routines: see man tgetent, tgetstr, tgoto, etc.  (JOE has its
  own implementation of "curses", so curses is not required except to get
  access to the terminfo database).

  Note that even if you don't have an /etc/termcap file, JOE will run: it
  will assume that the terminal is "ANSI" (but you need to compile it this
  way for it to be able to use the builtin ANSI termcap entry- if it's
  compiled for terminfo, it can not use its built-in termcap entry).

  Note for MIPS/SGI: to get a 64-bit JOE, do this:
    CC=cc CFLAGS=-64 ./configure ...

## Maximize warnings

Developers may want to try to maximize compiler warnings from gcc:

One way is to provide the CFLAGS enviroment variable to configure:

	CFLAGS='-g -Wall -Wconversion -Wunused -Wwrite-strings -Wstrict-overflow=4 -Wmissing-include-dirs -Winit-self -Wundef -Wlogical-op -Wmissing-declarations -Wformat -Wmissing-format-attribute -Wformat-nonliteral -Wformat-security -Wswitch-enum -Wshadow' ./configure ...

Another is to edit CFLAGS in the joe/Makefile:

	CFLAGS = -g -Wall -Wconversion -Wunused -Wwrite-strings \
	  -Wstrict-overflow=4 -Wmissing-include-dirs -Winit-self -Wcast-qual \
	  -Wundef -Wlogical-op -Wmissing-declarations -Wformat \
	  -Wmissing-format-attribute -Wformat-nonliteral \
	  -Wswitch-enum -Wshadow

(Try adding -Wextra and -Wformat-security for even more warnings)

It's a good idea to verify that JOE can be compiled with C++.  The C++
front-end sometimes finds different problems than the C front-end.

	CC = g++

It's a good idea to see what warnings occur when -m32 is added.  This
can reveal some conversion warnings.

## Verify the installation

A number of features should be tested:

### Shell windows:

Please test the installation by trying the shell command: ^K '  A shell
prompt should appear in the window and you should be able to type "ls".  If
not, two things could be broken:

JOE could not open a pseudo terminal (pty), which is unfortunately one of
the two most incompatible parts of the UNIX API.  Take a look at tty.c-
there are several methods for opening the pty: mess with the "#ifdefs" until
you find a method which works (and send a bug report for your operating
system).

The SHELL environment variable is not set or exported (Cygwin has this
problem).  Put:

	export SHELL=/bin/bash
	setenv SHELL /bin/bash

In you .profile or .cshrc file and send mail to the Cygwin mailing list
so that they fix this problem.

### Process groups:

Once you have a shell window open, try to suspend JOE: ^K Z.  Then resume
it: "fg".  The shell window should still be active.  If not, your operating
system is not handling process groups properly.  Look for the setsid() or
setprgp() system calls in tty.c (this is the other most incompatible part of
the UNIX API).  Currently process groups appear to be broken in Cygwin (so
if you suspend JOE, any shells get killed).

### Resize windows

Try resizing the terminal emulator window: JOE should resize itself to
properly fit.  If this doesn't work, either ttgtsz() (in tty.c) is not
reading the size properly, or the SIGWINCH signal is not being received
by JOE (the handler is winchd() in tty.c).

### Baud rate:

JOE cares about the baud rate as reported by "stty":

	38400 or above:		Joe does not issue scrolling commands

	9600 - 19200:		Joe issues scrolling commands, but does
				not delay.

	0 - 4800:		Joe defeats output buffering by sleeping
				after every chunk of data is sent to the
				screen, by the amount of time that the data
				should take to get there as determined by
				the baud rate.  This allows typeahead to
				interrupt the screen update process: If you
				hit Page Down 100 times, only the final
				contents of the screen get sent to the
				terminal, otherwise you have to wait for all
				100 pages to get to the screen before you
				can do anything.

Sleeping should really be used at 9600 baud, but too many systems use 9600
as the default speed for terminal emulators.  If you are using a real serial
link to a real terminal, you may want to adjust these thresholds: search for
"9600" in tty.c.

### Padding

Ideally either terminals can keep up with the baud rate or they backpressure
the computer using hardware flow control (RTS and CTS pins on RS-232
connector).

If not, there are two options, both bad:

Use XON/XOFF (^S/^Q) flow control: this works, but ^S causes the screen to
freeze, which freaks out new users, plus ^S is the search key in "jmacs".

Use padding: the termcap database indicates how long each command should
take.  If padding is enabled, JOE will send enough NUL characters after each
command to account for this time.  You need set the DOPADDING environment
variable or use the -dopadding option.

You should just buy a modern terminal :-)

### Usage

USAGE:	joe filename [filename ...]

  Optionally precede each filename with +nnn to start at specified line number.

  Options:

 -mid		Cursor is recentered when scrolling is necessary
 -marking	Text between ^KB and cursor is highlighted (use with -lightoff)
 -asis		Characters 128 - 255 shown as-is
 -force		Force final newline when files are saved
 -nobackups	If you don't want backup files to be created
 -lightoff	Turn off highlighting after block copy or move
 -exask		^KX always confirms file name
 -beep		Beep on errors and when cursor goes past extremes
 -nosta		Disable top-most status line
 -keepup	%k and %c status line escape sequences updated frequently
 -pg nnn	No. lines to keep for PgUp/PgDn
 -csmode	^KF after a previous search does a ^L instead
 -backpath path Directory to store backup files
 -nonotice	Disable copyright notice
 -noxon		Attempt to turn off ^S/^Q processing
 -orphan	Put extra files given on command line in orphaned buffers
		instead of in windows
 -dopadding	Output pad characters (for when there is no tty handshaking)
 -lines nnn	Set no. screen lines
 -baud nnn	Set baud rate for terminal optimizations
 -columns nnn	Set no. screen columns
 -help		Start with help on
 -skiptop nnn	Don't use top nnn lines of the screen

  Options before each file name:

 -wordwrap		Wordwrap
 -autoindent		Auto indent
 -overwrite		Overtype mode
 -lmargin nnn		Left margin
 -rmargin nnn		Right margin
 -tab nnn		Tab width
 -indentc nnn		Indentation character (32 for space, 9 for tab)
 -istep nnn		Number of indentation columns
 -french		One space after '.', '?' and '!' for wordwrap
			and paragraph reformat instead of two.  Joe
			does not change the spacing you give, but
			sometimes it must put spacing in itself.  This
			selects how much is inserted.
 -spaces		TAB inserts spaces instead of tabs.
 -linums		Enable line numbers on each line
 -rdonly		File is read-only
 -crlf			File is uses CR-LF at ends of lines (MS-DOS files)

	These options can also be set in the joerc file.  The NOXON, LINES,
COLUMNS, DOPADDING and BAUD options can also be set with environment
variables.

	The JOETERM environment variable can be set to override the TERM
environment variable.

### IMPORTANT

The baud rate must be correctly set or either typeahead will not interrupt 
the screen update and scrolling wont be used or there will be annoying 
delays in the screen update.  If you can't set the baud rate correctly with 
'stty', give a numeric value in the environment variable 'BAUD' or to the
command line options '-baud'.

The baud rate '38400' or 'extb' means infinite to joe.  Use it for X windows
and hardware console ttys.  No delays will be generated and scrolling will
not be used.

The baud rate '19200' or 'exta' means that joe will use scrolling, but will
not delay.

Use the LINES and COLUMNS environment variables or the -lines and -columns
command line options if you need the terminal size to be different than
whatever the termcap entry or stty reports.

Since most people use terminal emulators, JOE does not send out pad 
characters.  If you're using a real terminal and the padding matters, set 
the environment variable DOPADDING or give the command line option
-dopadding.

If you want joe to try to disable ^S/^Q processing, set the environment
variable NOXON or command line option -noxon.

A termcap file is included with JOE.  You might consider updating your own 
termcap file with the entries in it, particularly if you use ANSI/VT100ish 
terminals.  JOE understands some capabilities which are not usually supplied 
in normal termcap (see below).

## VARIATIONS
 
### Termcap/Terminfo

JOE prefers to use the termcap terminal capability database.  It
attempts to find this file in:

	$HOME/.termcap		Personal .termcap in your home directory
	/etc/joe/termcap	Joe's termcap file
	/etc/termcap		Normal system termcap file

Joe copies its own termcap file to /usr/local/lib/termcap (or
wherever the system-wide joerc file is going to go) when 'make install' is
run.

Termcap is better than terminfo because it is a more open standard. 
Programs can directly access the termcap database and future versions of
terminfo may require programs to use curses.  The only argument in
terminfo's favor is that it is faster than termcap.  To fix this problem,
JOE will use a termcap index file if it exists and if it is up to date.

This is the procedure to make the termcap index file:

	make termidx
	./termidx </etc/termcap >/etc/termcap.idx

The /etc/termcap.idx is a text file which you can look at if you're
curious.

JOE supports the GNU extensions to the termcap language and also
understands several new capabilities:

		AL DL IC DC RI LE UP DO SF SR

			Versions of the standard capabilities which accept
			an argument.  For example, RI with and argument of
			7 should move the cursor 7 positions to the right.

		rr

			Set this flag if the cursor is restricted to move
			only within the scrolling regions.  This is an optional
			mode on vt220s and several clones assume that this
			mode is always on.

		cV

			Like the 'cv' capability, but the cursor goes to the
			beginning of the specified line.  Like 'ESC [ n H' in
			ansi/vt100.

## BROKEN TERMINALS

"Joe does not update the screen correctly in Procomm"
"My Xenix console does not scroll correctly"

Old versions of Procomm, many other DOS comm programs and nearly every
PC-UNIX console (with the exception of Linux) does not emulate VT100s
properly.  There are usually one or more problems:

	1) Tabs are destructive

	2) Tabs are destructive when inverse mode is set

	3) Scrolling regions are not supported

	4) Cursor positioning is scrolling region relative instead of
	   screen relative.

	5) Some other program set the tab-stops to something other than
	   one tab stop every 8 columns.

	6) The erase commands (ESC [ J and ESC [ K) fill with inverse
	   video blanks instead of plain blanks when inverse mode is set.

	7) Backspace is destructive

Procomm 2.3 works fine- but make sure you have DEC VT100 selected, not 'ANSI
BBS' and also that backspace (BS) is set to 'non-destructive'.  If you must
use an old version of Procomm, try using the 'ansisys' or 'nansisys' termcap
entry.  Unix consoles usually do not have scrolling regions, but instead
have insert and delete line commands.  The 'fansi' entry and ones derived
from it will work correctly.  These termcap entries are provided in the
termcap file which came with joe.  If at all possible have your sysadmin
install these entries in '/etc/termcap'.  Even if your system normally uses
the terminfo database, you can copy Joe's termcap file into
/etc/termcap.

"I don't have root access and can't update the system's termcap file.  How
 do I get only Joe to use a different termcap entry?"

"My system uses terminfo.  How do I get only Joe to use a different termcap
 entry?"

What you should do is copy the termcap file which is provided with joe into
'.termcap' of your home directory.  Now suppose you want Joe to use the
'fansi' termcap entry:

If you use csh or tcsh, place this in your .cshrc file:

	setenv JOETERM fansi

If you use sh, ksh or bash, place this in your .profile file:

	JOETERM=fansi; export JOETERM

"I don't have root access and can't update the system's termcap file.  How
 do I get all of my programs to use one of Joe's termcap entries?"

Again, copy termcap into '.termcap' in your home directory, but set the
environment variables like this:

	setenv TERMCAP $HOME/.termcap
	setenv TERM fansi

"My system uses terminfo... how do I get all of my programs to use one of
 Joe's termcap entries?"

First, compile joe for terminfo.  You then have to 'tic' the terminfo
version of joe's termcap file into your account.  These are the commands for
doing this:

	1)	cd
	2)	mkdir .info
	3)	setenv TERMINFO $HOME/.info

		(or

		TERMINFO=$HOME/.info; export TERMINFO

		if you use bash, sh or ksh)

	4)	tic joe/terminfo

Then put the 'setenv TERMINFO $HOME/.info' line into your .login file or
'TERMINFO=$HOME/.info; export TERMINFO' in your .profile.  Now all of your
programs should look up the 'TERM' in your own personal terminfo database.
